/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.workmail.WorkMailClient;
import software.amazon.awssdk.services.workmail.model.AssociateDelegateToResourceRequest;
import software.amazon.awssdk.services.workmail.model.AssociateDelegateToResourceResponse;
import software.amazon.awssdk.services.workmail.model.AssociateMemberToGroupRequest;
import software.amazon.awssdk.services.workmail.model.AssociateMemberToGroupResponse;
import software.amazon.awssdk.services.workmail.model.CreateAliasRequest;
import software.amazon.awssdk.services.workmail.model.CreateAliasResponse;
import software.amazon.awssdk.services.workmail.model.CreateGroupRequest;
import software.amazon.awssdk.services.workmail.model.CreateGroupResponse;
import software.amazon.awssdk.services.workmail.model.CreateResourceRequest;
import software.amazon.awssdk.services.workmail.model.CreateResourceResponse;
import software.amazon.awssdk.services.workmail.model.CreateUserRequest;
import software.amazon.awssdk.services.workmail.model.CreateUserResponse;
import software.amazon.awssdk.services.workmail.model.DeleteAliasRequest;
import software.amazon.awssdk.services.workmail.model.DeleteAliasResponse;
import software.amazon.awssdk.services.workmail.model.DeleteGroupRequest;
import software.amazon.awssdk.services.workmail.model.DeleteGroupResponse;
import software.amazon.awssdk.services.workmail.model.DeleteMailboxPermissionsRequest;
import software.amazon.awssdk.services.workmail.model.DeleteMailboxPermissionsResponse;
import software.amazon.awssdk.services.workmail.model.DeleteResourceRequest;
import software.amazon.awssdk.services.workmail.model.DeleteResourceResponse;
import software.amazon.awssdk.services.workmail.model.DeleteUserRequest;
import software.amazon.awssdk.services.workmail.model.DeleteUserResponse;
import software.amazon.awssdk.services.workmail.model.DeregisterFromWorkMailRequest;
import software.amazon.awssdk.services.workmail.model.DeregisterFromWorkMailResponse;
import software.amazon.awssdk.services.workmail.model.DescribeGroupRequest;
import software.amazon.awssdk.services.workmail.model.DescribeGroupResponse;
import software.amazon.awssdk.services.workmail.model.DescribeOrganizationRequest;
import software.amazon.awssdk.services.workmail.model.DescribeOrganizationResponse;
import software.amazon.awssdk.services.workmail.model.DescribeResourceRequest;
import software.amazon.awssdk.services.workmail.model.DescribeResourceResponse;
import software.amazon.awssdk.services.workmail.model.DescribeUserRequest;
import software.amazon.awssdk.services.workmail.model.DescribeUserResponse;
import software.amazon.awssdk.services.workmail.model.DirectoryServiceAuthenticationFailedException;
import software.amazon.awssdk.services.workmail.model.DirectoryUnavailableException;
import software.amazon.awssdk.services.workmail.model.DisassociateDelegateFromResourceRequest;
import software.amazon.awssdk.services.workmail.model.DisassociateDelegateFromResourceResponse;
import software.amazon.awssdk.services.workmail.model.DisassociateMemberFromGroupRequest;
import software.amazon.awssdk.services.workmail.model.DisassociateMemberFromGroupResponse;
import software.amazon.awssdk.services.workmail.model.EmailAddressInUseException;
import software.amazon.awssdk.services.workmail.model.EntityAlreadyRegisteredException;
import software.amazon.awssdk.services.workmail.model.EntityNotFoundException;
import software.amazon.awssdk.services.workmail.model.EntityStateException;
import software.amazon.awssdk.services.workmail.model.GetMailboxDetailsRequest;
import software.amazon.awssdk.services.workmail.model.GetMailboxDetailsResponse;
import software.amazon.awssdk.services.workmail.model.InvalidConfigurationException;
import software.amazon.awssdk.services.workmail.model.InvalidParameterException;
import software.amazon.awssdk.services.workmail.model.InvalidPasswordException;
import software.amazon.awssdk.services.workmail.model.ListAliasesRequest;
import software.amazon.awssdk.services.workmail.model.ListAliasesResponse;
import software.amazon.awssdk.services.workmail.model.ListGroupMembersRequest;
import software.amazon.awssdk.services.workmail.model.ListGroupMembersResponse;
import software.amazon.awssdk.services.workmail.model.ListGroupsRequest;
import software.amazon.awssdk.services.workmail.model.ListGroupsResponse;
import software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsRequest;
import software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsResponse;
import software.amazon.awssdk.services.workmail.model.ListOrganizationsRequest;
import software.amazon.awssdk.services.workmail.model.ListOrganizationsResponse;
import software.amazon.awssdk.services.workmail.model.ListResourceDelegatesRequest;
import software.amazon.awssdk.services.workmail.model.ListResourceDelegatesResponse;
import software.amazon.awssdk.services.workmail.model.ListResourcesRequest;
import software.amazon.awssdk.services.workmail.model.ListResourcesResponse;
import software.amazon.awssdk.services.workmail.model.ListUsersRequest;
import software.amazon.awssdk.services.workmail.model.ListUsersResponse;
import software.amazon.awssdk.services.workmail.model.MailDomainNotFoundException;
import software.amazon.awssdk.services.workmail.model.MailDomainStateException;
import software.amazon.awssdk.services.workmail.model.NameAvailabilityException;
import software.amazon.awssdk.services.workmail.model.OrganizationNotFoundException;
import software.amazon.awssdk.services.workmail.model.OrganizationStateException;
import software.amazon.awssdk.services.workmail.model.PutMailboxPermissionsRequest;
import software.amazon.awssdk.services.workmail.model.PutMailboxPermissionsResponse;
import software.amazon.awssdk.services.workmail.model.RegisterToWorkMailRequest;
import software.amazon.awssdk.services.workmail.model.RegisterToWorkMailResponse;
import software.amazon.awssdk.services.workmail.model.ReservedNameException;
import software.amazon.awssdk.services.workmail.model.ResetPasswordRequest;
import software.amazon.awssdk.services.workmail.model.ResetPasswordResponse;
import software.amazon.awssdk.services.workmail.model.UnsupportedOperationException;
import software.amazon.awssdk.services.workmail.model.UpdateMailboxQuotaRequest;
import software.amazon.awssdk.services.workmail.model.UpdateMailboxQuotaResponse;
import software.amazon.awssdk.services.workmail.model.UpdatePrimaryEmailAddressRequest;
import software.amazon.awssdk.services.workmail.model.UpdatePrimaryEmailAddressResponse;
import software.amazon.awssdk.services.workmail.model.UpdateResourceRequest;
import software.amazon.awssdk.services.workmail.model.UpdateResourceResponse;
import software.amazon.awssdk.services.workmail.model.WorkMailException;
import software.amazon.awssdk.services.workmail.model.WorkMailRequest;
import software.amazon.awssdk.services.workmail.paginators.ListAliasesIterable;
import software.amazon.awssdk.services.workmail.paginators.ListGroupMembersIterable;
import software.amazon.awssdk.services.workmail.paginators.ListGroupsIterable;
import software.amazon.awssdk.services.workmail.paginators.ListMailboxPermissionsIterable;
import software.amazon.awssdk.services.workmail.paginators.ListOrganizationsIterable;
import software.amazon.awssdk.services.workmail.paginators.ListResourceDelegatesIterable;
import software.amazon.awssdk.services.workmail.paginators.ListResourcesIterable;
import software.amazon.awssdk.services.workmail.paginators.ListUsersIterable;
import software.amazon.awssdk.services.workmail.transform.AssociateDelegateToResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.AssociateMemberToGroupRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.CreateAliasRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.CreateGroupRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.CreateResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteAliasRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteGroupRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteMailboxPermissionsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeregisterFromWorkMailRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DescribeGroupRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DescribeOrganizationRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DescribeResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DescribeUserRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DisassociateDelegateFromResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DisassociateMemberFromGroupRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.GetMailboxDetailsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListAliasesRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListGroupMembersRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListGroupsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListMailboxPermissionsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListOrganizationsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListResourceDelegatesRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListResourcesRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListUsersRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.PutMailboxPermissionsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.RegisterToWorkMailRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ResetPasswordRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.UpdateMailboxQuotaRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.UpdatePrimaryEmailAddressRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.UpdateResourceRequestMarshaller;

@SdkInternalApi
final class DefaultWorkMailClient
implements WorkMailClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultWorkMailClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "workmail";
    }

    @Override
    public AssociateDelegateToResourceResponse associateDelegateToResource(AssociateDelegateToResourceRequest associateDelegateToResourceRequest) throws EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateDelegateToResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AssociateDelegateToResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateDelegateToResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateDelegateToResourceRequest).withMarshaller((Marshaller)new AssociateDelegateToResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public AssociateMemberToGroupResponse associateMemberToGroup(AssociateMemberToGroupRequest associateMemberToGroupRequest) throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, UnsupportedOperationException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateMemberToGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AssociateMemberToGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateMemberToGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateMemberToGroupRequest).withMarshaller((Marshaller)new AssociateMemberToGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateAliasResponse createAlias(CreateAliasRequest createAliasRequest) throws EmailAddressInUseException, EntityNotFoundException, EntityStateException, InvalidParameterException, MailDomainNotFoundException, MailDomainStateException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAliasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAlias").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAliasRequest).withMarshaller((Marshaller)new CreateAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateGroupResponse createGroup(CreateGroupRequest createGroupRequest) throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, InvalidParameterException, NameAvailabilityException, OrganizationNotFoundException, OrganizationStateException, ReservedNameException, UnsupportedOperationException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createGroupRequest).withMarshaller((Marshaller)new CreateGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateResourceResponse createResource(CreateResourceRequest createResourceRequest) throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, InvalidParameterException, NameAvailabilityException, OrganizationNotFoundException, OrganizationStateException, ReservedNameException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createResourceRequest).withMarshaller((Marshaller)new CreateResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateUserResponse createUser(CreateUserRequest createUserRequest) throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, InvalidParameterException, InvalidPasswordException, NameAvailabilityException, OrganizationNotFoundException, OrganizationStateException, ReservedNameException, UnsupportedOperationException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createUserRequest).withMarshaller((Marshaller)new CreateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteAliasResponse deleteAlias(DeleteAliasRequest deleteAliasRequest) throws EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAliasResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteAliasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAlias").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAliasRequest).withMarshaller((Marshaller)new DeleteAliasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteGroupResponse deleteGroup(DeleteGroupRequest deleteGroupRequest) throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, UnsupportedOperationException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteGroupRequest).withMarshaller((Marshaller)new DeleteGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteMailboxPermissionsResponse deleteMailboxPermissions(DeleteMailboxPermissionsRequest deleteMailboxPermissionsRequest) throws EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMailboxPermissionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteMailboxPermissionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMailboxPermissions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteMailboxPermissionsRequest).withMarshaller((Marshaller)new DeleteMailboxPermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteResourceResponse deleteResource(DeleteResourceRequest deleteResourceRequest) throws EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteResourceRequest).withMarshaller((Marshaller)new DeleteResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, UnsupportedOperationException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteUserRequest).withMarshaller((Marshaller)new DeleteUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeregisterFromWorkMailResponse deregisterFromWorkMail(DeregisterFromWorkMailRequest deregisterFromWorkMailRequest) throws EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterFromWorkMailResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeregisterFromWorkMailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterFromWorkMail").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deregisterFromWorkMailRequest).withMarshaller((Marshaller)new DeregisterFromWorkMailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeGroupResponse describeGroup(DescribeGroupRequest describeGroupRequest) throws EntityNotFoundException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeGroupRequest).withMarshaller((Marshaller)new DescribeGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeOrganizationResponse describeOrganization(DescribeOrganizationRequest describeOrganizationRequest) throws InvalidParameterException, OrganizationNotFoundException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeOrganizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeOrganizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrganization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeOrganizationRequest).withMarshaller((Marshaller)new DescribeOrganizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeResourceResponse describeResource(DescribeResourceRequest describeResourceRequest) throws EntityNotFoundException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeResourceRequest).withMarshaller((Marshaller)new DescribeResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeUserResponse describeUser(DescribeUserRequest describeUserRequest) throws EntityNotFoundException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeUserRequest).withMarshaller((Marshaller)new DescribeUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DisassociateDelegateFromResourceResponse disassociateDelegateFromResource(DisassociateDelegateFromResourceRequest disassociateDelegateFromResourceRequest) throws EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateDelegateFromResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DisassociateDelegateFromResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateDelegateFromResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateDelegateFromResourceRequest).withMarshaller((Marshaller)new DisassociateDelegateFromResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DisassociateMemberFromGroupResponse disassociateMemberFromGroup(DisassociateMemberFromGroupRequest disassociateMemberFromGroupRequest) throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, UnsupportedOperationException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateMemberFromGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DisassociateMemberFromGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateMemberFromGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateMemberFromGroupRequest).withMarshaller((Marshaller)new DisassociateMemberFromGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetMailboxDetailsResponse getMailboxDetails(GetMailboxDetailsRequest getMailboxDetailsRequest) throws OrganizationNotFoundException, OrganizationStateException, EntityNotFoundException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMailboxDetailsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetMailboxDetailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMailboxDetails").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getMailboxDetailsRequest).withMarshaller((Marshaller)new GetMailboxDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListAliasesResponse listAliases(ListAliasesRequest listAliasesRequest) throws EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAliasesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListAliasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAliases").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAliasesRequest).withMarshaller((Marshaller)new ListAliasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListAliasesIterable listAliasesPaginator(ListAliasesRequest listAliasesRequest) throws EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        return new ListAliasesIterable(this, this.applyPaginatorUserAgent(listAliasesRequest));
    }

    @Override
    public ListGroupMembersResponse listGroupMembers(ListGroupMembersRequest listGroupMembersRequest) throws EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGroupMembersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListGroupMembersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGroupMembers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listGroupMembersRequest).withMarshaller((Marshaller)new ListGroupMembersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListGroupMembersIterable listGroupMembersPaginator(ListGroupMembersRequest listGroupMembersRequest) throws EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        return new ListGroupMembersIterable(this, this.applyPaginatorUserAgent(listGroupMembersRequest));
    }

    @Override
    public ListGroupsResponse listGroups(ListGroupsRequest listGroupsRequest) throws EntityNotFoundException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listGroupsRequest).withMarshaller((Marshaller)new ListGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListGroupsIterable listGroupsPaginator(ListGroupsRequest listGroupsRequest) throws EntityNotFoundException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        return new ListGroupsIterable(this, this.applyPaginatorUserAgent(listGroupsRequest));
    }

    @Override
    public ListMailboxPermissionsResponse listMailboxPermissions(ListMailboxPermissionsRequest listMailboxPermissionsRequest) throws EntityNotFoundException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMailboxPermissionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListMailboxPermissionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMailboxPermissions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listMailboxPermissionsRequest).withMarshaller((Marshaller)new ListMailboxPermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListMailboxPermissionsIterable listMailboxPermissionsPaginator(ListMailboxPermissionsRequest listMailboxPermissionsRequest) throws EntityNotFoundException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        return new ListMailboxPermissionsIterable(this, this.applyPaginatorUserAgent(listMailboxPermissionsRequest));
    }

    @Override
    public ListOrganizationsResponse listOrganizations(ListOrganizationsRequest listOrganizationsRequest) throws InvalidParameterException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListOrganizationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListOrganizationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListOrganizations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listOrganizationsRequest).withMarshaller((Marshaller)new ListOrganizationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListOrganizationsIterable listOrganizationsPaginator(ListOrganizationsRequest listOrganizationsRequest) throws InvalidParameterException, AwsServiceException, SdkClientException, WorkMailException {
        return new ListOrganizationsIterable(this, this.applyPaginatorUserAgent(listOrganizationsRequest));
    }

    @Override
    public ListResourceDelegatesResponse listResourceDelegates(ListResourceDelegatesRequest listResourceDelegatesRequest) throws EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourceDelegatesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListResourceDelegatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResourceDelegates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listResourceDelegatesRequest).withMarshaller((Marshaller)new ListResourceDelegatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListResourceDelegatesIterable listResourceDelegatesPaginator(ListResourceDelegatesRequest listResourceDelegatesRequest) throws EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        return new ListResourceDelegatesIterable(this, this.applyPaginatorUserAgent(listResourceDelegatesRequest));
    }

    @Override
    public ListResourcesResponse listResources(ListResourcesRequest listResourcesRequest) throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListResourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listResourcesRequest).withMarshaller((Marshaller)new ListResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListResourcesIterable listResourcesPaginator(ListResourcesRequest listResourcesRequest) throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        return new ListResourcesIterable(this, this.applyPaginatorUserAgent(listResourcesRequest));
    }

    @Override
    public ListUsersResponse listUsers(ListUsersRequest listUsersRequest) throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListUsersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListUsersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListUsers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listUsersRequest).withMarshaller((Marshaller)new ListUsersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListUsersIterable listUsersPaginator(ListUsersRequest listUsersRequest) throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        return new ListUsersIterable(this, this.applyPaginatorUserAgent(listUsersRequest));
    }

    @Override
    public PutMailboxPermissionsResponse putMailboxPermissions(PutMailboxPermissionsRequest putMailboxPermissionsRequest) throws EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutMailboxPermissionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutMailboxPermissionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutMailboxPermissions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putMailboxPermissionsRequest).withMarshaller((Marshaller)new PutMailboxPermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RegisterToWorkMailResponse registerToWorkMail(RegisterToWorkMailRequest registerToWorkMailRequest) throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, EmailAddressInUseException, EntityNotFoundException, EntityStateException, EntityAlreadyRegisteredException, InvalidParameterException, MailDomainNotFoundException, MailDomainStateException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterToWorkMailResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RegisterToWorkMailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterToWorkMail").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerToWorkMailRequest).withMarshaller((Marshaller)new RegisterToWorkMailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ResetPasswordResponse resetPassword(ResetPasswordRequest resetPasswordRequest) throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, EntityNotFoundException, EntityStateException, InvalidParameterException, InvalidPasswordException, OrganizationNotFoundException, OrganizationStateException, UnsupportedOperationException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResetPasswordResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ResetPasswordResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetPassword").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)resetPasswordRequest).withMarshaller((Marshaller)new ResetPasswordRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateMailboxQuotaResponse updateMailboxQuota(UpdateMailboxQuotaRequest updateMailboxQuotaRequest) throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, EntityNotFoundException, EntityStateException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateMailboxQuotaResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateMailboxQuotaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateMailboxQuota").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateMailboxQuotaRequest).withMarshaller((Marshaller)new UpdateMailboxQuotaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdatePrimaryEmailAddressResponse updatePrimaryEmailAddress(UpdatePrimaryEmailAddressRequest updatePrimaryEmailAddressRequest) throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, EmailAddressInUseException, EntityNotFoundException, EntityStateException, InvalidParameterException, MailDomainNotFoundException, MailDomainStateException, OrganizationNotFoundException, OrganizationStateException, UnsupportedOperationException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePrimaryEmailAddressResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdatePrimaryEmailAddressResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePrimaryEmailAddress").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updatePrimaryEmailAddressRequest).withMarshaller((Marshaller)new UpdatePrimaryEmailAddressRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateResourceResponse updateResource(UpdateResourceRequest updateResourceRequest) throws DirectoryUnavailableException, EntityNotFoundException, EntityStateException, InvalidConfigurationException, EmailAddressInUseException, MailDomainNotFoundException, MailDomainStateException, NameAvailabilityException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateResourceRequest).withMarshaller((Marshaller)new UpdateResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(WorkMailException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").exceptionBuilderSupplier(DirectoryUnavailableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").exceptionBuilderSupplier(InvalidConfigurationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterException").exceptionBuilderSupplier(InvalidParameterException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MailDomainStateException").exceptionBuilderSupplier(MailDomainStateException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPasswordException").exceptionBuilderSupplier(InvalidPasswordException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").exceptionBuilderSupplier(UnsupportedOperationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EntityNotFoundException").exceptionBuilderSupplier(EntityNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReservedNameException").exceptionBuilderSupplier(ReservedNameException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").exceptionBuilderSupplier(MailDomainNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OrganizationStateException").exceptionBuilderSupplier(OrganizationStateException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException").exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").exceptionBuilderSupplier(OrganizationNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NameAvailabilityException").exceptionBuilderSupplier(NameAvailabilityException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").exceptionBuilderSupplier(EmailAddressInUseException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EntityStateException").exceptionBuilderSupplier(EntityStateException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException").exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends WorkMailRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.10.21").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((WorkMailRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

