/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workmail.model.Member;
import software.amazon.awssdk.services.workmail.model.MembersCopier;
import software.amazon.awssdk.services.workmail.model.WorkMailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGroupMembersResponse
extends WorkMailResponse
implements ToCopyableBuilder<Builder, ListGroupMembersResponse> {
    private static final SdkField<List<Member>> MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListGroupMembersResponse.getter(ListGroupMembersResponse::members)).setter(ListGroupMembersResponse.setter(Builder::members)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Members").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Member::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListGroupMembersResponse.getter(ListGroupMembersResponse::nextToken)).setter(ListGroupMembersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Member> members;
    private final String nextToken;

    private ListGroupMembersResponse(BuilderImpl builder) {
        super(builder);
        this.members = builder.members;
        this.nextToken = builder.nextToken;
    }

    public boolean hasMembers() {
        return this.members != null && !(this.members instanceof SdkAutoConstructList);
    }

    public List<Member> members() {
        return this.members;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.members());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupMembersResponse)) {
            return false;
        }
        ListGroupMembersResponse other = (ListGroupMembersResponse)((Object)obj);
        return Objects.equals(this.members(), other.members()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListGroupMembersResponse").add("Members", this.members()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Members": {
                return Optional.ofNullable(clazz.cast(this.members()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGroupMembersResponse, T> g) {
        return obj -> g.apply((ListGroupMembersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailResponse.BuilderImpl
    implements Builder {
        private List<Member> members = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupMembersResponse model) {
            super(model);
            this.members(model.members);
            this.nextToken(model.nextToken);
        }

        public final Collection<Member.Builder> getMembers() {
            return this.members != null ? (Collection)this.members.stream().map(Member::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder members(Collection<Member> members) {
            this.members = MembersCopier.copy(members);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(Member ... members) {
            this.members(Arrays.asList(members));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(Consumer<Member.Builder> ... members) {
            this.members(Stream.of(members).map(c -> (Member)((Member.Builder)Member.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMembers(Collection<Member.BuilderImpl> members) {
            this.members = MembersCopier.copyFromBuilder(members);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListGroupMembersResponse build() {
            return new ListGroupMembersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkMailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGroupMembersResponse> {
        public Builder members(Collection<Member> var1);

        public Builder members(Member ... var1);

        public Builder members(Consumer<Member.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

