/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workmail.model.WorkMailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMailboxQuotaRequest
extends WorkMailRequest
implements ToCopyableBuilder<Builder, UpdateMailboxQuotaRequest> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateMailboxQuotaRequest.getter(UpdateMailboxQuotaRequest::organizationId)).setter(UpdateMailboxQuotaRequest.setter(Builder::organizationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateMailboxQuotaRequest.getter(UpdateMailboxQuotaRequest::userId)).setter(UpdateMailboxQuotaRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<Integer> MAILBOX_QUOTA_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateMailboxQuotaRequest.getter(UpdateMailboxQuotaRequest::mailboxQuota)).setter(UpdateMailboxQuotaRequest.setter(Builder::mailboxQuota)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailboxQuota").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD, USER_ID_FIELD, MAILBOX_QUOTA_FIELD));
    private final String organizationId;
    private final String userId;
    private final Integer mailboxQuota;

    private UpdateMailboxQuotaRequest(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.userId = builder.userId;
        this.mailboxQuota = builder.mailboxQuota;
    }

    public String organizationId() {
        return this.organizationId;
    }

    public String userId() {
        return this.userId;
    }

    public Integer mailboxQuota() {
        return this.mailboxQuota;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mailboxQuota());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMailboxQuotaRequest)) {
            return false;
        }
        UpdateMailboxQuotaRequest other = (UpdateMailboxQuotaRequest)((Object)obj);
        return Objects.equals(this.organizationId(), other.organizationId()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.mailboxQuota(), other.mailboxQuota());
    }

    public String toString() {
        return ToString.builder((String)"UpdateMailboxQuotaRequest").add("OrganizationId", (Object)this.organizationId()).add("UserId", (Object)this.userId()).add("MailboxQuota", (Object)this.mailboxQuota()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationId": {
                return Optional.ofNullable(clazz.cast(this.organizationId()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "MailboxQuota": {
                return Optional.ofNullable(clazz.cast(this.mailboxQuota()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMailboxQuotaRequest, T> g) {
        return obj -> g.apply((UpdateMailboxQuotaRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailRequest.BuilderImpl
    implements Builder {
        private String organizationId;
        private String userId;
        private Integer mailboxQuota;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMailboxQuotaRequest model) {
            super(model);
            this.organizationId(model.organizationId);
            this.userId(model.userId);
            this.mailboxQuota(model.mailboxQuota);
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final Integer getMailboxQuota() {
            return this.mailboxQuota;
        }

        @Override
        public final Builder mailboxQuota(Integer mailboxQuota) {
            this.mailboxQuota = mailboxQuota;
            return this;
        }

        public final void setMailboxQuota(Integer mailboxQuota) {
            this.mailboxQuota = mailboxQuota;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMailboxQuotaRequest build() {
            return new UpdateMailboxQuotaRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkMailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMailboxQuotaRequest> {
        public Builder organizationId(String var1);

        public Builder userId(String var1);

        public Builder mailboxQuota(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

