/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration applied to an organization's folders by its retention policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FolderConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FolderConfiguration.Builder, FolderConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(FolderConfiguration::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(FolderConfiguration::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<Integer> PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Period").getter(getter(FolderConfiguration::period)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ACTION_FIELD,
            PERIOD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String action;

    private final Integer period;

    private FolderConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.action = builder.action;
        this.period = builder.period;
    }

    /**
     * <p>
     * The folder name.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link FolderName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The folder name.
     * @see FolderName
     */
    public FolderName name() {
        return FolderName.fromValue(name);
    }

    /**
     * <p>
     * The folder name.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link FolderName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The folder name.
     * @see FolderName
     */
    public String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The action to take on the folder contents at the end of the folder configuration period.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link RetentionAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action to take on the folder contents at the end of the folder configuration period.
     * @see RetentionAction
     */
    public RetentionAction action() {
        return RetentionAction.fromValue(action);
    }

    /**
     * <p>
     * The action to take on the folder contents at the end of the folder configuration period.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link RetentionAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action to take on the folder contents at the end of the folder configuration period.
     * @see RetentionAction
     */
    public String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The period of time at which the folder configuration action is applied.
     * </p>
     * 
     * @return The period of time at which the folder configuration action is applied.
     */
    public Integer period() {
        return period;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(period());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FolderConfiguration)) {
            return false;
        }
        FolderConfiguration other = (FolderConfiguration) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(period(), other.period());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FolderConfiguration").add("Name", nameAsString()).add("Action", actionAsString())
                .add("Period", period()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "Period":
            return Optional.ofNullable(clazz.cast(period()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FolderConfiguration, T> g) {
        return obj -> g.apply((FolderConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FolderConfiguration> {
        /**
         * <p>
         * The folder name.
         * </p>
         * 
         * @param name
         *        The folder name.
         * @see FolderName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FolderName
         */
        Builder name(String name);

        /**
         * <p>
         * The folder name.
         * </p>
         * 
         * @param name
         *        The folder name.
         * @see FolderName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FolderName
         */
        Builder name(FolderName name);

        /**
         * <p>
         * The action to take on the folder contents at the end of the folder configuration period.
         * </p>
         * 
         * @param action
         *        The action to take on the folder contents at the end of the folder configuration period.
         * @see RetentionAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetentionAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action to take on the folder contents at the end of the folder configuration period.
         * </p>
         * 
         * @param action
         *        The action to take on the folder contents at the end of the folder configuration period.
         * @see RetentionAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetentionAction
         */
        Builder action(RetentionAction action);

        /**
         * <p>
         * The period of time at which the folder configuration action is applied.
         * </p>
         * 
         * @param period
         *        The period of time at which the folder configuration action is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder period(Integer period);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String action;

        private Integer period;

        private BuilderImpl() {
        }

        private BuilderImpl(FolderConfiguration model) {
            name(model.name);
            action(model.action);
            period(model.period);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(FolderName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getAction() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(RetentionAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final Integer getPeriod() {
            return period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        @Override
        public FolderConfiguration build() {
            return new FolderConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
