/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BookingOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BookingOptions> {
    private static final SdkField<Boolean> AUTO_ACCEPT_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoAcceptRequests").getter(BookingOptions.getter(BookingOptions::autoAcceptRequests)).setter(BookingOptions.setter(Builder::autoAcceptRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoAcceptRequests").build()}).build();
    private static final SdkField<Boolean> AUTO_DECLINE_RECURRING_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoDeclineRecurringRequests").getter(BookingOptions.getter(BookingOptions::autoDeclineRecurringRequests)).setter(BookingOptions.setter(Builder::autoDeclineRecurringRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoDeclineRecurringRequests").build()}).build();
    private static final SdkField<Boolean> AUTO_DECLINE_CONFLICTING_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoDeclineConflictingRequests").getter(BookingOptions.getter(BookingOptions::autoDeclineConflictingRequests)).setter(BookingOptions.setter(Builder::autoDeclineConflictingRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoDeclineConflictingRequests").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ACCEPT_REQUESTS_FIELD, AUTO_DECLINE_RECURRING_REQUESTS_FIELD, AUTO_DECLINE_CONFLICTING_REQUESTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean autoAcceptRequests;
    private final Boolean autoDeclineRecurringRequests;
    private final Boolean autoDeclineConflictingRequests;

    private BookingOptions(BuilderImpl builder) {
        this.autoAcceptRequests = builder.autoAcceptRequests;
        this.autoDeclineRecurringRequests = builder.autoDeclineRecurringRequests;
        this.autoDeclineConflictingRequests = builder.autoDeclineConflictingRequests;
    }

    public Boolean autoAcceptRequests() {
        return this.autoAcceptRequests;
    }

    public Boolean autoDeclineRecurringRequests() {
        return this.autoDeclineRecurringRequests;
    }

    public Boolean autoDeclineConflictingRequests() {
        return this.autoDeclineConflictingRequests;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoAcceptRequests());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoDeclineRecurringRequests());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoDeclineConflictingRequests());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BookingOptions)) {
            return false;
        }
        BookingOptions other = (BookingOptions)obj;
        return Objects.equals(this.autoAcceptRequests(), other.autoAcceptRequests()) && Objects.equals(this.autoDeclineRecurringRequests(), other.autoDeclineRecurringRequests()) && Objects.equals(this.autoDeclineConflictingRequests(), other.autoDeclineConflictingRequests());
    }

    public String toString() {
        return ToString.builder((String)"BookingOptions").add("AutoAcceptRequests", (Object)this.autoAcceptRequests()).add("AutoDeclineRecurringRequests", (Object)this.autoDeclineRecurringRequests()).add("AutoDeclineConflictingRequests", (Object)this.autoDeclineConflictingRequests()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoAcceptRequests": {
                return Optional.ofNullable(clazz.cast(this.autoAcceptRequests()));
            }
            case "AutoDeclineRecurringRequests": {
                return Optional.ofNullable(clazz.cast(this.autoDeclineRecurringRequests()));
            }
            case "AutoDeclineConflictingRequests": {
                return Optional.ofNullable(clazz.cast(this.autoDeclineConflictingRequests()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BookingOptions, T> g) {
        return obj -> g.apply((BookingOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean autoAcceptRequests;
        private Boolean autoDeclineRecurringRequests;
        private Boolean autoDeclineConflictingRequests;

        private BuilderImpl() {
        }

        private BuilderImpl(BookingOptions model) {
            this.autoAcceptRequests(model.autoAcceptRequests);
            this.autoDeclineRecurringRequests(model.autoDeclineRecurringRequests);
            this.autoDeclineConflictingRequests(model.autoDeclineConflictingRequests);
        }

        public final Boolean getAutoAcceptRequests() {
            return this.autoAcceptRequests;
        }

        @Override
        public final Builder autoAcceptRequests(Boolean autoAcceptRequests) {
            this.autoAcceptRequests = autoAcceptRequests;
            return this;
        }

        public final void setAutoAcceptRequests(Boolean autoAcceptRequests) {
            this.autoAcceptRequests = autoAcceptRequests;
        }

        public final Boolean getAutoDeclineRecurringRequests() {
            return this.autoDeclineRecurringRequests;
        }

        @Override
        public final Builder autoDeclineRecurringRequests(Boolean autoDeclineRecurringRequests) {
            this.autoDeclineRecurringRequests = autoDeclineRecurringRequests;
            return this;
        }

        public final void setAutoDeclineRecurringRequests(Boolean autoDeclineRecurringRequests) {
            this.autoDeclineRecurringRequests = autoDeclineRecurringRequests;
        }

        public final Boolean getAutoDeclineConflictingRequests() {
            return this.autoDeclineConflictingRequests;
        }

        @Override
        public final Builder autoDeclineConflictingRequests(Boolean autoDeclineConflictingRequests) {
            this.autoDeclineConflictingRequests = autoDeclineConflictingRequests;
            return this;
        }

        public final void setAutoDeclineConflictingRequests(Boolean autoDeclineConflictingRequests) {
            this.autoDeclineConflictingRequests = autoDeclineConflictingRequests;
        }

        public BookingOptions build() {
            return new BookingOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BookingOptions> {
        public Builder autoAcceptRequests(Boolean var1);

        public Builder autoDeclineRecurringRequests(Boolean var1);

        public Builder autoDeclineConflictingRequests(Boolean var1);
    }
}

