/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workmail.model.FolderName;
import software.amazon.awssdk.services.workmail.model.RetentionAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FolderConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FolderConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(FolderConfiguration.getter(FolderConfiguration::nameAsString)).setter(FolderConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(FolderConfiguration.getter(FolderConfiguration::actionAsString)).setter(FolderConfiguration.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<Integer> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Period").getter(FolderConfiguration.getter(FolderConfiguration::period)).setter(FolderConfiguration.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ACTION_FIELD, PERIOD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String action;
    private final Integer period;

    private FolderConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.action = builder.action;
        this.period = builder.period;
    }

    public FolderName name() {
        return FolderName.fromValue(this.name);
    }

    public String nameAsString() {
        return this.name;
    }

    public RetentionAction action() {
        return RetentionAction.fromValue(this.action);
    }

    public String actionAsString() {
        return this.action;
    }

    public Integer period() {
        return this.period;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.period());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FolderConfiguration)) {
            return false;
        }
        FolderConfiguration other = (FolderConfiguration)obj;
        return Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.period(), other.period());
    }

    public String toString() {
        return ToString.builder((String)"FolderConfiguration").add("Name", (Object)this.nameAsString()).add("Action", (Object)this.actionAsString()).add("Period", (Object)this.period()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "Period": {
                return Optional.ofNullable(clazz.cast(this.period()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FolderConfiguration, T> g) {
        return obj -> g.apply((FolderConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String action;
        private Integer period;

        private BuilderImpl() {
        }

        private BuilderImpl(FolderConfiguration model) {
            this.name(model.name);
            this.action(model.action);
            this.period(model.period);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(FolderName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(RetentionAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final Integer getPeriod() {
            return this.period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        public FolderConfiguration build() {
            return new FolderConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FolderConfiguration> {
        public Builder name(String var1);

        public Builder name(FolderName var1);

        public Builder action(String var1);

        public Builder action(RetentionAction var1);

        public Builder period(Integer var1);
    }
}

