/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourceDelegatesResponse extends WorkMailResponse implements
        ToCopyableBuilder<ListResourceDelegatesResponse.Builder, ListResourceDelegatesResponse> {
    private static final SdkField<List<Delegate>> DELEGATES_FIELD = SdkField
            .<List<Delegate>> builder(MarshallingType.LIST)
            .memberName("Delegates")
            .getter(getter(ListResourceDelegatesResponse::delegates))
            .setter(setter(Builder::delegates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delegates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Delegate> builder(MarshallingType.SDK_POJO)
                                            .constructor(Delegate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListResourceDelegatesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELEGATES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Delegate> delegates;

    private final String nextToken;

    private ListResourceDelegatesResponse(BuilderImpl builder) {
        super(builder);
        this.delegates = builder.delegates;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Delegates property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDelegates() {
        return delegates != null && !(delegates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One page of the resource's delegates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDelegates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One page of the resource's delegates.
     */
    public List<Delegate> delegates() {
        return delegates;
    }

    /**
     * <p>
     * The token used to paginate through the delegates associated with a resource. While results are still available,
     * it has an associated value. When the last page is reached, the token is empty.
     * </p>
     * 
     * @return The token used to paginate through the delegates associated with a resource. While results are still
     *         available, it has an associated value. When the last page is reached, the token is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDelegates() ? delegates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceDelegatesResponse)) {
            return false;
        }
        ListResourceDelegatesResponse other = (ListResourceDelegatesResponse) obj;
        return hasDelegates() == other.hasDelegates() && Objects.equals(delegates(), other.delegates())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListResourceDelegatesResponse").add("Delegates", hasDelegates() ? delegates() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Delegates":
            return Optional.ofNullable(clazz.cast(delegates()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourceDelegatesResponse, T> g) {
        return obj -> g.apply((ListResourceDelegatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListResourceDelegatesResponse> {
        /**
         * <p>
         * One page of the resource's delegates.
         * </p>
         * 
         * @param delegates
         *        One page of the resource's delegates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegates(Collection<Delegate> delegates);

        /**
         * <p>
         * One page of the resource's delegates.
         * </p>
         * 
         * @param delegates
         *        One page of the resource's delegates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegates(Delegate... delegates);

        /**
         * <p>
         * One page of the resource's delegates.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Delegate>.Builder} avoiding the need to
         * create one manually via {@link List<Delegate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Delegate>.Builder#build()} is called immediately and its
         * result is passed to {@link #delegates(List<Delegate>)}.
         * 
         * @param delegates
         *        a consumer that will call methods on {@link List<Delegate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #delegates(List<Delegate>)
         */
        Builder delegates(Consumer<Delegate.Builder>... delegates);

        /**
         * <p>
         * The token used to paginate through the delegates associated with a resource. While results are still
         * available, it has an associated value. When the last page is reached, the token is empty.
         * </p>
         * 
         * @param nextToken
         *        The token used to paginate through the delegates associated with a resource. While results are still
         *        available, it has an associated value. When the last page is reached, the token is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends WorkMailResponse.BuilderImpl implements Builder {
        private List<Delegate> delegates = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceDelegatesResponse model) {
            super(model);
            delegates(model.delegates);
            nextToken(model.nextToken);
        }

        public final Collection<Delegate.Builder> getDelegates() {
            if (delegates instanceof SdkAutoConstructList) {
                return null;
            }
            return delegates != null ? delegates.stream().map(Delegate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder delegates(Collection<Delegate> delegates) {
            this.delegates = ResourceDelegatesCopier.copy(delegates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder delegates(Delegate... delegates) {
            delegates(Arrays.asList(delegates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder delegates(Consumer<Delegate.Builder>... delegates) {
            delegates(Stream.of(delegates).map(c -> Delegate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDelegates(Collection<Delegate.BuilderImpl> delegates) {
            this.delegates = ResourceDelegatesCopier.copyFromBuilder(delegates);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListResourceDelegatesResponse build() {
            return new ListResourceDelegatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
