/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workmail.model.MailboxExportJobState;
import software.amazon.awssdk.services.workmail.model.WorkMailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMailboxExportJobResponse
extends WorkMailResponse
implements ToCopyableBuilder<Builder, DescribeMailboxExportJobResponse> {
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityId").getter(DescribeMailboxExportJobResponse.getter(DescribeMailboxExportJobResponse::entityId)).setter(DescribeMailboxExportJobResponse.setter(Builder::entityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeMailboxExportJobResponse.getter(DescribeMailboxExportJobResponse::description)).setter(DescribeMailboxExportJobResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeMailboxExportJobResponse.getter(DescribeMailboxExportJobResponse::roleArn)).setter(DescribeMailboxExportJobResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyArn").getter(DescribeMailboxExportJobResponse.getter(DescribeMailboxExportJobResponse::kmsKeyArn)).setter(DescribeMailboxExportJobResponse.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()}).build();
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketName").getter(DescribeMailboxExportJobResponse.getter(DescribeMailboxExportJobResponse::s3BucketName)).setter(DescribeMailboxExportJobResponse.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()}).build();
    private static final SdkField<String> S3_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Prefix").getter(DescribeMailboxExportJobResponse.getter(DescribeMailboxExportJobResponse::s3Prefix)).setter(DescribeMailboxExportJobResponse.setter(Builder::s3Prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Prefix").build()}).build();
    private static final SdkField<String> S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Path").getter(DescribeMailboxExportJobResponse.getter(DescribeMailboxExportJobResponse::s3Path)).setter(DescribeMailboxExportJobResponse.setter(Builder::s3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Path").build()}).build();
    private static final SdkField<Integer> ESTIMATED_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EstimatedProgress").getter(DescribeMailboxExportJobResponse.getter(DescribeMailboxExportJobResponse::estimatedProgress)).setter(DescribeMailboxExportJobResponse.setter(Builder::estimatedProgress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedProgress").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(DescribeMailboxExportJobResponse.getter(DescribeMailboxExportJobResponse::stateAsString)).setter(DescribeMailboxExportJobResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> ERROR_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorInfo").getter(DescribeMailboxExportJobResponse.getter(DescribeMailboxExportJobResponse::errorInfo)).setter(DescribeMailboxExportJobResponse.setter(Builder::errorInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorInfo").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(DescribeMailboxExportJobResponse.getter(DescribeMailboxExportJobResponse::startTime)).setter(DescribeMailboxExportJobResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(DescribeMailboxExportJobResponse.getter(DescribeMailboxExportJobResponse::endTime)).setter(DescribeMailboxExportJobResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_ID_FIELD, DESCRIPTION_FIELD, ROLE_ARN_FIELD, KMS_KEY_ARN_FIELD, S3_BUCKET_NAME_FIELD, S3_PREFIX_FIELD, S3_PATH_FIELD, ESTIMATED_PROGRESS_FIELD, STATE_FIELD, ERROR_INFO_FIELD, START_TIME_FIELD, END_TIME_FIELD));
    private final String entityId;
    private final String description;
    private final String roleArn;
    private final String kmsKeyArn;
    private final String s3BucketName;
    private final String s3Prefix;
    private final String s3Path;
    private final Integer estimatedProgress;
    private final String state;
    private final String errorInfo;
    private final Instant startTime;
    private final Instant endTime;

    private DescribeMailboxExportJobResponse(BuilderImpl builder) {
        super(builder);
        this.entityId = builder.entityId;
        this.description = builder.description;
        this.roleArn = builder.roleArn;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.s3BucketName = builder.s3BucketName;
        this.s3Prefix = builder.s3Prefix;
        this.s3Path = builder.s3Path;
        this.estimatedProgress = builder.estimatedProgress;
        this.state = builder.state;
        this.errorInfo = builder.errorInfo;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    public String entityId() {
        return this.entityId;
    }

    public String description() {
        return this.description;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public String s3BucketName() {
        return this.s3BucketName;
    }

    public String s3Prefix() {
        return this.s3Prefix;
    }

    public String s3Path() {
        return this.s3Path;
    }

    public Integer estimatedProgress() {
        return this.estimatedProgress;
    }

    public MailboxExportJobState state() {
        return MailboxExportJobState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String errorInfo() {
        return this.errorInfo;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMailboxExportJobResponse)) {
            return false;
        }
        DescribeMailboxExportJobResponse other = (DescribeMailboxExportJobResponse)((Object)obj);
        return Objects.equals(this.entityId(), other.entityId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.s3Prefix(), other.s3Prefix()) && Objects.equals(this.s3Path(), other.s3Path()) && Objects.equals(this.estimatedProgress(), other.estimatedProgress()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.errorInfo(), other.errorInfo()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public String toString() {
        return ToString.builder((String)"DescribeMailboxExportJobResponse").add("EntityId", (Object)this.entityId()).add("Description", (Object)this.description()).add("RoleArn", (Object)this.roleArn()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("S3BucketName", (Object)this.s3BucketName()).add("S3Prefix", (Object)this.s3Prefix()).add("S3Path", (Object)this.s3Path()).add("EstimatedProgress", (Object)this.estimatedProgress()).add("State", (Object)this.stateAsString()).add("ErrorInfo", (Object)this.errorInfo()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EntityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "S3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "S3Prefix": {
                return Optional.ofNullable(clazz.cast(this.s3Prefix()));
            }
            case "S3Path": {
                return Optional.ofNullable(clazz.cast(this.s3Path()));
            }
            case "EstimatedProgress": {
                return Optional.ofNullable(clazz.cast(this.estimatedProgress()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "ErrorInfo": {
                return Optional.ofNullable(clazz.cast(this.errorInfo()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMailboxExportJobResponse, T> g) {
        return obj -> g.apply((DescribeMailboxExportJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailResponse.BuilderImpl
    implements Builder {
        private String entityId;
        private String description;
        private String roleArn;
        private String kmsKeyArn;
        private String s3BucketName;
        private String s3Prefix;
        private String s3Path;
        private Integer estimatedProgress;
        private String state;
        private String errorInfo;
        private Instant startTime;
        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMailboxExportJobResponse model) {
            super(model);
            this.entityId(model.entityId);
            this.description(model.description);
            this.roleArn(model.roleArn);
            this.kmsKeyArn(model.kmsKeyArn);
            this.s3BucketName(model.s3BucketName);
            this.s3Prefix(model.s3Prefix);
            this.s3Path(model.s3Path);
            this.estimatedProgress(model.estimatedProgress);
            this.state(model.state);
            this.errorInfo(model.errorInfo);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
        }

        public final String getEntityId() {
            return this.entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        public final String getS3Prefix() {
            return this.s3Prefix;
        }

        @Override
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        public final String getS3Path() {
            return this.s3Path;
        }

        @Override
        public final Builder s3Path(String s3Path) {
            this.s3Path = s3Path;
            return this;
        }

        public final void setS3Path(String s3Path) {
            this.s3Path = s3Path;
        }

        public final Integer getEstimatedProgress() {
            return this.estimatedProgress;
        }

        @Override
        public final Builder estimatedProgress(Integer estimatedProgress) {
            this.estimatedProgress = estimatedProgress;
            return this;
        }

        public final void setEstimatedProgress(Integer estimatedProgress) {
            this.estimatedProgress = estimatedProgress;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(MailboxExportJobState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getErrorInfo() {
            return this.errorInfo;
        }

        @Override
        public final Builder errorInfo(String errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        public final void setErrorInfo(String errorInfo) {
            this.errorInfo = errorInfo;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public DescribeMailboxExportJobResponse build() {
            return new DescribeMailboxExportJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkMailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMailboxExportJobResponse> {
        public Builder entityId(String var1);

        public Builder description(String var1);

        public Builder roleArn(String var1);

        public Builder kmsKeyArn(String var1);

        public Builder s3BucketName(String var1);

        public Builder s3Prefix(String var1);

        public Builder s3Path(String var1);

        public Builder estimatedProgress(Integer var1);

        public Builder state(String var1);

        public Builder state(MailboxExportJobState var1);

        public Builder errorInfo(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);
    }
}

