/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workmail.model.AccessControlRuleEffect;
import software.amazon.awssdk.services.workmail.model.ActionsListCopier;
import software.amazon.awssdk.services.workmail.model.IpRangeListCopier;
import software.amazon.awssdk.services.workmail.model.UserIdListCopier;
import software.amazon.awssdk.services.workmail.model.WorkMailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutAccessControlRuleRequest
extends WorkMailRequest
implements ToCopyableBuilder<Builder, PutAccessControlRuleRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(PutAccessControlRuleRequest.getter(PutAccessControlRuleRequest::name)).setter(PutAccessControlRuleRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> EFFECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Effect").getter(PutAccessControlRuleRequest.getter(PutAccessControlRuleRequest::effectAsString)).setter(PutAccessControlRuleRequest.setter(Builder::effect)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Effect").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(PutAccessControlRuleRequest.getter(PutAccessControlRuleRequest::description)).setter(PutAccessControlRuleRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<String>> IP_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpRanges").getter(PutAccessControlRuleRequest.getter(PutAccessControlRuleRequest::ipRanges)).setter(PutAccessControlRuleRequest.setter(Builder::ipRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpRanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NOT_IP_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NotIpRanges").getter(PutAccessControlRuleRequest.getter(PutAccessControlRuleRequest::notIpRanges)).setter(PutAccessControlRuleRequest.setter(Builder::notIpRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotIpRanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actions").getter(PutAccessControlRuleRequest.getter(PutAccessControlRuleRequest::actions)).setter(PutAccessControlRuleRequest.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NOT_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NotActions").getter(PutAccessControlRuleRequest.getter(PutAccessControlRuleRequest::notActions)).setter(PutAccessControlRuleRequest.setter(Builder::notActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> USER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserIds").getter(PutAccessControlRuleRequest.getter(PutAccessControlRuleRequest::userIds)).setter(PutAccessControlRuleRequest.setter(Builder::userIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NOT_USER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NotUserIds").getter(PutAccessControlRuleRequest.getter(PutAccessControlRuleRequest::notUserIds)).setter(PutAccessControlRuleRequest.setter(Builder::notUserIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotUserIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationId").getter(PutAccessControlRuleRequest.getter(PutAccessControlRuleRequest::organizationId)).setter(PutAccessControlRuleRequest.setter(Builder::organizationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, EFFECT_FIELD, DESCRIPTION_FIELD, IP_RANGES_FIELD, NOT_IP_RANGES_FIELD, ACTIONS_FIELD, NOT_ACTIONS_FIELD, USER_IDS_FIELD, NOT_USER_IDS_FIELD, ORGANIZATION_ID_FIELD));
    private final String name;
    private final String effect;
    private final String description;
    private final List<String> ipRanges;
    private final List<String> notIpRanges;
    private final List<String> actions;
    private final List<String> notActions;
    private final List<String> userIds;
    private final List<String> notUserIds;
    private final String organizationId;

    private PutAccessControlRuleRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.effect = builder.effect;
        this.description = builder.description;
        this.ipRanges = builder.ipRanges;
        this.notIpRanges = builder.notIpRanges;
        this.actions = builder.actions;
        this.notActions = builder.notActions;
        this.userIds = builder.userIds;
        this.notUserIds = builder.notUserIds;
        this.organizationId = builder.organizationId;
    }

    public final String name() {
        return this.name;
    }

    public final AccessControlRuleEffect effect() {
        return AccessControlRuleEffect.fromValue(this.effect);
    }

    public final String effectAsString() {
        return this.effect;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasIpRanges() {
        return this.ipRanges != null && !(this.ipRanges instanceof SdkAutoConstructList);
    }

    public final List<String> ipRanges() {
        return this.ipRanges;
    }

    public final boolean hasNotIpRanges() {
        return this.notIpRanges != null && !(this.notIpRanges instanceof SdkAutoConstructList);
    }

    public final List<String> notIpRanges() {
        return this.notIpRanges;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<String> actions() {
        return this.actions;
    }

    public final boolean hasNotActions() {
        return this.notActions != null && !(this.notActions instanceof SdkAutoConstructList);
    }

    public final List<String> notActions() {
        return this.notActions;
    }

    public final boolean hasUserIds() {
        return this.userIds != null && !(this.userIds instanceof SdkAutoConstructList);
    }

    public final List<String> userIds() {
        return this.userIds;
    }

    public final boolean hasNotUserIds() {
        return this.notUserIds != null && !(this.notUserIds instanceof SdkAutoConstructList);
    }

    public final List<String> notUserIds() {
        return this.notUserIds;
    }

    public final String organizationId() {
        return this.organizationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpRanges() ? this.ipRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotIpRanges() ? this.notIpRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotActions() ? this.notActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserIds() ? this.userIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotUserIds() ? this.notUserIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAccessControlRuleRequest)) {
            return false;
        }
        PutAccessControlRuleRequest other = (PutAccessControlRuleRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.effectAsString(), other.effectAsString()) && Objects.equals(this.description(), other.description()) && this.hasIpRanges() == other.hasIpRanges() && Objects.equals(this.ipRanges(), other.ipRanges()) && this.hasNotIpRanges() == other.hasNotIpRanges() && Objects.equals(this.notIpRanges(), other.notIpRanges()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && this.hasNotActions() == other.hasNotActions() && Objects.equals(this.notActions(), other.notActions()) && this.hasUserIds() == other.hasUserIds() && Objects.equals(this.userIds(), other.userIds()) && this.hasNotUserIds() == other.hasNotUserIds() && Objects.equals(this.notUserIds(), other.notUserIds()) && Objects.equals(this.organizationId(), other.organizationId());
    }

    public final String toString() {
        return ToString.builder((String)"PutAccessControlRuleRequest").add("Name", (Object)this.name()).add("Effect", (Object)this.effectAsString()).add("Description", (Object)this.description()).add("IpRanges", this.hasIpRanges() ? this.ipRanges() : null).add("NotIpRanges", this.hasNotIpRanges() ? this.notIpRanges() : null).add("Actions", this.hasActions() ? this.actions() : null).add("NotActions", this.hasNotActions() ? this.notActions() : null).add("UserIds", this.hasUserIds() ? this.userIds() : null).add("NotUserIds", this.hasNotUserIds() ? this.notUserIds() : null).add("OrganizationId", (Object)this.organizationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Effect": {
                return Optional.ofNullable(clazz.cast(this.effectAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "IpRanges": {
                return Optional.ofNullable(clazz.cast(this.ipRanges()));
            }
            case "NotIpRanges": {
                return Optional.ofNullable(clazz.cast(this.notIpRanges()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "NotActions": {
                return Optional.ofNullable(clazz.cast(this.notActions()));
            }
            case "UserIds": {
                return Optional.ofNullable(clazz.cast(this.userIds()));
            }
            case "NotUserIds": {
                return Optional.ofNullable(clazz.cast(this.notUserIds()));
            }
            case "OrganizationId": {
                return Optional.ofNullable(clazz.cast(this.organizationId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutAccessControlRuleRequest, T> g) {
        return obj -> g.apply((PutAccessControlRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailRequest.BuilderImpl
    implements Builder {
        private String name;
        private String effect;
        private String description;
        private List<String> ipRanges = DefaultSdkAutoConstructList.getInstance();
        private List<String> notIpRanges = DefaultSdkAutoConstructList.getInstance();
        private List<String> actions = DefaultSdkAutoConstructList.getInstance();
        private List<String> notActions = DefaultSdkAutoConstructList.getInstance();
        private List<String> userIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> notUserIds = DefaultSdkAutoConstructList.getInstance();
        private String organizationId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAccessControlRuleRequest model) {
            super(model);
            this.name(model.name);
            this.effect(model.effect);
            this.description(model.description);
            this.ipRanges(model.ipRanges);
            this.notIpRanges(model.notIpRanges);
            this.actions(model.actions);
            this.notActions(model.notActions);
            this.userIds(model.userIds);
            this.notUserIds(model.notUserIds);
            this.organizationId(model.organizationId);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getEffect() {
            return this.effect;
        }

        @Override
        public final Builder effect(String effect) {
            this.effect = effect;
            return this;
        }

        @Override
        public final Builder effect(AccessControlRuleEffect effect) {
            this.effect(effect == null ? null : effect.toString());
            return this;
        }

        public final void setEffect(String effect) {
            this.effect = effect;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getIpRanges() {
            if (this.ipRanges instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ipRanges;
        }

        @Override
        public final Builder ipRanges(Collection<String> ipRanges) {
            this.ipRanges = IpRangeListCopier.copy(ipRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRanges(String ... ipRanges) {
            this.ipRanges(Arrays.asList(ipRanges));
            return this;
        }

        public final void setIpRanges(Collection<String> ipRanges) {
            this.ipRanges = IpRangeListCopier.copy(ipRanges);
        }

        public final Collection<String> getNotIpRanges() {
            if (this.notIpRanges instanceof SdkAutoConstructList) {
                return null;
            }
            return this.notIpRanges;
        }

        @Override
        public final Builder notIpRanges(Collection<String> notIpRanges) {
            this.notIpRanges = IpRangeListCopier.copy(notIpRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notIpRanges(String ... notIpRanges) {
            this.notIpRanges(Arrays.asList(notIpRanges));
            return this;
        }

        public final void setNotIpRanges(Collection<String> notIpRanges) {
            this.notIpRanges = IpRangeListCopier.copy(notIpRanges);
        }

        public final Collection<String> getActions() {
            if (this.actions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.actions;
        }

        @Override
        public final Builder actions(Collection<String> actions) {
            this.actions = ActionsListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(String ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        public final void setActions(Collection<String> actions) {
            this.actions = ActionsListCopier.copy(actions);
        }

        public final Collection<String> getNotActions() {
            if (this.notActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.notActions;
        }

        @Override
        public final Builder notActions(Collection<String> notActions) {
            this.notActions = ActionsListCopier.copy(notActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notActions(String ... notActions) {
            this.notActions(Arrays.asList(notActions));
            return this;
        }

        public final void setNotActions(Collection<String> notActions) {
            this.notActions = ActionsListCopier.copy(notActions);
        }

        public final Collection<String> getUserIds() {
            if (this.userIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userIds;
        }

        @Override
        public final Builder userIds(Collection<String> userIds) {
            this.userIds = UserIdListCopier.copy(userIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIds(String ... userIds) {
            this.userIds(Arrays.asList(userIds));
            return this;
        }

        public final void setUserIds(Collection<String> userIds) {
            this.userIds = UserIdListCopier.copy(userIds);
        }

        public final Collection<String> getNotUserIds() {
            if (this.notUserIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.notUserIds;
        }

        @Override
        public final Builder notUserIds(Collection<String> notUserIds) {
            this.notUserIds = UserIdListCopier.copy(notUserIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notUserIds(String ... notUserIds) {
            this.notUserIds(Arrays.asList(notUserIds));
            return this;
        }

        public final void setNotUserIds(Collection<String> notUserIds) {
            this.notUserIds = UserIdListCopier.copy(notUserIds);
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAccessControlRuleRequest build() {
            return new PutAccessControlRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkMailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutAccessControlRuleRequest> {
        public Builder name(String var1);

        public Builder effect(String var1);

        public Builder effect(AccessControlRuleEffect var1);

        public Builder description(String var1);

        public Builder ipRanges(Collection<String> var1);

        public Builder ipRanges(String ... var1);

        public Builder notIpRanges(Collection<String> var1);

        public Builder notIpRanges(String ... var1);

        public Builder actions(Collection<String> var1);

        public Builder actions(String ... var1);

        public Builder notActions(Collection<String> var1);

        public Builder notActions(String ... var1);

        public Builder userIds(Collection<String> var1);

        public Builder userIds(String ... var1);

        public Builder notUserIds(Collection<String> var1);

        public Builder notUserIds(String ... var1);

        public Builder organizationId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

