/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRetentionPolicyRequest extends WorkMailRequest implements
        ToCopyableBuilder<PutRetentionPolicyRequest.Builder, PutRetentionPolicyRequest> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationId").getter(getter(PutRetentionPolicyRequest::organizationId))
            .setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(PutRetentionPolicyRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(PutRetentionPolicyRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(PutRetentionPolicyRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<FolderConfiguration>> FOLDER_CONFIGURATIONS_FIELD = SdkField
            .<List<FolderConfiguration>> builder(MarshallingType.LIST)
            .memberName("FolderConfigurations")
            .getter(getter(PutRetentionPolicyRequest::folderConfigurations))
            .setter(setter(Builder::folderConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FolderConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FolderConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(FolderConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD,
            ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, FOLDER_CONFIGURATIONS_FIELD));

    private final String organizationId;

    private final String id;

    private final String name;

    private final String description;

    private final List<FolderConfiguration> folderConfigurations;

    private PutRetentionPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.folderConfigurations = builder.folderConfigurations;
    }

    /**
     * <p>
     * The organization ID.
     * </p>
     * 
     * @return The organization ID.
     */
    public final String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * The retention policy ID.
     * </p>
     * 
     * @return The retention policy ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The retention policy name.
     * </p>
     * 
     * @return The retention policy name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The retention policy description.
     * </p>
     * 
     * @return The retention policy description.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns true if the FolderConfigurations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasFolderConfigurations() {
        return folderConfigurations != null && !(folderConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The retention policy folder configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFolderConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The retention policy folder configurations.
     */
    public final List<FolderConfiguration> folderConfigurations() {
        return folderConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasFolderConfigurations() ? folderConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRetentionPolicyRequest)) {
            return false;
        }
        PutRetentionPolicyRequest other = (PutRetentionPolicyRequest) obj;
        return Objects.equals(organizationId(), other.organizationId()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && hasFolderConfigurations() == other.hasFolderConfigurations()
                && Objects.equals(folderConfigurations(), other.folderConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutRetentionPolicyRequest").add("OrganizationId", organizationId()).add("Id", id())
                .add("Name", name()).add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FolderConfigurations", hasFolderConfigurations() ? folderConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "FolderConfigurations":
            return Optional.ofNullable(clazz.cast(folderConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRetentionPolicyRequest, T> g) {
        return obj -> g.apply((PutRetentionPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutRetentionPolicyRequest> {
        /**
         * <p>
         * The organization ID.
         * </p>
         * 
         * @param organizationId
         *        The organization ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * The retention policy ID.
         * </p>
         * 
         * @param id
         *        The retention policy ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The retention policy name.
         * </p>
         * 
         * @param name
         *        The retention policy name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The retention policy description.
         * </p>
         * 
         * @param description
         *        The retention policy description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The retention policy folder configurations.
         * </p>
         * 
         * @param folderConfigurations
         *        The retention policy folder configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folderConfigurations(Collection<FolderConfiguration> folderConfigurations);

        /**
         * <p>
         * The retention policy folder configurations.
         * </p>
         * 
         * @param folderConfigurations
         *        The retention policy folder configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folderConfigurations(FolderConfiguration... folderConfigurations);

        /**
         * <p>
         * The retention policy folder configurations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FolderConfiguration>.Builder} avoiding the
         * need to create one manually via {@link List<FolderConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FolderConfiguration>.Builder#build()} is called immediately
         * and its result is passed to {@link #folderConfigurations(List<FolderConfiguration>)}.
         * 
         * @param folderConfigurations
         *        a consumer that will call methods on {@link List<FolderConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #folderConfigurations(List<FolderConfiguration>)
         */
        Builder folderConfigurations(Consumer<FolderConfiguration.Builder>... folderConfigurations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkMailRequest.BuilderImpl implements Builder {
        private String organizationId;

        private String id;

        private String name;

        private String description;

        private List<FolderConfiguration> folderConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutRetentionPolicyRequest model) {
            super(model);
            organizationId(model.organizationId);
            id(model.id);
            name(model.name);
            description(model.description);
            folderConfigurations(model.folderConfigurations);
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final List<FolderConfiguration.Builder> getFolderConfigurations() {
            List<FolderConfiguration.Builder> result = FolderConfigurationsCopier.copyToBuilder(this.folderConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder folderConfigurations(Collection<FolderConfiguration> folderConfigurations) {
            this.folderConfigurations = FolderConfigurationsCopier.copy(folderConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folderConfigurations(FolderConfiguration... folderConfigurations) {
            folderConfigurations(Arrays.asList(folderConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder folderConfigurations(Consumer<FolderConfiguration.Builder>... folderConfigurations) {
            folderConfigurations(Stream.of(folderConfigurations).map(c -> FolderConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFolderConfigurations(Collection<FolderConfiguration.BuilderImpl> folderConfigurations) {
            this.folderConfigurations = FolderConfigurationsCopier.copyFromBuilder(folderConfigurations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRetentionPolicyRequest build() {
            return new PutRetentionPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
