/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMailboxExportJobResponse extends WorkMailResponse implements
        ToCopyableBuilder<DescribeMailboxExportJobResponse.Builder, DescribeMailboxExportJobResponse> {
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityId").getter(getter(DescribeMailboxExportJobResponse::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeMailboxExportJobResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeMailboxExportJobResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn").getter(getter(DescribeMailboxExportJobResponse::kmsKeyArn))
            .setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()).build();

    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketName").getter(getter(DescribeMailboxExportJobResponse::s3BucketName))
            .setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()).build();

    private static final SdkField<String> S3_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3Prefix").getter(getter(DescribeMailboxExportJobResponse::s3Prefix)).setter(setter(Builder::s3Prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Prefix").build()).build();

    private static final SdkField<String> S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Path")
            .getter(getter(DescribeMailboxExportJobResponse::s3Path)).setter(setter(Builder::s3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Path").build()).build();

    private static final SdkField<Integer> ESTIMATED_PROGRESS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EstimatedProgress").getter(getter(DescribeMailboxExportJobResponse::estimatedProgress))
            .setter(setter(Builder::estimatedProgress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedProgress").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(DescribeMailboxExportJobResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> ERROR_INFO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorInfo").getter(getter(DescribeMailboxExportJobResponse::errorInfo))
            .setter(setter(Builder::errorInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorInfo").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(DescribeMailboxExportJobResponse::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(DescribeMailboxExportJobResponse::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_ID_FIELD,
            DESCRIPTION_FIELD, ROLE_ARN_FIELD, KMS_KEY_ARN_FIELD, S3_BUCKET_NAME_FIELD, S3_PREFIX_FIELD, S3_PATH_FIELD,
            ESTIMATED_PROGRESS_FIELD, STATE_FIELD, ERROR_INFO_FIELD, START_TIME_FIELD, END_TIME_FIELD));

    private final String entityId;

    private final String description;

    private final String roleArn;

    private final String kmsKeyArn;

    private final String s3BucketName;

    private final String s3Prefix;

    private final String s3Path;

    private final Integer estimatedProgress;

    private final String state;

    private final String errorInfo;

    private final Instant startTime;

    private final Instant endTime;

    private DescribeMailboxExportJobResponse(BuilderImpl builder) {
        super(builder);
        this.entityId = builder.entityId;
        this.description = builder.description;
        this.roleArn = builder.roleArn;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.s3BucketName = builder.s3BucketName;
        this.s3Prefix = builder.s3Prefix;
        this.s3Path = builder.s3Path;
        this.estimatedProgress = builder.estimatedProgress;
        this.state = builder.state;
        this.errorInfo = builder.errorInfo;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    /**
     * <p>
     * The identifier of the user or resource associated with the mailbox.
     * </p>
     * 
     * @return The identifier of the user or resource associated with the mailbox.
     */
    public final String entityId() {
        return entityId;
    }

    /**
     * <p>
     * The mailbox export job description.
     * </p>
     * 
     * @return The mailbox export job description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ARN of the AWS Identity and Access Management (IAM) role that grants write permission to the Amazon Simple
     * Storage Service (Amazon S3) bucket.
     * </p>
     * 
     * @return The ARN of the AWS Identity and Access Management (IAM) role that grants write permission to the Amazon
     *         Simple Storage Service (Amazon S3) bucket.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the symmetric AWS Key Management Service (AWS KMS) key that encrypts the
     * exported mailbox content.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the symmetric AWS Key Management Service (AWS KMS) key that encrypts
     *         the exported mailbox content.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * The name of the S3 bucket.
     * </p>
     * 
     * @return The name of the S3 bucket.
     */
    public final String s3BucketName() {
        return s3BucketName;
    }

    /**
     * <p>
     * The S3 bucket prefix.
     * </p>
     * 
     * @return The S3 bucket prefix.
     */
    public final String s3Prefix() {
        return s3Prefix;
    }

    /**
     * <p>
     * The path to the S3 bucket and file that the mailbox export job is exporting to.
     * </p>
     * 
     * @return The path to the S3 bucket and file that the mailbox export job is exporting to.
     */
    public final String s3Path() {
        return s3Path;
    }

    /**
     * <p>
     * The estimated progress of the mailbox export job, in percentage points.
     * </p>
     * 
     * @return The estimated progress of the mailbox export job, in percentage points.
     */
    public final Integer estimatedProgress() {
        return estimatedProgress;
    }

    /**
     * <p>
     * The state of the mailbox export job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link MailboxExportJobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the mailbox export job.
     * @see MailboxExportJobState
     */
    public final MailboxExportJobState state() {
        return MailboxExportJobState.fromValue(state);
    }

    /**
     * <p>
     * The state of the mailbox export job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link MailboxExportJobState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the mailbox export job.
     * @see MailboxExportJobState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Error information for failed mailbox export jobs.
     * </p>
     * 
     * @return Error information for failed mailbox export jobs.
     */
    public final String errorInfo() {
        return errorInfo;
    }

    /**
     * <p>
     * The mailbox export job start timestamp.
     * </p>
     * 
     * @return The mailbox export job start timestamp.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The mailbox export job end timestamp.
     * </p>
     * 
     * @return The mailbox export job end timestamp.
     */
    public final Instant endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(s3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(s3Path());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedProgress());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorInfo());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMailboxExportJobResponse)) {
            return false;
        }
        DescribeMailboxExportJobResponse other = (DescribeMailboxExportJobResponse) obj;
        return Objects.equals(entityId(), other.entityId()) && Objects.equals(description(), other.description())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && Objects.equals(s3BucketName(), other.s3BucketName()) && Objects.equals(s3Prefix(), other.s3Prefix())
                && Objects.equals(s3Path(), other.s3Path()) && Objects.equals(estimatedProgress(), other.estimatedProgress())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(errorInfo(), other.errorInfo())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeMailboxExportJobResponse").add("EntityId", entityId()).add("Description", description())
                .add("RoleArn", roleArn()).add("KmsKeyArn", kmsKeyArn()).add("S3BucketName", s3BucketName())
                .add("S3Prefix", s3Prefix()).add("S3Path", s3Path()).add("EstimatedProgress", estimatedProgress())
                .add("State", stateAsString()).add("ErrorInfo", errorInfo()).add("StartTime", startTime())
                .add("EndTime", endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EntityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "S3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        case "S3Prefix":
            return Optional.ofNullable(clazz.cast(s3Prefix()));
        case "S3Path":
            return Optional.ofNullable(clazz.cast(s3Path()));
        case "EstimatedProgress":
            return Optional.ofNullable(clazz.cast(estimatedProgress()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "ErrorInfo":
            return Optional.ofNullable(clazz.cast(errorInfo()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMailboxExportJobResponse, T> g) {
        return obj -> g.apply((DescribeMailboxExportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeMailboxExportJobResponse> {
        /**
         * <p>
         * The identifier of the user or resource associated with the mailbox.
         * </p>
         * 
         * @param entityId
         *        The identifier of the user or resource associated with the mailbox.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * The mailbox export job description.
         * </p>
         * 
         * @param description
         *        The mailbox export job description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ARN of the AWS Identity and Access Management (IAM) role that grants write permission to the Amazon
         * Simple Storage Service (Amazon S3) bucket.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the AWS Identity and Access Management (IAM) role that grants write permission to the
         *        Amazon Simple Storage Service (Amazon S3) bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the symmetric AWS Key Management Service (AWS KMS) key that encrypts the
         * exported mailbox content.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of the symmetric AWS Key Management Service (AWS KMS) key that encrypts
         *        the exported mailbox content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The name of the S3 bucket.
         * </p>
         * 
         * @param s3BucketName
         *        The name of the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * <p>
         * The S3 bucket prefix.
         * </p>
         * 
         * @param s3Prefix
         *        The S3 bucket prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Prefix(String s3Prefix);

        /**
         * <p>
         * The path to the S3 bucket and file that the mailbox export job is exporting to.
         * </p>
         * 
         * @param s3Path
         *        The path to the S3 bucket and file that the mailbox export job is exporting to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Path(String s3Path);

        /**
         * <p>
         * The estimated progress of the mailbox export job, in percentage points.
         * </p>
         * 
         * @param estimatedProgress
         *        The estimated progress of the mailbox export job, in percentage points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedProgress(Integer estimatedProgress);

        /**
         * <p>
         * The state of the mailbox export job.
         * </p>
         * 
         * @param state
         *        The state of the mailbox export job.
         * @see MailboxExportJobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MailboxExportJobState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the mailbox export job.
         * </p>
         * 
         * @param state
         *        The state of the mailbox export job.
         * @see MailboxExportJobState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MailboxExportJobState
         */
        Builder state(MailboxExportJobState state);

        /**
         * <p>
         * Error information for failed mailbox export jobs.
         * </p>
         * 
         * @param errorInfo
         *        Error information for failed mailbox export jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorInfo(String errorInfo);

        /**
         * <p>
         * The mailbox export job start timestamp.
         * </p>
         * 
         * @param startTime
         *        The mailbox export job start timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The mailbox export job end timestamp.
         * </p>
         * 
         * @param endTime
         *        The mailbox export job end timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);
    }

    static final class BuilderImpl extends WorkMailResponse.BuilderImpl implements Builder {
        private String entityId;

        private String description;

        private String roleArn;

        private String kmsKeyArn;

        private String s3BucketName;

        private String s3Prefix;

        private String s3Path;

        private Integer estimatedProgress;

        private String state;

        private String errorInfo;

        private Instant startTime;

        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMailboxExportJobResponse model) {
            super(model);
            entityId(model.entityId);
            description(model.description);
            roleArn(model.roleArn);
            kmsKeyArn(model.kmsKeyArn);
            s3BucketName(model.s3BucketName);
            s3Prefix(model.s3Prefix);
            s3Path(model.s3Path);
            estimatedProgress(model.estimatedProgress);
            state(model.state);
            errorInfo(model.errorInfo);
            startTime(model.startTime);
            endTime(model.endTime);
        }

        public final String getEntityId() {
            return entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        public final String getS3Prefix() {
            return s3Prefix;
        }

        @Override
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        public final String getS3Path() {
            return s3Path;
        }

        @Override
        public final Builder s3Path(String s3Path) {
            this.s3Path = s3Path;
            return this;
        }

        public final void setS3Path(String s3Path) {
            this.s3Path = s3Path;
        }

        public final Integer getEstimatedProgress() {
            return estimatedProgress;
        }

        @Override
        public final Builder estimatedProgress(Integer estimatedProgress) {
            this.estimatedProgress = estimatedProgress;
            return this;
        }

        public final void setEstimatedProgress(Integer estimatedProgress) {
            this.estimatedProgress = estimatedProgress;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(MailboxExportJobState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getErrorInfo() {
            return errorInfo;
        }

        @Override
        public final Builder errorInfo(String errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        public final void setErrorInfo(String errorInfo) {
            this.errorInfo = errorInfo;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public DescribeMailboxExportJobResponse build() {
            return new DescribeMailboxExportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
