/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workmail.model.MobileDeviceAccessMatchedRule;
import software.amazon.awssdk.services.workmail.model.MobileDeviceAccessMatchedRuleListCopier;
import software.amazon.awssdk.services.workmail.model.MobileDeviceAccessRuleEffect;
import software.amazon.awssdk.services.workmail.model.WorkMailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMobileDeviceAccessEffectResponse
extends WorkMailResponse
implements ToCopyableBuilder<Builder, GetMobileDeviceAccessEffectResponse> {
    private static final SdkField<String> EFFECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Effect").getter(GetMobileDeviceAccessEffectResponse.getter(GetMobileDeviceAccessEffectResponse::effectAsString)).setter(GetMobileDeviceAccessEffectResponse.setter(Builder::effect)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Effect").build()}).build();
    private static final SdkField<List<MobileDeviceAccessMatchedRule>> MATCHED_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MatchedRules").getter(GetMobileDeviceAccessEffectResponse.getter(GetMobileDeviceAccessEffectResponse::matchedRules)).setter(GetMobileDeviceAccessEffectResponse.setter(Builder::matchedRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchedRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MobileDeviceAccessMatchedRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EFFECT_FIELD, MATCHED_RULES_FIELD));
    private final String effect;
    private final List<MobileDeviceAccessMatchedRule> matchedRules;

    private GetMobileDeviceAccessEffectResponse(BuilderImpl builder) {
        super(builder);
        this.effect = builder.effect;
        this.matchedRules = builder.matchedRules;
    }

    public final MobileDeviceAccessRuleEffect effect() {
        return MobileDeviceAccessRuleEffect.fromValue(this.effect);
    }

    public final String effectAsString() {
        return this.effect;
    }

    public final boolean hasMatchedRules() {
        return this.matchedRules != null && !(this.matchedRules instanceof SdkAutoConstructList);
    }

    public final List<MobileDeviceAccessMatchedRule> matchedRules() {
        return this.matchedRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.effectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchedRules() ? this.matchedRules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMobileDeviceAccessEffectResponse)) {
            return false;
        }
        GetMobileDeviceAccessEffectResponse other = (GetMobileDeviceAccessEffectResponse)((Object)obj);
        return Objects.equals(this.effectAsString(), other.effectAsString()) && this.hasMatchedRules() == other.hasMatchedRules() && Objects.equals(this.matchedRules(), other.matchedRules());
    }

    public final String toString() {
        return ToString.builder((String)"GetMobileDeviceAccessEffectResponse").add("Effect", (Object)this.effectAsString()).add("MatchedRules", this.hasMatchedRules() ? this.matchedRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Effect": {
                return Optional.ofNullable(clazz.cast(this.effectAsString()));
            }
            case "MatchedRules": {
                return Optional.ofNullable(clazz.cast(this.matchedRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMobileDeviceAccessEffectResponse, T> g) {
        return obj -> g.apply((GetMobileDeviceAccessEffectResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailResponse.BuilderImpl
    implements Builder {
        private String effect;
        private List<MobileDeviceAccessMatchedRule> matchedRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMobileDeviceAccessEffectResponse model) {
            super(model);
            this.effect(model.effect);
            this.matchedRules(model.matchedRules);
        }

        public final String getEffect() {
            return this.effect;
        }

        @Override
        public final Builder effect(String effect) {
            this.effect = effect;
            return this;
        }

        @Override
        public final Builder effect(MobileDeviceAccessRuleEffect effect) {
            this.effect(effect == null ? null : effect.toString());
            return this;
        }

        public final void setEffect(String effect) {
            this.effect = effect;
        }

        public final List<MobileDeviceAccessMatchedRule.Builder> getMatchedRules() {
            List<MobileDeviceAccessMatchedRule.Builder> result = MobileDeviceAccessMatchedRuleListCopier.copyToBuilder(this.matchedRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder matchedRules(Collection<MobileDeviceAccessMatchedRule> matchedRules) {
            this.matchedRules = MobileDeviceAccessMatchedRuleListCopier.copy(matchedRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchedRules(MobileDeviceAccessMatchedRule ... matchedRules) {
            this.matchedRules(Arrays.asList(matchedRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchedRules(Consumer<MobileDeviceAccessMatchedRule.Builder> ... matchedRules) {
            this.matchedRules(Stream.of(matchedRules).map(c -> (MobileDeviceAccessMatchedRule)((MobileDeviceAccessMatchedRule.Builder)MobileDeviceAccessMatchedRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMatchedRules(Collection<MobileDeviceAccessMatchedRule.BuilderImpl> matchedRules) {
            this.matchedRules = MobileDeviceAccessMatchedRuleListCopier.copyFromBuilder(matchedRules);
        }

        @Override
        public GetMobileDeviceAccessEffectResponse build() {
            return new GetMobileDeviceAccessEffectResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkMailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMobileDeviceAccessEffectResponse> {
        public Builder effect(String var1);

        public Builder effect(MobileDeviceAccessRuleEffect var1);

        public Builder matchedRules(Collection<MobileDeviceAccessMatchedRule> var1);

        public Builder matchedRules(MobileDeviceAccessMatchedRule ... var1);

        public Builder matchedRules(Consumer<MobileDeviceAccessMatchedRule.Builder> ... var1);
    }
}

