/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMobileDeviceAccessRuleRequest extends WorkMailRequest implements
        ToCopyableBuilder<UpdateMobileDeviceAccessRuleRequest.Builder, UpdateMobileDeviceAccessRuleRequest> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationId").getter(getter(UpdateMobileDeviceAccessRuleRequest::organizationId))
            .setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()).build();

    private static final SdkField<String> MOBILE_DEVICE_ACCESS_RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MobileDeviceAccessRuleId").getter(getter(UpdateMobileDeviceAccessRuleRequest::mobileDeviceAccessRuleId))
            .setter(setter(Builder::mobileDeviceAccessRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MobileDeviceAccessRuleId").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateMobileDeviceAccessRuleRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateMobileDeviceAccessRuleRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> EFFECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Effect")
            .getter(getter(UpdateMobileDeviceAccessRuleRequest::effectAsString)).setter(setter(Builder::effect))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Effect").build()).build();

    private static final SdkField<List<String>> DEVICE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DeviceTypes")
            .getter(getter(UpdateMobileDeviceAccessRuleRequest::deviceTypes))
            .setter(setter(Builder::deviceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NOT_DEVICE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NotDeviceTypes")
            .getter(getter(UpdateMobileDeviceAccessRuleRequest::notDeviceTypes))
            .setter(setter(Builder::notDeviceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotDeviceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DEVICE_MODELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DeviceModels")
            .getter(getter(UpdateMobileDeviceAccessRuleRequest::deviceModels))
            .setter(setter(Builder::deviceModels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceModels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NOT_DEVICE_MODELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NotDeviceModels")
            .getter(getter(UpdateMobileDeviceAccessRuleRequest::notDeviceModels))
            .setter(setter(Builder::notDeviceModels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotDeviceModels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DEVICE_OPERATING_SYSTEMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DeviceOperatingSystems")
            .getter(getter(UpdateMobileDeviceAccessRuleRequest::deviceOperatingSystems))
            .setter(setter(Builder::deviceOperatingSystems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceOperatingSystems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NOT_DEVICE_OPERATING_SYSTEMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NotDeviceOperatingSystems")
            .getter(getter(UpdateMobileDeviceAccessRuleRequest::notDeviceOperatingSystems))
            .setter(setter(Builder::notDeviceOperatingSystems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotDeviceOperatingSystems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DEVICE_USER_AGENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DeviceUserAgents")
            .getter(getter(UpdateMobileDeviceAccessRuleRequest::deviceUserAgents))
            .setter(setter(Builder::deviceUserAgents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceUserAgents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NOT_DEVICE_USER_AGENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NotDeviceUserAgents")
            .getter(getter(UpdateMobileDeviceAccessRuleRequest::notDeviceUserAgents))
            .setter(setter(Builder::notDeviceUserAgents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotDeviceUserAgents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD,
            MOBILE_DEVICE_ACCESS_RULE_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, EFFECT_FIELD, DEVICE_TYPES_FIELD,
            NOT_DEVICE_TYPES_FIELD, DEVICE_MODELS_FIELD, NOT_DEVICE_MODELS_FIELD, DEVICE_OPERATING_SYSTEMS_FIELD,
            NOT_DEVICE_OPERATING_SYSTEMS_FIELD, DEVICE_USER_AGENTS_FIELD, NOT_DEVICE_USER_AGENTS_FIELD));

    private final String organizationId;

    private final String mobileDeviceAccessRuleId;

    private final String name;

    private final String description;

    private final String effect;

    private final List<String> deviceTypes;

    private final List<String> notDeviceTypes;

    private final List<String> deviceModels;

    private final List<String> notDeviceModels;

    private final List<String> deviceOperatingSystems;

    private final List<String> notDeviceOperatingSystems;

    private final List<String> deviceUserAgents;

    private final List<String> notDeviceUserAgents;

    private UpdateMobileDeviceAccessRuleRequest(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.mobileDeviceAccessRuleId = builder.mobileDeviceAccessRuleId;
        this.name = builder.name;
        this.description = builder.description;
        this.effect = builder.effect;
        this.deviceTypes = builder.deviceTypes;
        this.notDeviceTypes = builder.notDeviceTypes;
        this.deviceModels = builder.deviceModels;
        this.notDeviceModels = builder.notDeviceModels;
        this.deviceOperatingSystems = builder.deviceOperatingSystems;
        this.notDeviceOperatingSystems = builder.notDeviceOperatingSystems;
        this.deviceUserAgents = builder.deviceUserAgents;
        this.notDeviceUserAgents = builder.notDeviceUserAgents;
    }

    /**
     * <p>
     * The Amazon WorkMail organization under which the rule will be updated.
     * </p>
     * 
     * @return The Amazon WorkMail organization under which the rule will be updated.
     */
    public final String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * The identifier of the rule to be updated.
     * </p>
     * 
     * @return The identifier of the rule to be updated.
     */
    public final String mobileDeviceAccessRuleId() {
        return mobileDeviceAccessRuleId;
    }

    /**
     * <p>
     * The updated rule name.
     * </p>
     * 
     * @return The updated rule name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The updated rule description.
     * </p>
     * 
     * @return The updated rule description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #effect} will
     * return {@link MobileDeviceAccessRuleEffect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #effectAsString}.
     * </p>
     * 
     * @return The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.
     * @see MobileDeviceAccessRuleEffect
     */
    public final MobileDeviceAccessRuleEffect effect() {
        return MobileDeviceAccessRuleEffect.fromValue(effect);
    }

    /**
     * <p>
     * The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #effect} will
     * return {@link MobileDeviceAccessRuleEffect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #effectAsString}.
     * </p>
     * 
     * @return The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.
     * @see MobileDeviceAccessRuleEffect
     */
    public final String effectAsString() {
        return effect;
    }

    /**
     * Returns true if the DeviceTypes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDeviceTypes() {
        return deviceTypes != null && !(deviceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Device types that the updated rule will match.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDeviceTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Device types that the updated rule will match.
     */
    public final List<String> deviceTypes() {
        return deviceTypes;
    }

    /**
     * Returns true if the NotDeviceTypes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasNotDeviceTypes() {
        return notDeviceTypes != null && !(notDeviceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Device types that the updated rule <b>will not</b> match. All other device types will match.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNotDeviceTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Device types that the updated rule <b>will not</b> match. All other device types will match.
     */
    public final List<String> notDeviceTypes() {
        return notDeviceTypes;
    }

    /**
     * Returns true if the DeviceModels property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDeviceModels() {
        return deviceModels != null && !(deviceModels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Device models that the updated rule will match.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDeviceModels()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Device models that the updated rule will match.
     */
    public final List<String> deviceModels() {
        return deviceModels;
    }

    /**
     * Returns true if the NotDeviceModels property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasNotDeviceModels() {
        return notDeviceModels != null && !(notDeviceModels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Device models that the updated rule <b>will not</b> match. All other device models will match.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNotDeviceModels()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Device models that the updated rule <b>will not</b> match. All other device models will match.
     */
    public final List<String> notDeviceModels() {
        return notDeviceModels;
    }

    /**
     * Returns true if the DeviceOperatingSystems property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDeviceOperatingSystems() {
        return deviceOperatingSystems != null && !(deviceOperatingSystems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Device operating systems that the updated rule will match.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDeviceOperatingSystems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Device operating systems that the updated rule will match.
     */
    public final List<String> deviceOperatingSystems() {
        return deviceOperatingSystems;
    }

    /**
     * Returns true if the NotDeviceOperatingSystems property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasNotDeviceOperatingSystems() {
        return notDeviceOperatingSystems != null && !(notDeviceOperatingSystems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Device operating systems that the updated rule <b>will not</b> match. All other device operating systems will
     * match.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNotDeviceOperatingSystems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Device operating systems that the updated rule <b>will not</b> match. All other device operating systems
     *         will match.
     */
    public final List<String> notDeviceOperatingSystems() {
        return notDeviceOperatingSystems;
    }

    /**
     * Returns true if the DeviceUserAgents property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDeviceUserAgents() {
        return deviceUserAgents != null && !(deviceUserAgents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * User agents that the updated rule will match.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDeviceUserAgents()} to see if a value was sent in this field.
     * </p>
     * 
     * @return User agents that the updated rule will match.
     */
    public final List<String> deviceUserAgents() {
        return deviceUserAgents;
    }

    /**
     * Returns true if the NotDeviceUserAgents property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasNotDeviceUserAgents() {
        return notDeviceUserAgents != null && !(notDeviceUserAgents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * User agents that the updated rule <b>will not</b> match. All other user agents will match.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNotDeviceUserAgents()} to see if a value was sent in this field.
     * </p>
     * 
     * @return User agents that the updated rule <b>will not</b> match. All other user agents will match.
     */
    public final List<String> notDeviceUserAgents() {
        return notDeviceUserAgents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(mobileDeviceAccessRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(effectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasDeviceTypes() ? deviceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNotDeviceTypes() ? notDeviceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDeviceModels() ? deviceModels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNotDeviceModels() ? notDeviceModels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDeviceOperatingSystems() ? deviceOperatingSystems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNotDeviceOperatingSystems() ? notDeviceOperatingSystems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDeviceUserAgents() ? deviceUserAgents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNotDeviceUserAgents() ? notDeviceUserAgents() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMobileDeviceAccessRuleRequest)) {
            return false;
        }
        UpdateMobileDeviceAccessRuleRequest other = (UpdateMobileDeviceAccessRuleRequest) obj;
        return Objects.equals(organizationId(), other.organizationId())
                && Objects.equals(mobileDeviceAccessRuleId(), other.mobileDeviceAccessRuleId())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(effectAsString(), other.effectAsString()) && hasDeviceTypes() == other.hasDeviceTypes()
                && Objects.equals(deviceTypes(), other.deviceTypes()) && hasNotDeviceTypes() == other.hasNotDeviceTypes()
                && Objects.equals(notDeviceTypes(), other.notDeviceTypes()) && hasDeviceModels() == other.hasDeviceModels()
                && Objects.equals(deviceModels(), other.deviceModels()) && hasNotDeviceModels() == other.hasNotDeviceModels()
                && Objects.equals(notDeviceModels(), other.notDeviceModels())
                && hasDeviceOperatingSystems() == other.hasDeviceOperatingSystems()
                && Objects.equals(deviceOperatingSystems(), other.deviceOperatingSystems())
                && hasNotDeviceOperatingSystems() == other.hasNotDeviceOperatingSystems()
                && Objects.equals(notDeviceOperatingSystems(), other.notDeviceOperatingSystems())
                && hasDeviceUserAgents() == other.hasDeviceUserAgents()
                && Objects.equals(deviceUserAgents(), other.deviceUserAgents())
                && hasNotDeviceUserAgents() == other.hasNotDeviceUserAgents()
                && Objects.equals(notDeviceUserAgents(), other.notDeviceUserAgents());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMobileDeviceAccessRuleRequest").add("OrganizationId", organizationId())
                .add("MobileDeviceAccessRuleId", mobileDeviceAccessRuleId()).add("Name", name())
                .add("Description", description()).add("Effect", effectAsString())
                .add("DeviceTypes", hasDeviceTypes() ? deviceTypes() : null)
                .add("NotDeviceTypes", hasNotDeviceTypes() ? notDeviceTypes() : null)
                .add("DeviceModels", hasDeviceModels() ? deviceModels() : null)
                .add("NotDeviceModels", hasNotDeviceModels() ? notDeviceModels() : null)
                .add("DeviceOperatingSystems", hasDeviceOperatingSystems() ? deviceOperatingSystems() : null)
                .add("NotDeviceOperatingSystems", hasNotDeviceOperatingSystems() ? notDeviceOperatingSystems() : null)
                .add("DeviceUserAgents", hasDeviceUserAgents() ? deviceUserAgents() : null)
                .add("NotDeviceUserAgents", hasNotDeviceUserAgents() ? notDeviceUserAgents() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "MobileDeviceAccessRuleId":
            return Optional.ofNullable(clazz.cast(mobileDeviceAccessRuleId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Effect":
            return Optional.ofNullable(clazz.cast(effectAsString()));
        case "DeviceTypes":
            return Optional.ofNullable(clazz.cast(deviceTypes()));
        case "NotDeviceTypes":
            return Optional.ofNullable(clazz.cast(notDeviceTypes()));
        case "DeviceModels":
            return Optional.ofNullable(clazz.cast(deviceModels()));
        case "NotDeviceModels":
            return Optional.ofNullable(clazz.cast(notDeviceModels()));
        case "DeviceOperatingSystems":
            return Optional.ofNullable(clazz.cast(deviceOperatingSystems()));
        case "NotDeviceOperatingSystems":
            return Optional.ofNullable(clazz.cast(notDeviceOperatingSystems()));
        case "DeviceUserAgents":
            return Optional.ofNullable(clazz.cast(deviceUserAgents()));
        case "NotDeviceUserAgents":
            return Optional.ofNullable(clazz.cast(notDeviceUserAgents()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMobileDeviceAccessRuleRequest, T> g) {
        return obj -> g.apply((UpdateMobileDeviceAccessRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateMobileDeviceAccessRuleRequest> {
        /**
         * <p>
         * The Amazon WorkMail organization under which the rule will be updated.
         * </p>
         * 
         * @param organizationId
         *        The Amazon WorkMail organization under which the rule will be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * The identifier of the rule to be updated.
         * </p>
         * 
         * @param mobileDeviceAccessRuleId
         *        The identifier of the rule to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mobileDeviceAccessRuleId(String mobileDeviceAccessRuleId);

        /**
         * <p>
         * The updated rule name.
         * </p>
         * 
         * @param name
         *        The updated rule name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The updated rule description.
         * </p>
         * 
         * @param description
         *        The updated rule description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.
         * </p>
         * 
         * @param effect
         *        The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.
         * @see MobileDeviceAccessRuleEffect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MobileDeviceAccessRuleEffect
         */
        Builder effect(String effect);

        /**
         * <p>
         * The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.
         * </p>
         * 
         * @param effect
         *        The effect of the rule when it matches. Allowed values are <code>ALLOW</code> or <code>DENY</code>.
         * @see MobileDeviceAccessRuleEffect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MobileDeviceAccessRuleEffect
         */
        Builder effect(MobileDeviceAccessRuleEffect effect);

        /**
         * <p>
         * Device types that the updated rule will match.
         * </p>
         * 
         * @param deviceTypes
         *        Device types that the updated rule will match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceTypes(Collection<String> deviceTypes);

        /**
         * <p>
         * Device types that the updated rule will match.
         * </p>
         * 
         * @param deviceTypes
         *        Device types that the updated rule will match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceTypes(String... deviceTypes);

        /**
         * <p>
         * Device types that the updated rule <b>will not</b> match. All other device types will match.
         * </p>
         * 
         * @param notDeviceTypes
         *        Device types that the updated rule <b>will not</b> match. All other device types will match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notDeviceTypes(Collection<String> notDeviceTypes);

        /**
         * <p>
         * Device types that the updated rule <b>will not</b> match. All other device types will match.
         * </p>
         * 
         * @param notDeviceTypes
         *        Device types that the updated rule <b>will not</b> match. All other device types will match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notDeviceTypes(String... notDeviceTypes);

        /**
         * <p>
         * Device models that the updated rule will match.
         * </p>
         * 
         * @param deviceModels
         *        Device models that the updated rule will match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceModels(Collection<String> deviceModels);

        /**
         * <p>
         * Device models that the updated rule will match.
         * </p>
         * 
         * @param deviceModels
         *        Device models that the updated rule will match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceModels(String... deviceModels);

        /**
         * <p>
         * Device models that the updated rule <b>will not</b> match. All other device models will match.
         * </p>
         * 
         * @param notDeviceModels
         *        Device models that the updated rule <b>will not</b> match. All other device models will match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notDeviceModels(Collection<String> notDeviceModels);

        /**
         * <p>
         * Device models that the updated rule <b>will not</b> match. All other device models will match.
         * </p>
         * 
         * @param notDeviceModels
         *        Device models that the updated rule <b>will not</b> match. All other device models will match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notDeviceModels(String... notDeviceModels);

        /**
         * <p>
         * Device operating systems that the updated rule will match.
         * </p>
         * 
         * @param deviceOperatingSystems
         *        Device operating systems that the updated rule will match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceOperatingSystems(Collection<String> deviceOperatingSystems);

        /**
         * <p>
         * Device operating systems that the updated rule will match.
         * </p>
         * 
         * @param deviceOperatingSystems
         *        Device operating systems that the updated rule will match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceOperatingSystems(String... deviceOperatingSystems);

        /**
         * <p>
         * Device operating systems that the updated rule <b>will not</b> match. All other device operating systems will
         * match.
         * </p>
         * 
         * @param notDeviceOperatingSystems
         *        Device operating systems that the updated rule <b>will not</b> match. All other device operating
         *        systems will match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notDeviceOperatingSystems(Collection<String> notDeviceOperatingSystems);

        /**
         * <p>
         * Device operating systems that the updated rule <b>will not</b> match. All other device operating systems will
         * match.
         * </p>
         * 
         * @param notDeviceOperatingSystems
         *        Device operating systems that the updated rule <b>will not</b> match. All other device operating
         *        systems will match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notDeviceOperatingSystems(String... notDeviceOperatingSystems);

        /**
         * <p>
         * User agents that the updated rule will match.
         * </p>
         * 
         * @param deviceUserAgents
         *        User agents that the updated rule will match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceUserAgents(Collection<String> deviceUserAgents);

        /**
         * <p>
         * User agents that the updated rule will match.
         * </p>
         * 
         * @param deviceUserAgents
         *        User agents that the updated rule will match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceUserAgents(String... deviceUserAgents);

        /**
         * <p>
         * User agents that the updated rule <b>will not</b> match. All other user agents will match.
         * </p>
         * 
         * @param notDeviceUserAgents
         *        User agents that the updated rule <b>will not</b> match. All other user agents will match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notDeviceUserAgents(Collection<String> notDeviceUserAgents);

        /**
         * <p>
         * User agents that the updated rule <b>will not</b> match. All other user agents will match.
         * </p>
         * 
         * @param notDeviceUserAgents
         *        User agents that the updated rule <b>will not</b> match. All other user agents will match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notDeviceUserAgents(String... notDeviceUserAgents);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkMailRequest.BuilderImpl implements Builder {
        private String organizationId;

        private String mobileDeviceAccessRuleId;

        private String name;

        private String description;

        private String effect;

        private List<String> deviceTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> notDeviceTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> deviceModels = DefaultSdkAutoConstructList.getInstance();

        private List<String> notDeviceModels = DefaultSdkAutoConstructList.getInstance();

        private List<String> deviceOperatingSystems = DefaultSdkAutoConstructList.getInstance();

        private List<String> notDeviceOperatingSystems = DefaultSdkAutoConstructList.getInstance();

        private List<String> deviceUserAgents = DefaultSdkAutoConstructList.getInstance();

        private List<String> notDeviceUserAgents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMobileDeviceAccessRuleRequest model) {
            super(model);
            organizationId(model.organizationId);
            mobileDeviceAccessRuleId(model.mobileDeviceAccessRuleId);
            name(model.name);
            description(model.description);
            effect(model.effect);
            deviceTypes(model.deviceTypes);
            notDeviceTypes(model.notDeviceTypes);
            deviceModels(model.deviceModels);
            notDeviceModels(model.notDeviceModels);
            deviceOperatingSystems(model.deviceOperatingSystems);
            notDeviceOperatingSystems(model.notDeviceOperatingSystems);
            deviceUserAgents(model.deviceUserAgents);
            notDeviceUserAgents(model.notDeviceUserAgents);
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public final String getMobileDeviceAccessRuleId() {
            return mobileDeviceAccessRuleId;
        }

        @Override
        public final Builder mobileDeviceAccessRuleId(String mobileDeviceAccessRuleId) {
            this.mobileDeviceAccessRuleId = mobileDeviceAccessRuleId;
            return this;
        }

        public final void setMobileDeviceAccessRuleId(String mobileDeviceAccessRuleId) {
            this.mobileDeviceAccessRuleId = mobileDeviceAccessRuleId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getEffect() {
            return effect;
        }

        @Override
        public final Builder effect(String effect) {
            this.effect = effect;
            return this;
        }

        @Override
        public final Builder effect(MobileDeviceAccessRuleEffect effect) {
            this.effect(effect == null ? null : effect.toString());
            return this;
        }

        public final void setEffect(String effect) {
            this.effect = effect;
        }

        public final Collection<String> getDeviceTypes() {
            if (deviceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return deviceTypes;
        }

        @Override
        public final Builder deviceTypes(Collection<String> deviceTypes) {
            this.deviceTypes = DeviceTypeListCopier.copy(deviceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceTypes(String... deviceTypes) {
            deviceTypes(Arrays.asList(deviceTypes));
            return this;
        }

        public final void setDeviceTypes(Collection<String> deviceTypes) {
            this.deviceTypes = DeviceTypeListCopier.copy(deviceTypes);
        }

        public final Collection<String> getNotDeviceTypes() {
            if (notDeviceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return notDeviceTypes;
        }

        @Override
        public final Builder notDeviceTypes(Collection<String> notDeviceTypes) {
            this.notDeviceTypes = DeviceTypeListCopier.copy(notDeviceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notDeviceTypes(String... notDeviceTypes) {
            notDeviceTypes(Arrays.asList(notDeviceTypes));
            return this;
        }

        public final void setNotDeviceTypes(Collection<String> notDeviceTypes) {
            this.notDeviceTypes = DeviceTypeListCopier.copy(notDeviceTypes);
        }

        public final Collection<String> getDeviceModels() {
            if (deviceModels instanceof SdkAutoConstructList) {
                return null;
            }
            return deviceModels;
        }

        @Override
        public final Builder deviceModels(Collection<String> deviceModels) {
            this.deviceModels = DeviceModelListCopier.copy(deviceModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceModels(String... deviceModels) {
            deviceModels(Arrays.asList(deviceModels));
            return this;
        }

        public final void setDeviceModels(Collection<String> deviceModels) {
            this.deviceModels = DeviceModelListCopier.copy(deviceModels);
        }

        public final Collection<String> getNotDeviceModels() {
            if (notDeviceModels instanceof SdkAutoConstructList) {
                return null;
            }
            return notDeviceModels;
        }

        @Override
        public final Builder notDeviceModels(Collection<String> notDeviceModels) {
            this.notDeviceModels = DeviceModelListCopier.copy(notDeviceModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notDeviceModels(String... notDeviceModels) {
            notDeviceModels(Arrays.asList(notDeviceModels));
            return this;
        }

        public final void setNotDeviceModels(Collection<String> notDeviceModels) {
            this.notDeviceModels = DeviceModelListCopier.copy(notDeviceModels);
        }

        public final Collection<String> getDeviceOperatingSystems() {
            if (deviceOperatingSystems instanceof SdkAutoConstructList) {
                return null;
            }
            return deviceOperatingSystems;
        }

        @Override
        public final Builder deviceOperatingSystems(Collection<String> deviceOperatingSystems) {
            this.deviceOperatingSystems = DeviceOperatingSystemListCopier.copy(deviceOperatingSystems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceOperatingSystems(String... deviceOperatingSystems) {
            deviceOperatingSystems(Arrays.asList(deviceOperatingSystems));
            return this;
        }

        public final void setDeviceOperatingSystems(Collection<String> deviceOperatingSystems) {
            this.deviceOperatingSystems = DeviceOperatingSystemListCopier.copy(deviceOperatingSystems);
        }

        public final Collection<String> getNotDeviceOperatingSystems() {
            if (notDeviceOperatingSystems instanceof SdkAutoConstructList) {
                return null;
            }
            return notDeviceOperatingSystems;
        }

        @Override
        public final Builder notDeviceOperatingSystems(Collection<String> notDeviceOperatingSystems) {
            this.notDeviceOperatingSystems = DeviceOperatingSystemListCopier.copy(notDeviceOperatingSystems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notDeviceOperatingSystems(String... notDeviceOperatingSystems) {
            notDeviceOperatingSystems(Arrays.asList(notDeviceOperatingSystems));
            return this;
        }

        public final void setNotDeviceOperatingSystems(Collection<String> notDeviceOperatingSystems) {
            this.notDeviceOperatingSystems = DeviceOperatingSystemListCopier.copy(notDeviceOperatingSystems);
        }

        public final Collection<String> getDeviceUserAgents() {
            if (deviceUserAgents instanceof SdkAutoConstructList) {
                return null;
            }
            return deviceUserAgents;
        }

        @Override
        public final Builder deviceUserAgents(Collection<String> deviceUserAgents) {
            this.deviceUserAgents = DeviceUserAgentListCopier.copy(deviceUserAgents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceUserAgents(String... deviceUserAgents) {
            deviceUserAgents(Arrays.asList(deviceUserAgents));
            return this;
        }

        public final void setDeviceUserAgents(Collection<String> deviceUserAgents) {
            this.deviceUserAgents = DeviceUserAgentListCopier.copy(deviceUserAgents);
        }

        public final Collection<String> getNotDeviceUserAgents() {
            if (notDeviceUserAgents instanceof SdkAutoConstructList) {
                return null;
            }
            return notDeviceUserAgents;
        }

        @Override
        public final Builder notDeviceUserAgents(Collection<String> notDeviceUserAgents) {
            this.notDeviceUserAgents = DeviceUserAgentListCopier.copy(notDeviceUserAgents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notDeviceUserAgents(String... notDeviceUserAgents) {
            notDeviceUserAgents(Arrays.asList(notDeviceUserAgents));
            return this;
        }

        public final void setNotDeviceUserAgents(Collection<String> notDeviceUserAgents) {
            this.notDeviceUserAgents = DeviceUserAgentListCopier.copy(notDeviceUserAgents);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMobileDeviceAccessRuleRequest build() {
            return new UpdateMobileDeviceAccessRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
