/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEmailMonitoringConfigurationResponse extends WorkMailResponse implements
        ToCopyableBuilder<DescribeEmailMonitoringConfigurationResponse.Builder, DescribeEmailMonitoringConfigurationResponse> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeEmailMonitoringConfigurationResponse::roleArn))
            .setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> LOG_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogGroupArn").getter(getter(DescribeEmailMonitoringConfigurationResponse::logGroupArn))
            .setter(setter(Builder::logGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            LOG_GROUP_ARN_FIELD));

    private final String roleArn;

    private final String logGroupArn;

    private DescribeEmailMonitoringConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.roleArn = builder.roleArn;
        this.logGroupArn = builder.logGroupArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM Role associated with the email monitoring configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM Role associated with the email monitoring configuration.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the CloudWatch Log group associated with the email monitoring configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the CloudWatch Log group associated with the email monitoring
     *         configuration.
     */
    public final String logGroupArn() {
        return logGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEmailMonitoringConfigurationResponse)) {
            return false;
        }
        DescribeEmailMonitoringConfigurationResponse other = (DescribeEmailMonitoringConfigurationResponse) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(logGroupArn(), other.logGroupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEmailMonitoringConfigurationResponse").add("RoleArn", roleArn())
                .add("LogGroupArn", logGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "LogGroupArn":
            return Optional.ofNullable(clazz.cast(logGroupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEmailMonitoringConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeEmailMonitoringConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEmailMonitoringConfigurationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM Role associated with the email monitoring configuration.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM Role associated with the email monitoring configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the CloudWatch Log group associated with the email monitoring
         * configuration.
         * </p>
         * 
         * @param logGroupArn
         *        The Amazon Resource Name (ARN) of the CloudWatch Log group associated with the email monitoring
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupArn(String logGroupArn);
    }

    static final class BuilderImpl extends WorkMailResponse.BuilderImpl implements Builder {
        private String roleArn;

        private String logGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEmailMonitoringConfigurationResponse model) {
            super(model);
            roleArn(model.roleArn);
            logGroupArn(model.logGroupArn);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getLogGroupArn() {
            return logGroupArn;
        }

        public final void setLogGroupArn(String logGroupArn) {
            this.logGroupArn = logGroupArn;
        }

        @Override
        @Transient
        public final Builder logGroupArn(String logGroupArn) {
            this.logGroupArn = logGroupArn;
            return this;
        }

        @Override
        public DescribeEmailMonitoringConfigurationResponse build() {
            return new DescribeEmailMonitoringConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
