/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteMobileDeviceAccessOverrideRequest extends WorkMailRequest implements
        ToCopyableBuilder<DeleteMobileDeviceAccessOverrideRequest.Builder, DeleteMobileDeviceAccessOverrideRequest> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationId").getter(getter(DeleteMobileDeviceAccessOverrideRequest::organizationId))
            .setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(DeleteMobileDeviceAccessOverrideRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceId").getter(getter(DeleteMobileDeviceAccessOverrideRequest::deviceId))
            .setter(setter(Builder::deviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD,
            USER_ID_FIELD, DEVICE_ID_FIELD));

    private final String organizationId;

    private final String userId;

    private final String deviceId;

    private DeleteMobileDeviceAccessOverrideRequest(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.userId = builder.userId;
        this.deviceId = builder.deviceId;
    }

    /**
     * <p>
     * The Amazon WorkMail organization for which the access override will be deleted.
     * </p>
     * 
     * @return The Amazon WorkMail organization for which the access override will be deleted.
     */
    public final String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * The WorkMail user for which you want to delete the override. Accepts the following types of user identities:
     * </p>
     * <ul>
     * <li>
     * <p>
     * User ID: <code>12345678-1234-1234-1234-123456789012</code> or
     * <code>S-1-1-12-1234567890-123456789-123456789-1234</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Email address: <code>user@domain.tld</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * User name: <code>user</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The WorkMail user for which you want to delete the override. Accepts the following types of user
     *         identities:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         User ID: <code>12345678-1234-1234-1234-123456789012</code> or
     *         <code>S-1-1-12-1234567890-123456789-123456789-1234</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Email address: <code>user@domain.tld</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         User name: <code>user</code>
     *         </p>
     *         </li>
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * The mobile device for which you delete the override. <code>DeviceId</code> is case insensitive.
     * </p>
     * 
     * @return The mobile device for which you delete the override. <code>DeviceId</code> is case insensitive.
     */
    public final String deviceId() {
        return deviceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(deviceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMobileDeviceAccessOverrideRequest)) {
            return false;
        }
        DeleteMobileDeviceAccessOverrideRequest other = (DeleteMobileDeviceAccessOverrideRequest) obj;
        return Objects.equals(organizationId(), other.organizationId()) && Objects.equals(userId(), other.userId())
                && Objects.equals(deviceId(), other.deviceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteMobileDeviceAccessOverrideRequest").add("OrganizationId", organizationId())
                .add("UserId", userId()).add("DeviceId", deviceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "DeviceId":
            return Optional.ofNullable(clazz.cast(deviceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteMobileDeviceAccessOverrideRequest, T> g) {
        return obj -> g.apply((DeleteMobileDeviceAccessOverrideRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteMobileDeviceAccessOverrideRequest> {
        /**
         * <p>
         * The Amazon WorkMail organization for which the access override will be deleted.
         * </p>
         * 
         * @param organizationId
         *        The Amazon WorkMail organization for which the access override will be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * The WorkMail user for which you want to delete the override. Accepts the following types of user identities:
         * </p>
         * <ul>
         * <li>
         * <p>
         * User ID: <code>12345678-1234-1234-1234-123456789012</code> or
         * <code>S-1-1-12-1234567890-123456789-123456789-1234</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Email address: <code>user@domain.tld</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * User name: <code>user</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param userId
         *        The WorkMail user for which you want to delete the override. Accepts the following types of user
         *        identities:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        User ID: <code>12345678-1234-1234-1234-123456789012</code> or
         *        <code>S-1-1-12-1234567890-123456789-123456789-1234</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Email address: <code>user@domain.tld</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        User name: <code>user</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The mobile device for which you delete the override. <code>DeviceId</code> is case insensitive.
         * </p>
         * 
         * @param deviceId
         *        The mobile device for which you delete the override. <code>DeviceId</code> is case insensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkMailRequest.BuilderImpl implements Builder {
        private String organizationId;

        private String userId;

        private String deviceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMobileDeviceAccessOverrideRequest model) {
            super(model);
            organizationId(model.organizationId);
            userId(model.userId);
            deviceId(model.deviceId);
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getDeviceId() {
            return deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteMobileDeviceAccessOverrideRequest build() {
            return new DeleteMobileDeviceAccessOverrideRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
