/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.workmail.model.AssociateDelegateToResourceRequest;
import software.amazon.awssdk.services.workmail.model.AssociateDelegateToResourceResponse;
import software.amazon.awssdk.services.workmail.model.AssociateMemberToGroupRequest;
import software.amazon.awssdk.services.workmail.model.AssociateMemberToGroupResponse;
import software.amazon.awssdk.services.workmail.model.CancelMailboxExportJobRequest;
import software.amazon.awssdk.services.workmail.model.CancelMailboxExportJobResponse;
import software.amazon.awssdk.services.workmail.model.CreateAliasRequest;
import software.amazon.awssdk.services.workmail.model.CreateAliasResponse;
import software.amazon.awssdk.services.workmail.model.CreateAvailabilityConfigurationRequest;
import software.amazon.awssdk.services.workmail.model.CreateAvailabilityConfigurationResponse;
import software.amazon.awssdk.services.workmail.model.CreateGroupRequest;
import software.amazon.awssdk.services.workmail.model.CreateGroupResponse;
import software.amazon.awssdk.services.workmail.model.CreateMobileDeviceAccessRuleRequest;
import software.amazon.awssdk.services.workmail.model.CreateMobileDeviceAccessRuleResponse;
import software.amazon.awssdk.services.workmail.model.CreateOrganizationRequest;
import software.amazon.awssdk.services.workmail.model.CreateOrganizationResponse;
import software.amazon.awssdk.services.workmail.model.CreateResourceRequest;
import software.amazon.awssdk.services.workmail.model.CreateResourceResponse;
import software.amazon.awssdk.services.workmail.model.CreateUserRequest;
import software.amazon.awssdk.services.workmail.model.CreateUserResponse;
import software.amazon.awssdk.services.workmail.model.DeleteAccessControlRuleRequest;
import software.amazon.awssdk.services.workmail.model.DeleteAccessControlRuleResponse;
import software.amazon.awssdk.services.workmail.model.DeleteAliasRequest;
import software.amazon.awssdk.services.workmail.model.DeleteAliasResponse;
import software.amazon.awssdk.services.workmail.model.DeleteAvailabilityConfigurationRequest;
import software.amazon.awssdk.services.workmail.model.DeleteAvailabilityConfigurationResponse;
import software.amazon.awssdk.services.workmail.model.DeleteEmailMonitoringConfigurationRequest;
import software.amazon.awssdk.services.workmail.model.DeleteEmailMonitoringConfigurationResponse;
import software.amazon.awssdk.services.workmail.model.DeleteGroupRequest;
import software.amazon.awssdk.services.workmail.model.DeleteGroupResponse;
import software.amazon.awssdk.services.workmail.model.DeleteMailboxPermissionsRequest;
import software.amazon.awssdk.services.workmail.model.DeleteMailboxPermissionsResponse;
import software.amazon.awssdk.services.workmail.model.DeleteMobileDeviceAccessOverrideRequest;
import software.amazon.awssdk.services.workmail.model.DeleteMobileDeviceAccessOverrideResponse;
import software.amazon.awssdk.services.workmail.model.DeleteMobileDeviceAccessRuleRequest;
import software.amazon.awssdk.services.workmail.model.DeleteMobileDeviceAccessRuleResponse;
import software.amazon.awssdk.services.workmail.model.DeleteOrganizationRequest;
import software.amazon.awssdk.services.workmail.model.DeleteOrganizationResponse;
import software.amazon.awssdk.services.workmail.model.DeleteResourceRequest;
import software.amazon.awssdk.services.workmail.model.DeleteResourceResponse;
import software.amazon.awssdk.services.workmail.model.DeleteRetentionPolicyRequest;
import software.amazon.awssdk.services.workmail.model.DeleteRetentionPolicyResponse;
import software.amazon.awssdk.services.workmail.model.DeleteUserRequest;
import software.amazon.awssdk.services.workmail.model.DeleteUserResponse;
import software.amazon.awssdk.services.workmail.model.DeregisterFromWorkMailRequest;
import software.amazon.awssdk.services.workmail.model.DeregisterFromWorkMailResponse;
import software.amazon.awssdk.services.workmail.model.DeregisterMailDomainRequest;
import software.amazon.awssdk.services.workmail.model.DeregisterMailDomainResponse;
import software.amazon.awssdk.services.workmail.model.DescribeEmailMonitoringConfigurationRequest;
import software.amazon.awssdk.services.workmail.model.DescribeEmailMonitoringConfigurationResponse;
import software.amazon.awssdk.services.workmail.model.DescribeGroupRequest;
import software.amazon.awssdk.services.workmail.model.DescribeGroupResponse;
import software.amazon.awssdk.services.workmail.model.DescribeInboundDmarcSettingsRequest;
import software.amazon.awssdk.services.workmail.model.DescribeInboundDmarcSettingsResponse;
import software.amazon.awssdk.services.workmail.model.DescribeMailboxExportJobRequest;
import software.amazon.awssdk.services.workmail.model.DescribeMailboxExportJobResponse;
import software.amazon.awssdk.services.workmail.model.DescribeOrganizationRequest;
import software.amazon.awssdk.services.workmail.model.DescribeOrganizationResponse;
import software.amazon.awssdk.services.workmail.model.DescribeResourceRequest;
import software.amazon.awssdk.services.workmail.model.DescribeResourceResponse;
import software.amazon.awssdk.services.workmail.model.DescribeUserRequest;
import software.amazon.awssdk.services.workmail.model.DescribeUserResponse;
import software.amazon.awssdk.services.workmail.model.DirectoryInUseException;
import software.amazon.awssdk.services.workmail.model.DirectoryServiceAuthenticationFailedException;
import software.amazon.awssdk.services.workmail.model.DirectoryUnavailableException;
import software.amazon.awssdk.services.workmail.model.DisassociateDelegateFromResourceRequest;
import software.amazon.awssdk.services.workmail.model.DisassociateDelegateFromResourceResponse;
import software.amazon.awssdk.services.workmail.model.DisassociateMemberFromGroupRequest;
import software.amazon.awssdk.services.workmail.model.DisassociateMemberFromGroupResponse;
import software.amazon.awssdk.services.workmail.model.EmailAddressInUseException;
import software.amazon.awssdk.services.workmail.model.EntityAlreadyRegisteredException;
import software.amazon.awssdk.services.workmail.model.EntityNotFoundException;
import software.amazon.awssdk.services.workmail.model.EntityStateException;
import software.amazon.awssdk.services.workmail.model.GetAccessControlEffectRequest;
import software.amazon.awssdk.services.workmail.model.GetAccessControlEffectResponse;
import software.amazon.awssdk.services.workmail.model.GetDefaultRetentionPolicyRequest;
import software.amazon.awssdk.services.workmail.model.GetDefaultRetentionPolicyResponse;
import software.amazon.awssdk.services.workmail.model.GetMailDomainRequest;
import software.amazon.awssdk.services.workmail.model.GetMailDomainResponse;
import software.amazon.awssdk.services.workmail.model.GetMailboxDetailsRequest;
import software.amazon.awssdk.services.workmail.model.GetMailboxDetailsResponse;
import software.amazon.awssdk.services.workmail.model.GetMobileDeviceAccessEffectRequest;
import software.amazon.awssdk.services.workmail.model.GetMobileDeviceAccessEffectResponse;
import software.amazon.awssdk.services.workmail.model.GetMobileDeviceAccessOverrideRequest;
import software.amazon.awssdk.services.workmail.model.GetMobileDeviceAccessOverrideResponse;
import software.amazon.awssdk.services.workmail.model.InvalidConfigurationException;
import software.amazon.awssdk.services.workmail.model.InvalidCustomSesConfigurationException;
import software.amazon.awssdk.services.workmail.model.InvalidParameterException;
import software.amazon.awssdk.services.workmail.model.InvalidPasswordException;
import software.amazon.awssdk.services.workmail.model.LimitExceededException;
import software.amazon.awssdk.services.workmail.model.ListAccessControlRulesRequest;
import software.amazon.awssdk.services.workmail.model.ListAccessControlRulesResponse;
import software.amazon.awssdk.services.workmail.model.ListAliasesRequest;
import software.amazon.awssdk.services.workmail.model.ListAliasesResponse;
import software.amazon.awssdk.services.workmail.model.ListAvailabilityConfigurationsRequest;
import software.amazon.awssdk.services.workmail.model.ListAvailabilityConfigurationsResponse;
import software.amazon.awssdk.services.workmail.model.ListGroupMembersRequest;
import software.amazon.awssdk.services.workmail.model.ListGroupMembersResponse;
import software.amazon.awssdk.services.workmail.model.ListGroupsRequest;
import software.amazon.awssdk.services.workmail.model.ListGroupsResponse;
import software.amazon.awssdk.services.workmail.model.ListMailDomainsRequest;
import software.amazon.awssdk.services.workmail.model.ListMailDomainsResponse;
import software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsRequest;
import software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsResponse;
import software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsRequest;
import software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsResponse;
import software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessOverridesRequest;
import software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessOverridesResponse;
import software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessRulesRequest;
import software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessRulesResponse;
import software.amazon.awssdk.services.workmail.model.ListOrganizationsRequest;
import software.amazon.awssdk.services.workmail.model.ListOrganizationsResponse;
import software.amazon.awssdk.services.workmail.model.ListResourceDelegatesRequest;
import software.amazon.awssdk.services.workmail.model.ListResourceDelegatesResponse;
import software.amazon.awssdk.services.workmail.model.ListResourcesRequest;
import software.amazon.awssdk.services.workmail.model.ListResourcesResponse;
import software.amazon.awssdk.services.workmail.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.workmail.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.workmail.model.ListUsersRequest;
import software.amazon.awssdk.services.workmail.model.ListUsersResponse;
import software.amazon.awssdk.services.workmail.model.MailDomainInUseException;
import software.amazon.awssdk.services.workmail.model.MailDomainNotFoundException;
import software.amazon.awssdk.services.workmail.model.MailDomainStateException;
import software.amazon.awssdk.services.workmail.model.NameAvailabilityException;
import software.amazon.awssdk.services.workmail.model.OrganizationNotFoundException;
import software.amazon.awssdk.services.workmail.model.OrganizationStateException;
import software.amazon.awssdk.services.workmail.model.PutAccessControlRuleRequest;
import software.amazon.awssdk.services.workmail.model.PutAccessControlRuleResponse;
import software.amazon.awssdk.services.workmail.model.PutEmailMonitoringConfigurationRequest;
import software.amazon.awssdk.services.workmail.model.PutEmailMonitoringConfigurationResponse;
import software.amazon.awssdk.services.workmail.model.PutInboundDmarcSettingsRequest;
import software.amazon.awssdk.services.workmail.model.PutInboundDmarcSettingsResponse;
import software.amazon.awssdk.services.workmail.model.PutMailboxPermissionsRequest;
import software.amazon.awssdk.services.workmail.model.PutMailboxPermissionsResponse;
import software.amazon.awssdk.services.workmail.model.PutMobileDeviceAccessOverrideRequest;
import software.amazon.awssdk.services.workmail.model.PutMobileDeviceAccessOverrideResponse;
import software.amazon.awssdk.services.workmail.model.PutRetentionPolicyRequest;
import software.amazon.awssdk.services.workmail.model.PutRetentionPolicyResponse;
import software.amazon.awssdk.services.workmail.model.RegisterMailDomainRequest;
import software.amazon.awssdk.services.workmail.model.RegisterMailDomainResponse;
import software.amazon.awssdk.services.workmail.model.RegisterToWorkMailRequest;
import software.amazon.awssdk.services.workmail.model.RegisterToWorkMailResponse;
import software.amazon.awssdk.services.workmail.model.ReservedNameException;
import software.amazon.awssdk.services.workmail.model.ResetPasswordRequest;
import software.amazon.awssdk.services.workmail.model.ResetPasswordResponse;
import software.amazon.awssdk.services.workmail.model.ResourceNotFoundException;
import software.amazon.awssdk.services.workmail.model.StartMailboxExportJobRequest;
import software.amazon.awssdk.services.workmail.model.StartMailboxExportJobResponse;
import software.amazon.awssdk.services.workmail.model.TagResourceRequest;
import software.amazon.awssdk.services.workmail.model.TagResourceResponse;
import software.amazon.awssdk.services.workmail.model.TestAvailabilityConfigurationRequest;
import software.amazon.awssdk.services.workmail.model.TestAvailabilityConfigurationResponse;
import software.amazon.awssdk.services.workmail.model.TooManyTagsException;
import software.amazon.awssdk.services.workmail.model.UntagResourceRequest;
import software.amazon.awssdk.services.workmail.model.UntagResourceResponse;
import software.amazon.awssdk.services.workmail.model.UpdateAvailabilityConfigurationRequest;
import software.amazon.awssdk.services.workmail.model.UpdateAvailabilityConfigurationResponse;
import software.amazon.awssdk.services.workmail.model.UpdateDefaultMailDomainRequest;
import software.amazon.awssdk.services.workmail.model.UpdateDefaultMailDomainResponse;
import software.amazon.awssdk.services.workmail.model.UpdateMailboxQuotaRequest;
import software.amazon.awssdk.services.workmail.model.UpdateMailboxQuotaResponse;
import software.amazon.awssdk.services.workmail.model.UpdateMobileDeviceAccessRuleRequest;
import software.amazon.awssdk.services.workmail.model.UpdateMobileDeviceAccessRuleResponse;
import software.amazon.awssdk.services.workmail.model.UpdatePrimaryEmailAddressRequest;
import software.amazon.awssdk.services.workmail.model.UpdatePrimaryEmailAddressResponse;
import software.amazon.awssdk.services.workmail.model.UpdateResourceRequest;
import software.amazon.awssdk.services.workmail.model.UpdateResourceResponse;
import software.amazon.awssdk.services.workmail.model.WorkMailException;
import software.amazon.awssdk.services.workmail.paginators.ListAliasesIterable;
import software.amazon.awssdk.services.workmail.paginators.ListAvailabilityConfigurationsIterable;
import software.amazon.awssdk.services.workmail.paginators.ListGroupMembersIterable;
import software.amazon.awssdk.services.workmail.paginators.ListGroupsIterable;
import software.amazon.awssdk.services.workmail.paginators.ListMailDomainsIterable;
import software.amazon.awssdk.services.workmail.paginators.ListMailboxExportJobsIterable;
import software.amazon.awssdk.services.workmail.paginators.ListMailboxPermissionsIterable;
import software.amazon.awssdk.services.workmail.paginators.ListMobileDeviceAccessOverridesIterable;
import software.amazon.awssdk.services.workmail.paginators.ListOrganizationsIterable;
import software.amazon.awssdk.services.workmail.paginators.ListResourceDelegatesIterable;
import software.amazon.awssdk.services.workmail.paginators.ListResourcesIterable;
import software.amazon.awssdk.services.workmail.paginators.ListUsersIterable;

/**
 * Service client for accessing Amazon WorkMail. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon WorkMail is a secure, managed business email and calendaring service with support for existing desktop and
 * mobile email clients. You can access your email, contacts, and calendars using Microsoft Outlook, your browser, or
 * other native iOS and Android email applications. You can integrate WorkMail with your existing corporate directory
 * and control both the keys that encrypt your data and the location in which your data is stored.
 * </p>
 * <p>
 * The WorkMail API is designed for the following scenarios:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Listing and describing organizations
 * </p>
 * </li>
 * </ul>
 * <ul>
 * <li>
 * <p>
 * Managing users
 * </p>
 * </li>
 * </ul>
 * <ul>
 * <li>
 * <p>
 * Managing groups
 * </p>
 * </li>
 * </ul>
 * <ul>
 * <li>
 * <p>
 * Managing resources
 * </p>
 * </li>
 * </ul>
 * <p>
 * All WorkMail API operations are Amazon-authenticated and certificate-signed. They not only require the use of the AWS
 * SDK, but also allow for the exclusive use of AWS Identity and Access Management users and roles to help facilitate
 * access, trust, and permission policies. By creating a role and allowing an IAM user to access the WorkMail site, the
 * IAM user gains full administrative visibility into the entire WorkMail organization (or as set in the IAM policy).
 * This includes, but is not limited to, the ability to create, update, and delete users, groups, and resources. This
 * allows developers to perform the scenarios listed above, as well as give users the ability to grant access on a
 * selective basis using the IAM model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface WorkMailClient extends SdkClient {
    String SERVICE_NAME = "workmail";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "workmail";

    /**
     * Create a {@link WorkMailClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static WorkMailClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link WorkMailClient}.
     */
    static WorkMailClientBuilder builder() {
        return new DefaultWorkMailClientBuilder();
    }

    /**
     * <p>
     * Adds a member (user or group) to the resource's set of delegates.
     * </p>
     *
     * @param associateDelegateToResourceRequest
     * @return Result of the AssociateDelegateToResource operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.AssociateDelegateToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/AssociateDelegateToResource"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateDelegateToResourceResponse associateDelegateToResource(
            AssociateDelegateToResourceRequest associateDelegateToResourceRequest) throws EntityNotFoundException,
            EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a member (user or group) to the resource's set of delegates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateDelegateToResourceRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateDelegateToResourceRequest#builder()}
     * </p>
     *
     * @param associateDelegateToResourceRequest
     *        A {@link Consumer} that will call methods on {@link AssociateDelegateToResourceRequest.Builder} to create
     *        a request.
     * @return Result of the AssociateDelegateToResource operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.AssociateDelegateToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/AssociateDelegateToResource"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateDelegateToResourceResponse associateDelegateToResource(
            Consumer<AssociateDelegateToResourceRequest.Builder> associateDelegateToResourceRequest)
            throws EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException,
            OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        return associateDelegateToResource(AssociateDelegateToResourceRequest.builder()
                .applyMutation(associateDelegateToResourceRequest).build());
    }

    /**
     * <p>
     * Adds a member (user or group) to the group's set.
     * </p>
     *
     * @param associateMemberToGroupRequest
     * @return Result of the AssociateMemberToGroup operation returned by the service.
     * @throws DirectoryServiceAuthenticationFailedException
     *         The directory service doesn't recognize the credentials supplied by WorkMail.
     * @throws DirectoryUnavailableException
     *         The directory is unavailable. It might be located in another Region or deleted.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws UnsupportedOperationException
     *         You can't perform a write operation against a read-only directory.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.AssociateMemberToGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/AssociateMemberToGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateMemberToGroupResponse associateMemberToGroup(AssociateMemberToGroupRequest associateMemberToGroupRequest)
            throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, EntityNotFoundException,
            EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            software.amazon.awssdk.services.workmail.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a member (user or group) to the group's set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateMemberToGroupRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateMemberToGroupRequest#builder()}
     * </p>
     *
     * @param associateMemberToGroupRequest
     *        A {@link Consumer} that will call methods on {@link AssociateMemberToGroupRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateMemberToGroup operation returned by the service.
     * @throws DirectoryServiceAuthenticationFailedException
     *         The directory service doesn't recognize the credentials supplied by WorkMail.
     * @throws DirectoryUnavailableException
     *         The directory is unavailable. It might be located in another Region or deleted.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws UnsupportedOperationException
     *         You can't perform a write operation against a read-only directory.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.AssociateMemberToGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/AssociateMemberToGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateMemberToGroupResponse associateMemberToGroup(
            Consumer<AssociateMemberToGroupRequest.Builder> associateMemberToGroupRequest)
            throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, EntityNotFoundException,
            EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            software.amazon.awssdk.services.workmail.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, WorkMailException {
        return associateMemberToGroup(AssociateMemberToGroupRequest.builder().applyMutation(associateMemberToGroupRequest)
                .build());
    }

    /**
     * <p>
     * Cancels a mailbox export job.
     * </p>
     * <note>
     * <p>
     * If the mailbox export job is near completion, it might not be possible to cancel it.
     * </p>
     * </note>
     *
     * @param cancelMailboxExportJobRequest
     * @return Result of the CancelMailboxExportJob operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.CancelMailboxExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CancelMailboxExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelMailboxExportJobResponse cancelMailboxExportJob(CancelMailboxExportJobRequest cancelMailboxExportJobRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, EntityNotFoundException,
            AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a mailbox export job.
     * </p>
     * <note>
     * <p>
     * If the mailbox export job is near completion, it might not be possible to cancel it.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelMailboxExportJobRequest.Builder} avoiding the
     * need to create one manually via {@link CancelMailboxExportJobRequest#builder()}
     * </p>
     *
     * @param cancelMailboxExportJobRequest
     *        A {@link Consumer} that will call methods on {@link CancelMailboxExportJobRequest.Builder} to create a
     *        request.
     * @return Result of the CancelMailboxExportJob operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.CancelMailboxExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CancelMailboxExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelMailboxExportJobResponse cancelMailboxExportJob(
            Consumer<CancelMailboxExportJobRequest.Builder> cancelMailboxExportJobRequest) throws InvalidParameterException,
            OrganizationNotFoundException, OrganizationStateException, EntityNotFoundException, AwsServiceException,
            SdkClientException, WorkMailException {
        return cancelMailboxExportJob(CancelMailboxExportJobRequest.builder().applyMutation(cancelMailboxExportJobRequest)
                .build());
    }

    /**
     * <p>
     * Adds an alias to the set of a given member (user or group) of Amazon WorkMail.
     * </p>
     *
     * @param createAliasRequest
     * @return Result of the CreateAlias operation returned by the service.
     * @throws EmailAddressInUseException
     *         The email address that you're trying to assign is already created for a different user, group, or
     *         resource.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws MailDomainNotFoundException
     *         The domain specified is not found in your organization.
     * @throws MailDomainStateException
     *         After a domain has been added to the organization, it must be verified. The domain is not yet verified.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws LimitExceededException
     *         The request exceeds the limit of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.CreateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAliasResponse createAlias(CreateAliasRequest createAliasRequest) throws EmailAddressInUseException,
            EntityNotFoundException, EntityStateException, InvalidParameterException, MailDomainNotFoundException,
            MailDomainStateException, OrganizationNotFoundException, OrganizationStateException, LimitExceededException,
            AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an alias to the set of a given member (user or group) of Amazon WorkMail.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAliasRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAliasRequest#builder()}
     * </p>
     *
     * @param createAliasRequest
     *        A {@link Consumer} that will call methods on {@link CreateAliasRequest.Builder} to create a request.
     * @return Result of the CreateAlias operation returned by the service.
     * @throws EmailAddressInUseException
     *         The email address that you're trying to assign is already created for a different user, group, or
     *         resource.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws MailDomainNotFoundException
     *         The domain specified is not found in your organization.
     * @throws MailDomainStateException
     *         After a domain has been added to the organization, it must be verified. The domain is not yet verified.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws LimitExceededException
     *         The request exceeds the limit of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.CreateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAliasResponse createAlias(Consumer<CreateAliasRequest.Builder> createAliasRequest)
            throws EmailAddressInUseException, EntityNotFoundException, EntityStateException, InvalidParameterException,
            MailDomainNotFoundException, MailDomainStateException, OrganizationNotFoundException, OrganizationStateException,
            LimitExceededException, AwsServiceException, SdkClientException, WorkMailException {
        return createAlias(CreateAliasRequest.builder().applyMutation(createAliasRequest).build());
    }

    /**
     * <p>
     * Creates an <code>AvailabilityConfiguration</code> for the given WorkMail organization and domain.
     * </p>
     *
     * @param createAvailabilityConfigurationRequest
     * @return Result of the CreateAvailabilityConfiguration operation returned by the service.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws NameAvailabilityException
     *         The user, group, or resource name isn't unique in Amazon WorkMail.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws LimitExceededException
     *         The request exceeds the limit of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.CreateAvailabilityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateAvailabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAvailabilityConfigurationResponse createAvailabilityConfiguration(
            CreateAvailabilityConfigurationRequest createAvailabilityConfigurationRequest) throws OrganizationNotFoundException,
            OrganizationStateException, NameAvailabilityException, InvalidParameterException, LimitExceededException,
            AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an <code>AvailabilityConfiguration</code> for the given WorkMail organization and domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAvailabilityConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateAvailabilityConfigurationRequest#builder()}
     * </p>
     *
     * @param createAvailabilityConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link CreateAvailabilityConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateAvailabilityConfiguration operation returned by the service.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws NameAvailabilityException
     *         The user, group, or resource name isn't unique in Amazon WorkMail.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws LimitExceededException
     *         The request exceeds the limit of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.CreateAvailabilityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateAvailabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAvailabilityConfigurationResponse createAvailabilityConfiguration(
            Consumer<CreateAvailabilityConfigurationRequest.Builder> createAvailabilityConfigurationRequest)
            throws OrganizationNotFoundException, OrganizationStateException, NameAvailabilityException,
            InvalidParameterException, LimitExceededException, AwsServiceException, SdkClientException, WorkMailException {
        return createAvailabilityConfiguration(CreateAvailabilityConfigurationRequest.builder()
                .applyMutation(createAvailabilityConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a group that can be used in Amazon WorkMail by calling the <a>RegisterToWorkMail</a> operation.
     * </p>
     *
     * @param createGroupRequest
     * @return Result of the CreateGroup operation returned by the service.
     * @throws DirectoryServiceAuthenticationFailedException
     *         The directory service doesn't recognize the credentials supplied by WorkMail.
     * @throws DirectoryUnavailableException
     *         The directory is unavailable. It might be located in another Region or deleted.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws NameAvailabilityException
     *         The user, group, or resource name isn't unique in Amazon WorkMail.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws ReservedNameException
     *         This user, group, or resource name is not allowed in Amazon WorkMail.
     * @throws UnsupportedOperationException
     *         You can't perform a write operation against a read-only directory.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateGroupResponse createGroup(CreateGroupRequest createGroupRequest)
            throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, InvalidParameterException,
            NameAvailabilityException, OrganizationNotFoundException, OrganizationStateException, ReservedNameException,
            software.amazon.awssdk.services.workmail.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a group that can be used in Amazon WorkMail by calling the <a>RegisterToWorkMail</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGroupRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGroupRequest#builder()}
     * </p>
     *
     * @param createGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateGroupRequest.Builder} to create a request.
     * @return Result of the CreateGroup operation returned by the service.
     * @throws DirectoryServiceAuthenticationFailedException
     *         The directory service doesn't recognize the credentials supplied by WorkMail.
     * @throws DirectoryUnavailableException
     *         The directory is unavailable. It might be located in another Region or deleted.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws NameAvailabilityException
     *         The user, group, or resource name isn't unique in Amazon WorkMail.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws ReservedNameException
     *         This user, group, or resource name is not allowed in Amazon WorkMail.
     * @throws UnsupportedOperationException
     *         You can't perform a write operation against a read-only directory.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateGroupResponse createGroup(Consumer<CreateGroupRequest.Builder> createGroupRequest)
            throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, InvalidParameterException,
            NameAvailabilityException, OrganizationNotFoundException, OrganizationStateException, ReservedNameException,
            software.amazon.awssdk.services.workmail.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, WorkMailException {
        return createGroup(CreateGroupRequest.builder().applyMutation(createGroupRequest).build());
    }

    /**
     * <p>
     * Creates a new mobile device access rule for the specified Amazon WorkMail organization.
     * </p>
     *
     * @param createMobileDeviceAccessRuleRequest
     * @return Result of the CreateMobileDeviceAccessRule operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws LimitExceededException
     *         The request exceeds the limit of the resource.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.CreateMobileDeviceAccessRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateMobileDeviceAccessRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMobileDeviceAccessRuleResponse createMobileDeviceAccessRule(
            CreateMobileDeviceAccessRuleRequest createMobileDeviceAccessRuleRequest) throws InvalidParameterException,
            LimitExceededException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new mobile device access rule for the specified Amazon WorkMail organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMobileDeviceAccessRuleRequest.Builder}
     * avoiding the need to create one manually via {@link CreateMobileDeviceAccessRuleRequest#builder()}
     * </p>
     *
     * @param createMobileDeviceAccessRuleRequest
     *        A {@link Consumer} that will call methods on {@link CreateMobileDeviceAccessRuleRequest.Builder} to create
     *        a request.
     * @return Result of the CreateMobileDeviceAccessRule operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws LimitExceededException
     *         The request exceeds the limit of the resource.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.CreateMobileDeviceAccessRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateMobileDeviceAccessRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateMobileDeviceAccessRuleResponse createMobileDeviceAccessRule(
            Consumer<CreateMobileDeviceAccessRuleRequest.Builder> createMobileDeviceAccessRuleRequest)
            throws InvalidParameterException, LimitExceededException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        return createMobileDeviceAccessRule(CreateMobileDeviceAccessRuleRequest.builder()
                .applyMutation(createMobileDeviceAccessRuleRequest).build());
    }

    /**
     * <p>
     * Creates a new Amazon WorkMail organization. Optionally, you can choose to associate an existing AWS Directory
     * Service directory with your organization. If an AWS Directory Service directory ID is specified, the organization
     * alias must match the directory alias. If you choose not to associate an existing directory with your
     * organization, then we create a new Amazon WorkMail directory for you. For more information, see <a
     * href="https://docs.aws.amazon.com/workmail/latest/adminguide/add_new_organization.html">Adding an
     * organization</a> in the <i>Amazon WorkMail Administrator Guide</i>.
     * </p>
     * <p>
     * You can associate multiple email domains with an organization, then set your default email domain from the Amazon
     * WorkMail console. You can also associate a domain that is managed in an Amazon Route 53 public hosted zone. For
     * more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/add_domain.html">Adding a
     * domain</a> and <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/default_domain.html">Choosing the
     * default domain</a> in the <i>Amazon WorkMail Administrator Guide</i>.
     * </p>
     * <p>
     * Optionally, you can use a customer managed master key from AWS Key Management Service (AWS KMS) to encrypt email
     * for your organization. If you don't associate an AWS KMS key, Amazon WorkMail creates a default AWS managed
     * master key for you.
     * </p>
     *
     * @param createOrganizationRequest
     * @return Result of the CreateOrganization operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws DirectoryInUseException
     *         The directory is already in use by another WorkMail organization in the same account and Region.
     * @throws DirectoryUnavailableException
     *         The directory is unavailable. It might be located in another Region or deleted.
     * @throws LimitExceededException
     *         The request exceeds the limit of the resource.
     * @throws NameAvailabilityException
     *         The user, group, or resource name isn't unique in Amazon WorkMail.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.CreateOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateOrganization" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateOrganizationResponse createOrganization(CreateOrganizationRequest createOrganizationRequest)
            throws InvalidParameterException, DirectoryInUseException, DirectoryUnavailableException, LimitExceededException,
            NameAvailabilityException, AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Amazon WorkMail organization. Optionally, you can choose to associate an existing AWS Directory
     * Service directory with your organization. If an AWS Directory Service directory ID is specified, the organization
     * alias must match the directory alias. If you choose not to associate an existing directory with your
     * organization, then we create a new Amazon WorkMail directory for you. For more information, see <a
     * href="https://docs.aws.amazon.com/workmail/latest/adminguide/add_new_organization.html">Adding an
     * organization</a> in the <i>Amazon WorkMail Administrator Guide</i>.
     * </p>
     * <p>
     * You can associate multiple email domains with an organization, then set your default email domain from the Amazon
     * WorkMail console. You can also associate a domain that is managed in an Amazon Route 53 public hosted zone. For
     * more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/add_domain.html">Adding a
     * domain</a> and <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/default_domain.html">Choosing the
     * default domain</a> in the <i>Amazon WorkMail Administrator Guide</i>.
     * </p>
     * <p>
     * Optionally, you can use a customer managed master key from AWS Key Management Service (AWS KMS) to encrypt email
     * for your organization. If you don't associate an AWS KMS key, Amazon WorkMail creates a default AWS managed
     * master key for you.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOrganizationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateOrganizationRequest#builder()}
     * </p>
     *
     * @param createOrganizationRequest
     *        A {@link Consumer} that will call methods on {@link CreateOrganizationRequest.Builder} to create a
     *        request.
     * @return Result of the CreateOrganization operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws DirectoryInUseException
     *         The directory is already in use by another WorkMail organization in the same account and Region.
     * @throws DirectoryUnavailableException
     *         The directory is unavailable. It might be located in another Region or deleted.
     * @throws LimitExceededException
     *         The request exceeds the limit of the resource.
     * @throws NameAvailabilityException
     *         The user, group, or resource name isn't unique in Amazon WorkMail.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.CreateOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateOrganization" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateOrganizationResponse createOrganization(Consumer<CreateOrganizationRequest.Builder> createOrganizationRequest)
            throws InvalidParameterException, DirectoryInUseException, DirectoryUnavailableException, LimitExceededException,
            NameAvailabilityException, AwsServiceException, SdkClientException, WorkMailException {
        return createOrganization(CreateOrganizationRequest.builder().applyMutation(createOrganizationRequest).build());
    }

    /**
     * <p>
     * Creates a new Amazon WorkMail resource.
     * </p>
     *
     * @param createResourceRequest
     * @return Result of the CreateResource operation returned by the service.
     * @throws DirectoryServiceAuthenticationFailedException
     *         The directory service doesn't recognize the credentials supplied by WorkMail.
     * @throws DirectoryUnavailableException
     *         The directory is unavailable. It might be located in another Region or deleted.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws NameAvailabilityException
     *         The user, group, or resource name isn't unique in Amazon WorkMail.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws ReservedNameException
     *         This user, group, or resource name is not allowed in Amazon WorkMail.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.CreateResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateResourceResponse createResource(CreateResourceRequest createResourceRequest)
            throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, InvalidParameterException,
            NameAvailabilityException, OrganizationNotFoundException, OrganizationStateException, ReservedNameException,
            AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Amazon WorkMail resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResourceRequest.Builder} avoiding the need to
     * create one manually via {@link CreateResourceRequest#builder()}
     * </p>
     *
     * @param createResourceRequest
     *        A {@link Consumer} that will call methods on {@link CreateResourceRequest.Builder} to create a request.
     * @return Result of the CreateResource operation returned by the service.
     * @throws DirectoryServiceAuthenticationFailedException
     *         The directory service doesn't recognize the credentials supplied by WorkMail.
     * @throws DirectoryUnavailableException
     *         The directory is unavailable. It might be located in another Region or deleted.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws NameAvailabilityException
     *         The user, group, or resource name isn't unique in Amazon WorkMail.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws ReservedNameException
     *         This user, group, or resource name is not allowed in Amazon WorkMail.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.CreateResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateResourceResponse createResource(Consumer<CreateResourceRequest.Builder> createResourceRequest)
            throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, InvalidParameterException,
            NameAvailabilityException, OrganizationNotFoundException, OrganizationStateException, ReservedNameException,
            AwsServiceException, SdkClientException, WorkMailException {
        return createResource(CreateResourceRequest.builder().applyMutation(createResourceRequest).build());
    }

    /**
     * <p>
     * Creates a user who can be used in Amazon WorkMail by calling the <a>RegisterToWorkMail</a> operation.
     * </p>
     *
     * @param createUserRequest
     * @return Result of the CreateUser operation returned by the service.
     * @throws DirectoryServiceAuthenticationFailedException
     *         The directory service doesn't recognize the credentials supplied by WorkMail.
     * @throws DirectoryUnavailableException
     *         The directory is unavailable. It might be located in another Region or deleted.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws InvalidPasswordException
     *         The supplied password doesn't match the minimum security constraints, such as length or use of special
     *         characters.
     * @throws NameAvailabilityException
     *         The user, group, or resource name isn't unique in Amazon WorkMail.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws ReservedNameException
     *         This user, group, or resource name is not allowed in Amazon WorkMail.
     * @throws UnsupportedOperationException
     *         You can't perform a write operation against a read-only directory.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateUserResponse createUser(CreateUserRequest createUserRequest)
            throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, InvalidParameterException,
            InvalidPasswordException, NameAvailabilityException, OrganizationNotFoundException, OrganizationStateException,
            ReservedNameException, software.amazon.awssdk.services.workmail.model.UnsupportedOperationException,
            AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a user who can be used in Amazon WorkMail by calling the <a>RegisterToWorkMail</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUserRequest#builder()}
     * </p>
     *
     * @param createUserRequest
     *        A {@link Consumer} that will call methods on {@link CreateUserRequest.Builder} to create a request.
     * @return Result of the CreateUser operation returned by the service.
     * @throws DirectoryServiceAuthenticationFailedException
     *         The directory service doesn't recognize the credentials supplied by WorkMail.
     * @throws DirectoryUnavailableException
     *         The directory is unavailable. It might be located in another Region or deleted.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws InvalidPasswordException
     *         The supplied password doesn't match the minimum security constraints, such as length or use of special
     *         characters.
     * @throws NameAvailabilityException
     *         The user, group, or resource name isn't unique in Amazon WorkMail.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws ReservedNameException
     *         This user, group, or resource name is not allowed in Amazon WorkMail.
     * @throws UnsupportedOperationException
     *         You can't perform a write operation against a read-only directory.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateUserResponse createUser(Consumer<CreateUserRequest.Builder> createUserRequest)
            throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, InvalidParameterException,
            InvalidPasswordException, NameAvailabilityException, OrganizationNotFoundException, OrganizationStateException,
            ReservedNameException, software.amazon.awssdk.services.workmail.model.UnsupportedOperationException,
            AwsServiceException, SdkClientException, WorkMailException {
        return createUser(CreateUserRequest.builder().applyMutation(createUserRequest).build());
    }

    /**
     * <p>
     * Deletes an access control rule for the specified WorkMail organization.
     * </p>
     * <note>
     * <p>
     * Deleting already deleted and non-existing rules does not produce an error. In those cases, the service sends back
     * an HTTP 200 response with an empty HTTP body.
     * </p>
     * </note>
     *
     * @param deleteAccessControlRuleRequest
     * @return Result of the DeleteAccessControlRule operation returned by the service.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeleteAccessControlRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteAccessControlRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAccessControlRuleResponse deleteAccessControlRule(DeleteAccessControlRuleRequest deleteAccessControlRuleRequest)
            throws OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException,
            WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an access control rule for the specified WorkMail organization.
     * </p>
     * <note>
     * <p>
     * Deleting already deleted and non-existing rules does not produce an error. In those cases, the service sends back
     * an HTTP 200 response with an empty HTTP body.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccessControlRuleRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteAccessControlRuleRequest#builder()}
     * </p>
     *
     * @param deleteAccessControlRuleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAccessControlRuleRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAccessControlRule operation returned by the service.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeleteAccessControlRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteAccessControlRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAccessControlRuleResponse deleteAccessControlRule(
            Consumer<DeleteAccessControlRuleRequest.Builder> deleteAccessControlRuleRequest)
            throws OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException,
            WorkMailException {
        return deleteAccessControlRule(DeleteAccessControlRuleRequest.builder().applyMutation(deleteAccessControlRuleRequest)
                .build());
    }

    /**
     * <p>
     * Remove one or more specified aliases from a set of aliases for a given user.
     * </p>
     *
     * @param deleteAliasRequest
     * @return Result of the DeleteAlias operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeleteAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAliasResponse deleteAlias(DeleteAliasRequest deleteAliasRequest) throws EntityNotFoundException,
            EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove one or more specified aliases from a set of aliases for a given user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAliasRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAliasRequest#builder()}
     * </p>
     *
     * @param deleteAliasRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAliasRequest.Builder} to create a request.
     * @return Result of the DeleteAlias operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeleteAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAliasResponse deleteAlias(Consumer<DeleteAliasRequest.Builder> deleteAliasRequest)
            throws EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException,
            OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        return deleteAlias(DeleteAliasRequest.builder().applyMutation(deleteAliasRequest).build());
    }

    /**
     * <p>
     * Deletes the <code>AvailabilityConfiguration</code> for the given WorkMail organization and domain.
     * </p>
     *
     * @param deleteAvailabilityConfigurationRequest
     * @return Result of the DeleteAvailabilityConfiguration operation returned by the service.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeleteAvailabilityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteAvailabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAvailabilityConfigurationResponse deleteAvailabilityConfiguration(
            DeleteAvailabilityConfigurationRequest deleteAvailabilityConfigurationRequest) throws OrganizationNotFoundException,
            OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the <code>AvailabilityConfiguration</code> for the given WorkMail organization and domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAvailabilityConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteAvailabilityConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteAvailabilityConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAvailabilityConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteAvailabilityConfiguration operation returned by the service.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeleteAvailabilityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteAvailabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAvailabilityConfigurationResponse deleteAvailabilityConfiguration(
            Consumer<DeleteAvailabilityConfigurationRequest.Builder> deleteAvailabilityConfigurationRequest)
            throws OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException,
            WorkMailException {
        return deleteAvailabilityConfiguration(DeleteAvailabilityConfigurationRequest.builder()
                .applyMutation(deleteAvailabilityConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the email monitoring configuration for a specified organization.
     * </p>
     *
     * @param deleteEmailMonitoringConfigurationRequest
     * @return Result of the DeleteEmailMonitoringConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeleteEmailMonitoringConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteEmailMonitoringConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEmailMonitoringConfigurationResponse deleteEmailMonitoringConfiguration(
            DeleteEmailMonitoringConfigurationRequest deleteEmailMonitoringConfigurationRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the email monitoring configuration for a specified organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEmailMonitoringConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteEmailMonitoringConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteEmailMonitoringConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEmailMonitoringConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteEmailMonitoringConfiguration operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeleteEmailMonitoringConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteEmailMonitoringConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEmailMonitoringConfigurationResponse deleteEmailMonitoringConfiguration(
            Consumer<DeleteEmailMonitoringConfigurationRequest.Builder> deleteEmailMonitoringConfigurationRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        return deleteEmailMonitoringConfiguration(DeleteEmailMonitoringConfigurationRequest.builder()
                .applyMutation(deleteEmailMonitoringConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes a group from Amazon WorkMail.
     * </p>
     *
     * @param deleteGroupRequest
     * @return Result of the DeleteGroup operation returned by the service.
     * @throws DirectoryServiceAuthenticationFailedException
     *         The directory service doesn't recognize the credentials supplied by WorkMail.
     * @throws DirectoryUnavailableException
     *         The directory is unavailable. It might be located in another Region or deleted.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws UnsupportedOperationException
     *         You can't perform a write operation against a read-only directory.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGroupResponse deleteGroup(DeleteGroupRequest deleteGroupRequest)
            throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, EntityStateException,
            InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            software.amazon.awssdk.services.workmail.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a group from Amazon WorkMail.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGroupRequest#builder()}
     * </p>
     *
     * @param deleteGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGroupRequest.Builder} to create a request.
     * @return Result of the DeleteGroup operation returned by the service.
     * @throws DirectoryServiceAuthenticationFailedException
     *         The directory service doesn't recognize the credentials supplied by WorkMail.
     * @throws DirectoryUnavailableException
     *         The directory is unavailable. It might be located in another Region or deleted.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws UnsupportedOperationException
     *         You can't perform a write operation against a read-only directory.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGroupResponse deleteGroup(Consumer<DeleteGroupRequest.Builder> deleteGroupRequest)
            throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, EntityStateException,
            InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            software.amazon.awssdk.services.workmail.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, WorkMailException {
        return deleteGroup(DeleteGroupRequest.builder().applyMutation(deleteGroupRequest).build());
    }

    /**
     * <p>
     * Deletes permissions granted to a member (user or group).
     * </p>
     *
     * @param deleteMailboxPermissionsRequest
     * @return Result of the DeleteMailboxPermissions operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeleteMailboxPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteMailboxPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMailboxPermissionsResponse deleteMailboxPermissions(
            DeleteMailboxPermissionsRequest deleteMailboxPermissionsRequest) throws EntityNotFoundException,
            EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes permissions granted to a member (user or group).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMailboxPermissionsRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteMailboxPermissionsRequest#builder()}
     * </p>
     *
     * @param deleteMailboxPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMailboxPermissionsRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteMailboxPermissions operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeleteMailboxPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteMailboxPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMailboxPermissionsResponse deleteMailboxPermissions(
            Consumer<DeleteMailboxPermissionsRequest.Builder> deleteMailboxPermissionsRequest) throws EntityNotFoundException,
            EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        return deleteMailboxPermissions(DeleteMailboxPermissionsRequest.builder().applyMutation(deleteMailboxPermissionsRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the mobile device access override for the given WorkMail organization, user, and device.
     * </p>
     * <note>
     * <p>
     * Deleting already deleted and non-existing overrides does not produce an error. In those cases, the service sends
     * back an HTTP 200 response with an empty HTTP body.
     * </p>
     * </note>
     *
     * @param deleteMobileDeviceAccessOverrideRequest
     * @return Result of the DeleteMobileDeviceAccessOverride operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeleteMobileDeviceAccessOverride
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteMobileDeviceAccessOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMobileDeviceAccessOverrideResponse deleteMobileDeviceAccessOverride(
            DeleteMobileDeviceAccessOverrideRequest deleteMobileDeviceAccessOverrideRequest) throws InvalidParameterException,
            OrganizationNotFoundException, OrganizationStateException, EntityNotFoundException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the mobile device access override for the given WorkMail organization, user, and device.
     * </p>
     * <note>
     * <p>
     * Deleting already deleted and non-existing overrides does not produce an error. In those cases, the service sends
     * back an HTTP 200 response with an empty HTTP body.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMobileDeviceAccessOverrideRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteMobileDeviceAccessOverrideRequest#builder()}
     * </p>
     *
     * @param deleteMobileDeviceAccessOverrideRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMobileDeviceAccessOverrideRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteMobileDeviceAccessOverride operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeleteMobileDeviceAccessOverride
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteMobileDeviceAccessOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMobileDeviceAccessOverrideResponse deleteMobileDeviceAccessOverride(
            Consumer<DeleteMobileDeviceAccessOverrideRequest.Builder> deleteMobileDeviceAccessOverrideRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, EntityNotFoundException,
            AwsServiceException, SdkClientException, WorkMailException {
        return deleteMobileDeviceAccessOverride(DeleteMobileDeviceAccessOverrideRequest.builder()
                .applyMutation(deleteMobileDeviceAccessOverrideRequest).build());
    }

    /**
     * <p>
     * Deletes a mobile device access rule for the specified Amazon WorkMail organization.
     * </p>
     * <note>
     * <p>
     * Deleting already deleted and non-existing rules does not produce an error. In those cases, the service sends back
     * an HTTP 200 response with an empty HTTP body.
     * </p>
     * </note>
     *
     * @param deleteMobileDeviceAccessRuleRequest
     * @return Result of the DeleteMobileDeviceAccessRule operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeleteMobileDeviceAccessRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteMobileDeviceAccessRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMobileDeviceAccessRuleResponse deleteMobileDeviceAccessRule(
            DeleteMobileDeviceAccessRuleRequest deleteMobileDeviceAccessRuleRequest) throws InvalidParameterException,
            OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a mobile device access rule for the specified Amazon WorkMail organization.
     * </p>
     * <note>
     * <p>
     * Deleting already deleted and non-existing rules does not produce an error. In those cases, the service sends back
     * an HTTP 200 response with an empty HTTP body.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMobileDeviceAccessRuleRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteMobileDeviceAccessRuleRequest#builder()}
     * </p>
     *
     * @param deleteMobileDeviceAccessRuleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMobileDeviceAccessRuleRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteMobileDeviceAccessRule operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeleteMobileDeviceAccessRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteMobileDeviceAccessRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteMobileDeviceAccessRuleResponse deleteMobileDeviceAccessRule(
            Consumer<DeleteMobileDeviceAccessRuleRequest.Builder> deleteMobileDeviceAccessRuleRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        return deleteMobileDeviceAccessRule(DeleteMobileDeviceAccessRuleRequest.builder()
                .applyMutation(deleteMobileDeviceAccessRuleRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon WorkMail organization and all underlying AWS resources managed by Amazon WorkMail as part of
     * the organization. You can choose whether to delete the associated directory. For more information, see <a
     * href="https://docs.aws.amazon.com/workmail/latest/adminguide/remove_organization.html">Removing an
     * organization</a> in the <i>Amazon WorkMail Administrator Guide</i>.
     * </p>
     *
     * @param deleteOrganizationRequest
     * @return Result of the DeleteOrganization operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeleteOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteOrganization" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteOrganizationResponse deleteOrganization(DeleteOrganizationRequest deleteOrganizationRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon WorkMail organization and all underlying AWS resources managed by Amazon WorkMail as part of
     * the organization. You can choose whether to delete the associated directory. For more information, see <a
     * href="https://docs.aws.amazon.com/workmail/latest/adminguide/remove_organization.html">Removing an
     * organization</a> in the <i>Amazon WorkMail Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOrganizationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteOrganizationRequest#builder()}
     * </p>
     *
     * @param deleteOrganizationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteOrganizationRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteOrganization operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeleteOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteOrganization" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteOrganizationResponse deleteOrganization(Consumer<DeleteOrganizationRequest.Builder> deleteOrganizationRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        return deleteOrganization(DeleteOrganizationRequest.builder().applyMutation(deleteOrganizationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified resource.
     * </p>
     *
     * @param deleteResourceRequest
     * @return Result of the DeleteResource operation returned by the service.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeleteResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteResource" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteResourceResponse deleteResource(DeleteResourceRequest deleteResourceRequest) throws EntityStateException,
            InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourceRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteResourceRequest#builder()}
     * </p>
     *
     * @param deleteResourceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResourceRequest.Builder} to create a request.
     * @return Result of the DeleteResource operation returned by the service.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeleteResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteResource" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteResourceResponse deleteResource(Consumer<DeleteResourceRequest.Builder> deleteResourceRequest)
            throws EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        return deleteResource(DeleteResourceRequest.builder().applyMutation(deleteResourceRequest).build());
    }

    /**
     * <p>
     * Deletes the specified retention policy from the specified organization.
     * </p>
     *
     * @param deleteRetentionPolicyRequest
     * @return Result of the DeleteRetentionPolicy operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeleteRetentionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteRetentionPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRetentionPolicyResponse deleteRetentionPolicy(DeleteRetentionPolicyRequest deleteRetentionPolicyRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified retention policy from the specified organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRetentionPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRetentionPolicyRequest#builder()}
     * </p>
     *
     * @param deleteRetentionPolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRetentionPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteRetentionPolicy operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeleteRetentionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteRetentionPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRetentionPolicyResponse deleteRetentionPolicy(
            Consumer<DeleteRetentionPolicyRequest.Builder> deleteRetentionPolicyRequest) throws InvalidParameterException,
            OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        return deleteRetentionPolicy(DeleteRetentionPolicyRequest.builder().applyMutation(deleteRetentionPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a user from Amazon WorkMail and all subsequent systems. Before you can delete a user, the user state must
     * be <code>DISABLED</code>. Use the <a>DescribeUser</a> action to confirm the user state.
     * </p>
     * <p>
     * Deleting a user is permanent and cannot be undone. WorkMail archives user mailboxes for 30 days before they are
     * permanently removed.
     * </p>
     *
     * @param deleteUserRequest
     * @return Result of the DeleteUser operation returned by the service.
     * @throws DirectoryServiceAuthenticationFailedException
     *         The directory service doesn't recognize the credentials supplied by WorkMail.
     * @throws DirectoryUnavailableException
     *         The directory is unavailable. It might be located in another Region or deleted.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws UnsupportedOperationException
     *         You can't perform a write operation against a read-only directory.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest)
            throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, EntityStateException,
            InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            software.amazon.awssdk.services.workmail.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a user from Amazon WorkMail and all subsequent systems. Before you can delete a user, the user state must
     * be <code>DISABLED</code>. Use the <a>DescribeUser</a> action to confirm the user state.
     * </p>
     * <p>
     * Deleting a user is permanent and cannot be undone. WorkMail archives user mailboxes for 30 days before they are
     * permanently removed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserRequest#builder()}
     * </p>
     *
     * @param deleteUserRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserRequest.Builder} to create a request.
     * @return Result of the DeleteUser operation returned by the service.
     * @throws DirectoryServiceAuthenticationFailedException
     *         The directory service doesn't recognize the credentials supplied by WorkMail.
     * @throws DirectoryUnavailableException
     *         The directory is unavailable. It might be located in another Region or deleted.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws UnsupportedOperationException
     *         You can't perform a write operation against a read-only directory.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUserResponse deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest)
            throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, EntityStateException,
            InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            software.amazon.awssdk.services.workmail.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, WorkMailException {
        return deleteUser(DeleteUserRequest.builder().applyMutation(deleteUserRequest).build());
    }

    /**
     * <p>
     * Mark a user, group, or resource as no longer used in Amazon WorkMail. This action disassociates the mailbox and
     * schedules it for clean-up. WorkMail keeps mailboxes for 30 days before they are permanently removed. The
     * functionality in the console is <i>Disable</i>.
     * </p>
     *
     * @param deregisterFromWorkMailRequest
     * @return Result of the DeregisterFromWorkMail operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeregisterFromWorkMail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeregisterFromWorkMail"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterFromWorkMailResponse deregisterFromWorkMail(DeregisterFromWorkMailRequest deregisterFromWorkMailRequest)
            throws EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException,
            OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Mark a user, group, or resource as no longer used in Amazon WorkMail. This action disassociates the mailbox and
     * schedules it for clean-up. WorkMail keeps mailboxes for 30 days before they are permanently removed. The
     * functionality in the console is <i>Disable</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterFromWorkMailRequest.Builder} avoiding the
     * need to create one manually via {@link DeregisterFromWorkMailRequest#builder()}
     * </p>
     *
     * @param deregisterFromWorkMailRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterFromWorkMailRequest.Builder} to create a
     *        request.
     * @return Result of the DeregisterFromWorkMail operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeregisterFromWorkMail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeregisterFromWorkMail"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterFromWorkMailResponse deregisterFromWorkMail(
            Consumer<DeregisterFromWorkMailRequest.Builder> deregisterFromWorkMailRequest) throws EntityNotFoundException,
            EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        return deregisterFromWorkMail(DeregisterFromWorkMailRequest.builder().applyMutation(deregisterFromWorkMailRequest)
                .build());
    }

    /**
     * <p>
     * Removes a domain from Amazon WorkMail, stops email routing to WorkMail, and removes the authorization allowing
     * WorkMail use. SES keeps the domain because other applications may use it. You must first remove any email address
     * used by WorkMail entities before you remove the domain.
     * </p>
     *
     * @param deregisterMailDomainRequest
     * @return Result of the DeregisterMailDomain operation returned by the service.
     * @throws MailDomainInUseException
     *         The domain you're trying to change is in use by another user or organization in your account. See the
     *         error message for details.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws InvalidCustomSesConfigurationException
     *         You SES configuration has customizations that Amazon WorkMail cannot save. The error message lists the
     *         invalid setting. For examples of invalid settings, refer to <a
     *         href="https://docs.aws.amazon.com/ses/latest/APIReference/API_CreateReceiptRule.html"
     *         >CreateReceiptRule</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeregisterMailDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeregisterMailDomain" target="_top">AWS
     *      API Documentation</a>
     */
    default DeregisterMailDomainResponse deregisterMailDomain(DeregisterMailDomainRequest deregisterMailDomainRequest)
            throws MailDomainInUseException, OrganizationNotFoundException, OrganizationStateException,
            InvalidParameterException, InvalidCustomSesConfigurationException, AwsServiceException, SdkClientException,
            WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a domain from Amazon WorkMail, stops email routing to WorkMail, and removes the authorization allowing
     * WorkMail use. SES keeps the domain because other applications may use it. You must first remove any email address
     * used by WorkMail entities before you remove the domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterMailDomainRequest.Builder} avoiding the
     * need to create one manually via {@link DeregisterMailDomainRequest#builder()}
     * </p>
     *
     * @param deregisterMailDomainRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterMailDomainRequest.Builder} to create a
     *        request.
     * @return Result of the DeregisterMailDomain operation returned by the service.
     * @throws MailDomainInUseException
     *         The domain you're trying to change is in use by another user or organization in your account. See the
     *         error message for details.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws InvalidCustomSesConfigurationException
     *         You SES configuration has customizations that Amazon WorkMail cannot save. The error message lists the
     *         invalid setting. For examples of invalid settings, refer to <a
     *         href="https://docs.aws.amazon.com/ses/latest/APIReference/API_CreateReceiptRule.html"
     *         >CreateReceiptRule</a>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DeregisterMailDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeregisterMailDomain" target="_top">AWS
     *      API Documentation</a>
     */
    default DeregisterMailDomainResponse deregisterMailDomain(
            Consumer<DeregisterMailDomainRequest.Builder> deregisterMailDomainRequest) throws MailDomainInUseException,
            OrganizationNotFoundException, OrganizationStateException, InvalidParameterException,
            InvalidCustomSesConfigurationException, AwsServiceException, SdkClientException, WorkMailException {
        return deregisterMailDomain(DeregisterMailDomainRequest.builder().applyMutation(deregisterMailDomainRequest).build());
    }

    /**
     * <p>
     * Describes the current email monitoring configuration for a specified organization.
     * </p>
     *
     * @param describeEmailMonitoringConfigurationRequest
     * @return Result of the DescribeEmailMonitoringConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DescribeEmailMonitoringConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeEmailMonitoringConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEmailMonitoringConfigurationResponse describeEmailMonitoringConfiguration(
            DescribeEmailMonitoringConfigurationRequest describeEmailMonitoringConfigurationRequest)
            throws ResourceNotFoundException, InvalidParameterException, OrganizationNotFoundException,
            OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the current email monitoring configuration for a specified organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeEmailMonitoringConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeEmailMonitoringConfigurationRequest#builder()}
     * </p>
     *
     * @param describeEmailMonitoringConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEmailMonitoringConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeEmailMonitoringConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DescribeEmailMonitoringConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeEmailMonitoringConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEmailMonitoringConfigurationResponse describeEmailMonitoringConfiguration(
            Consumer<DescribeEmailMonitoringConfigurationRequest.Builder> describeEmailMonitoringConfigurationRequest)
            throws ResourceNotFoundException, InvalidParameterException, OrganizationNotFoundException,
            OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        return describeEmailMonitoringConfiguration(DescribeEmailMonitoringConfigurationRequest.builder()
                .applyMutation(describeEmailMonitoringConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns the data available for the group.
     * </p>
     *
     * @param describeGroupRequest
     * @return Result of the DescribeGroup operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DescribeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeGroupResponse describeGroup(DescribeGroupRequest describeGroupRequest) throws EntityNotFoundException,
            InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the data available for the group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeGroupRequest#builder()}
     * </p>
     *
     * @param describeGroupRequest
     *        A {@link Consumer} that will call methods on {@link DescribeGroupRequest.Builder} to create a request.
     * @return Result of the DescribeGroup operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DescribeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeGroupResponse describeGroup(Consumer<DescribeGroupRequest.Builder> describeGroupRequest)
            throws EntityNotFoundException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        return describeGroup(DescribeGroupRequest.builder().applyMutation(describeGroupRequest).build());
    }

    /**
     * <p>
     * Lists the settings in a DMARC policy for a specified organization.
     * </p>
     *
     * @param describeInboundDmarcSettingsRequest
     * @return Result of the DescribeInboundDmarcSettings operation returned by the service.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DescribeInboundDmarcSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeInboundDmarcSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInboundDmarcSettingsResponse describeInboundDmarcSettings(
            DescribeInboundDmarcSettingsRequest describeInboundDmarcSettingsRequest) throws OrganizationNotFoundException,
            OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the settings in a DMARC policy for a specified organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInboundDmarcSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeInboundDmarcSettingsRequest#builder()}
     * </p>
     *
     * @param describeInboundDmarcSettingsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInboundDmarcSettingsRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeInboundDmarcSettings operation returned by the service.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DescribeInboundDmarcSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeInboundDmarcSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInboundDmarcSettingsResponse describeInboundDmarcSettings(
            Consumer<DescribeInboundDmarcSettingsRequest.Builder> describeInboundDmarcSettingsRequest)
            throws OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException,
            WorkMailException {
        return describeInboundDmarcSettings(DescribeInboundDmarcSettingsRequest.builder()
                .applyMutation(describeInboundDmarcSettingsRequest).build());
    }

    /**
     * <p>
     * Describes the current status of a mailbox export job.
     * </p>
     *
     * @param describeMailboxExportJobRequest
     * @return Result of the DescribeMailboxExportJob operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DescribeMailboxExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeMailboxExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMailboxExportJobResponse describeMailboxExportJob(
            DescribeMailboxExportJobRequest describeMailboxExportJobRequest) throws InvalidParameterException,
            OrganizationNotFoundException, OrganizationStateException, EntityNotFoundException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the current status of a mailbox export job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMailboxExportJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeMailboxExportJobRequest#builder()}
     * </p>
     *
     * @param describeMailboxExportJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMailboxExportJobRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeMailboxExportJob operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DescribeMailboxExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeMailboxExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMailboxExportJobResponse describeMailboxExportJob(
            Consumer<DescribeMailboxExportJobRequest.Builder> describeMailboxExportJobRequest) throws InvalidParameterException,
            OrganizationNotFoundException, OrganizationStateException, EntityNotFoundException, AwsServiceException,
            SdkClientException, WorkMailException {
        return describeMailboxExportJob(DescribeMailboxExportJobRequest.builder().applyMutation(describeMailboxExportJobRequest)
                .build());
    }

    /**
     * <p>
     * Provides more information regarding a given organization based on its identifier.
     * </p>
     *
     * @param describeOrganizationRequest
     * @return Result of the DescribeOrganization operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DescribeOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeOrganization" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeOrganizationResponse describeOrganization(DescribeOrganizationRequest describeOrganizationRequest)
            throws InvalidParameterException, OrganizationNotFoundException, AwsServiceException, SdkClientException,
            WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides more information regarding a given organization based on its identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrganizationRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeOrganizationRequest#builder()}
     * </p>
     *
     * @param describeOrganizationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOrganizationRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeOrganization operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DescribeOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeOrganization" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeOrganizationResponse describeOrganization(
            Consumer<DescribeOrganizationRequest.Builder> describeOrganizationRequest) throws InvalidParameterException,
            OrganizationNotFoundException, AwsServiceException, SdkClientException, WorkMailException {
        return describeOrganization(DescribeOrganizationRequest.builder().applyMutation(describeOrganizationRequest).build());
    }

    /**
     * <p>
     * Returns the data available for the resource.
     * </p>
     *
     * @param describeResourceRequest
     * @return Result of the DescribeResource operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DescribeResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeResource" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeResourceResponse describeResource(DescribeResourceRequest describeResourceRequest)
            throws EntityNotFoundException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the data available for the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeResourceRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeResourceRequest#builder()}
     * </p>
     *
     * @param describeResourceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeResourceRequest.Builder} to create a request.
     * @return Result of the DescribeResource operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DescribeResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeResource" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeResourceResponse describeResource(Consumer<DescribeResourceRequest.Builder> describeResourceRequest)
            throws EntityNotFoundException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        return describeResource(DescribeResourceRequest.builder().applyMutation(describeResourceRequest).build());
    }

    /**
     * <p>
     * Provides information regarding the user.
     * </p>
     *
     * @param describeUserRequest
     * @return Result of the DescribeUser operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DescribeUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeUserResponse describeUser(DescribeUserRequest describeUserRequest) throws EntityNotFoundException,
            InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information regarding the user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeUserRequest#builder()}
     * </p>
     *
     * @param describeUserRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUserRequest.Builder} to create a request.
     * @return Result of the DescribeUser operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DescribeUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeUserResponse describeUser(Consumer<DescribeUserRequest.Builder> describeUserRequest)
            throws EntityNotFoundException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        return describeUser(DescribeUserRequest.builder().applyMutation(describeUserRequest).build());
    }

    /**
     * <p>
     * Removes a member from the resource's set of delegates.
     * </p>
     *
     * @param disassociateDelegateFromResourceRequest
     * @return Result of the DisassociateDelegateFromResource operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DisassociateDelegateFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DisassociateDelegateFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateDelegateFromResourceResponse disassociateDelegateFromResource(
            DisassociateDelegateFromResourceRequest disassociateDelegateFromResourceRequest) throws EntityNotFoundException,
            EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a member from the resource's set of delegates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateDelegateFromResourceRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateDelegateFromResourceRequest#builder()}
     * </p>
     *
     * @param disassociateDelegateFromResourceRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateDelegateFromResourceRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateDelegateFromResource operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DisassociateDelegateFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DisassociateDelegateFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateDelegateFromResourceResponse disassociateDelegateFromResource(
            Consumer<DisassociateDelegateFromResourceRequest.Builder> disassociateDelegateFromResourceRequest)
            throws EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException,
            OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        return disassociateDelegateFromResource(DisassociateDelegateFromResourceRequest.builder()
                .applyMutation(disassociateDelegateFromResourceRequest).build());
    }

    /**
     * <p>
     * Removes a member from a group.
     * </p>
     *
     * @param disassociateMemberFromGroupRequest
     * @return Result of the DisassociateMemberFromGroup operation returned by the service.
     * @throws DirectoryServiceAuthenticationFailedException
     *         The directory service doesn't recognize the credentials supplied by WorkMail.
     * @throws DirectoryUnavailableException
     *         The directory is unavailable. It might be located in another Region or deleted.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws UnsupportedOperationException
     *         You can't perform a write operation against a read-only directory.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DisassociateMemberFromGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DisassociateMemberFromGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateMemberFromGroupResponse disassociateMemberFromGroup(
            DisassociateMemberFromGroupRequest disassociateMemberFromGroupRequest)
            throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, EntityNotFoundException,
            EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            software.amazon.awssdk.services.workmail.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a member from a group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateMemberFromGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateMemberFromGroupRequest#builder()}
     * </p>
     *
     * @param disassociateMemberFromGroupRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateMemberFromGroupRequest.Builder} to create
     *        a request.
     * @return Result of the DisassociateMemberFromGroup operation returned by the service.
     * @throws DirectoryServiceAuthenticationFailedException
     *         The directory service doesn't recognize the credentials supplied by WorkMail.
     * @throws DirectoryUnavailableException
     *         The directory is unavailable. It might be located in another Region or deleted.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws UnsupportedOperationException
     *         You can't perform a write operation against a read-only directory.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.DisassociateMemberFromGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DisassociateMemberFromGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateMemberFromGroupResponse disassociateMemberFromGroup(
            Consumer<DisassociateMemberFromGroupRequest.Builder> disassociateMemberFromGroupRequest)
            throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, EntityNotFoundException,
            EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            software.amazon.awssdk.services.workmail.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, WorkMailException {
        return disassociateMemberFromGroup(DisassociateMemberFromGroupRequest.builder()
                .applyMutation(disassociateMemberFromGroupRequest).build());
    }

    /**
     * <p>
     * Gets the effects of an organization's access control rules as they apply to a specified IPv4 address, access
     * protocol action, or user ID.
     * </p>
     *
     * @param getAccessControlEffectRequest
     * @return Result of the GetAccessControlEffect operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.GetAccessControlEffect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetAccessControlEffect"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAccessControlEffectResponse getAccessControlEffect(GetAccessControlEffectRequest getAccessControlEffectRequest)
            throws EntityNotFoundException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the effects of an organization's access control rules as they apply to a specified IPv4 address, access
     * protocol action, or user ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccessControlEffectRequest.Builder} avoiding the
     * need to create one manually via {@link GetAccessControlEffectRequest#builder()}
     * </p>
     *
     * @param getAccessControlEffectRequest
     *        A {@link Consumer} that will call methods on {@link GetAccessControlEffectRequest.Builder} to create a
     *        request.
     * @return Result of the GetAccessControlEffect operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.GetAccessControlEffect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetAccessControlEffect"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAccessControlEffectResponse getAccessControlEffect(
            Consumer<GetAccessControlEffectRequest.Builder> getAccessControlEffectRequest) throws EntityNotFoundException,
            InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        return getAccessControlEffect(GetAccessControlEffectRequest.builder().applyMutation(getAccessControlEffectRequest)
                .build());
    }

    /**
     * <p>
     * Gets the default retention policy details for the specified organization.
     * </p>
     *
     * @param getDefaultRetentionPolicyRequest
     * @return Result of the GetDefaultRetentionPolicy operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.GetDefaultRetentionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetDefaultRetentionPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDefaultRetentionPolicyResponse getDefaultRetentionPolicy(
            GetDefaultRetentionPolicyRequest getDefaultRetentionPolicyRequest) throws InvalidParameterException,
            OrganizationNotFoundException, OrganizationStateException, EntityNotFoundException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the default retention policy details for the specified organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDefaultRetentionPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link GetDefaultRetentionPolicyRequest#builder()}
     * </p>
     *
     * @param getDefaultRetentionPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetDefaultRetentionPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the GetDefaultRetentionPolicy operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.GetDefaultRetentionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetDefaultRetentionPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDefaultRetentionPolicyResponse getDefaultRetentionPolicy(
            Consumer<GetDefaultRetentionPolicyRequest.Builder> getDefaultRetentionPolicyRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, EntityNotFoundException,
            AwsServiceException, SdkClientException, WorkMailException {
        return getDefaultRetentionPolicy(GetDefaultRetentionPolicyRequest.builder()
                .applyMutation(getDefaultRetentionPolicyRequest).build());
    }

    /**
     * <p>
     * Gets details for a mail domain, including domain records required to configure your domain with recommended
     * security.
     * </p>
     *
     * @param getMailDomainRequest
     * @return Result of the GetMailDomain operation returned by the service.
     * @throws MailDomainNotFoundException
     *         The domain specified is not found in your organization.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.GetMailDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetMailDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMailDomainResponse getMailDomain(GetMailDomainRequest getMailDomainRequest) throws MailDomainNotFoundException,
            OrganizationNotFoundException, OrganizationStateException, InvalidParameterException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details for a mail domain, including domain records required to configure your domain with recommended
     * security.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMailDomainRequest.Builder} avoiding the need to
     * create one manually via {@link GetMailDomainRequest#builder()}
     * </p>
     *
     * @param getMailDomainRequest
     *        A {@link Consumer} that will call methods on {@link GetMailDomainRequest.Builder} to create a request.
     * @return Result of the GetMailDomain operation returned by the service.
     * @throws MailDomainNotFoundException
     *         The domain specified is not found in your organization.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.GetMailDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetMailDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMailDomainResponse getMailDomain(Consumer<GetMailDomainRequest.Builder> getMailDomainRequest)
            throws MailDomainNotFoundException, OrganizationNotFoundException, OrganizationStateException,
            InvalidParameterException, AwsServiceException, SdkClientException, WorkMailException {
        return getMailDomain(GetMailDomainRequest.builder().applyMutation(getMailDomainRequest).build());
    }

    /**
     * <p>
     * Requests a user's mailbox details for a specified organization and user.
     * </p>
     *
     * @param getMailboxDetailsRequest
     * @return Result of the GetMailboxDetails operation returned by the service.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.GetMailboxDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetMailboxDetails" target="_top">AWS
     *      API Documentation</a>
     */
    default GetMailboxDetailsResponse getMailboxDetails(GetMailboxDetailsRequest getMailboxDetailsRequest)
            throws OrganizationNotFoundException, OrganizationStateException, EntityNotFoundException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Requests a user's mailbox details for a specified organization and user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMailboxDetailsRequest.Builder} avoiding the need
     * to create one manually via {@link GetMailboxDetailsRequest#builder()}
     * </p>
     *
     * @param getMailboxDetailsRequest
     *        A {@link Consumer} that will call methods on {@link GetMailboxDetailsRequest.Builder} to create a request.
     * @return Result of the GetMailboxDetails operation returned by the service.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.GetMailboxDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetMailboxDetails" target="_top">AWS
     *      API Documentation</a>
     */
    default GetMailboxDetailsResponse getMailboxDetails(Consumer<GetMailboxDetailsRequest.Builder> getMailboxDetailsRequest)
            throws OrganizationNotFoundException, OrganizationStateException, EntityNotFoundException, AwsServiceException,
            SdkClientException, WorkMailException {
        return getMailboxDetails(GetMailboxDetailsRequest.builder().applyMutation(getMailboxDetailsRequest).build());
    }

    /**
     * <p>
     * Simulates the effect of the mobile device access rules for the given attributes of a sample access event. Use
     * this method to test the effects of the current set of mobile device access rules for the Amazon WorkMail
     * organization for a particular user's attributes.
     * </p>
     *
     * @param getMobileDeviceAccessEffectRequest
     * @return Result of the GetMobileDeviceAccessEffect operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.GetMobileDeviceAccessEffect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetMobileDeviceAccessEffect"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMobileDeviceAccessEffectResponse getMobileDeviceAccessEffect(
            GetMobileDeviceAccessEffectRequest getMobileDeviceAccessEffectRequest) throws InvalidParameterException,
            OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Simulates the effect of the mobile device access rules for the given attributes of a sample access event. Use
     * this method to test the effects of the current set of mobile device access rules for the Amazon WorkMail
     * organization for a particular user's attributes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMobileDeviceAccessEffectRequest.Builder}
     * avoiding the need to create one manually via {@link GetMobileDeviceAccessEffectRequest#builder()}
     * </p>
     *
     * @param getMobileDeviceAccessEffectRequest
     *        A {@link Consumer} that will call methods on {@link GetMobileDeviceAccessEffectRequest.Builder} to create
     *        a request.
     * @return Result of the GetMobileDeviceAccessEffect operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.GetMobileDeviceAccessEffect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetMobileDeviceAccessEffect"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMobileDeviceAccessEffectResponse getMobileDeviceAccessEffect(
            Consumer<GetMobileDeviceAccessEffectRequest.Builder> getMobileDeviceAccessEffectRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        return getMobileDeviceAccessEffect(GetMobileDeviceAccessEffectRequest.builder()
                .applyMutation(getMobileDeviceAccessEffectRequest).build());
    }

    /**
     * <p>
     * Gets the mobile device access override for the given WorkMail organization, user, and device.
     * </p>
     *
     * @param getMobileDeviceAccessOverrideRequest
     * @return Result of the GetMobileDeviceAccessOverride operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.GetMobileDeviceAccessOverride
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetMobileDeviceAccessOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMobileDeviceAccessOverrideResponse getMobileDeviceAccessOverride(
            GetMobileDeviceAccessOverrideRequest getMobileDeviceAccessOverrideRequest) throws InvalidParameterException,
            OrganizationNotFoundException, OrganizationStateException, EntityNotFoundException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the mobile device access override for the given WorkMail organization, user, and device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMobileDeviceAccessOverrideRequest.Builder}
     * avoiding the need to create one manually via {@link GetMobileDeviceAccessOverrideRequest#builder()}
     * </p>
     *
     * @param getMobileDeviceAccessOverrideRequest
     *        A {@link Consumer} that will call methods on {@link GetMobileDeviceAccessOverrideRequest.Builder} to
     *        create a request.
     * @return Result of the GetMobileDeviceAccessOverride operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.GetMobileDeviceAccessOverride
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetMobileDeviceAccessOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMobileDeviceAccessOverrideResponse getMobileDeviceAccessOverride(
            Consumer<GetMobileDeviceAccessOverrideRequest.Builder> getMobileDeviceAccessOverrideRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, EntityNotFoundException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, WorkMailException {
        return getMobileDeviceAccessOverride(GetMobileDeviceAccessOverrideRequest.builder()
                .applyMutation(getMobileDeviceAccessOverrideRequest).build());
    }

    /**
     * <p>
     * Lists the access control rules for the specified organization.
     * </p>
     *
     * @param listAccessControlRulesRequest
     * @return Result of the ListAccessControlRules operation returned by the service.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListAccessControlRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAccessControlRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessControlRulesResponse listAccessControlRules(ListAccessControlRulesRequest listAccessControlRulesRequest)
            throws OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException,
            WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the access control rules for the specified organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessControlRulesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAccessControlRulesRequest#builder()}
     * </p>
     *
     * @param listAccessControlRulesRequest
     *        A {@link Consumer} that will call methods on {@link ListAccessControlRulesRequest.Builder} to create a
     *        request.
     * @return Result of the ListAccessControlRules operation returned by the service.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListAccessControlRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAccessControlRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessControlRulesResponse listAccessControlRules(
            Consumer<ListAccessControlRulesRequest.Builder> listAccessControlRulesRequest) throws OrganizationNotFoundException,
            OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        return listAccessControlRules(ListAccessControlRulesRequest.builder().applyMutation(listAccessControlRulesRequest)
                .build());
    }

    /**
     * <p>
     * Creates a paginated call to list the aliases associated with a given entity.
     * </p>
     *
     * @param listAliasesRequest
     * @return Result of the ListAliases operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAliasesResponse listAliases(ListAliasesRequest listAliasesRequest) throws EntityNotFoundException,
            EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a paginated call to list the aliases associated with a given entity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAliasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAliasesRequest#builder()}
     * </p>
     *
     * @param listAliasesRequest
     *        A {@link Consumer} that will call methods on {@link ListAliasesRequest.Builder} to create a request.
     * @return Result of the ListAliases operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAliasesResponse listAliases(Consumer<ListAliasesRequest.Builder> listAliasesRequest)
            throws EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException,
            OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        return listAliases(ListAliasesRequest.builder().applyMutation(listAliasesRequest).build());
    }

    /**
     * <p>
     * Creates a paginated call to list the aliases associated with a given entity.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAliases(software.amazon.awssdk.services.workmail.model.ListAliasesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListAliasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAliases(software.amazon.awssdk.services.workmail.model.ListAliasesRequest)} operation.</b>
     * </p>
     *
     * @param listAliasesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAliasesIterable listAliasesPaginator(ListAliasesRequest listAliasesRequest) throws EntityNotFoundException,
            EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a paginated call to list the aliases associated with a given entity.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAliases(software.amazon.awssdk.services.workmail.model.ListAliasesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListAliasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAliases(software.amazon.awssdk.services.workmail.model.ListAliasesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAliasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAliasesRequest#builder()}
     * </p>
     *
     * @param listAliasesRequest
     *        A {@link Consumer} that will call methods on {@link ListAliasesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAliasesIterable listAliasesPaginator(Consumer<ListAliasesRequest.Builder> listAliasesRequest)
            throws EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException,
            OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        return listAliasesPaginator(ListAliasesRequest.builder().applyMutation(listAliasesRequest).build());
    }

    /**
     * <p>
     * List all the <code>AvailabilityConfiguration</code>'s for the given WorkMail organization.
     * </p>
     *
     * @param listAvailabilityConfigurationsRequest
     * @return Result of the ListAvailabilityConfigurations operation returned by the service.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListAvailabilityConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAvailabilityConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAvailabilityConfigurationsResponse listAvailabilityConfigurations(
            ListAvailabilityConfigurationsRequest listAvailabilityConfigurationsRequest) throws OrganizationNotFoundException,
            OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all the <code>AvailabilityConfiguration</code>'s for the given WorkMail organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAvailabilityConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAvailabilityConfigurationsRequest#builder()}
     * </p>
     *
     * @param listAvailabilityConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListAvailabilityConfigurationsRequest.Builder} to
     *        create a request.
     * @return Result of the ListAvailabilityConfigurations operation returned by the service.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListAvailabilityConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAvailabilityConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAvailabilityConfigurationsResponse listAvailabilityConfigurations(
            Consumer<ListAvailabilityConfigurationsRequest.Builder> listAvailabilityConfigurationsRequest)
            throws OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException,
            WorkMailException {
        return listAvailabilityConfigurations(ListAvailabilityConfigurationsRequest.builder()
                .applyMutation(listAvailabilityConfigurationsRequest).build());
    }

    /**
     * <p>
     * List all the <code>AvailabilityConfiguration</code>'s for the given WorkMail organization.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAvailabilityConfigurations(software.amazon.awssdk.services.workmail.model.ListAvailabilityConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListAvailabilityConfigurationsIterable responses = client.listAvailabilityConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListAvailabilityConfigurationsIterable responses = client
     *             .listAvailabilityConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListAvailabilityConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListAvailabilityConfigurationsIterable responses = client.listAvailabilityConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAvailabilityConfigurations(software.amazon.awssdk.services.workmail.model.ListAvailabilityConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAvailabilityConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListAvailabilityConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAvailabilityConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAvailabilityConfigurationsIterable listAvailabilityConfigurationsPaginator(
            ListAvailabilityConfigurationsRequest listAvailabilityConfigurationsRequest) throws OrganizationNotFoundException,
            OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all the <code>AvailabilityConfiguration</code>'s for the given WorkMail organization.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAvailabilityConfigurations(software.amazon.awssdk.services.workmail.model.ListAvailabilityConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListAvailabilityConfigurationsIterable responses = client.listAvailabilityConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListAvailabilityConfigurationsIterable responses = client
     *             .listAvailabilityConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListAvailabilityConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListAvailabilityConfigurationsIterable responses = client.listAvailabilityConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAvailabilityConfigurations(software.amazon.awssdk.services.workmail.model.ListAvailabilityConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAvailabilityConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAvailabilityConfigurationsRequest#builder()}
     * </p>
     *
     * @param listAvailabilityConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link ListAvailabilityConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListAvailabilityConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAvailabilityConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAvailabilityConfigurationsIterable listAvailabilityConfigurationsPaginator(
            Consumer<ListAvailabilityConfigurationsRequest.Builder> listAvailabilityConfigurationsRequest)
            throws OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException,
            WorkMailException {
        return listAvailabilityConfigurationsPaginator(ListAvailabilityConfigurationsRequest.builder()
                .applyMutation(listAvailabilityConfigurationsRequest).build());
    }

    /**
     * <p>
     * Returns an overview of the members of a group. Users and groups can be members of a group.
     * </p>
     *
     * @param listGroupMembersRequest
     * @return Result of the ListGroupMembers operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListGroupMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroupMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupMembersResponse listGroupMembers(ListGroupMembersRequest listGroupMembersRequest)
            throws EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException,
            OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an overview of the members of a group. Users and groups can be members of a group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupMembersRequest.Builder} avoiding the need
     * to create one manually via {@link ListGroupMembersRequest#builder()}
     * </p>
     *
     * @param listGroupMembersRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupMembersRequest.Builder} to create a request.
     * @return Result of the ListGroupMembers operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListGroupMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroupMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupMembersResponse listGroupMembers(Consumer<ListGroupMembersRequest.Builder> listGroupMembersRequest)
            throws EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException,
            OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        return listGroupMembers(ListGroupMembersRequest.builder().applyMutation(listGroupMembersRequest).build());
    }

    /**
     * <p>
     * Returns an overview of the members of a group. Users and groups can be members of a group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGroupMembers(software.amazon.awssdk.services.workmail.model.ListGroupMembersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupMembersIterable responses = client.listGroupMembersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListGroupMembersIterable responses = client
     *             .listGroupMembersPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListGroupMembersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupMembersIterable responses = client.listGroupMembersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroupMembers(software.amazon.awssdk.services.workmail.model.ListGroupMembersRequest)} operation.</b>
     * </p>
     *
     * @param listGroupMembersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListGroupMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroupMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupMembersIterable listGroupMembersPaginator(ListGroupMembersRequest listGroupMembersRequest)
            throws EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException,
            OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an overview of the members of a group. Users and groups can be members of a group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGroupMembers(software.amazon.awssdk.services.workmail.model.ListGroupMembersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupMembersIterable responses = client.listGroupMembersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListGroupMembersIterable responses = client
     *             .listGroupMembersPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListGroupMembersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupMembersIterable responses = client.listGroupMembersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroupMembers(software.amazon.awssdk.services.workmail.model.ListGroupMembersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupMembersRequest.Builder} avoiding the need
     * to create one manually via {@link ListGroupMembersRequest#builder()}
     * </p>
     *
     * @param listGroupMembersRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupMembersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListGroupMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroupMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupMembersIterable listGroupMembersPaginator(Consumer<ListGroupMembersRequest.Builder> listGroupMembersRequest)
            throws EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException,
            OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        return listGroupMembersPaginator(ListGroupMembersRequest.builder().applyMutation(listGroupMembersRequest).build());
    }

    /**
     * <p>
     * Returns summaries of the organization's groups.
     * </p>
     *
     * @param listGroupsRequest
     * @return Result of the ListGroups operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsResponse listGroups(ListGroupsRequest listGroupsRequest) throws EntityNotFoundException,
            InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summaries of the organization's groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGroupsRequest#builder()}
     * </p>
     *
     * @param listGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupsRequest.Builder} to create a request.
     * @return Result of the ListGroups operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsResponse listGroups(Consumer<ListGroupsRequest.Builder> listGroupsRequest) throws EntityNotFoundException,
            InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        return listGroups(ListGroupsRequest.builder().applyMutation(listGroupsRequest).build());
    }

    /**
     * <p>
     * Returns summaries of the organization's groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listGroups(software.amazon.awssdk.services.workmail.model.ListGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupsIterable responses = client.listGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListGroupsIterable responses = client.listGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupsIterable responses = client.listGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroups(software.amazon.awssdk.services.workmail.model.ListGroupsRequest)} operation.</b>
     * </p>
     *
     * @param listGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsIterable listGroupsPaginator(ListGroupsRequest listGroupsRequest) throws EntityNotFoundException,
            InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summaries of the organization's groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listGroups(software.amazon.awssdk.services.workmail.model.ListGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupsIterable responses = client.listGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListGroupsIterable responses = client.listGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupsIterable responses = client.listGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroups(software.amazon.awssdk.services.workmail.model.ListGroupsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGroupsRequest#builder()}
     * </p>
     *
     * @param listGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsIterable listGroupsPaginator(Consumer<ListGroupsRequest.Builder> listGroupsRequest)
            throws EntityNotFoundException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        return listGroupsPaginator(ListGroupsRequest.builder().applyMutation(listGroupsRequest).build());
    }

    /**
     * <p>
     * Lists the mail domains in a given Amazon WorkMail organization.
     * </p>
     *
     * @param listMailDomainsRequest
     * @return Result of the ListMailDomains operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListMailDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMailDomainsResponse listMailDomains(ListMailDomainsRequest listMailDomainsRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the mail domains in a given Amazon WorkMail organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMailDomainsRequest.Builder} avoiding the need
     * to create one manually via {@link ListMailDomainsRequest#builder()}
     * </p>
     *
     * @param listMailDomainsRequest
     *        A {@link Consumer} that will call methods on {@link ListMailDomainsRequest.Builder} to create a request.
     * @return Result of the ListMailDomains operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListMailDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMailDomainsResponse listMailDomains(Consumer<ListMailDomainsRequest.Builder> listMailDomainsRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        return listMailDomains(ListMailDomainsRequest.builder().applyMutation(listMailDomainsRequest).build());
    }

    /**
     * <p>
     * Lists the mail domains in a given Amazon WorkMail organization.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMailDomains(software.amazon.awssdk.services.workmail.model.ListMailDomainsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailDomainsIterable responses = client.listMailDomainsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListMailDomainsIterable responses = client
     *             .listMailDomainsPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListMailDomainsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailDomainsIterable responses = client.listMailDomainsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMailDomains(software.amazon.awssdk.services.workmail.model.ListMailDomainsRequest)} operation.</b>
     * </p>
     *
     * @param listMailDomainsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListMailDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMailDomainsIterable listMailDomainsPaginator(ListMailDomainsRequest listMailDomainsRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the mail domains in a given Amazon WorkMail organization.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMailDomains(software.amazon.awssdk.services.workmail.model.ListMailDomainsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailDomainsIterable responses = client.listMailDomainsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListMailDomainsIterable responses = client
     *             .listMailDomainsPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListMailDomainsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailDomainsIterable responses = client.listMailDomainsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMailDomains(software.amazon.awssdk.services.workmail.model.ListMailDomainsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMailDomainsRequest.Builder} avoiding the need
     * to create one manually via {@link ListMailDomainsRequest#builder()}
     * </p>
     *
     * @param listMailDomainsRequest
     *        A {@link Consumer} that will call methods on {@link ListMailDomainsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListMailDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMailDomainsIterable listMailDomainsPaginator(Consumer<ListMailDomainsRequest.Builder> listMailDomainsRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        return listMailDomainsPaginator(ListMailDomainsRequest.builder().applyMutation(listMailDomainsRequest).build());
    }

    /**
     * <p>
     * Lists the mailbox export jobs started for the specified organization within the last seven days.
     * </p>
     *
     * @param listMailboxExportJobsRequest
     * @return Result of the ListMailboxExportJobs operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListMailboxExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMailboxExportJobsResponse listMailboxExportJobs(ListMailboxExportJobsRequest listMailboxExportJobsRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the mailbox export jobs started for the specified organization within the last seven days.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMailboxExportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMailboxExportJobsRequest#builder()}
     * </p>
     *
     * @param listMailboxExportJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListMailboxExportJobsRequest.Builder} to create a
     *        request.
     * @return Result of the ListMailboxExportJobs operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListMailboxExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMailboxExportJobsResponse listMailboxExportJobs(
            Consumer<ListMailboxExportJobsRequest.Builder> listMailboxExportJobsRequest) throws InvalidParameterException,
            OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        return listMailboxExportJobs(ListMailboxExportJobsRequest.builder().applyMutation(listMailboxExportJobsRequest).build());
    }

    /**
     * <p>
     * Lists the mailbox export jobs started for the specified organization within the last seven days.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMailboxExportJobs(software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailboxExportJobsIterable responses = client.listMailboxExportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListMailboxExportJobsIterable responses = client
     *             .listMailboxExportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailboxExportJobsIterable responses = client.listMailboxExportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMailboxExportJobs(software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMailboxExportJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListMailboxExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMailboxExportJobsIterable listMailboxExportJobsPaginator(ListMailboxExportJobsRequest listMailboxExportJobsRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the mailbox export jobs started for the specified organization within the last seven days.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMailboxExportJobs(software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailboxExportJobsIterable responses = client.listMailboxExportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListMailboxExportJobsIterable responses = client
     *             .listMailboxExportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailboxExportJobsIterable responses = client.listMailboxExportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMailboxExportJobs(software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMailboxExportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMailboxExportJobsRequest#builder()}
     * </p>
     *
     * @param listMailboxExportJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListMailboxExportJobsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListMailboxExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMailboxExportJobsIterable listMailboxExportJobsPaginator(
            Consumer<ListMailboxExportJobsRequest.Builder> listMailboxExportJobsRequest) throws InvalidParameterException,
            OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        return listMailboxExportJobsPaginator(ListMailboxExportJobsRequest.builder().applyMutation(listMailboxExportJobsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the mailbox permissions associated with a user, group, or resource mailbox.
     * </p>
     *
     * @param listMailboxPermissionsRequest
     * @return Result of the ListMailboxPermissions operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListMailboxPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMailboxPermissionsResponse listMailboxPermissions(ListMailboxPermissionsRequest listMailboxPermissionsRequest)
            throws EntityNotFoundException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the mailbox permissions associated with a user, group, or resource mailbox.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMailboxPermissionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMailboxPermissionsRequest#builder()}
     * </p>
     *
     * @param listMailboxPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link ListMailboxPermissionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListMailboxPermissions operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListMailboxPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMailboxPermissionsResponse listMailboxPermissions(
            Consumer<ListMailboxPermissionsRequest.Builder> listMailboxPermissionsRequest) throws EntityNotFoundException,
            InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        return listMailboxPermissions(ListMailboxPermissionsRequest.builder().applyMutation(listMailboxPermissionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the mailbox permissions associated with a user, group, or resource mailbox.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMailboxPermissions(software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailboxPermissionsIterable responses = client.listMailboxPermissionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListMailboxPermissionsIterable responses = client
     *             .listMailboxPermissionsPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailboxPermissionsIterable responses = client.listMailboxPermissionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMailboxPermissions(software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMailboxPermissionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListMailboxPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMailboxPermissionsIterable listMailboxPermissionsPaginator(
            ListMailboxPermissionsRequest listMailboxPermissionsRequest) throws EntityNotFoundException,
            InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the mailbox permissions associated with a user, group, or resource mailbox.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMailboxPermissions(software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailboxPermissionsIterable responses = client.listMailboxPermissionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListMailboxPermissionsIterable responses = client
     *             .listMailboxPermissionsPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailboxPermissionsIterable responses = client.listMailboxPermissionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMailboxPermissions(software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMailboxPermissionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListMailboxPermissionsRequest#builder()}
     * </p>
     *
     * @param listMailboxPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link ListMailboxPermissionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListMailboxPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMailboxPermissionsIterable listMailboxPermissionsPaginator(
            Consumer<ListMailboxPermissionsRequest.Builder> listMailboxPermissionsRequest) throws EntityNotFoundException,
            InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        return listMailboxPermissionsPaginator(ListMailboxPermissionsRequest.builder()
                .applyMutation(listMailboxPermissionsRequest).build());
    }

    /**
     * <p>
     * Lists all the mobile device access overrides for any given combination of WorkMail organization, user, or device.
     * </p>
     *
     * @param listMobileDeviceAccessOverridesRequest
     * @return Result of the ListMobileDeviceAccessOverrides operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListMobileDeviceAccessOverrides
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMobileDeviceAccessOverrides"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMobileDeviceAccessOverridesResponse listMobileDeviceAccessOverrides(
            ListMobileDeviceAccessOverridesRequest listMobileDeviceAccessOverridesRequest) throws InvalidParameterException,
            OrganizationNotFoundException, OrganizationStateException, EntityNotFoundException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the mobile device access overrides for any given combination of WorkMail organization, user, or device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMobileDeviceAccessOverridesRequest.Builder}
     * avoiding the need to create one manually via {@link ListMobileDeviceAccessOverridesRequest#builder()}
     * </p>
     *
     * @param listMobileDeviceAccessOverridesRequest
     *        A {@link Consumer} that will call methods on {@link ListMobileDeviceAccessOverridesRequest.Builder} to
     *        create a request.
     * @return Result of the ListMobileDeviceAccessOverrides operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListMobileDeviceAccessOverrides
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMobileDeviceAccessOverrides"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMobileDeviceAccessOverridesResponse listMobileDeviceAccessOverrides(
            Consumer<ListMobileDeviceAccessOverridesRequest.Builder> listMobileDeviceAccessOverridesRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, EntityNotFoundException,
            AwsServiceException, SdkClientException, WorkMailException {
        return listMobileDeviceAccessOverrides(ListMobileDeviceAccessOverridesRequest.builder()
                .applyMutation(listMobileDeviceAccessOverridesRequest).build());
    }

    /**
     * <p>
     * Lists all the mobile device access overrides for any given combination of WorkMail organization, user, or device.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMobileDeviceAccessOverrides(software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessOverridesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMobileDeviceAccessOverridesIterable responses = client.listMobileDeviceAccessOverridesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListMobileDeviceAccessOverridesIterable responses = client
     *             .listMobileDeviceAccessOverridesPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessOverridesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMobileDeviceAccessOverridesIterable responses = client.listMobileDeviceAccessOverridesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMobileDeviceAccessOverrides(software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessOverridesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMobileDeviceAccessOverridesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListMobileDeviceAccessOverrides
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMobileDeviceAccessOverrides"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMobileDeviceAccessOverridesIterable listMobileDeviceAccessOverridesPaginator(
            ListMobileDeviceAccessOverridesRequest listMobileDeviceAccessOverridesRequest) throws InvalidParameterException,
            OrganizationNotFoundException, OrganizationStateException, EntityNotFoundException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the mobile device access overrides for any given combination of WorkMail organization, user, or device.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMobileDeviceAccessOverrides(software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessOverridesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMobileDeviceAccessOverridesIterable responses = client.listMobileDeviceAccessOverridesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListMobileDeviceAccessOverridesIterable responses = client
     *             .listMobileDeviceAccessOverridesPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessOverridesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMobileDeviceAccessOverridesIterable responses = client.listMobileDeviceAccessOverridesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMobileDeviceAccessOverrides(software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessOverridesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMobileDeviceAccessOverridesRequest.Builder}
     * avoiding the need to create one manually via {@link ListMobileDeviceAccessOverridesRequest#builder()}
     * </p>
     *
     * @param listMobileDeviceAccessOverridesRequest
     *        A {@link Consumer} that will call methods on {@link ListMobileDeviceAccessOverridesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListMobileDeviceAccessOverrides
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMobileDeviceAccessOverrides"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMobileDeviceAccessOverridesIterable listMobileDeviceAccessOverridesPaginator(
            Consumer<ListMobileDeviceAccessOverridesRequest.Builder> listMobileDeviceAccessOverridesRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, EntityNotFoundException,
            AwsServiceException, SdkClientException, WorkMailException {
        return listMobileDeviceAccessOverridesPaginator(ListMobileDeviceAccessOverridesRequest.builder()
                .applyMutation(listMobileDeviceAccessOverridesRequest).build());
    }

    /**
     * <p>
     * Lists the mobile device access rules for the specified Amazon WorkMail organization.
     * </p>
     *
     * @param listMobileDeviceAccessRulesRequest
     * @return Result of the ListMobileDeviceAccessRules operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListMobileDeviceAccessRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMobileDeviceAccessRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMobileDeviceAccessRulesResponse listMobileDeviceAccessRules(
            ListMobileDeviceAccessRulesRequest listMobileDeviceAccessRulesRequest) throws InvalidParameterException,
            OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the mobile device access rules for the specified Amazon WorkMail organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMobileDeviceAccessRulesRequest.Builder}
     * avoiding the need to create one manually via {@link ListMobileDeviceAccessRulesRequest#builder()}
     * </p>
     *
     * @param listMobileDeviceAccessRulesRequest
     *        A {@link Consumer} that will call methods on {@link ListMobileDeviceAccessRulesRequest.Builder} to create
     *        a request.
     * @return Result of the ListMobileDeviceAccessRules operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListMobileDeviceAccessRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMobileDeviceAccessRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMobileDeviceAccessRulesResponse listMobileDeviceAccessRules(
            Consumer<ListMobileDeviceAccessRulesRequest.Builder> listMobileDeviceAccessRulesRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        return listMobileDeviceAccessRules(ListMobileDeviceAccessRulesRequest.builder()
                .applyMutation(listMobileDeviceAccessRulesRequest).build());
    }

    /**
     * <p>
     * Returns summaries of the customer's organizations.
     * </p>
     *
     * @return Result of the ListOrganizations operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListOrganizations
     * @see #listOrganizations(ListOrganizationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListOrganizations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOrganizationsResponse listOrganizations() throws InvalidParameterException, AwsServiceException,
            SdkClientException, WorkMailException {
        return listOrganizations(ListOrganizationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns summaries of the customer's organizations.
     * </p>
     *
     * @param listOrganizationsRequest
     * @return Result of the ListOrganizations operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListOrganizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListOrganizations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOrganizationsResponse listOrganizations(ListOrganizationsRequest listOrganizationsRequest)
            throws InvalidParameterException, AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summaries of the customer's organizations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListOrganizationsRequest#builder()}
     * </p>
     *
     * @param listOrganizationsRequest
     *        A {@link Consumer} that will call methods on {@link ListOrganizationsRequest.Builder} to create a request.
     * @return Result of the ListOrganizations operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListOrganizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListOrganizations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOrganizationsResponse listOrganizations(Consumer<ListOrganizationsRequest.Builder> listOrganizationsRequest)
            throws InvalidParameterException, AwsServiceException, SdkClientException, WorkMailException {
        return listOrganizations(ListOrganizationsRequest.builder().applyMutation(listOrganizationsRequest).build());
    }

    /**
     * <p>
     * Returns summaries of the customer's organizations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOrganizations(software.amazon.awssdk.services.workmail.model.ListOrganizationsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListOrganizationsIterable responses = client.listOrganizationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListOrganizationsIterable responses = client
     *             .listOrganizationsPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListOrganizationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListOrganizationsIterable responses = client.listOrganizationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizations(software.amazon.awssdk.services.workmail.model.ListOrganizationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListOrganizations
     * @see #listOrganizationsPaginator(ListOrganizationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListOrganizations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOrganizationsIterable listOrganizationsPaginator() throws InvalidParameterException, AwsServiceException,
            SdkClientException, WorkMailException {
        return listOrganizationsPaginator(ListOrganizationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns summaries of the customer's organizations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOrganizations(software.amazon.awssdk.services.workmail.model.ListOrganizationsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListOrganizationsIterable responses = client.listOrganizationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListOrganizationsIterable responses = client
     *             .listOrganizationsPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListOrganizationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListOrganizationsIterable responses = client.listOrganizationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizations(software.amazon.awssdk.services.workmail.model.ListOrganizationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOrganizationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListOrganizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListOrganizations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOrganizationsIterable listOrganizationsPaginator(ListOrganizationsRequest listOrganizationsRequest)
            throws InvalidParameterException, AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summaries of the customer's organizations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOrganizations(software.amazon.awssdk.services.workmail.model.ListOrganizationsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListOrganizationsIterable responses = client.listOrganizationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListOrganizationsIterable responses = client
     *             .listOrganizationsPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListOrganizationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListOrganizationsIterable responses = client.listOrganizationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizations(software.amazon.awssdk.services.workmail.model.ListOrganizationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListOrganizationsRequest#builder()}
     * </p>
     *
     * @param listOrganizationsRequest
     *        A {@link Consumer} that will call methods on {@link ListOrganizationsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListOrganizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListOrganizations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOrganizationsIterable listOrganizationsPaginator(
            Consumer<ListOrganizationsRequest.Builder> listOrganizationsRequest) throws InvalidParameterException,
            AwsServiceException, SdkClientException, WorkMailException {
        return listOrganizationsPaginator(ListOrganizationsRequest.builder().applyMutation(listOrganizationsRequest).build());
    }

    /**
     * <p>
     * Lists the delegates associated with a resource. Users and groups can be resource delegates and answer requests on
     * behalf of the resource.
     * </p>
     *
     * @param listResourceDelegatesRequest
     * @return Result of the ListResourceDelegates operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListResourceDelegates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResourceDelegates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceDelegatesResponse listResourceDelegates(ListResourceDelegatesRequest listResourceDelegatesRequest)
            throws EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException,
            OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the delegates associated with a resource. Users and groups can be resource delegates and answer requests on
     * behalf of the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceDelegatesRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourceDelegatesRequest#builder()}
     * </p>
     *
     * @param listResourceDelegatesRequest
     *        A {@link Consumer} that will call methods on {@link ListResourceDelegatesRequest.Builder} to create a
     *        request.
     * @return Result of the ListResourceDelegates operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListResourceDelegates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResourceDelegates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceDelegatesResponse listResourceDelegates(
            Consumer<ListResourceDelegatesRequest.Builder> listResourceDelegatesRequest) throws EntityNotFoundException,
            EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        return listResourceDelegates(ListResourceDelegatesRequest.builder().applyMutation(listResourceDelegatesRequest).build());
    }

    /**
     * <p>
     * Lists the delegates associated with a resource. Users and groups can be resource delegates and answer requests on
     * behalf of the resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceDelegates(software.amazon.awssdk.services.workmail.model.ListResourceDelegatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListResourceDelegatesIterable responses = client.listResourceDelegatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListResourceDelegatesIterable responses = client
     *             .listResourceDelegatesPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListResourceDelegatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListResourceDelegatesIterable responses = client.listResourceDelegatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceDelegates(software.amazon.awssdk.services.workmail.model.ListResourceDelegatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceDelegatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListResourceDelegates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResourceDelegates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceDelegatesIterable listResourceDelegatesPaginator(ListResourceDelegatesRequest listResourceDelegatesRequest)
            throws EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException,
            OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the delegates associated with a resource. Users and groups can be resource delegates and answer requests on
     * behalf of the resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceDelegates(software.amazon.awssdk.services.workmail.model.ListResourceDelegatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListResourceDelegatesIterable responses = client.listResourceDelegatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListResourceDelegatesIterable responses = client
     *             .listResourceDelegatesPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListResourceDelegatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListResourceDelegatesIterable responses = client.listResourceDelegatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceDelegates(software.amazon.awssdk.services.workmail.model.ListResourceDelegatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceDelegatesRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourceDelegatesRequest#builder()}
     * </p>
     *
     * @param listResourceDelegatesRequest
     *        A {@link Consumer} that will call methods on {@link ListResourceDelegatesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListResourceDelegates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResourceDelegates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceDelegatesIterable listResourceDelegatesPaginator(
            Consumer<ListResourceDelegatesRequest.Builder> listResourceDelegatesRequest) throws EntityNotFoundException,
            EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        return listResourceDelegatesPaginator(ListResourceDelegatesRequest.builder().applyMutation(listResourceDelegatesRequest)
                .build());
    }

    /**
     * <p>
     * Returns summaries of the organization's resources.
     * </p>
     *
     * @param listResourcesRequest
     * @return Result of the ListResources operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourcesResponse listResources(ListResourcesRequest listResourcesRequest) throws InvalidParameterException,
            OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summaries of the organization's resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourcesRequest.Builder} avoiding the need to
     * create one manually via {@link ListResourcesRequest#builder()}
     * </p>
     *
     * @param listResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListResourcesRequest.Builder} to create a request.
     * @return Result of the ListResources operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourcesResponse listResources(Consumer<ListResourcesRequest.Builder> listResourcesRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        return listResources(ListResourcesRequest.builder().applyMutation(listResourcesRequest).build());
    }

    /**
     * <p>
     * Returns summaries of the organization's resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listResources(software.amazon.awssdk.services.workmail.model.ListResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListResourcesIterable responses = client.listResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListResourcesIterable responses = client.listResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListResourcesIterable responses = client.listResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResources(software.amazon.awssdk.services.workmail.model.ListResourcesRequest)} operation.</b>
     * </p>
     *
     * @param listResourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourcesIterable listResourcesPaginator(ListResourcesRequest listResourcesRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summaries of the organization's resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listResources(software.amazon.awssdk.services.workmail.model.ListResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListResourcesIterable responses = client.listResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListResourcesIterable responses = client.listResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListResourcesIterable responses = client.listResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResources(software.amazon.awssdk.services.workmail.model.ListResourcesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourcesRequest.Builder} avoiding the need to
     * create one manually via {@link ListResourcesRequest#builder()}
     * </p>
     *
     * @param listResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListResourcesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourcesIterable listResourcesPaginator(Consumer<ListResourcesRequest.Builder> listResourcesRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        return listResourcesPaginator(ListResourcesRequest.builder().applyMutation(listResourcesRequest).build());
    }

    /**
     * <p>
     * Lists the tags applied to an Amazon WorkMail organization resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags applied to an Amazon WorkMail organization resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, WorkMailException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Returns summaries of the organization's users.
     * </p>
     *
     * @param listUsersRequest
     * @return Result of the ListUsers operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersResponse listUsers(ListUsersRequest listUsersRequest) throws InvalidParameterException,
            OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summaries of the organization's users.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListUsersRequest#builder()}
     * </p>
     *
     * @param listUsersRequest
     *        A {@link Consumer} that will call methods on {@link ListUsersRequest.Builder} to create a request.
     * @return Result of the ListUsers operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersResponse listUsers(Consumer<ListUsersRequest.Builder> listUsersRequest) throws InvalidParameterException,
            OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        return listUsers(ListUsersRequest.builder().applyMutation(listUsersRequest).build());
    }

    /**
     * <p>
     * Returns summaries of the organization's users.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listUsers(software.amazon.awssdk.services.workmail.model.ListUsersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListUsersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsers(software.amazon.awssdk.services.workmail.model.ListUsersRequest)} operation.</b>
     * </p>
     *
     * @param listUsersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersIterable listUsersPaginator(ListUsersRequest listUsersRequest) throws InvalidParameterException,
            OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns summaries of the organization's users.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listUsers(software.amazon.awssdk.services.workmail.model.ListUsersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workmail.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     *     for (software.amazon.awssdk.services.workmail.model.ListUsersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsers(software.amazon.awssdk.services.workmail.model.ListUsersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUsersRequest.Builder} avoiding the need to
     * create one manually via {@link ListUsersRequest#builder()}
     * </p>
     *
     * @param listUsersRequest
     *        A {@link Consumer} that will call methods on {@link ListUsersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListUsersIterable listUsersPaginator(Consumer<ListUsersRequest.Builder> listUsersRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        return listUsersPaginator(ListUsersRequest.builder().applyMutation(listUsersRequest).build());
    }

    /**
     * <p>
     * Adds a new access control rule for the specified organization. The rule allows or denies access to the
     * organization for the specified IPv4 addresses, access protocol actions, and user IDs. Adding a new rule with the
     * same name as an existing rule replaces the older rule.
     * </p>
     *
     * @param putAccessControlRuleRequest
     * @return Result of the PutAccessControlRule operation returned by the service.
     * @throws LimitExceededException
     *         The request exceeds the limit of the resource.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.PutAccessControlRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutAccessControlRule" target="_top">AWS
     *      API Documentation</a>
     */
    default PutAccessControlRuleResponse putAccessControlRule(PutAccessControlRuleRequest putAccessControlRuleRequest)
            throws LimitExceededException, InvalidParameterException, EntityNotFoundException, OrganizationNotFoundException,
            OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a new access control rule for the specified organization. The rule allows or denies access to the
     * organization for the specified IPv4 addresses, access protocol actions, and user IDs. Adding a new rule with the
     * same name as an existing rule replaces the older rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAccessControlRuleRequest.Builder} avoiding the
     * need to create one manually via {@link PutAccessControlRuleRequest#builder()}
     * </p>
     *
     * @param putAccessControlRuleRequest
     *        A {@link Consumer} that will call methods on {@link PutAccessControlRuleRequest.Builder} to create a
     *        request.
     * @return Result of the PutAccessControlRule operation returned by the service.
     * @throws LimitExceededException
     *         The request exceeds the limit of the resource.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.PutAccessControlRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutAccessControlRule" target="_top">AWS
     *      API Documentation</a>
     */
    default PutAccessControlRuleResponse putAccessControlRule(
            Consumer<PutAccessControlRuleRequest.Builder> putAccessControlRuleRequest) throws LimitExceededException,
            InvalidParameterException, EntityNotFoundException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        return putAccessControlRule(PutAccessControlRuleRequest.builder().applyMutation(putAccessControlRuleRequest).build());
    }

    /**
     * <p>
     * Creates or updates the email monitoring configuration for a specified organization.
     * </p>
     *
     * @param putEmailMonitoringConfigurationRequest
     * @return Result of the PutEmailMonitoringConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.PutEmailMonitoringConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutEmailMonitoringConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutEmailMonitoringConfigurationResponse putEmailMonitoringConfiguration(
            PutEmailMonitoringConfigurationRequest putEmailMonitoringConfigurationRequest) throws ResourceNotFoundException,
            InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates the email monitoring configuration for a specified organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutEmailMonitoringConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link PutEmailMonitoringConfigurationRequest#builder()}
     * </p>
     *
     * @param putEmailMonitoringConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link PutEmailMonitoringConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the PutEmailMonitoringConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.PutEmailMonitoringConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutEmailMonitoringConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutEmailMonitoringConfigurationResponse putEmailMonitoringConfiguration(
            Consumer<PutEmailMonitoringConfigurationRequest.Builder> putEmailMonitoringConfigurationRequest)
            throws ResourceNotFoundException, InvalidParameterException, OrganizationNotFoundException,
            OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        return putEmailMonitoringConfiguration(PutEmailMonitoringConfigurationRequest.builder()
                .applyMutation(putEmailMonitoringConfigurationRequest).build());
    }

    /**
     * <p>
     * Enables or disables a DMARC policy for a given organization.
     * </p>
     *
     * @param putInboundDmarcSettingsRequest
     * @return Result of the PutInboundDmarcSettings operation returned by the service.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.PutInboundDmarcSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutInboundDmarcSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default PutInboundDmarcSettingsResponse putInboundDmarcSettings(PutInboundDmarcSettingsRequest putInboundDmarcSettingsRequest)
            throws OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException,
            WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables or disables a DMARC policy for a given organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutInboundDmarcSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link PutInboundDmarcSettingsRequest#builder()}
     * </p>
     *
     * @param putInboundDmarcSettingsRequest
     *        A {@link Consumer} that will call methods on {@link PutInboundDmarcSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the PutInboundDmarcSettings operation returned by the service.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.PutInboundDmarcSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutInboundDmarcSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default PutInboundDmarcSettingsResponse putInboundDmarcSettings(
            Consumer<PutInboundDmarcSettingsRequest.Builder> putInboundDmarcSettingsRequest)
            throws OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException,
            WorkMailException {
        return putInboundDmarcSettings(PutInboundDmarcSettingsRequest.builder().applyMutation(putInboundDmarcSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Sets permissions for a user, group, or resource. This replaces any pre-existing permissions.
     * </p>
     *
     * @param putMailboxPermissionsRequest
     * @return Result of the PutMailboxPermissions operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.PutMailboxPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutMailboxPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default PutMailboxPermissionsResponse putMailboxPermissions(PutMailboxPermissionsRequest putMailboxPermissionsRequest)
            throws EntityNotFoundException, EntityStateException, InvalidParameterException, OrganizationNotFoundException,
            OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets permissions for a user, group, or resource. This replaces any pre-existing permissions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutMailboxPermissionsRequest.Builder} avoiding the
     * need to create one manually via {@link PutMailboxPermissionsRequest#builder()}
     * </p>
     *
     * @param putMailboxPermissionsRequest
     *        A {@link Consumer} that will call methods on {@link PutMailboxPermissionsRequest.Builder} to create a
     *        request.
     * @return Result of the PutMailboxPermissions operation returned by the service.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.PutMailboxPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutMailboxPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default PutMailboxPermissionsResponse putMailboxPermissions(
            Consumer<PutMailboxPermissionsRequest.Builder> putMailboxPermissionsRequest) throws EntityNotFoundException,
            EntityStateException, InvalidParameterException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        return putMailboxPermissions(PutMailboxPermissionsRequest.builder().applyMutation(putMailboxPermissionsRequest).build());
    }

    /**
     * <p>
     * Creates or updates a mobile device access override for the given WorkMail organization, user, and device.
     * </p>
     *
     * @param putMobileDeviceAccessOverrideRequest
     * @return Result of the PutMobileDeviceAccessOverride operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.PutMobileDeviceAccessOverride
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutMobileDeviceAccessOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default PutMobileDeviceAccessOverrideResponse putMobileDeviceAccessOverride(
            PutMobileDeviceAccessOverrideRequest putMobileDeviceAccessOverrideRequest) throws InvalidParameterException,
            OrganizationNotFoundException, OrganizationStateException, EntityNotFoundException, EntityStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a mobile device access override for the given WorkMail organization, user, and device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutMobileDeviceAccessOverrideRequest.Builder}
     * avoiding the need to create one manually via {@link PutMobileDeviceAccessOverrideRequest#builder()}
     * </p>
     *
     * @param putMobileDeviceAccessOverrideRequest
     *        A {@link Consumer} that will call methods on {@link PutMobileDeviceAccessOverrideRequest.Builder} to
     *        create a request.
     * @return Result of the PutMobileDeviceAccessOverride operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.PutMobileDeviceAccessOverride
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutMobileDeviceAccessOverride"
     *      target="_top">AWS API Documentation</a>
     */
    default PutMobileDeviceAccessOverrideResponse putMobileDeviceAccessOverride(
            Consumer<PutMobileDeviceAccessOverrideRequest.Builder> putMobileDeviceAccessOverrideRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, EntityNotFoundException,
            EntityStateException, AwsServiceException, SdkClientException, WorkMailException {
        return putMobileDeviceAccessOverride(PutMobileDeviceAccessOverrideRequest.builder()
                .applyMutation(putMobileDeviceAccessOverrideRequest).build());
    }

    /**
     * <p>
     * Puts a retention policy to the specified organization.
     * </p>
     *
     * @param putRetentionPolicyRequest
     * @return Result of the PutRetentionPolicy operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws LimitExceededException
     *         The request exceeds the limit of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.PutRetentionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutRetentionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default PutRetentionPolicyResponse putRetentionPolicy(PutRetentionPolicyRequest putRetentionPolicyRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, LimitExceededException,
            AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Puts a retention policy to the specified organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRetentionPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link PutRetentionPolicyRequest#builder()}
     * </p>
     *
     * @param putRetentionPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutRetentionPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the PutRetentionPolicy operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws LimitExceededException
     *         The request exceeds the limit of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.PutRetentionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutRetentionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default PutRetentionPolicyResponse putRetentionPolicy(Consumer<PutRetentionPolicyRequest.Builder> putRetentionPolicyRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, LimitExceededException,
            AwsServiceException, SdkClientException, WorkMailException {
        return putRetentionPolicy(PutRetentionPolicyRequest.builder().applyMutation(putRetentionPolicyRequest).build());
    }

    /**
     * <p>
     * Registers a new domain in Amazon WorkMail and SES, and configures it for use by WorkMail. Emails received by SES
     * for this domain are routed to the specified WorkMail organization, and WorkMail has permanent permission to use
     * the specified domain for sending your users' emails.
     * </p>
     *
     * @param registerMailDomainRequest
     * @return Result of the RegisterMailDomain operation returned by the service.
     * @throws MailDomainInUseException
     *         The domain you're trying to change is in use by another user or organization in your account. See the
     *         error message for details.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws LimitExceededException
     *         The request exceeds the limit of the resource.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.RegisterMailDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/RegisterMailDomain" target="_top">AWS
     *      API Documentation</a>
     */
    default RegisterMailDomainResponse registerMailDomain(RegisterMailDomainRequest registerMailDomainRequest)
            throws MailDomainInUseException, OrganizationNotFoundException, OrganizationStateException, LimitExceededException,
            InvalidParameterException, AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers a new domain in Amazon WorkMail and SES, and configures it for use by WorkMail. Emails received by SES
     * for this domain are routed to the specified WorkMail organization, and WorkMail has permanent permission to use
     * the specified domain for sending your users' emails.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterMailDomainRequest.Builder} avoiding the
     * need to create one manually via {@link RegisterMailDomainRequest#builder()}
     * </p>
     *
     * @param registerMailDomainRequest
     *        A {@link Consumer} that will call methods on {@link RegisterMailDomainRequest.Builder} to create a
     *        request.
     * @return Result of the RegisterMailDomain operation returned by the service.
     * @throws MailDomainInUseException
     *         The domain you're trying to change is in use by another user or organization in your account. See the
     *         error message for details.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws LimitExceededException
     *         The request exceeds the limit of the resource.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.RegisterMailDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/RegisterMailDomain" target="_top">AWS
     *      API Documentation</a>
     */
    default RegisterMailDomainResponse registerMailDomain(Consumer<RegisterMailDomainRequest.Builder> registerMailDomainRequest)
            throws MailDomainInUseException, OrganizationNotFoundException, OrganizationStateException, LimitExceededException,
            InvalidParameterException, AwsServiceException, SdkClientException, WorkMailException {
        return registerMailDomain(RegisterMailDomainRequest.builder().applyMutation(registerMailDomainRequest).build());
    }

    /**
     * <p>
     * Registers an existing and disabled user, group, or resource for Amazon WorkMail use by associating a mailbox and
     * calendaring capabilities. It performs no change if the user, group, or resource is enabled and fails if the user,
     * group, or resource is deleted. This operation results in the accumulation of costs. For more information, see <a
     * href="https://aws.amazon.com/workmail/pricing">Pricing</a>. The equivalent console functionality for this
     * operation is <i>Enable</i>.
     * </p>
     * <p>
     * Users can either be created by calling the <a>CreateUser</a> API operation or they can be synchronized from your
     * directory. For more information, see <a>DeregisterFromWorkMail</a>.
     * </p>
     *
     * @param registerToWorkMailRequest
     * @return Result of the RegisterToWorkMail operation returned by the service.
     * @throws DirectoryServiceAuthenticationFailedException
     *         The directory service doesn't recognize the credentials supplied by WorkMail.
     * @throws DirectoryUnavailableException
     *         The directory is unavailable. It might be located in another Region or deleted.
     * @throws EmailAddressInUseException
     *         The email address that you're trying to assign is already created for a different user, group, or
     *         resource.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws EntityAlreadyRegisteredException
     *         The user, group, or resource that you're trying to register is already registered.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws MailDomainNotFoundException
     *         The domain specified is not found in your organization.
     * @throws MailDomainStateException
     *         After a domain has been added to the organization, it must be verified. The domain is not yet verified.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.RegisterToWorkMail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/RegisterToWorkMail" target="_top">AWS
     *      API Documentation</a>
     */
    default RegisterToWorkMailResponse registerToWorkMail(RegisterToWorkMailRequest registerToWorkMailRequest)
            throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, EmailAddressInUseException,
            EntityNotFoundException, EntityStateException, EntityAlreadyRegisteredException, InvalidParameterException,
            MailDomainNotFoundException, MailDomainStateException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers an existing and disabled user, group, or resource for Amazon WorkMail use by associating a mailbox and
     * calendaring capabilities. It performs no change if the user, group, or resource is enabled and fails if the user,
     * group, or resource is deleted. This operation results in the accumulation of costs. For more information, see <a
     * href="https://aws.amazon.com/workmail/pricing">Pricing</a>. The equivalent console functionality for this
     * operation is <i>Enable</i>.
     * </p>
     * <p>
     * Users can either be created by calling the <a>CreateUser</a> API operation or they can be synchronized from your
     * directory. For more information, see <a>DeregisterFromWorkMail</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterToWorkMailRequest.Builder} avoiding the
     * need to create one manually via {@link RegisterToWorkMailRequest#builder()}
     * </p>
     *
     * @param registerToWorkMailRequest
     *        A {@link Consumer} that will call methods on {@link RegisterToWorkMailRequest.Builder} to create a
     *        request.
     * @return Result of the RegisterToWorkMail operation returned by the service.
     * @throws DirectoryServiceAuthenticationFailedException
     *         The directory service doesn't recognize the credentials supplied by WorkMail.
     * @throws DirectoryUnavailableException
     *         The directory is unavailable. It might be located in another Region or deleted.
     * @throws EmailAddressInUseException
     *         The email address that you're trying to assign is already created for a different user, group, or
     *         resource.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws EntityAlreadyRegisteredException
     *         The user, group, or resource that you're trying to register is already registered.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws MailDomainNotFoundException
     *         The domain specified is not found in your organization.
     * @throws MailDomainStateException
     *         After a domain has been added to the organization, it must be verified. The domain is not yet verified.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.RegisterToWorkMail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/RegisterToWorkMail" target="_top">AWS
     *      API Documentation</a>
     */
    default RegisterToWorkMailResponse registerToWorkMail(Consumer<RegisterToWorkMailRequest.Builder> registerToWorkMailRequest)
            throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, EmailAddressInUseException,
            EntityNotFoundException, EntityStateException, EntityAlreadyRegisteredException, InvalidParameterException,
            MailDomainNotFoundException, MailDomainStateException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        return registerToWorkMail(RegisterToWorkMailRequest.builder().applyMutation(registerToWorkMailRequest).build());
    }

    /**
     * <p>
     * Allows the administrator to reset the password for a user.
     * </p>
     *
     * @param resetPasswordRequest
     * @return Result of the ResetPassword operation returned by the service.
     * @throws DirectoryServiceAuthenticationFailedException
     *         The directory service doesn't recognize the credentials supplied by WorkMail.
     * @throws DirectoryUnavailableException
     *         The directory is unavailable. It might be located in another Region or deleted.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws InvalidPasswordException
     *         The supplied password doesn't match the minimum security constraints, such as length or use of special
     *         characters.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws UnsupportedOperationException
     *         You can't perform a write operation against a read-only directory.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ResetPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ResetPassword" target="_top">AWS API
     *      Documentation</a>
     */
    default ResetPasswordResponse resetPassword(ResetPasswordRequest resetPasswordRequest)
            throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, EntityNotFoundException,
            EntityStateException, InvalidParameterException, InvalidPasswordException, OrganizationNotFoundException,
            OrganizationStateException, software.amazon.awssdk.services.workmail.model.UnsupportedOperationException,
            AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows the administrator to reset the password for a user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetPasswordRequest.Builder} avoiding the need to
     * create one manually via {@link ResetPasswordRequest#builder()}
     * </p>
     *
     * @param resetPasswordRequest
     *        A {@link Consumer} that will call methods on {@link ResetPasswordRequest.Builder} to create a request.
     * @return Result of the ResetPassword operation returned by the service.
     * @throws DirectoryServiceAuthenticationFailedException
     *         The directory service doesn't recognize the credentials supplied by WorkMail.
     * @throws DirectoryUnavailableException
     *         The directory is unavailable. It might be located in another Region or deleted.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws InvalidPasswordException
     *         The supplied password doesn't match the minimum security constraints, such as length or use of special
     *         characters.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws UnsupportedOperationException
     *         You can't perform a write operation against a read-only directory.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.ResetPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ResetPassword" target="_top">AWS API
     *      Documentation</a>
     */
    default ResetPasswordResponse resetPassword(Consumer<ResetPasswordRequest.Builder> resetPasswordRequest)
            throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, EntityNotFoundException,
            EntityStateException, InvalidParameterException, InvalidPasswordException, OrganizationNotFoundException,
            OrganizationStateException, software.amazon.awssdk.services.workmail.model.UnsupportedOperationException,
            AwsServiceException, SdkClientException, WorkMailException {
        return resetPassword(ResetPasswordRequest.builder().applyMutation(resetPasswordRequest).build());
    }

    /**
     * <p>
     * Starts a mailbox export job to export MIME-format email messages and calendar items from the specified mailbox to
     * the specified Amazon Simple Storage Service (Amazon S3) bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/workmail/latest/adminguide/mail-export.html">Exporting mailbox content</a> in
     * the <i>Amazon WorkMail Administrator Guide</i>.
     * </p>
     *
     * @param startMailboxExportJobRequest
     * @return Result of the StartMailboxExportJob operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws LimitExceededException
     *         The request exceeds the limit of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.StartMailboxExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/StartMailboxExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartMailboxExportJobResponse startMailboxExportJob(StartMailboxExportJobRequest startMailboxExportJobRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, EntityNotFoundException,
            LimitExceededException, AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a mailbox export job to export MIME-format email messages and calendar items from the specified mailbox to
     * the specified Amazon Simple Storage Service (Amazon S3) bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/workmail/latest/adminguide/mail-export.html">Exporting mailbox content</a> in
     * the <i>Amazon WorkMail Administrator Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMailboxExportJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartMailboxExportJobRequest#builder()}
     * </p>
     *
     * @param startMailboxExportJobRequest
     *        A {@link Consumer} that will call methods on {@link StartMailboxExportJobRequest.Builder} to create a
     *        request.
     * @return Result of the StartMailboxExportJob operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws LimitExceededException
     *         The request exceeds the limit of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.StartMailboxExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/StartMailboxExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartMailboxExportJobResponse startMailboxExportJob(
            Consumer<StartMailboxExportJobRequest.Builder> startMailboxExportJobRequest) throws InvalidParameterException,
            OrganizationNotFoundException, OrganizationStateException, EntityNotFoundException, LimitExceededException,
            AwsServiceException, SdkClientException, WorkMailException {
        return startMailboxExportJob(StartMailboxExportJobRequest.builder().applyMutation(startMailboxExportJobRequest).build());
    }

    /**
     * <p>
     * Applies the specified tags to the specified Amazon WorkMail organization resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws TooManyTagsException
     *         The resource can have up to 50 user-applied tags.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            TooManyTagsException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies the specified tags to the specified Amazon WorkMail organization resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws TooManyTagsException
     *         The resource can have up to 50 user-applied tags.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, TooManyTagsException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Performs a test on an availability provider to ensure that access is allowed. For EWS, it verifies the provided
     * credentials can be used to successfully log in. For Lambda, it verifies that the Lambda function can be invoked
     * and that the resource access policy was configured to deny anonymous access. An anonymous invocation is one done
     * without providing either a <code>SourceArn</code> or <code>SourceAccount</code> header.
     * </p>
     * <note>
     * <p>
     * The request must contain either one provider definition (<code>EwsProvider</code> or <code>LambdaProvider</code>)
     * or the <code>DomainName</code> parameter. If the <code>DomainName</code> parameter is provided, the configuration
     * stored under the <code>DomainName</code> will be tested.
     * </p>
     * </note>
     *
     * @param testAvailabilityConfigurationRequest
     * @return Result of the TestAvailabilityConfiguration operation returned by the service.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.TestAvailabilityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/TestAvailabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default TestAvailabilityConfigurationResponse testAvailabilityConfiguration(
            TestAvailabilityConfigurationRequest testAvailabilityConfigurationRequest) throws OrganizationNotFoundException,
            OrganizationStateException, ResourceNotFoundException, InvalidParameterException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Performs a test on an availability provider to ensure that access is allowed. For EWS, it verifies the provided
     * credentials can be used to successfully log in. For Lambda, it verifies that the Lambda function can be invoked
     * and that the resource access policy was configured to deny anonymous access. An anonymous invocation is one done
     * without providing either a <code>SourceArn</code> or <code>SourceAccount</code> header.
     * </p>
     * <note>
     * <p>
     * The request must contain either one provider definition (<code>EwsProvider</code> or <code>LambdaProvider</code>)
     * or the <code>DomainName</code> parameter. If the <code>DomainName</code> parameter is provided, the configuration
     * stored under the <code>DomainName</code> will be tested.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestAvailabilityConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link TestAvailabilityConfigurationRequest#builder()}
     * </p>
     *
     * @param testAvailabilityConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link TestAvailabilityConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the TestAvailabilityConfiguration operation returned by the service.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.TestAvailabilityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/TestAvailabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default TestAvailabilityConfigurationResponse testAvailabilityConfiguration(
            Consumer<TestAvailabilityConfigurationRequest.Builder> testAvailabilityConfigurationRequest)
            throws OrganizationNotFoundException, OrganizationStateException, ResourceNotFoundException,
            InvalidParameterException, AwsServiceException, SdkClientException, WorkMailException {
        return testAvailabilityConfiguration(TestAvailabilityConfigurationRequest.builder()
                .applyMutation(testAvailabilityConfigurationRequest).build());
    }

    /**
     * <p>
     * Untags the specified tags from the specified Amazon WorkMail organization resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Untags the specified tags from the specified Amazon WorkMail organization resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, WorkMailException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing <code>AvailabilityConfiguration</code> for the given WorkMail organization and domain.
     * </p>
     *
     * @param updateAvailabilityConfigurationRequest
     * @return Result of the UpdateAvailabilityConfiguration operation returned by the service.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.UpdateAvailabilityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateAvailabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAvailabilityConfigurationResponse updateAvailabilityConfiguration(
            UpdateAvailabilityConfigurationRequest updateAvailabilityConfigurationRequest) throws OrganizationNotFoundException,
            OrganizationStateException, ResourceNotFoundException, InvalidParameterException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing <code>AvailabilityConfiguration</code> for the given WorkMail organization and domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAvailabilityConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateAvailabilityConfigurationRequest#builder()}
     * </p>
     *
     * @param updateAvailabilityConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAvailabilityConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateAvailabilityConfiguration operation returned by the service.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.UpdateAvailabilityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateAvailabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAvailabilityConfigurationResponse updateAvailabilityConfiguration(
            Consumer<UpdateAvailabilityConfigurationRequest.Builder> updateAvailabilityConfigurationRequest)
            throws OrganizationNotFoundException, OrganizationStateException, ResourceNotFoundException,
            InvalidParameterException, AwsServiceException, SdkClientException, WorkMailException {
        return updateAvailabilityConfiguration(UpdateAvailabilityConfigurationRequest.builder()
                .applyMutation(updateAvailabilityConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates the default mail domain for an organization. The default mail domain is used by the WorkMail AWS Console
     * to suggest an email address when enabling a mail user. You can only have one default domain.
     * </p>
     *
     * @param updateDefaultMailDomainRequest
     * @return Result of the UpdateDefaultMailDomain operation returned by the service.
     * @throws MailDomainNotFoundException
     *         The domain specified is not found in your organization.
     * @throws MailDomainStateException
     *         After a domain has been added to the organization, it must be verified. The domain is not yet verified.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.UpdateDefaultMailDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateDefaultMailDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDefaultMailDomainResponse updateDefaultMailDomain(UpdateDefaultMailDomainRequest updateDefaultMailDomainRequest)
            throws MailDomainNotFoundException, MailDomainStateException, OrganizationNotFoundException,
            OrganizationStateException, InvalidParameterException, AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the default mail domain for an organization. The default mail domain is used by the WorkMail AWS Console
     * to suggest an email address when enabling a mail user. You can only have one default domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDefaultMailDomainRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateDefaultMailDomainRequest#builder()}
     * </p>
     *
     * @param updateDefaultMailDomainRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDefaultMailDomainRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateDefaultMailDomain operation returned by the service.
     * @throws MailDomainNotFoundException
     *         The domain specified is not found in your organization.
     * @throws MailDomainStateException
     *         After a domain has been added to the organization, it must be verified. The domain is not yet verified.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.UpdateDefaultMailDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateDefaultMailDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDefaultMailDomainResponse updateDefaultMailDomain(
            Consumer<UpdateDefaultMailDomainRequest.Builder> updateDefaultMailDomainRequest) throws MailDomainNotFoundException,
            MailDomainStateException, OrganizationNotFoundException, OrganizationStateException, InvalidParameterException,
            AwsServiceException, SdkClientException, WorkMailException {
        return updateDefaultMailDomain(UpdateDefaultMailDomainRequest.builder().applyMutation(updateDefaultMailDomainRequest)
                .build());
    }

    /**
     * <p>
     * Updates a user's current mailbox quota for a specified organization and user.
     * </p>
     *
     * @param updateMailboxQuotaRequest
     * @return Result of the UpdateMailboxQuota operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.UpdateMailboxQuota
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateMailboxQuota" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateMailboxQuotaResponse updateMailboxQuota(UpdateMailboxQuotaRequest updateMailboxQuotaRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, EntityNotFoundException,
            EntityStateException, AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a user's current mailbox quota for a specified organization and user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMailboxQuotaRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateMailboxQuotaRequest#builder()}
     * </p>
     *
     * @param updateMailboxQuotaRequest
     *        A {@link Consumer} that will call methods on {@link UpdateMailboxQuotaRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateMailboxQuota operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.UpdateMailboxQuota
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateMailboxQuota" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateMailboxQuotaResponse updateMailboxQuota(Consumer<UpdateMailboxQuotaRequest.Builder> updateMailboxQuotaRequest)
            throws InvalidParameterException, OrganizationNotFoundException, OrganizationStateException, EntityNotFoundException,
            EntityStateException, AwsServiceException, SdkClientException, WorkMailException {
        return updateMailboxQuota(UpdateMailboxQuotaRequest.builder().applyMutation(updateMailboxQuotaRequest).build());
    }

    /**
     * <p>
     * Updates a mobile device access rule for the specified Amazon WorkMail organization.
     * </p>
     *
     * @param updateMobileDeviceAccessRuleRequest
     * @return Result of the UpdateMobileDeviceAccessRule operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.UpdateMobileDeviceAccessRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateMobileDeviceAccessRule"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateMobileDeviceAccessRuleResponse updateMobileDeviceAccessRule(
            UpdateMobileDeviceAccessRuleRequest updateMobileDeviceAccessRuleRequest) throws InvalidParameterException,
            EntityNotFoundException, OrganizationNotFoundException, OrganizationStateException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a mobile device access rule for the specified Amazon WorkMail organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMobileDeviceAccessRuleRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateMobileDeviceAccessRuleRequest#builder()}
     * </p>
     *
     * @param updateMobileDeviceAccessRuleRequest
     *        A {@link Consumer} that will call methods on {@link UpdateMobileDeviceAccessRuleRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateMobileDeviceAccessRule operation returned by the service.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.UpdateMobileDeviceAccessRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateMobileDeviceAccessRule"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateMobileDeviceAccessRuleResponse updateMobileDeviceAccessRule(
            Consumer<UpdateMobileDeviceAccessRuleRequest.Builder> updateMobileDeviceAccessRuleRequest)
            throws InvalidParameterException, EntityNotFoundException, OrganizationNotFoundException, OrganizationStateException,
            AwsServiceException, SdkClientException, WorkMailException {
        return updateMobileDeviceAccessRule(UpdateMobileDeviceAccessRuleRequest.builder()
                .applyMutation(updateMobileDeviceAccessRuleRequest).build());
    }

    /**
     * <p>
     * Updates the primary email for a user, group, or resource. The current email is moved into the list of aliases (or
     * swapped between an existing alias and the current primary email), and the email provided in the input is promoted
     * as the primary.
     * </p>
     *
     * @param updatePrimaryEmailAddressRequest
     * @return Result of the UpdatePrimaryEmailAddress operation returned by the service.
     * @throws DirectoryServiceAuthenticationFailedException
     *         The directory service doesn't recognize the credentials supplied by WorkMail.
     * @throws DirectoryUnavailableException
     *         The directory is unavailable. It might be located in another Region or deleted.
     * @throws EmailAddressInUseException
     *         The email address that you're trying to assign is already created for a different user, group, or
     *         resource.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws MailDomainNotFoundException
     *         The domain specified is not found in your organization.
     * @throws MailDomainStateException
     *         After a domain has been added to the organization, it must be verified. The domain is not yet verified.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws UnsupportedOperationException
     *         You can't perform a write operation against a read-only directory.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.UpdatePrimaryEmailAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdatePrimaryEmailAddress"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdatePrimaryEmailAddressResponse updatePrimaryEmailAddress(
            UpdatePrimaryEmailAddressRequest updatePrimaryEmailAddressRequest)
            throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, EmailAddressInUseException,
            EntityNotFoundException, EntityStateException, InvalidParameterException, MailDomainNotFoundException,
            MailDomainStateException, OrganizationNotFoundException, OrganizationStateException,
            software.amazon.awssdk.services.workmail.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the primary email for a user, group, or resource. The current email is moved into the list of aliases (or
     * swapped between an existing alias and the current primary email), and the email provided in the input is promoted
     * as the primary.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePrimaryEmailAddressRequest.Builder} avoiding
     * the need to create one manually via {@link UpdatePrimaryEmailAddressRequest#builder()}
     * </p>
     *
     * @param updatePrimaryEmailAddressRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePrimaryEmailAddressRequest.Builder} to create a
     *        request.
     * @return Result of the UpdatePrimaryEmailAddress operation returned by the service.
     * @throws DirectoryServiceAuthenticationFailedException
     *         The directory service doesn't recognize the credentials supplied by WorkMail.
     * @throws DirectoryUnavailableException
     *         The directory is unavailable. It might be located in another Region or deleted.
     * @throws EmailAddressInUseException
     *         The email address that you're trying to assign is already created for a different user, group, or
     *         resource.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws MailDomainNotFoundException
     *         The domain specified is not found in your organization.
     * @throws MailDomainStateException
     *         After a domain has been added to the organization, it must be verified. The domain is not yet verified.
     * @throws InvalidParameterException
     *         One or more of the input parameters don't match the service's restrictions.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws UnsupportedOperationException
     *         You can't perform a write operation against a read-only directory.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.UpdatePrimaryEmailAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdatePrimaryEmailAddress"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdatePrimaryEmailAddressResponse updatePrimaryEmailAddress(
            Consumer<UpdatePrimaryEmailAddressRequest.Builder> updatePrimaryEmailAddressRequest)
            throws DirectoryServiceAuthenticationFailedException, DirectoryUnavailableException, EmailAddressInUseException,
            EntityNotFoundException, EntityStateException, InvalidParameterException, MailDomainNotFoundException,
            MailDomainStateException, OrganizationNotFoundException, OrganizationStateException,
            software.amazon.awssdk.services.workmail.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, WorkMailException {
        return updatePrimaryEmailAddress(UpdatePrimaryEmailAddressRequest.builder()
                .applyMutation(updatePrimaryEmailAddressRequest).build());
    }

    /**
     * <p>
     * Updates data for the resource. To have the latest information, it must be preceded by a <a>DescribeResource</a>
     * call. The dataset in the request should be the one expected when performing another <code>DescribeResource</code>
     * call.
     * </p>
     *
     * @param updateResourceRequest
     * @return Result of the UpdateResource operation returned by the service.
     * @throws DirectoryUnavailableException
     *         The directory is unavailable. It might be located in another Region or deleted.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidConfigurationException
     *         The configuration for a resource isn't valid. A resource must either be able to auto-respond to requests
     *         or have at least one delegate associated that can do so on its behalf.
     * @throws EmailAddressInUseException
     *         The email address that you're trying to assign is already created for a different user, group, or
     *         resource.
     * @throws MailDomainNotFoundException
     *         The domain specified is not found in your organization.
     * @throws MailDomainStateException
     *         After a domain has been added to the organization, it must be verified. The domain is not yet verified.
     * @throws NameAvailabilityException
     *         The user, group, or resource name isn't unique in Amazon WorkMail.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.UpdateResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateResourceResponse updateResource(UpdateResourceRequest updateResourceRequest)
            throws DirectoryUnavailableException, EntityNotFoundException, EntityStateException, InvalidConfigurationException,
            EmailAddressInUseException, MailDomainNotFoundException, MailDomainStateException, NameAvailabilityException,
            OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates data for the resource. To have the latest information, it must be preceded by a <a>DescribeResource</a>
     * call. The dataset in the request should be the one expected when performing another <code>DescribeResource</code>
     * call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateResourceRequest#builder()}
     * </p>
     *
     * @param updateResourceRequest
     *        A {@link Consumer} that will call methods on {@link UpdateResourceRequest.Builder} to create a request.
     * @return Result of the UpdateResource operation returned by the service.
     * @throws DirectoryUnavailableException
     *         The directory is unavailable. It might be located in another Region or deleted.
     * @throws EntityNotFoundException
     *         The identifier supplied for the user, group, or resource does not exist in your organization.
     * @throws EntityStateException
     *         You are performing an operation on a user, group, or resource that isn't in the expected state, such as
     *         trying to delete an active user.
     * @throws InvalidConfigurationException
     *         The configuration for a resource isn't valid. A resource must either be able to auto-respond to requests
     *         or have at least one delegate associated that can do so on its behalf.
     * @throws EmailAddressInUseException
     *         The email address that you're trying to assign is already created for a different user, group, or
     *         resource.
     * @throws MailDomainNotFoundException
     *         The domain specified is not found in your organization.
     * @throws MailDomainStateException
     *         After a domain has been added to the organization, it must be verified. The domain is not yet verified.
     * @throws NameAvailabilityException
     *         The user, group, or resource name isn't unique in Amazon WorkMail.
     * @throws OrganizationNotFoundException
     *         An operation received a valid organization identifier that either doesn't belong or exist in the system.
     * @throws OrganizationStateException
     *         The organization must have a valid state to perform certain operations on the organization or its
     *         members.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkMailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkMailClient.UpdateResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateResourceResponse updateResource(Consumer<UpdateResourceRequest.Builder> updateResourceRequest)
            throws DirectoryUnavailableException, EntityNotFoundException, EntityStateException, InvalidConfigurationException,
            EmailAddressInUseException, MailDomainNotFoundException, MailDomainStateException, NameAvailabilityException,
            OrganizationNotFoundException, OrganizationStateException, AwsServiceException, SdkClientException, WorkMailException {
        return updateResource(UpdateResourceRequest.builder().applyMutation(updateResourceRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }
}
