/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMobileDeviceAccessRulesResponse extends WorkMailResponse implements
        ToCopyableBuilder<ListMobileDeviceAccessRulesResponse.Builder, ListMobileDeviceAccessRulesResponse> {
    private static final SdkField<List<MobileDeviceAccessRule>> RULES_FIELD = SdkField
            .<List<MobileDeviceAccessRule>> builder(MarshallingType.LIST)
            .memberName("Rules")
            .getter(getter(ListMobileDeviceAccessRulesResponse::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MobileDeviceAccessRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(MobileDeviceAccessRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULES_FIELD));

    private final List<MobileDeviceAccessRule> rules;

    private ListMobileDeviceAccessRulesResponse(BuilderImpl builder) {
        super(builder);
        this.rules = builder.rules;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of mobile device access rules that exist under the specified Amazon WorkMail organization.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return The list of mobile device access rules that exist under the specified Amazon WorkMail organization.
     */
    public final List<MobileDeviceAccessRule> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMobileDeviceAccessRulesResponse)) {
            return false;
        }
        ListMobileDeviceAccessRulesResponse other = (ListMobileDeviceAccessRulesResponse) obj;
        return hasRules() == other.hasRules() && Objects.equals(rules(), other.rules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMobileDeviceAccessRulesResponse").add("Rules", hasRules() ? rules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMobileDeviceAccessRulesResponse, T> g) {
        return obj -> g.apply((ListMobileDeviceAccessRulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListMobileDeviceAccessRulesResponse> {
        /**
         * <p>
         * The list of mobile device access rules that exist under the specified Amazon WorkMail organization.
         * </p>
         * 
         * @param rules
         *        The list of mobile device access rules that exist under the specified Amazon WorkMail organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<MobileDeviceAccessRule> rules);

        /**
         * <p>
         * The list of mobile device access rules that exist under the specified Amazon WorkMail organization.
         * </p>
         * 
         * @param rules
         *        The list of mobile device access rules that exist under the specified Amazon WorkMail organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(MobileDeviceAccessRule... rules);

        /**
         * <p>
         * The list of mobile device access rules that exist under the specified Amazon WorkMail organization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workmail.model.MobileDeviceAccessRule.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.workmail.model.MobileDeviceAccessRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workmail.model.MobileDeviceAccessRule.Builder#build()} is called
         * immediately and its result is passed to {@link #rules(List<MobileDeviceAccessRule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workmail.model.MobileDeviceAccessRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(java.util.Collection<MobileDeviceAccessRule>)
         */
        Builder rules(Consumer<MobileDeviceAccessRule.Builder>... rules);
    }

    static final class BuilderImpl extends WorkMailResponse.BuilderImpl implements Builder {
        private List<MobileDeviceAccessRule> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMobileDeviceAccessRulesResponse model) {
            super(model);
            rules(model.rules);
        }

        public final List<MobileDeviceAccessRule.Builder> getRules() {
            List<MobileDeviceAccessRule.Builder> result = MobileDeviceAccessRulesListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<MobileDeviceAccessRule.BuilderImpl> rules) {
            this.rules = MobileDeviceAccessRulesListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<MobileDeviceAccessRule> rules) {
            this.rules = MobileDeviceAccessRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(MobileDeviceAccessRule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<MobileDeviceAccessRule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> MobileDeviceAccessRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListMobileDeviceAccessRulesResponse build() {
            return new ListMobileDeviceAccessRulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
