/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateOrganizationRequest extends WorkMailRequest implements
        ToCopyableBuilder<CreateOrganizationRequest.Builder, CreateOrganizationRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(CreateOrganizationRequest::directoryId))
            .setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Alias")
            .getter(getter(CreateOrganizationRequest::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateOrganizationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Domain>> DOMAINS_FIELD = SdkField
            .<List<Domain>> builder(MarshallingType.LIST)
            .memberName("Domains")
            .getter(getter(CreateOrganizationRequest::domains))
            .setter(setter(Builder::domains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Domain> builder(MarshallingType.SDK_POJO)
                                            .constructor(Domain::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn").getter(getter(CreateOrganizationRequest::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()).build();

    private static final SdkField<Boolean> ENABLE_INTEROPERABILITY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableInteroperability").getter(getter(CreateOrganizationRequest::enableInteroperability))
            .setter(setter(Builder::enableInteroperability))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableInteroperability").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            ALIAS_FIELD, CLIENT_TOKEN_FIELD, DOMAINS_FIELD, KMS_KEY_ARN_FIELD, ENABLE_INTEROPERABILITY_FIELD));

    private final String directoryId;

    private final String alias;

    private final String clientToken;

    private final List<Domain> domains;

    private final String kmsKeyArn;

    private final Boolean enableInteroperability;

    private CreateOrganizationRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.alias = builder.alias;
        this.clientToken = builder.clientToken;
        this.domains = builder.domains;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.enableInteroperability = builder.enableInteroperability;
    }

    /**
     * <p>
     * The AWS Directory Service directory ID.
     * </p>
     * 
     * @return The AWS Directory Service directory ID.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The organization alias.
     * </p>
     * 
     * @return The organization alias.
     */
    public final String alias() {
        return alias;
    }

    /**
     * <p>
     * The idempotency token associated with the request.
     * </p>
     * 
     * @return The idempotency token associated with the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Domains property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDomains() {
        return domains != null && !(domains instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The email domains to associate with the organization.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomains} method.
     * </p>
     * 
     * @return The email domains to associate with the organization.
     */
    public final List<Domain> domains() {
        return domains;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a customer managed master key from AWS KMS.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a customer managed master key from AWS KMS.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * When <code>true</code>, allows organization interoperability between Amazon WorkMail and Microsoft Exchange. Can
     * only be set to <code>true</code> if an AD Connector directory ID is included in the request.
     * </p>
     * 
     * @return When <code>true</code>, allows organization interoperability between Amazon WorkMail and Microsoft
     *         Exchange. Can only be set to <code>true</code> if an AD Connector directory ID is included in the
     *         request.
     */
    public final Boolean enableInteroperability() {
        return enableInteroperability;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasDomains() ? domains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(enableInteroperability());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOrganizationRequest)) {
            return false;
        }
        CreateOrganizationRequest other = (CreateOrganizationRequest) obj;
        return Objects.equals(directoryId(), other.directoryId()) && Objects.equals(alias(), other.alias())
                && Objects.equals(clientToken(), other.clientToken()) && hasDomains() == other.hasDomains()
                && Objects.equals(domains(), other.domains()) && Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && Objects.equals(enableInteroperability(), other.enableInteroperability());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateOrganizationRequest").add("DirectoryId", directoryId()).add("Alias", alias())
                .add("ClientToken", clientToken()).add("Domains", hasDomains() ? domains() : null).add("KmsKeyArn", kmsKeyArn())
                .add("EnableInteroperability", enableInteroperability()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "Alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Domains":
            return Optional.ofNullable(clazz.cast(domains()));
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "EnableInteroperability":
            return Optional.ofNullable(clazz.cast(enableInteroperability()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateOrganizationRequest, T> g) {
        return obj -> g.apply((CreateOrganizationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateOrganizationRequest> {
        /**
         * <p>
         * The AWS Directory Service directory ID.
         * </p>
         * 
         * @param directoryId
         *        The AWS Directory Service directory ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The organization alias.
         * </p>
         * 
         * @param alias
         *        The organization alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * The idempotency token associated with the request.
         * </p>
         * 
         * @param clientToken
         *        The idempotency token associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The email domains to associate with the organization.
         * </p>
         * 
         * @param domains
         *        The email domains to associate with the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domains(Collection<Domain> domains);

        /**
         * <p>
         * The email domains to associate with the organization.
         * </p>
         * 
         * @param domains
         *        The email domains to associate with the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domains(Domain... domains);

        /**
         * <p>
         * The email domains to associate with the organization.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Domain>.Builder} avoiding the need to
         * create one manually via {@link List<Domain>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Domain>.Builder#build()} is called immediately and its
         * result is passed to {@link #domains(List<Domain>)}.
         * 
         * @param domains
         *        a consumer that will call methods on {@link List<Domain>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domains(List<Domain>)
         */
        Builder domains(Consumer<Domain.Builder>... domains);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a customer managed master key from AWS KMS.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of a customer managed master key from AWS KMS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * When <code>true</code>, allows organization interoperability between Amazon WorkMail and Microsoft Exchange.
         * Can only be set to <code>true</code> if an AD Connector directory ID is included in the request.
         * </p>
         * 
         * @param enableInteroperability
         *        When <code>true</code>, allows organization interoperability between Amazon WorkMail and Microsoft
         *        Exchange. Can only be set to <code>true</code> if an AD Connector directory ID is included in the
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableInteroperability(Boolean enableInteroperability);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkMailRequest.BuilderImpl implements Builder {
        private String directoryId;

        private String alias;

        private String clientToken;

        private List<Domain> domains = DefaultSdkAutoConstructList.getInstance();

        private String kmsKeyArn;

        private Boolean enableInteroperability;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOrganizationRequest model) {
            super(model);
            directoryId(model.directoryId);
            alias(model.alias);
            clientToken(model.clientToken);
            domains(model.domains);
            kmsKeyArn(model.kmsKeyArn);
            enableInteroperability(model.enableInteroperability);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        @Transient
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getAlias() {
            return alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        @Transient
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Domain.Builder> getDomains() {
            List<Domain.Builder> result = DomainsCopier.copyToBuilder(this.domains);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomains(Collection<Domain.BuilderImpl> domains) {
            this.domains = DomainsCopier.copyFromBuilder(domains);
        }

        @Override
        @Transient
        public final Builder domains(Collection<Domain> domains) {
            this.domains = DomainsCopier.copy(domains);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder domains(Domain... domains) {
            domains(Arrays.asList(domains));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder domains(Consumer<Domain.Builder>... domains) {
            domains(Stream.of(domains).map(c -> Domain.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        @Transient
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final Boolean getEnableInteroperability() {
            return enableInteroperability;
        }

        public final void setEnableInteroperability(Boolean enableInteroperability) {
            this.enableInteroperability = enableInteroperability;
        }

        @Override
        @Transient
        public final Builder enableInteroperability(Boolean enableInteroperability) {
            this.enableInteroperability = enableInteroperability;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOrganizationRequest build() {
            return new CreateOrganizationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
