/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.workmail.model.AssociateDelegateToResourceRequest;
import software.amazon.awssdk.services.workmail.model.AssociateDelegateToResourceResponse;
import software.amazon.awssdk.services.workmail.model.AssociateMemberToGroupRequest;
import software.amazon.awssdk.services.workmail.model.AssociateMemberToGroupResponse;
import software.amazon.awssdk.services.workmail.model.CancelMailboxExportJobRequest;
import software.amazon.awssdk.services.workmail.model.CancelMailboxExportJobResponse;
import software.amazon.awssdk.services.workmail.model.CreateAliasRequest;
import software.amazon.awssdk.services.workmail.model.CreateAliasResponse;
import software.amazon.awssdk.services.workmail.model.CreateGroupRequest;
import software.amazon.awssdk.services.workmail.model.CreateGroupResponse;
import software.amazon.awssdk.services.workmail.model.CreateMobileDeviceAccessRuleRequest;
import software.amazon.awssdk.services.workmail.model.CreateMobileDeviceAccessRuleResponse;
import software.amazon.awssdk.services.workmail.model.CreateOrganizationRequest;
import software.amazon.awssdk.services.workmail.model.CreateOrganizationResponse;
import software.amazon.awssdk.services.workmail.model.CreateResourceRequest;
import software.amazon.awssdk.services.workmail.model.CreateResourceResponse;
import software.amazon.awssdk.services.workmail.model.CreateUserRequest;
import software.amazon.awssdk.services.workmail.model.CreateUserResponse;
import software.amazon.awssdk.services.workmail.model.DeleteAccessControlRuleRequest;
import software.amazon.awssdk.services.workmail.model.DeleteAccessControlRuleResponse;
import software.amazon.awssdk.services.workmail.model.DeleteAliasRequest;
import software.amazon.awssdk.services.workmail.model.DeleteAliasResponse;
import software.amazon.awssdk.services.workmail.model.DeleteGroupRequest;
import software.amazon.awssdk.services.workmail.model.DeleteGroupResponse;
import software.amazon.awssdk.services.workmail.model.DeleteMailboxPermissionsRequest;
import software.amazon.awssdk.services.workmail.model.DeleteMailboxPermissionsResponse;
import software.amazon.awssdk.services.workmail.model.DeleteMobileDeviceAccessOverrideRequest;
import software.amazon.awssdk.services.workmail.model.DeleteMobileDeviceAccessOverrideResponse;
import software.amazon.awssdk.services.workmail.model.DeleteMobileDeviceAccessRuleRequest;
import software.amazon.awssdk.services.workmail.model.DeleteMobileDeviceAccessRuleResponse;
import software.amazon.awssdk.services.workmail.model.DeleteOrganizationRequest;
import software.amazon.awssdk.services.workmail.model.DeleteOrganizationResponse;
import software.amazon.awssdk.services.workmail.model.DeleteResourceRequest;
import software.amazon.awssdk.services.workmail.model.DeleteResourceResponse;
import software.amazon.awssdk.services.workmail.model.DeleteRetentionPolicyRequest;
import software.amazon.awssdk.services.workmail.model.DeleteRetentionPolicyResponse;
import software.amazon.awssdk.services.workmail.model.DeleteUserRequest;
import software.amazon.awssdk.services.workmail.model.DeleteUserResponse;
import software.amazon.awssdk.services.workmail.model.DeregisterFromWorkMailRequest;
import software.amazon.awssdk.services.workmail.model.DeregisterFromWorkMailResponse;
import software.amazon.awssdk.services.workmail.model.DeregisterMailDomainRequest;
import software.amazon.awssdk.services.workmail.model.DeregisterMailDomainResponse;
import software.amazon.awssdk.services.workmail.model.DescribeGroupRequest;
import software.amazon.awssdk.services.workmail.model.DescribeGroupResponse;
import software.amazon.awssdk.services.workmail.model.DescribeInboundDmarcSettingsRequest;
import software.amazon.awssdk.services.workmail.model.DescribeInboundDmarcSettingsResponse;
import software.amazon.awssdk.services.workmail.model.DescribeMailboxExportJobRequest;
import software.amazon.awssdk.services.workmail.model.DescribeMailboxExportJobResponse;
import software.amazon.awssdk.services.workmail.model.DescribeOrganizationRequest;
import software.amazon.awssdk.services.workmail.model.DescribeOrganizationResponse;
import software.amazon.awssdk.services.workmail.model.DescribeResourceRequest;
import software.amazon.awssdk.services.workmail.model.DescribeResourceResponse;
import software.amazon.awssdk.services.workmail.model.DescribeUserRequest;
import software.amazon.awssdk.services.workmail.model.DescribeUserResponse;
import software.amazon.awssdk.services.workmail.model.DirectoryInUseException;
import software.amazon.awssdk.services.workmail.model.DirectoryServiceAuthenticationFailedException;
import software.amazon.awssdk.services.workmail.model.DirectoryUnavailableException;
import software.amazon.awssdk.services.workmail.model.DisassociateDelegateFromResourceRequest;
import software.amazon.awssdk.services.workmail.model.DisassociateDelegateFromResourceResponse;
import software.amazon.awssdk.services.workmail.model.DisassociateMemberFromGroupRequest;
import software.amazon.awssdk.services.workmail.model.DisassociateMemberFromGroupResponse;
import software.amazon.awssdk.services.workmail.model.EmailAddressInUseException;
import software.amazon.awssdk.services.workmail.model.EntityAlreadyRegisteredException;
import software.amazon.awssdk.services.workmail.model.EntityNotFoundException;
import software.amazon.awssdk.services.workmail.model.EntityStateException;
import software.amazon.awssdk.services.workmail.model.GetAccessControlEffectRequest;
import software.amazon.awssdk.services.workmail.model.GetAccessControlEffectResponse;
import software.amazon.awssdk.services.workmail.model.GetDefaultRetentionPolicyRequest;
import software.amazon.awssdk.services.workmail.model.GetDefaultRetentionPolicyResponse;
import software.amazon.awssdk.services.workmail.model.GetMailDomainRequest;
import software.amazon.awssdk.services.workmail.model.GetMailDomainResponse;
import software.amazon.awssdk.services.workmail.model.GetMailboxDetailsRequest;
import software.amazon.awssdk.services.workmail.model.GetMailboxDetailsResponse;
import software.amazon.awssdk.services.workmail.model.GetMobileDeviceAccessEffectRequest;
import software.amazon.awssdk.services.workmail.model.GetMobileDeviceAccessEffectResponse;
import software.amazon.awssdk.services.workmail.model.GetMobileDeviceAccessOverrideRequest;
import software.amazon.awssdk.services.workmail.model.GetMobileDeviceAccessOverrideResponse;
import software.amazon.awssdk.services.workmail.model.InvalidConfigurationException;
import software.amazon.awssdk.services.workmail.model.InvalidCustomSesConfigurationException;
import software.amazon.awssdk.services.workmail.model.InvalidParameterException;
import software.amazon.awssdk.services.workmail.model.InvalidPasswordException;
import software.amazon.awssdk.services.workmail.model.LimitExceededException;
import software.amazon.awssdk.services.workmail.model.ListAccessControlRulesRequest;
import software.amazon.awssdk.services.workmail.model.ListAccessControlRulesResponse;
import software.amazon.awssdk.services.workmail.model.ListAliasesRequest;
import software.amazon.awssdk.services.workmail.model.ListAliasesResponse;
import software.amazon.awssdk.services.workmail.model.ListGroupMembersRequest;
import software.amazon.awssdk.services.workmail.model.ListGroupMembersResponse;
import software.amazon.awssdk.services.workmail.model.ListGroupsRequest;
import software.amazon.awssdk.services.workmail.model.ListGroupsResponse;
import software.amazon.awssdk.services.workmail.model.ListMailDomainsRequest;
import software.amazon.awssdk.services.workmail.model.ListMailDomainsResponse;
import software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsRequest;
import software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsResponse;
import software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsRequest;
import software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsResponse;
import software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessOverridesRequest;
import software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessOverridesResponse;
import software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessRulesRequest;
import software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessRulesResponse;
import software.amazon.awssdk.services.workmail.model.ListOrganizationsRequest;
import software.amazon.awssdk.services.workmail.model.ListOrganizationsResponse;
import software.amazon.awssdk.services.workmail.model.ListResourceDelegatesRequest;
import software.amazon.awssdk.services.workmail.model.ListResourceDelegatesResponse;
import software.amazon.awssdk.services.workmail.model.ListResourcesRequest;
import software.amazon.awssdk.services.workmail.model.ListResourcesResponse;
import software.amazon.awssdk.services.workmail.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.workmail.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.workmail.model.ListUsersRequest;
import software.amazon.awssdk.services.workmail.model.ListUsersResponse;
import software.amazon.awssdk.services.workmail.model.MailDomainInUseException;
import software.amazon.awssdk.services.workmail.model.MailDomainNotFoundException;
import software.amazon.awssdk.services.workmail.model.MailDomainStateException;
import software.amazon.awssdk.services.workmail.model.NameAvailabilityException;
import software.amazon.awssdk.services.workmail.model.OrganizationNotFoundException;
import software.amazon.awssdk.services.workmail.model.OrganizationStateException;
import software.amazon.awssdk.services.workmail.model.PutAccessControlRuleRequest;
import software.amazon.awssdk.services.workmail.model.PutAccessControlRuleResponse;
import software.amazon.awssdk.services.workmail.model.PutInboundDmarcSettingsRequest;
import software.amazon.awssdk.services.workmail.model.PutInboundDmarcSettingsResponse;
import software.amazon.awssdk.services.workmail.model.PutMailboxPermissionsRequest;
import software.amazon.awssdk.services.workmail.model.PutMailboxPermissionsResponse;
import software.amazon.awssdk.services.workmail.model.PutMobileDeviceAccessOverrideRequest;
import software.amazon.awssdk.services.workmail.model.PutMobileDeviceAccessOverrideResponse;
import software.amazon.awssdk.services.workmail.model.PutRetentionPolicyRequest;
import software.amazon.awssdk.services.workmail.model.PutRetentionPolicyResponse;
import software.amazon.awssdk.services.workmail.model.RegisterMailDomainRequest;
import software.amazon.awssdk.services.workmail.model.RegisterMailDomainResponse;
import software.amazon.awssdk.services.workmail.model.RegisterToWorkMailRequest;
import software.amazon.awssdk.services.workmail.model.RegisterToWorkMailResponse;
import software.amazon.awssdk.services.workmail.model.ReservedNameException;
import software.amazon.awssdk.services.workmail.model.ResetPasswordRequest;
import software.amazon.awssdk.services.workmail.model.ResetPasswordResponse;
import software.amazon.awssdk.services.workmail.model.ResourceNotFoundException;
import software.amazon.awssdk.services.workmail.model.StartMailboxExportJobRequest;
import software.amazon.awssdk.services.workmail.model.StartMailboxExportJobResponse;
import software.amazon.awssdk.services.workmail.model.TagResourceRequest;
import software.amazon.awssdk.services.workmail.model.TagResourceResponse;
import software.amazon.awssdk.services.workmail.model.TooManyTagsException;
import software.amazon.awssdk.services.workmail.model.UnsupportedOperationException;
import software.amazon.awssdk.services.workmail.model.UntagResourceRequest;
import software.amazon.awssdk.services.workmail.model.UntagResourceResponse;
import software.amazon.awssdk.services.workmail.model.UpdateDefaultMailDomainRequest;
import software.amazon.awssdk.services.workmail.model.UpdateDefaultMailDomainResponse;
import software.amazon.awssdk.services.workmail.model.UpdateMailboxQuotaRequest;
import software.amazon.awssdk.services.workmail.model.UpdateMailboxQuotaResponse;
import software.amazon.awssdk.services.workmail.model.UpdateMobileDeviceAccessRuleRequest;
import software.amazon.awssdk.services.workmail.model.UpdateMobileDeviceAccessRuleResponse;
import software.amazon.awssdk.services.workmail.model.UpdatePrimaryEmailAddressRequest;
import software.amazon.awssdk.services.workmail.model.UpdatePrimaryEmailAddressResponse;
import software.amazon.awssdk.services.workmail.model.UpdateResourceRequest;
import software.amazon.awssdk.services.workmail.model.UpdateResourceResponse;
import software.amazon.awssdk.services.workmail.model.WorkMailException;
import software.amazon.awssdk.services.workmail.model.WorkMailRequest;
import software.amazon.awssdk.services.workmail.paginators.ListAliasesPublisher;
import software.amazon.awssdk.services.workmail.paginators.ListGroupMembersPublisher;
import software.amazon.awssdk.services.workmail.paginators.ListGroupsPublisher;
import software.amazon.awssdk.services.workmail.paginators.ListMailDomainsPublisher;
import software.amazon.awssdk.services.workmail.paginators.ListMailboxExportJobsPublisher;
import software.amazon.awssdk.services.workmail.paginators.ListMailboxPermissionsPublisher;
import software.amazon.awssdk.services.workmail.paginators.ListMobileDeviceAccessOverridesPublisher;
import software.amazon.awssdk.services.workmail.paginators.ListOrganizationsPublisher;
import software.amazon.awssdk.services.workmail.paginators.ListResourceDelegatesPublisher;
import software.amazon.awssdk.services.workmail.paginators.ListResourcesPublisher;
import software.amazon.awssdk.services.workmail.paginators.ListUsersPublisher;
import software.amazon.awssdk.services.workmail.transform.AssociateDelegateToResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.AssociateMemberToGroupRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.CancelMailboxExportJobRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.CreateAliasRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.CreateGroupRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.CreateMobileDeviceAccessRuleRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.CreateOrganizationRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.CreateResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteAccessControlRuleRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteAliasRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteGroupRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteMailboxPermissionsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteMobileDeviceAccessOverrideRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteMobileDeviceAccessRuleRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteOrganizationRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteRetentionPolicyRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeregisterFromWorkMailRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeregisterMailDomainRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DescribeGroupRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DescribeInboundDmarcSettingsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DescribeMailboxExportJobRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DescribeOrganizationRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DescribeResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DescribeUserRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DisassociateDelegateFromResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DisassociateMemberFromGroupRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.GetAccessControlEffectRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.GetDefaultRetentionPolicyRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.GetMailDomainRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.GetMailboxDetailsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.GetMobileDeviceAccessEffectRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.GetMobileDeviceAccessOverrideRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListAccessControlRulesRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListAliasesRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListGroupMembersRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListGroupsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListMailDomainsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListMailboxExportJobsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListMailboxPermissionsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListMobileDeviceAccessOverridesRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListMobileDeviceAccessRulesRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListOrganizationsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListResourceDelegatesRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListResourcesRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListUsersRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.PutAccessControlRuleRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.PutInboundDmarcSettingsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.PutMailboxPermissionsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.PutMobileDeviceAccessOverrideRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.PutRetentionPolicyRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.RegisterMailDomainRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.RegisterToWorkMailRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ResetPasswordRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.StartMailboxExportJobRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.UpdateDefaultMailDomainRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.UpdateMailboxQuotaRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.UpdateMobileDeviceAccessRuleRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.UpdatePrimaryEmailAddressRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.UpdateResourceRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link WorkMailAsyncClient}.
 *
 * @see WorkMailAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultWorkMailAsyncClient implements WorkMailAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkMailAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultWorkMailAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Adds a member (user or group) to the resource's set of delegates.
     * </p>
     *
     * @param associateDelegateToResourceRequest
     * @return A Java Future containing the result of the AssociateDelegateToResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.AssociateDelegateToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/AssociateDelegateToResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateDelegateToResourceResponse> associateDelegateToResource(
            AssociateDelegateToResourceRequest associateDelegateToResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateDelegateToResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateDelegateToResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateDelegateToResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateDelegateToResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateDelegateToResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateDelegateToResourceRequest, AssociateDelegateToResourceResponse>()
                            .withOperationName("AssociateDelegateToResource")
                            .withMarshaller(new AssociateDelegateToResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(associateDelegateToResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = associateDelegateToResourceRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<AssociateDelegateToResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds a member (user or group) to the group's set.
     * </p>
     *
     * @param associateMemberToGroupRequest
     * @return A Java Future containing the result of the AssociateMemberToGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.AssociateMemberToGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/AssociateMemberToGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateMemberToGroupResponse> associateMemberToGroup(
            AssociateMemberToGroupRequest associateMemberToGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateMemberToGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateMemberToGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateMemberToGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateMemberToGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateMemberToGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateMemberToGroupRequest, AssociateMemberToGroupResponse>()
                            .withOperationName("AssociateMemberToGroup")
                            .withMarshaller(new AssociateMemberToGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(associateMemberToGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = associateMemberToGroupRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<AssociateMemberToGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels a mailbox export job.
     * </p>
     * <note>
     * <p>
     * If the mailbox export job is near completion, it might not be possible to cancel it.
     * </p>
     * </note>
     *
     * @param cancelMailboxExportJobRequest
     * @return A Java Future containing the result of the CancelMailboxExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CancelMailboxExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CancelMailboxExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelMailboxExportJobResponse> cancelMailboxExportJob(
            CancelMailboxExportJobRequest cancelMailboxExportJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelMailboxExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelMailboxExportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelMailboxExportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelMailboxExportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelMailboxExportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelMailboxExportJobRequest, CancelMailboxExportJobResponse>()
                            .withOperationName("CancelMailboxExportJob")
                            .withMarshaller(new CancelMailboxExportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(cancelMailboxExportJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = cancelMailboxExportJobRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<CancelMailboxExportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds an alias to the set of a given member (user or group) of Amazon WorkMail.
     * </p>
     *
     * @param createAliasRequest
     * @return A Java Future containing the result of the CreateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EmailAddressInUseException The email address that you're trying to assign is already created for a
     *         different user, group, or resource.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>MailDomainNotFoundException The domain specified is not found in your organization.</li>
     *         <li>MailDomainStateException After a domain has been added to the organization, it must be verified. The
     *         domain is not yet verified.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAliasResponse> createAlias(CreateAliasRequest createAliasRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateAliasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAliasRequest, CreateAliasResponse>()
                            .withOperationName("CreateAlias").withMarshaller(new CreateAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createAliasRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createAliasRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateAliasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a group that can be used in Amazon WorkMail by calling the <a>RegisterToWorkMail</a> operation.
     * </p>
     *
     * @param createGroupRequest
     * @return A Java Future containing the result of the CreateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>NameAvailabilityException The user, group, or resource name isn't unique in Amazon WorkMail.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>ReservedNameException This user, group, or resource name is not allowed in Amazon WorkMail.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateGroupResponse> createGroup(CreateGroupRequest createGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateGroupRequest, CreateGroupResponse>()
                            .withOperationName("CreateGroup").withMarshaller(new CreateGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createGroupRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new mobile device access rule for the specified Amazon WorkMail organization.
     * </p>
     *
     * @param createMobileDeviceAccessRuleRequest
     * @return A Java Future containing the result of the CreateMobileDeviceAccessRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateMobileDeviceAccessRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateMobileDeviceAccessRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMobileDeviceAccessRuleResponse> createMobileDeviceAccessRule(
            CreateMobileDeviceAccessRuleRequest createMobileDeviceAccessRuleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMobileDeviceAccessRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMobileDeviceAccessRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMobileDeviceAccessRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateMobileDeviceAccessRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateMobileDeviceAccessRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMobileDeviceAccessRuleRequest, CreateMobileDeviceAccessRuleResponse>()
                            .withOperationName("CreateMobileDeviceAccessRule")
                            .withMarshaller(new CreateMobileDeviceAccessRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createMobileDeviceAccessRuleRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createMobileDeviceAccessRuleRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<CreateMobileDeviceAccessRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new Amazon WorkMail organization. Optionally, you can choose to associate an existing AWS Directory
     * Service directory with your organization. If an AWS Directory Service directory ID is specified, the organization
     * alias must match the directory alias. If you choose not to associate an existing directory with your
     * organization, then we create a new Amazon WorkMail directory for you. For more information, see <a
     * href="https://docs.aws.amazon.com/workmail/latest/adminguide/add_new_organization.html">Adding an
     * organization</a> in the <i>Amazon WorkMail Administrator Guide</i>.
     * </p>
     * <p>
     * You can associate multiple email domains with an organization, then set your default email domain from the Amazon
     * WorkMail console. You can also associate a domain that is managed in an Amazon Route 53 public hosted zone. For
     * more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/add_domain.html">Adding a
     * domain</a> and <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/default_domain.html">Choosing the
     * default domain</a> in the <i>Amazon WorkMail Administrator Guide</i>.
     * </p>
     * <p>
     * Optionally, you can use a customer managed master key from AWS Key Management Service (AWS KMS) to encrypt email
     * for your organization. If you don't associate an AWS KMS key, Amazon WorkMail creates a default AWS managed
     * master key for you.
     * </p>
     *
     * @param createOrganizationRequest
     * @return A Java Future containing the result of the CreateOrganization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>DirectoryInUseException The directory is already in use by another WorkMail organization in the same
     *         account and Region.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>NameAvailabilityException The user, group, or resource name isn't unique in Amazon WorkMail.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateOrganization" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateOrganizationResponse> createOrganization(CreateOrganizationRequest createOrganizationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createOrganizationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOrganization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateOrganizationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateOrganizationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateOrganizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateOrganizationRequest, CreateOrganizationResponse>()
                            .withOperationName("CreateOrganization")
                            .withMarshaller(new CreateOrganizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createOrganizationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createOrganizationRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<CreateOrganizationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new Amazon WorkMail resource.
     * </p>
     *
     * @param createResourceRequest
     * @return A Java Future containing the result of the CreateResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>NameAvailabilityException The user, group, or resource name isn't unique in Amazon WorkMail.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>ReservedNameException This user, group, or resource name is not allowed in Amazon WorkMail.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateResourceResponse> createResource(CreateResourceRequest createResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateResourceRequest, CreateResourceResponse>()
                            .withOperationName("CreateResource")
                            .withMarshaller(new CreateResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createResourceRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a user who can be used in Amazon WorkMail by calling the <a>RegisterToWorkMail</a> operation.
     * </p>
     *
     * @param createUserRequest
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>InvalidPasswordException The supplied password doesn't match the minimum security constraints, such
     *         as length or use of special characters.</li>
     *         <li>NameAvailabilityException The user, group, or resource name isn't unique in Amazon WorkMail.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>ReservedNameException This user, group, or resource name is not allowed in Amazon WorkMail.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateUserResponse> createUser(CreateUserRequest createUserRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateUserRequest, CreateUserResponse>().withOperationName("CreateUser")
                            .withMarshaller(new CreateUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createUserRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createUserRequest.overrideConfiguration().orElse(null);
            CompletableFuture<CreateUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an access control rule for the specified WorkMail organization.
     * </p>
     * <note>
     * <p>
     * Deleting already deleted and non-existing rules does not produce an error. In those cases, the service sends back
     * an HTTP 200 response with an empty HTTP body.
     * </p>
     * </note>
     *
     * @param deleteAccessControlRuleRequest
     * @return A Java Future containing the result of the DeleteAccessControlRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteAccessControlRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteAccessControlRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAccessControlRuleResponse> deleteAccessControlRule(
            DeleteAccessControlRuleRequest deleteAccessControlRuleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAccessControlRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccessControlRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAccessControlRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAccessControlRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAccessControlRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAccessControlRuleRequest, DeleteAccessControlRuleResponse>()
                            .withOperationName("DeleteAccessControlRule")
                            .withMarshaller(new DeleteAccessControlRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteAccessControlRuleRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteAccessControlRuleRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DeleteAccessControlRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Remove one or more specified aliases from a set of aliases for a given user.
     * </p>
     *
     * @param deleteAliasRequest
     * @return A Java Future containing the result of the DeleteAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAliasResponse> deleteAlias(DeleteAliasRequest deleteAliasRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteAliasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAliasRequest, DeleteAliasResponse>()
                            .withOperationName("DeleteAlias").withMarshaller(new DeleteAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteAliasRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteAliasRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteAliasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a group from Amazon WorkMail.
     * </p>
     *
     * @param deleteGroupRequest
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteGroupResponse> deleteGroup(DeleteGroupRequest deleteGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteGroupRequest, DeleteGroupResponse>()
                            .withOperationName("DeleteGroup").withMarshaller(new DeleteGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteGroupRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes permissions granted to a member (user or group).
     * </p>
     *
     * @param deleteMailboxPermissionsRequest
     * @return A Java Future containing the result of the DeleteMailboxPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteMailboxPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteMailboxPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMailboxPermissionsResponse> deleteMailboxPermissions(
            DeleteMailboxPermissionsRequest deleteMailboxPermissionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMailboxPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMailboxPermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMailboxPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteMailboxPermissionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteMailboxPermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMailboxPermissionsRequest, DeleteMailboxPermissionsResponse>()
                            .withOperationName("DeleteMailboxPermissions")
                            .withMarshaller(new DeleteMailboxPermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteMailboxPermissionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteMailboxPermissionsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DeleteMailboxPermissionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the mobile device access override for the given WorkMail organization, user, and device.
     * </p>
     * <note>
     * <p>
     * Deleting already deleted and non-existing overrides does not produce an error. In those cases, the service sends
     * back an HTTP 200 response with an empty HTTP body.
     * </p>
     * </note>
     *
     * @param deleteMobileDeviceAccessOverrideRequest
     * @return A Java Future containing the result of the DeleteMobileDeviceAccessOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteMobileDeviceAccessOverride
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteMobileDeviceAccessOverride"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMobileDeviceAccessOverrideResponse> deleteMobileDeviceAccessOverride(
            DeleteMobileDeviceAccessOverrideRequest deleteMobileDeviceAccessOverrideRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteMobileDeviceAccessOverrideRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMobileDeviceAccessOverride");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMobileDeviceAccessOverrideResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteMobileDeviceAccessOverrideResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteMobileDeviceAccessOverrideResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMobileDeviceAccessOverrideRequest, DeleteMobileDeviceAccessOverrideResponse>()
                            .withOperationName("DeleteMobileDeviceAccessOverride")
                            .withMarshaller(new DeleteMobileDeviceAccessOverrideRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteMobileDeviceAccessOverrideRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteMobileDeviceAccessOverrideRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DeleteMobileDeviceAccessOverrideResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a mobile device access rule for the specified Amazon WorkMail organization.
     * </p>
     * <note>
     * <p>
     * Deleting already deleted and non-existing rules does not produce an error. In those cases, the service sends back
     * an HTTP 200 response with an empty HTTP body.
     * </p>
     * </note>
     *
     * @param deleteMobileDeviceAccessRuleRequest
     * @return A Java Future containing the result of the DeleteMobileDeviceAccessRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteMobileDeviceAccessRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteMobileDeviceAccessRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMobileDeviceAccessRuleResponse> deleteMobileDeviceAccessRule(
            DeleteMobileDeviceAccessRuleRequest deleteMobileDeviceAccessRuleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMobileDeviceAccessRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMobileDeviceAccessRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMobileDeviceAccessRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteMobileDeviceAccessRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteMobileDeviceAccessRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMobileDeviceAccessRuleRequest, DeleteMobileDeviceAccessRuleResponse>()
                            .withOperationName("DeleteMobileDeviceAccessRule")
                            .withMarshaller(new DeleteMobileDeviceAccessRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteMobileDeviceAccessRuleRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteMobileDeviceAccessRuleRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DeleteMobileDeviceAccessRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon WorkMail organization and all underlying AWS resources managed by Amazon WorkMail as part of
     * the organization. You can choose whether to delete the associated directory. For more information, see <a
     * href="https://docs.aws.amazon.com/workmail/latest/adminguide/remove_organization.html">Removing an
     * organization</a> in the <i>Amazon WorkMail Administrator Guide</i>.
     * </p>
     *
     * @param deleteOrganizationRequest
     * @return A Java Future containing the result of the DeleteOrganization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteOrganization" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteOrganizationResponse> deleteOrganization(DeleteOrganizationRequest deleteOrganizationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOrganizationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOrganization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteOrganizationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteOrganizationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteOrganizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteOrganizationRequest, DeleteOrganizationResponse>()
                            .withOperationName("DeleteOrganization")
                            .withMarshaller(new DeleteOrganizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteOrganizationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteOrganizationRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DeleteOrganizationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified resource.
     * </p>
     *
     * @param deleteResourceRequest
     * @return A Java Future containing the result of the DeleteResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteResourceResponse> deleteResource(DeleteResourceRequest deleteResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteResourceRequest, DeleteResourceResponse>()
                            .withOperationName("DeleteResource")
                            .withMarshaller(new DeleteResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteResourceRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified retention policy from the specified organization.
     * </p>
     *
     * @param deleteRetentionPolicyRequest
     * @return A Java Future containing the result of the DeleteRetentionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteRetentionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteRetentionPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRetentionPolicyResponse> deleteRetentionPolicy(
            DeleteRetentionPolicyRequest deleteRetentionPolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRetentionPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRetentionPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRetentionPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRetentionPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteRetentionPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRetentionPolicyRequest, DeleteRetentionPolicyResponse>()
                            .withOperationName("DeleteRetentionPolicy")
                            .withMarshaller(new DeleteRetentionPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteRetentionPolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteRetentionPolicyRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DeleteRetentionPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a user from Amazon WorkMail and all subsequent systems. Before you can delete a user, the user state must
     * be <code>DISABLED</code>. Use the <a>DescribeUser</a> action to confirm the user state.
     * </p>
     * <p>
     * Deleting a user is permanent and cannot be undone. WorkMail archives user mailboxes for 30 days before they are
     * permanently removed.
     * </p>
     *
     * @param deleteUserRequest
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserRequest, DeleteUserResponse>().withOperationName("DeleteUser")
                            .withMarshaller(new DeleteUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteUserRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteUserRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DeleteUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Mark a user, group, or resource as no longer used in Amazon WorkMail. This action disassociates the mailbox and
     * schedules it for clean-up. WorkMail keeps mailboxes for 30 days before they are permanently removed. The
     * functionality in the console is <i>Disable</i>.
     * </p>
     *
     * @param deregisterFromWorkMailRequest
     * @return A Java Future containing the result of the DeregisterFromWorkMail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeregisterFromWorkMail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeregisterFromWorkMail"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterFromWorkMailResponse> deregisterFromWorkMail(
            DeregisterFromWorkMailRequest deregisterFromWorkMailRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterFromWorkMailRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterFromWorkMail");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeregisterFromWorkMailResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeregisterFromWorkMailResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeregisterFromWorkMailResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterFromWorkMailRequest, DeregisterFromWorkMailResponse>()
                            .withOperationName("DeregisterFromWorkMail")
                            .withMarshaller(new DeregisterFromWorkMailRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deregisterFromWorkMailRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deregisterFromWorkMailRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DeregisterFromWorkMailResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a domain from Amazon WorkMail, stops email routing to WorkMail, and removes the authorization allowing
     * WorkMail use. SES keeps the domain because other applications may use it. You must first remove any email address
     * used by WorkMail entities before you remove the domain.
     * </p>
     *
     * @param deregisterMailDomainRequest
     * @return A Java Future containing the result of the DeregisterMailDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MailDomainInUseException The domain you're trying to change is in use by another user or organization
     *         in your account. See the error message for details.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>InvalidCustomSesConfigurationException You SES configuration has customizations that Amazon WorkMail
     *         cannot save. The error message lists the invalid setting. For examples of invalid settings, refer to <a
     *         href
     *         ="https://docs.aws.amazon.com/ses/latest/APIReference/API_CreateReceiptRule.html">CreateReceiptRule</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeregisterMailDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeregisterMailDomain" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterMailDomainResponse> deregisterMailDomain(
            DeregisterMailDomainRequest deregisterMailDomainRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterMailDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterMailDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeregisterMailDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeregisterMailDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeregisterMailDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterMailDomainRequest, DeregisterMailDomainResponse>()
                            .withOperationName("DeregisterMailDomain")
                            .withMarshaller(new DeregisterMailDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deregisterMailDomainRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deregisterMailDomainRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DeregisterMailDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the data available for the group.
     * </p>
     *
     * @param describeGroupRequest
     * @return A Java Future containing the result of the DescribeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeGroupResponse> describeGroup(DescribeGroupRequest describeGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeGroupRequest, DescribeGroupResponse>()
                            .withOperationName("DescribeGroup")
                            .withMarshaller(new DescribeGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeGroupRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DescribeGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the settings in a DMARC policy for a specified organization.
     * </p>
     *
     * @param describeInboundDmarcSettingsRequest
     * @return A Java Future containing the result of the DescribeInboundDmarcSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeInboundDmarcSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeInboundDmarcSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInboundDmarcSettingsResponse> describeInboundDmarcSettings(
            DescribeInboundDmarcSettingsRequest describeInboundDmarcSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeInboundDmarcSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInboundDmarcSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeInboundDmarcSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeInboundDmarcSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeInboundDmarcSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeInboundDmarcSettingsRequest, DescribeInboundDmarcSettingsResponse>()
                            .withOperationName("DescribeInboundDmarcSettings")
                            .withMarshaller(new DescribeInboundDmarcSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeInboundDmarcSettingsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeInboundDmarcSettingsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DescribeInboundDmarcSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the current status of a mailbox export job.
     * </p>
     *
     * @param describeMailboxExportJobRequest
     * @return A Java Future containing the result of the DescribeMailboxExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeMailboxExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeMailboxExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMailboxExportJobResponse> describeMailboxExportJob(
            DescribeMailboxExportJobRequest describeMailboxExportJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeMailboxExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMailboxExportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMailboxExportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeMailboxExportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeMailboxExportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMailboxExportJobRequest, DescribeMailboxExportJobResponse>()
                            .withOperationName("DescribeMailboxExportJob")
                            .withMarshaller(new DescribeMailboxExportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeMailboxExportJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeMailboxExportJobRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DescribeMailboxExportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides more information regarding a given organization based on its identifier.
     * </p>
     *
     * @param describeOrganizationRequest
     * @return A Java Future containing the result of the DescribeOrganization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeOrganization" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeOrganizationResponse> describeOrganization(
            DescribeOrganizationRequest describeOrganizationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeOrganizationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOrganization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeOrganizationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeOrganizationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeOrganizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeOrganizationRequest, DescribeOrganizationResponse>()
                            .withOperationName("DescribeOrganization")
                            .withMarshaller(new DescribeOrganizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeOrganizationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeOrganizationRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<DescribeOrganizationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the data available for the resource.
     * </p>
     *
     * @param describeResourceRequest
     * @return A Java Future containing the result of the DescribeResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeResourceResponse> describeResource(DescribeResourceRequest describeResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeResourceRequest, DescribeResourceResponse>()
                            .withOperationName("DescribeResource")
                            .withMarshaller(new DescribeResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeResourceRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DescribeResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides information regarding the user.
     * </p>
     *
     * @param describeUserRequest
     * @return A Java Future containing the result of the DescribeUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeUserResponse> describeUser(DescribeUserRequest describeUserRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeUserRequest, DescribeUserResponse>()
                            .withOperationName("DescribeUser").withMarshaller(new DescribeUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeUserRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = describeUserRequest.overrideConfiguration().orElse(null);
            CompletableFuture<DescribeUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a member from the resource's set of delegates.
     * </p>
     *
     * @param disassociateDelegateFromResourceRequest
     * @return A Java Future containing the result of the DisassociateDelegateFromResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DisassociateDelegateFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DisassociateDelegateFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateDelegateFromResourceResponse> disassociateDelegateFromResource(
            DisassociateDelegateFromResourceRequest disassociateDelegateFromResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateDelegateFromResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateDelegateFromResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateDelegateFromResourceResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociateDelegateFromResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateDelegateFromResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateDelegateFromResourceRequest, DisassociateDelegateFromResourceResponse>()
                            .withOperationName("DisassociateDelegateFromResource")
                            .withMarshaller(new DisassociateDelegateFromResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(disassociateDelegateFromResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = disassociateDelegateFromResourceRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<DisassociateDelegateFromResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a member from a group.
     * </p>
     *
     * @param disassociateMemberFromGroupRequest
     * @return A Java Future containing the result of the DisassociateMemberFromGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DisassociateMemberFromGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DisassociateMemberFromGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateMemberFromGroupResponse> disassociateMemberFromGroup(
            DisassociateMemberFromGroupRequest disassociateMemberFromGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateMemberFromGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateMemberFromGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateMemberFromGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateMemberFromGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateMemberFromGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateMemberFromGroupRequest, DisassociateMemberFromGroupResponse>()
                            .withOperationName("DisassociateMemberFromGroup")
                            .withMarshaller(new DisassociateMemberFromGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(disassociateMemberFromGroupRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = disassociateMemberFromGroupRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<DisassociateMemberFromGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the effects of an organization's access control rules as they apply to a specified IPv4 address, access
     * protocol action, or user ID.
     * </p>
     *
     * @param getAccessControlEffectRequest
     * @return A Java Future containing the result of the GetAccessControlEffect operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetAccessControlEffect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetAccessControlEffect"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAccessControlEffectResponse> getAccessControlEffect(
            GetAccessControlEffectRequest getAccessControlEffectRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAccessControlEffectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccessControlEffect");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAccessControlEffectResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAccessControlEffectResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAccessControlEffectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAccessControlEffectRequest, GetAccessControlEffectResponse>()
                            .withOperationName("GetAccessControlEffect")
                            .withMarshaller(new GetAccessControlEffectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getAccessControlEffectRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getAccessControlEffectRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<GetAccessControlEffectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the default retention policy details for the specified organization.
     * </p>
     *
     * @param getDefaultRetentionPolicyRequest
     * @return A Java Future containing the result of the GetDefaultRetentionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetDefaultRetentionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetDefaultRetentionPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDefaultRetentionPolicyResponse> getDefaultRetentionPolicy(
            GetDefaultRetentionPolicyRequest getDefaultRetentionPolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDefaultRetentionPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDefaultRetentionPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDefaultRetentionPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDefaultRetentionPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDefaultRetentionPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDefaultRetentionPolicyRequest, GetDefaultRetentionPolicyResponse>()
                            .withOperationName("GetDefaultRetentionPolicy")
                            .withMarshaller(new GetDefaultRetentionPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDefaultRetentionPolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDefaultRetentionPolicyRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetDefaultRetentionPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets details for a mail domain, including domain records required to configure your domain with recommended
     * security.
     * </p>
     *
     * @param getMailDomainRequest
     * @return A Java Future containing the result of the GetMailDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MailDomainNotFoundException The domain specified is not found in your organization.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetMailDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetMailDomain" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetMailDomainResponse> getMailDomain(GetMailDomainRequest getMailDomainRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMailDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMailDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMailDomainResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetMailDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMailDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMailDomainRequest, GetMailDomainResponse>()
                            .withOperationName("GetMailDomain")
                            .withMarshaller(new GetMailDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getMailDomainRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getMailDomainRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetMailDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Requests a user's mailbox details for a specified organization and user.
     * </p>
     *
     * @param getMailboxDetailsRequest
     * @return A Java Future containing the result of the GetMailboxDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetMailboxDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetMailboxDetails" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMailboxDetailsResponse> getMailboxDetails(GetMailboxDetailsRequest getMailboxDetailsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMailboxDetailsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMailboxDetails");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMailboxDetailsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMailboxDetailsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMailboxDetailsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMailboxDetailsRequest, GetMailboxDetailsResponse>()
                            .withOperationName("GetMailboxDetails")
                            .withMarshaller(new GetMailboxDetailsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getMailboxDetailsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getMailboxDetailsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<GetMailboxDetailsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Simulates the effect of the mobile device access rules for the given attributes of a sample access event. Use
     * this method to test the effects of the current set of mobile device access rules for the Amazon WorkMail
     * organization for a particular user's attributes.
     * </p>
     *
     * @param getMobileDeviceAccessEffectRequest
     * @return A Java Future containing the result of the GetMobileDeviceAccessEffect operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetMobileDeviceAccessEffect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetMobileDeviceAccessEffect"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMobileDeviceAccessEffectResponse> getMobileDeviceAccessEffect(
            GetMobileDeviceAccessEffectRequest getMobileDeviceAccessEffectRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMobileDeviceAccessEffectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMobileDeviceAccessEffect");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMobileDeviceAccessEffectResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMobileDeviceAccessEffectResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMobileDeviceAccessEffectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMobileDeviceAccessEffectRequest, GetMobileDeviceAccessEffectResponse>()
                            .withOperationName("GetMobileDeviceAccessEffect")
                            .withMarshaller(new GetMobileDeviceAccessEffectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getMobileDeviceAccessEffectRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getMobileDeviceAccessEffectRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetMobileDeviceAccessEffectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the mobile device access override for the given WorkMail organization, user, and device.
     * </p>
     *
     * @param getMobileDeviceAccessOverrideRequest
     * @return A Java Future containing the result of the GetMobileDeviceAccessOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetMobileDeviceAccessOverride
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetMobileDeviceAccessOverride"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMobileDeviceAccessOverrideResponse> getMobileDeviceAccessOverride(
            GetMobileDeviceAccessOverrideRequest getMobileDeviceAccessOverrideRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getMobileDeviceAccessOverrideRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMobileDeviceAccessOverride");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMobileDeviceAccessOverrideResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMobileDeviceAccessOverrideResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMobileDeviceAccessOverrideResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMobileDeviceAccessOverrideRequest, GetMobileDeviceAccessOverrideResponse>()
                            .withOperationName("GetMobileDeviceAccessOverride")
                            .withMarshaller(new GetMobileDeviceAccessOverrideRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getMobileDeviceAccessOverrideRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getMobileDeviceAccessOverrideRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<GetMobileDeviceAccessOverrideResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the access control rules for the specified organization.
     * </p>
     *
     * @param listAccessControlRulesRequest
     * @return A Java Future containing the result of the ListAccessControlRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListAccessControlRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAccessControlRules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAccessControlRulesResponse> listAccessControlRules(
            ListAccessControlRulesRequest listAccessControlRulesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAccessControlRulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccessControlRules");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAccessControlRulesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAccessControlRulesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAccessControlRulesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAccessControlRulesRequest, ListAccessControlRulesResponse>()
                            .withOperationName("ListAccessControlRules")
                            .withMarshaller(new ListAccessControlRulesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listAccessControlRulesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listAccessControlRulesRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<ListAccessControlRulesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a paginated call to list the aliases associated with a given entity.
     * </p>
     *
     * @param listAliasesRequest
     * @return A Java Future containing the result of the ListAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListAliasesResponse> listAliases(ListAliasesRequest listAliasesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAliasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAliases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAliasesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListAliasesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAliasesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAliasesRequest, ListAliasesResponse>()
                            .withOperationName("ListAliases").withMarshaller(new ListAliasesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listAliasesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listAliasesRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ListAliasesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a paginated call to list the aliases associated with a given entity.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAliases(software.amazon.awssdk.services.workmail.model.ListAliasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListAliasesPublisher publisher = client.listAliasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListAliasesPublisher publisher = client.listAliasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListAliasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListAliasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAliases(software.amazon.awssdk.services.workmail.model.ListAliasesRequest)} operation.</b>
     * </p>
     *
     * @param listAliasesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    public ListAliasesPublisher listAliasesPaginator(ListAliasesRequest listAliasesRequest) {
        return new ListAliasesPublisher(this, applyPaginatorUserAgent(listAliasesRequest));
    }

    /**
     * <p>
     * Returns an overview of the members of a group. Users and groups can be members of a group.
     * </p>
     *
     * @param listGroupMembersRequest
     * @return A Java Future containing the result of the ListGroupMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListGroupMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroupMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListGroupMembersResponse> listGroupMembers(ListGroupMembersRequest listGroupMembersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGroupMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGroupMembers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGroupMembersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListGroupMembersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListGroupMembersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGroupMembersRequest, ListGroupMembersResponse>()
                            .withOperationName("ListGroupMembers")
                            .withMarshaller(new ListGroupMembersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listGroupMembersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listGroupMembersRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ListGroupMembersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns an overview of the members of a group. Users and groups can be members of a group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGroupMembers(software.amazon.awssdk.services.workmail.model.ListGroupMembersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupMembersPublisher publisher = client.listGroupMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupMembersPublisher publisher = client.listGroupMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListGroupMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListGroupMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroupMembers(software.amazon.awssdk.services.workmail.model.ListGroupMembersRequest)} operation.</b>
     * </p>
     *
     * @param listGroupMembersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListGroupMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroupMembers" target="_top">AWS API
     *      Documentation</a>
     */
    public ListGroupMembersPublisher listGroupMembersPaginator(ListGroupMembersRequest listGroupMembersRequest) {
        return new ListGroupMembersPublisher(this, applyPaginatorUserAgent(listGroupMembersRequest));
    }

    /**
     * <p>
     * Returns summaries of the organization's groups.
     * </p>
     *
     * @param listGroupsRequest
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListGroupsResponse> listGroups(ListGroupsRequest listGroupsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGroupsRequest, ListGroupsResponse>().withOperationName("ListGroups")
                            .withMarshaller(new ListGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listGroupsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listGroupsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ListGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns summaries of the organization's groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listGroups(software.amazon.awssdk.services.workmail.model.ListGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroups(software.amazon.awssdk.services.workmail.model.ListGroupsRequest)} operation.</b>
     * </p>
     *
     * @param listGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    public ListGroupsPublisher listGroupsPaginator(ListGroupsRequest listGroupsRequest) {
        return new ListGroupsPublisher(this, applyPaginatorUserAgent(listGroupsRequest));
    }

    /**
     * <p>
     * Lists the mail domains in a given Amazon WorkMail organization.
     * </p>
     *
     * @param listMailDomainsRequest
     * @return A Java Future containing the result of the ListMailDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMailDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailDomains" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListMailDomainsResponse> listMailDomains(ListMailDomainsRequest listMailDomainsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMailDomainsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMailDomains");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMailDomainsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMailDomainsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMailDomainsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMailDomainsRequest, ListMailDomainsResponse>()
                            .withOperationName("ListMailDomains")
                            .withMarshaller(new ListMailDomainsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listMailDomainsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listMailDomainsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ListMailDomainsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the mail domains in a given Amazon WorkMail organization.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMailDomains(software.amazon.awssdk.services.workmail.model.ListMailDomainsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailDomainsPublisher publisher = client.listMailDomainsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailDomainsPublisher publisher = client.listMailDomainsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListMailDomainsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListMailDomainsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMailDomains(software.amazon.awssdk.services.workmail.model.ListMailDomainsRequest)} operation.</b>
     * </p>
     *
     * @param listMailDomainsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMailDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailDomains" target="_top">AWS API
     *      Documentation</a>
     */
    public ListMailDomainsPublisher listMailDomainsPaginator(ListMailDomainsRequest listMailDomainsRequest) {
        return new ListMailDomainsPublisher(this, applyPaginatorUserAgent(listMailDomainsRequest));
    }

    /**
     * <p>
     * Lists the mailbox export jobs started for the specified organization within the last seven days.
     * </p>
     *
     * @param listMailboxExportJobsRequest
     * @return A Java Future containing the result of the ListMailboxExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMailboxExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMailboxExportJobsResponse> listMailboxExportJobs(
            ListMailboxExportJobsRequest listMailboxExportJobsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMailboxExportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMailboxExportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMailboxExportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMailboxExportJobsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMailboxExportJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMailboxExportJobsRequest, ListMailboxExportJobsResponse>()
                            .withOperationName("ListMailboxExportJobs")
                            .withMarshaller(new ListMailboxExportJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listMailboxExportJobsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listMailboxExportJobsRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<ListMailboxExportJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the mailbox export jobs started for the specified organization within the last seven days.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMailboxExportJobs(software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailboxExportJobsPublisher publisher = client.listMailboxExportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailboxExportJobsPublisher publisher = client.listMailboxExportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMailboxExportJobs(software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMailboxExportJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMailboxExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    public ListMailboxExportJobsPublisher listMailboxExportJobsPaginator(ListMailboxExportJobsRequest listMailboxExportJobsRequest) {
        return new ListMailboxExportJobsPublisher(this, applyPaginatorUserAgent(listMailboxExportJobsRequest));
    }

    /**
     * <p>
     * Lists the mailbox permissions associated with a user, group, or resource mailbox.
     * </p>
     *
     * @param listMailboxPermissionsRequest
     * @return A Java Future containing the result of the ListMailboxPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMailboxPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMailboxPermissionsResponse> listMailboxPermissions(
            ListMailboxPermissionsRequest listMailboxPermissionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMailboxPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMailboxPermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMailboxPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMailboxPermissionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMailboxPermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMailboxPermissionsRequest, ListMailboxPermissionsResponse>()
                            .withOperationName("ListMailboxPermissions")
                            .withMarshaller(new ListMailboxPermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listMailboxPermissionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listMailboxPermissionsRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<ListMailboxPermissionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the mailbox permissions associated with a user, group, or resource mailbox.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMailboxPermissions(software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailboxPermissionsPublisher publisher = client.listMailboxPermissionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailboxPermissionsPublisher publisher = client.listMailboxPermissionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMailboxPermissions(software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMailboxPermissionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMailboxPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    public ListMailboxPermissionsPublisher listMailboxPermissionsPaginator(
            ListMailboxPermissionsRequest listMailboxPermissionsRequest) {
        return new ListMailboxPermissionsPublisher(this, applyPaginatorUserAgent(listMailboxPermissionsRequest));
    }

    /**
     * <p>
     * Lists all the mobile device access overrides for any given combination of WorkMail organization, user, or device.
     * </p>
     *
     * @param listMobileDeviceAccessOverridesRequest
     * @return A Java Future containing the result of the ListMobileDeviceAccessOverrides operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMobileDeviceAccessOverrides
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMobileDeviceAccessOverrides"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMobileDeviceAccessOverridesResponse> listMobileDeviceAccessOverrides(
            ListMobileDeviceAccessOverridesRequest listMobileDeviceAccessOverridesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listMobileDeviceAccessOverridesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMobileDeviceAccessOverrides");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMobileDeviceAccessOverridesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMobileDeviceAccessOverridesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMobileDeviceAccessOverridesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMobileDeviceAccessOverridesRequest, ListMobileDeviceAccessOverridesResponse>()
                            .withOperationName("ListMobileDeviceAccessOverrides")
                            .withMarshaller(new ListMobileDeviceAccessOverridesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listMobileDeviceAccessOverridesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listMobileDeviceAccessOverridesRequest
                    .overrideConfiguration().orElse(null);
            CompletableFuture<ListMobileDeviceAccessOverridesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the mobile device access overrides for any given combination of WorkMail organization, user, or device.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMobileDeviceAccessOverrides(software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessOverridesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMobileDeviceAccessOverridesPublisher publisher = client.listMobileDeviceAccessOverridesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMobileDeviceAccessOverridesPublisher publisher = client.listMobileDeviceAccessOverridesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessOverridesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessOverridesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMobileDeviceAccessOverrides(software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessOverridesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMobileDeviceAccessOverridesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMobileDeviceAccessOverrides
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMobileDeviceAccessOverrides"
     *      target="_top">AWS API Documentation</a>
     */
    public ListMobileDeviceAccessOverridesPublisher listMobileDeviceAccessOverridesPaginator(
            ListMobileDeviceAccessOverridesRequest listMobileDeviceAccessOverridesRequest) {
        return new ListMobileDeviceAccessOverridesPublisher(this, applyPaginatorUserAgent(listMobileDeviceAccessOverridesRequest));
    }

    /**
     * <p>
     * Lists the mobile device access rules for the specified Amazon WorkMail organization.
     * </p>
     *
     * @param listMobileDeviceAccessRulesRequest
     * @return A Java Future containing the result of the ListMobileDeviceAccessRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMobileDeviceAccessRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMobileDeviceAccessRules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMobileDeviceAccessRulesResponse> listMobileDeviceAccessRules(
            ListMobileDeviceAccessRulesRequest listMobileDeviceAccessRulesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMobileDeviceAccessRulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMobileDeviceAccessRules");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMobileDeviceAccessRulesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMobileDeviceAccessRulesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMobileDeviceAccessRulesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMobileDeviceAccessRulesRequest, ListMobileDeviceAccessRulesResponse>()
                            .withOperationName("ListMobileDeviceAccessRules")
                            .withMarshaller(new ListMobileDeviceAccessRulesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listMobileDeviceAccessRulesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listMobileDeviceAccessRulesRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<ListMobileDeviceAccessRulesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns summaries of the customer's organizations.
     * </p>
     *
     * @param listOrganizationsRequest
     * @return A Java Future containing the result of the ListOrganizations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListOrganizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListOrganizations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListOrganizationsResponse> listOrganizations(ListOrganizationsRequest listOrganizationsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOrganizationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOrganizations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListOrganizationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListOrganizationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListOrganizationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListOrganizationsRequest, ListOrganizationsResponse>()
                            .withOperationName("ListOrganizations")
                            .withMarshaller(new ListOrganizationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listOrganizationsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listOrganizationsRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ListOrganizationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns summaries of the customer's organizations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOrganizations(software.amazon.awssdk.services.workmail.model.ListOrganizationsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListOrganizationsPublisher publisher = client.listOrganizationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListOrganizationsPublisher publisher = client.listOrganizationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListOrganizationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListOrganizationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizations(software.amazon.awssdk.services.workmail.model.ListOrganizationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOrganizationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListOrganizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListOrganizations" target="_top">AWS
     *      API Documentation</a>
     */
    public ListOrganizationsPublisher listOrganizationsPaginator(ListOrganizationsRequest listOrganizationsRequest) {
        return new ListOrganizationsPublisher(this, applyPaginatorUserAgent(listOrganizationsRequest));
    }

    /**
     * <p>
     * Lists the delegates associated with a resource. Users and groups can be resource delegates and answer requests on
     * behalf of the resource.
     * </p>
     *
     * @param listResourceDelegatesRequest
     * @return A Java Future containing the result of the ListResourceDelegates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListResourceDelegates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResourceDelegates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResourceDelegatesResponse> listResourceDelegates(
            ListResourceDelegatesRequest listResourceDelegatesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResourceDelegatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResourceDelegates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResourceDelegatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListResourceDelegatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListResourceDelegatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResourceDelegatesRequest, ListResourceDelegatesResponse>()
                            .withOperationName("ListResourceDelegates")
                            .withMarshaller(new ListResourceDelegatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listResourceDelegatesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listResourceDelegatesRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<ListResourceDelegatesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the delegates associated with a resource. Users and groups can be resource delegates and answer requests on
     * behalf of the resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceDelegates(software.amazon.awssdk.services.workmail.model.ListResourceDelegatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListResourceDelegatesPublisher publisher = client.listResourceDelegatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListResourceDelegatesPublisher publisher = client.listResourceDelegatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListResourceDelegatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListResourceDelegatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceDelegates(software.amazon.awssdk.services.workmail.model.ListResourceDelegatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceDelegatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListResourceDelegates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResourceDelegates"
     *      target="_top">AWS API Documentation</a>
     */
    public ListResourceDelegatesPublisher listResourceDelegatesPaginator(ListResourceDelegatesRequest listResourceDelegatesRequest) {
        return new ListResourceDelegatesPublisher(this, applyPaginatorUserAgent(listResourceDelegatesRequest));
    }

    /**
     * <p>
     * Returns summaries of the organization's resources.
     * </p>
     *
     * @param listResourcesRequest
     * @return A Java Future containing the result of the ListResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResources" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListResourcesResponse> listResources(ListResourcesRequest listResourcesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResourcesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListResourcesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListResourcesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResourcesRequest, ListResourcesResponse>()
                            .withOperationName("ListResources")
                            .withMarshaller(new ListResourcesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listResourcesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listResourcesRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ListResourcesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns summaries of the organization's resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listResources(software.amazon.awssdk.services.workmail.model.ListResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListResourcesPublisher publisher = client.listResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListResourcesPublisher publisher = client.listResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResources(software.amazon.awssdk.services.workmail.model.ListResourcesRequest)} operation.</b>
     * </p>
     *
     * @param listResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResources" target="_top">AWS API
     *      Documentation</a>
     */
    public ListResourcesPublisher listResourcesPaginator(ListResourcesRequest listResourcesRequest) {
        return new ListResourcesPublisher(this, applyPaginatorUserAgent(listResourcesRequest));
    }

    /**
     * <p>
     * Lists the tags applied to an Amazon WorkMail organization resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource")
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTagsForResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTagsForResourceRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns summaries of the organization's users.
     * </p>
     *
     * @param listUsersRequest
     * @return A Java Future containing the result of the ListUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListUsersResponse> listUsers(ListUsersRequest listUsersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUsersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUsers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListUsersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListUsersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListUsersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListUsersRequest, ListUsersResponse>().withOperationName("ListUsers")
                            .withMarshaller(new ListUsersRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listUsersRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listUsersRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ListUsersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns summaries of the organization's users.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listUsers(software.amazon.awssdk.services.workmail.model.ListUsersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListUsersPublisher publisher = client.listUsersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListUsersPublisher publisher = client.listUsersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListUsersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListUsersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsers(software.amazon.awssdk.services.workmail.model.ListUsersRequest)} operation.</b>
     * </p>
     *
     * @param listUsersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    public ListUsersPublisher listUsersPaginator(ListUsersRequest listUsersRequest) {
        return new ListUsersPublisher(this, applyPaginatorUserAgent(listUsersRequest));
    }

    /**
     * <p>
     * Adds a new access control rule for the specified organization. The rule allows or denies access to the
     * organization for the specified IPv4 addresses, access protocol actions, and user IDs. Adding a new rule with the
     * same name as an existing rule replaces the older rule.
     * </p>
     *
     * @param putAccessControlRuleRequest
     * @return A Java Future containing the result of the PutAccessControlRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.PutAccessControlRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutAccessControlRule" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PutAccessControlRuleResponse> putAccessControlRule(
            PutAccessControlRuleRequest putAccessControlRuleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putAccessControlRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutAccessControlRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutAccessControlRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutAccessControlRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutAccessControlRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutAccessControlRuleRequest, PutAccessControlRuleResponse>()
                            .withOperationName("PutAccessControlRule")
                            .withMarshaller(new PutAccessControlRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putAccessControlRuleRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putAccessControlRuleRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<PutAccessControlRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables or disables a DMARC policy for a given organization.
     * </p>
     *
     * @param putInboundDmarcSettingsRequest
     * @return A Java Future containing the result of the PutInboundDmarcSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.PutInboundDmarcSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutInboundDmarcSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutInboundDmarcSettingsResponse> putInboundDmarcSettings(
            PutInboundDmarcSettingsRequest putInboundDmarcSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putInboundDmarcSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutInboundDmarcSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutInboundDmarcSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutInboundDmarcSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutInboundDmarcSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutInboundDmarcSettingsRequest, PutInboundDmarcSettingsResponse>()
                            .withOperationName("PutInboundDmarcSettings")
                            .withMarshaller(new PutInboundDmarcSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putInboundDmarcSettingsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putInboundDmarcSettingsRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<PutInboundDmarcSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets permissions for a user, group, or resource. This replaces any pre-existing permissions.
     * </p>
     *
     * @param putMailboxPermissionsRequest
     * @return A Java Future containing the result of the PutMailboxPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.PutMailboxPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutMailboxPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutMailboxPermissionsResponse> putMailboxPermissions(
            PutMailboxPermissionsRequest putMailboxPermissionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putMailboxPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutMailboxPermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutMailboxPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutMailboxPermissionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutMailboxPermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutMailboxPermissionsRequest, PutMailboxPermissionsResponse>()
                            .withOperationName("PutMailboxPermissions")
                            .withMarshaller(new PutMailboxPermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putMailboxPermissionsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putMailboxPermissionsRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<PutMailboxPermissionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates or updates a mobile device access override for the given WorkMail organization, user, and device.
     * </p>
     *
     * @param putMobileDeviceAccessOverrideRequest
     * @return A Java Future containing the result of the PutMobileDeviceAccessOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.PutMobileDeviceAccessOverride
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutMobileDeviceAccessOverride"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutMobileDeviceAccessOverrideResponse> putMobileDeviceAccessOverride(
            PutMobileDeviceAccessOverrideRequest putMobileDeviceAccessOverrideRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putMobileDeviceAccessOverrideRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutMobileDeviceAccessOverride");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutMobileDeviceAccessOverrideResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutMobileDeviceAccessOverrideResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutMobileDeviceAccessOverrideResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutMobileDeviceAccessOverrideRequest, PutMobileDeviceAccessOverrideResponse>()
                            .withOperationName("PutMobileDeviceAccessOverride")
                            .withMarshaller(new PutMobileDeviceAccessOverrideRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putMobileDeviceAccessOverrideRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putMobileDeviceAccessOverrideRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<PutMobileDeviceAccessOverrideResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Puts a retention policy to the specified organization.
     * </p>
     *
     * @param putRetentionPolicyRequest
     * @return A Java Future containing the result of the PutRetentionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.PutRetentionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutRetentionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PutRetentionPolicyResponse> putRetentionPolicy(PutRetentionPolicyRequest putRetentionPolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putRetentionPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutRetentionPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutRetentionPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutRetentionPolicyResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutRetentionPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutRetentionPolicyRequest, PutRetentionPolicyResponse>()
                            .withOperationName("PutRetentionPolicy")
                            .withMarshaller(new PutRetentionPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(putRetentionPolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putRetentionPolicyRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<PutRetentionPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Registers a new domain in Amazon WorkMail and SES, and configures it for use by WorkMail. Emails received by SES
     * for this domain are routed to the specified WorkMail organization, and WorkMail has permanent permission to use
     * the specified domain for sending your users' emails.
     * </p>
     *
     * @param registerMailDomainRequest
     * @return A Java Future containing the result of the RegisterMailDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MailDomainInUseException The domain you're trying to change is in use by another user or organization
     *         in your account. See the error message for details.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.RegisterMailDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/RegisterMailDomain" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterMailDomainResponse> registerMailDomain(RegisterMailDomainRequest registerMailDomainRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerMailDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterMailDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RegisterMailDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RegisterMailDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RegisterMailDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RegisterMailDomainRequest, RegisterMailDomainResponse>()
                            .withOperationName("RegisterMailDomain")
                            .withMarshaller(new RegisterMailDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(registerMailDomainRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = registerMailDomainRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<RegisterMailDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Registers an existing and disabled user, group, or resource for Amazon WorkMail use by associating a mailbox and
     * calendaring capabilities. It performs no change if the user, group, or resource is enabled and fails if the user,
     * group, or resource is deleted. This operation results in the accumulation of costs. For more information, see <a
     * href="https://aws.amazon.com/workmail/pricing">Pricing</a>. The equivalent console functionality for this
     * operation is <i>Enable</i>.
     * </p>
     * <p>
     * Users can either be created by calling the <a>CreateUser</a> API operation or they can be synchronized from your
     * directory. For more information, see <a>DeregisterFromWorkMail</a>.
     * </p>
     *
     * @param registerToWorkMailRequest
     * @return A Java Future containing the result of the RegisterToWorkMail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EmailAddressInUseException The email address that you're trying to assign is already created for a
     *         different user, group, or resource.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>EntityAlreadyRegisteredException The user, group, or resource that you're trying to register is
     *         already registered.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>MailDomainNotFoundException The domain specified is not found in your organization.</li>
     *         <li>MailDomainStateException After a domain has been added to the organization, it must be verified. The
     *         domain is not yet verified.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.RegisterToWorkMail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/RegisterToWorkMail" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterToWorkMailResponse> registerToWorkMail(RegisterToWorkMailRequest registerToWorkMailRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerToWorkMailRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterToWorkMail");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RegisterToWorkMailResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RegisterToWorkMailResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RegisterToWorkMailResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RegisterToWorkMailRequest, RegisterToWorkMailResponse>()
                            .withOperationName("RegisterToWorkMail")
                            .withMarshaller(new RegisterToWorkMailRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(registerToWorkMailRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = registerToWorkMailRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<RegisterToWorkMailResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows the administrator to reset the password for a user.
     * </p>
     *
     * @param resetPasswordRequest
     * @return A Java Future containing the result of the ResetPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>InvalidPasswordException The supplied password doesn't match the minimum security constraints, such
     *         as length or use of special characters.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ResetPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ResetPassword" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ResetPasswordResponse> resetPassword(ResetPasswordRequest resetPasswordRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resetPasswordRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResetPassword");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ResetPasswordResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ResetPasswordResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ResetPasswordResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ResetPasswordRequest, ResetPasswordResponse>()
                            .withOperationName("ResetPassword")
                            .withMarshaller(new ResetPasswordRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(resetPasswordRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = resetPasswordRequest.overrideConfiguration().orElse(null);
            CompletableFuture<ResetPasswordResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a mailbox export job to export MIME-format email messages and calendar items from the specified mailbox to
     * the specified Amazon Simple Storage Service (Amazon S3) bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/workmail/latest/adminguide/mail-export.html">Exporting mailbox content</a> in
     * the <i>Amazon WorkMail Administrator Guide</i>.
     * </p>
     *
     * @param startMailboxExportJobRequest
     * @return A Java Future containing the result of the StartMailboxExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.StartMailboxExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/StartMailboxExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartMailboxExportJobResponse> startMailboxExportJob(
            StartMailboxExportJobRequest startMailboxExportJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startMailboxExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartMailboxExportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartMailboxExportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartMailboxExportJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartMailboxExportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartMailboxExportJobRequest, StartMailboxExportJobResponse>()
                            .withOperationName("StartMailboxExportJob")
                            .withMarshaller(new StartMailboxExportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startMailboxExportJobRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = startMailboxExportJobRequest.overrideConfiguration().orElse(
                    null);
            CompletableFuture<StartMailboxExportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Applies the specified tags to the specified Amazon WorkMail organization resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>TooManyTagsException The resource can have up to 50 user-applied tags.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(tagResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = tagResourceRequest.overrideConfiguration().orElse(null);
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Untags the specified tags from the specified Amazon WorkMail organization resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource")
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(untagResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = untagResourceRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the default mail domain for an organization. The default mail domain is used by the WorkMail AWS Console
     * to suggest an email address when enabling a mail user. You can only have one default domain.
     * </p>
     *
     * @param updateDefaultMailDomainRequest
     * @return A Java Future containing the result of the UpdateDefaultMailDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MailDomainNotFoundException The domain specified is not found in your organization.</li>
     *         <li>MailDomainStateException After a domain has been added to the organization, it must be verified. The
     *         domain is not yet verified.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UpdateDefaultMailDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateDefaultMailDomain"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDefaultMailDomainResponse> updateDefaultMailDomain(
            UpdateDefaultMailDomainRequest updateDefaultMailDomainRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDefaultMailDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDefaultMailDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDefaultMailDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDefaultMailDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDefaultMailDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDefaultMailDomainRequest, UpdateDefaultMailDomainResponse>()
                            .withOperationName("UpdateDefaultMailDomain")
                            .withMarshaller(new UpdateDefaultMailDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateDefaultMailDomainRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateDefaultMailDomainRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateDefaultMailDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a user's current mailbox quota for a specified organization and user.
     * </p>
     *
     * @param updateMailboxQuotaRequest
     * @return A Java Future containing the result of the UpdateMailboxQuota operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UpdateMailboxQuota
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateMailboxQuota" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateMailboxQuotaResponse> updateMailboxQuota(UpdateMailboxQuotaRequest updateMailboxQuotaRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMailboxQuotaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMailboxQuota");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateMailboxQuotaResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateMailboxQuotaResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateMailboxQuotaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateMailboxQuotaRequest, UpdateMailboxQuotaResponse>()
                            .withOperationName("UpdateMailboxQuota")
                            .withMarshaller(new UpdateMailboxQuotaRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateMailboxQuotaRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateMailboxQuotaRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateMailboxQuotaResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a mobile device access rule for the specified Amazon WorkMail organization.
     * </p>
     *
     * @param updateMobileDeviceAccessRuleRequest
     * @return A Java Future containing the result of the UpdateMobileDeviceAccessRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UpdateMobileDeviceAccessRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateMobileDeviceAccessRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateMobileDeviceAccessRuleResponse> updateMobileDeviceAccessRule(
            UpdateMobileDeviceAccessRuleRequest updateMobileDeviceAccessRuleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMobileDeviceAccessRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMobileDeviceAccessRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateMobileDeviceAccessRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateMobileDeviceAccessRuleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateMobileDeviceAccessRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateMobileDeviceAccessRuleRequest, UpdateMobileDeviceAccessRuleResponse>()
                            .withOperationName("UpdateMobileDeviceAccessRule")
                            .withMarshaller(new UpdateMobileDeviceAccessRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateMobileDeviceAccessRuleRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateMobileDeviceAccessRuleRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdateMobileDeviceAccessRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the primary email for a user, group, or resource. The current email is moved into the list of aliases (or
     * swapped between an existing alias and the current primary email), and the email provided in the input is promoted
     * as the primary.
     * </p>
     *
     * @param updatePrimaryEmailAddressRequest
     * @return A Java Future containing the result of the UpdatePrimaryEmailAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EmailAddressInUseException The email address that you're trying to assign is already created for a
     *         different user, group, or resource.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>MailDomainNotFoundException The domain specified is not found in your organization.</li>
     *         <li>MailDomainStateException After a domain has been added to the organization, it must be verified. The
     *         domain is not yet verified.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UpdatePrimaryEmailAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdatePrimaryEmailAddress"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdatePrimaryEmailAddressResponse> updatePrimaryEmailAddress(
            UpdatePrimaryEmailAddressRequest updatePrimaryEmailAddressRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePrimaryEmailAddressRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePrimaryEmailAddress");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdatePrimaryEmailAddressResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdatePrimaryEmailAddressResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdatePrimaryEmailAddressResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePrimaryEmailAddressRequest, UpdatePrimaryEmailAddressResponse>()
                            .withOperationName("UpdatePrimaryEmailAddress")
                            .withMarshaller(new UpdatePrimaryEmailAddressRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updatePrimaryEmailAddressRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updatePrimaryEmailAddressRequest.overrideConfiguration()
                    .orElse(null);
            CompletableFuture<UpdatePrimaryEmailAddressResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates data for the resource. To have the latest information, it must be preceded by a <a>DescribeResource</a>
     * call. The dataset in the request should be the one expected when performing another <code>DescribeResource</code>
     * call.
     * </p>
     *
     * @param updateResourceRequest
     * @return A Java Future containing the result of the UpdateResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidConfigurationException The configuration for a resource isn't valid. A resource must either be
     *         able to auto-respond to requests or have at least one delegate associated that can do so on its behalf.</li>
     *         <li>EmailAddressInUseException The email address that you're trying to assign is already created for a
     *         different user, group, or resource.</li>
     *         <li>MailDomainNotFoundException The domain specified is not found in your organization.</li>
     *         <li>MailDomainStateException After a domain has been added to the organization, it must be verified. The
     *         domain is not yet verified.</li>
     *         <li>NameAvailabilityException The user, group, or resource name isn't unique in Amazon WorkMail.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UpdateResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateResourceResponse> updateResource(UpdateResourceRequest updateResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateResourceRequest, UpdateResourceResponse>()
                            .withOperationName("UpdateResource")
                            .withMarshaller(new UpdateResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateResourceRequest.overrideConfiguration().orElse(null);
            CompletableFuture<UpdateResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(WorkMailException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DirectoryUnavailableException")
                                .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidConfigurationException")
                                .exceptionBuilderSupplier(InvalidConfigurationException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterException")
                                .exceptionBuilderSupplier(InvalidParameterException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MailDomainStateException")
                                .exceptionBuilderSupplier(MailDomainStateException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                                .exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MailDomainNotFoundException")
                                .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                                .exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NameAvailabilityException")
                                .exceptionBuilderSupplier(NameAvailabilityException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EmailAddressInUseException")
                                .exceptionBuilderSupplier(EmailAddressInUseException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                                .exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTagsException")
                                .exceptionBuilderSupplier(TooManyTagsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPasswordException")
                                .exceptionBuilderSupplier(InvalidPasswordException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedOperationException")
                                .exceptionBuilderSupplier(UnsupportedOperationException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EntityNotFoundException")
                                .exceptionBuilderSupplier(EntityNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DirectoryInUseException")
                                .exceptionBuilderSupplier(DirectoryInUseException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MailDomainInUseException")
                                .exceptionBuilderSupplier(MailDomainInUseException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReservedNameException")
                                .exceptionBuilderSupplier(ReservedNameException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OrganizationStateException")
                                .exceptionBuilderSupplier(OrganizationStateException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OrganizationNotFoundException")
                                .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EntityStateException")
                                .exceptionBuilderSupplier(EntityStateException::builder).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends WorkMailRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}
