/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInboundDmarcSettingsResponse extends WorkMailResponse implements
        ToCopyableBuilder<DescribeInboundDmarcSettingsResponse.Builder, DescribeInboundDmarcSettingsResponse> {
    private static final SdkField<Boolean> ENFORCED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enforced").getter(getter(DescribeInboundDmarcSettingsResponse::enforced))
            .setter(setter(Builder::enforced))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enforced").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENFORCED_FIELD));

    private final Boolean enforced;

    private DescribeInboundDmarcSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.enforced = builder.enforced;
    }

    /**
     * <p>
     * Lists the enforcement setting of the applied policy.
     * </p>
     * 
     * @return Lists the enforcement setting of the applied policy.
     */
    public final Boolean enforced() {
        return enforced;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(enforced());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInboundDmarcSettingsResponse)) {
            return false;
        }
        DescribeInboundDmarcSettingsResponse other = (DescribeInboundDmarcSettingsResponse) obj;
        return Objects.equals(enforced(), other.enforced());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInboundDmarcSettingsResponse").add("Enforced", enforced()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enforced":
            return Optional.ofNullable(clazz.cast(enforced()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInboundDmarcSettingsResponse, T> g) {
        return obj -> g.apply((DescribeInboundDmarcSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeInboundDmarcSettingsResponse> {
        /**
         * <p>
         * Lists the enforcement setting of the applied policy.
         * </p>
         * 
         * @param enforced
         *        Lists the enforcement setting of the applied policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enforced(Boolean enforced);
    }

    static final class BuilderImpl extends WorkMailResponse.BuilderImpl implements Builder {
        private Boolean enforced;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInboundDmarcSettingsResponse model) {
            super(model);
            enforced(model.enforced);
        }

        public final Boolean getEnforced() {
            return enforced;
        }

        public final void setEnforced(Boolean enforced) {
            this.enforced = enforced;
        }

        @Override
        @Transient
        public final Builder enforced(Boolean enforced) {
            this.enforced = enforced;
            return this;
        }

        @Override
        public DescribeInboundDmarcSettingsResponse build() {
            return new DescribeInboundDmarcSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
