/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workmail.model.DeviceModelListCopier;
import software.amazon.awssdk.services.workmail.model.DeviceOperatingSystemListCopier;
import software.amazon.awssdk.services.workmail.model.DeviceTypeListCopier;
import software.amazon.awssdk.services.workmail.model.DeviceUserAgentListCopier;
import software.amazon.awssdk.services.workmail.model.MobileDeviceAccessRuleEffect;
import software.amazon.awssdk.services.workmail.model.WorkMailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMobileDeviceAccessRuleRequest
extends WorkMailRequest
implements ToCopyableBuilder<Builder, CreateMobileDeviceAccessRuleRequest> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationId").getter(CreateMobileDeviceAccessRuleRequest.getter(CreateMobileDeviceAccessRuleRequest::organizationId)).setter(CreateMobileDeviceAccessRuleRequest.setter(Builder::organizationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateMobileDeviceAccessRuleRequest.getter(CreateMobileDeviceAccessRuleRequest::clientToken)).setter(CreateMobileDeviceAccessRuleRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateMobileDeviceAccessRuleRequest.getter(CreateMobileDeviceAccessRuleRequest::name)).setter(CreateMobileDeviceAccessRuleRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateMobileDeviceAccessRuleRequest.getter(CreateMobileDeviceAccessRuleRequest::description)).setter(CreateMobileDeviceAccessRuleRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> EFFECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Effect").getter(CreateMobileDeviceAccessRuleRequest.getter(CreateMobileDeviceAccessRuleRequest::effectAsString)).setter(CreateMobileDeviceAccessRuleRequest.setter(Builder::effect)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Effect").build()}).build();
    private static final SdkField<List<String>> DEVICE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeviceTypes").getter(CreateMobileDeviceAccessRuleRequest.getter(CreateMobileDeviceAccessRuleRequest::deviceTypes)).setter(CreateMobileDeviceAccessRuleRequest.setter(Builder::deviceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NOT_DEVICE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NotDeviceTypes").getter(CreateMobileDeviceAccessRuleRequest.getter(CreateMobileDeviceAccessRuleRequest::notDeviceTypes)).setter(CreateMobileDeviceAccessRuleRequest.setter(Builder::notDeviceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotDeviceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DEVICE_MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeviceModels").getter(CreateMobileDeviceAccessRuleRequest.getter(CreateMobileDeviceAccessRuleRequest::deviceModels)).setter(CreateMobileDeviceAccessRuleRequest.setter(Builder::deviceModels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceModels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NOT_DEVICE_MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NotDeviceModels").getter(CreateMobileDeviceAccessRuleRequest.getter(CreateMobileDeviceAccessRuleRequest::notDeviceModels)).setter(CreateMobileDeviceAccessRuleRequest.setter(Builder::notDeviceModels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotDeviceModels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DEVICE_OPERATING_SYSTEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeviceOperatingSystems").getter(CreateMobileDeviceAccessRuleRequest.getter(CreateMobileDeviceAccessRuleRequest::deviceOperatingSystems)).setter(CreateMobileDeviceAccessRuleRequest.setter(Builder::deviceOperatingSystems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceOperatingSystems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NOT_DEVICE_OPERATING_SYSTEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NotDeviceOperatingSystems").getter(CreateMobileDeviceAccessRuleRequest.getter(CreateMobileDeviceAccessRuleRequest::notDeviceOperatingSystems)).setter(CreateMobileDeviceAccessRuleRequest.setter(Builder::notDeviceOperatingSystems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotDeviceOperatingSystems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DEVICE_USER_AGENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeviceUserAgents").getter(CreateMobileDeviceAccessRuleRequest.getter(CreateMobileDeviceAccessRuleRequest::deviceUserAgents)).setter(CreateMobileDeviceAccessRuleRequest.setter(Builder::deviceUserAgents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceUserAgents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NOT_DEVICE_USER_AGENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NotDeviceUserAgents").getter(CreateMobileDeviceAccessRuleRequest.getter(CreateMobileDeviceAccessRuleRequest::notDeviceUserAgents)).setter(CreateMobileDeviceAccessRuleRequest.setter(Builder::notDeviceUserAgents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotDeviceUserAgents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD, CLIENT_TOKEN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, EFFECT_FIELD, DEVICE_TYPES_FIELD, NOT_DEVICE_TYPES_FIELD, DEVICE_MODELS_FIELD, NOT_DEVICE_MODELS_FIELD, DEVICE_OPERATING_SYSTEMS_FIELD, NOT_DEVICE_OPERATING_SYSTEMS_FIELD, DEVICE_USER_AGENTS_FIELD, NOT_DEVICE_USER_AGENTS_FIELD));
    private final String organizationId;
    private final String clientToken;
    private final String name;
    private final String description;
    private final String effect;
    private final List<String> deviceTypes;
    private final List<String> notDeviceTypes;
    private final List<String> deviceModels;
    private final List<String> notDeviceModels;
    private final List<String> deviceOperatingSystems;
    private final List<String> notDeviceOperatingSystems;
    private final List<String> deviceUserAgents;
    private final List<String> notDeviceUserAgents;

    private CreateMobileDeviceAccessRuleRequest(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.clientToken = builder.clientToken;
        this.name = builder.name;
        this.description = builder.description;
        this.effect = builder.effect;
        this.deviceTypes = builder.deviceTypes;
        this.notDeviceTypes = builder.notDeviceTypes;
        this.deviceModels = builder.deviceModels;
        this.notDeviceModels = builder.notDeviceModels;
        this.deviceOperatingSystems = builder.deviceOperatingSystems;
        this.notDeviceOperatingSystems = builder.notDeviceOperatingSystems;
        this.deviceUserAgents = builder.deviceUserAgents;
        this.notDeviceUserAgents = builder.notDeviceUserAgents;
    }

    public final String organizationId() {
        return this.organizationId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final MobileDeviceAccessRuleEffect effect() {
        return MobileDeviceAccessRuleEffect.fromValue(this.effect);
    }

    public final String effectAsString() {
        return this.effect;
    }

    public final boolean hasDeviceTypes() {
        return this.deviceTypes != null && !(this.deviceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> deviceTypes() {
        return this.deviceTypes;
    }

    public final boolean hasNotDeviceTypes() {
        return this.notDeviceTypes != null && !(this.notDeviceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> notDeviceTypes() {
        return this.notDeviceTypes;
    }

    public final boolean hasDeviceModels() {
        return this.deviceModels != null && !(this.deviceModels instanceof SdkAutoConstructList);
    }

    public final List<String> deviceModels() {
        return this.deviceModels;
    }

    public final boolean hasNotDeviceModels() {
        return this.notDeviceModels != null && !(this.notDeviceModels instanceof SdkAutoConstructList);
    }

    public final List<String> notDeviceModels() {
        return this.notDeviceModels;
    }

    public final boolean hasDeviceOperatingSystems() {
        return this.deviceOperatingSystems != null && !(this.deviceOperatingSystems instanceof SdkAutoConstructList);
    }

    public final List<String> deviceOperatingSystems() {
        return this.deviceOperatingSystems;
    }

    public final boolean hasNotDeviceOperatingSystems() {
        return this.notDeviceOperatingSystems != null && !(this.notDeviceOperatingSystems instanceof SdkAutoConstructList);
    }

    public final List<String> notDeviceOperatingSystems() {
        return this.notDeviceOperatingSystems;
    }

    public final boolean hasDeviceUserAgents() {
        return this.deviceUserAgents != null && !(this.deviceUserAgents instanceof SdkAutoConstructList);
    }

    public final List<String> deviceUserAgents() {
        return this.deviceUserAgents;
    }

    public final boolean hasNotDeviceUserAgents() {
        return this.notDeviceUserAgents != null && !(this.notDeviceUserAgents instanceof SdkAutoConstructList);
    }

    public final List<String> notDeviceUserAgents() {
        return this.notDeviceUserAgents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeviceTypes() ? this.deviceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotDeviceTypes() ? this.notDeviceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeviceModels() ? this.deviceModels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotDeviceModels() ? this.notDeviceModels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeviceOperatingSystems() ? this.deviceOperatingSystems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotDeviceOperatingSystems() ? this.notDeviceOperatingSystems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeviceUserAgents() ? this.deviceUserAgents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotDeviceUserAgents() ? this.notDeviceUserAgents() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMobileDeviceAccessRuleRequest)) {
            return false;
        }
        CreateMobileDeviceAccessRuleRequest other = (CreateMobileDeviceAccessRuleRequest)((Object)obj);
        return Objects.equals(this.organizationId(), other.organizationId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.effectAsString(), other.effectAsString()) && this.hasDeviceTypes() == other.hasDeviceTypes() && Objects.equals(this.deviceTypes(), other.deviceTypes()) && this.hasNotDeviceTypes() == other.hasNotDeviceTypes() && Objects.equals(this.notDeviceTypes(), other.notDeviceTypes()) && this.hasDeviceModels() == other.hasDeviceModels() && Objects.equals(this.deviceModels(), other.deviceModels()) && this.hasNotDeviceModels() == other.hasNotDeviceModels() && Objects.equals(this.notDeviceModels(), other.notDeviceModels()) && this.hasDeviceOperatingSystems() == other.hasDeviceOperatingSystems() && Objects.equals(this.deviceOperatingSystems(), other.deviceOperatingSystems()) && this.hasNotDeviceOperatingSystems() == other.hasNotDeviceOperatingSystems() && Objects.equals(this.notDeviceOperatingSystems(), other.notDeviceOperatingSystems()) && this.hasDeviceUserAgents() == other.hasDeviceUserAgents() && Objects.equals(this.deviceUserAgents(), other.deviceUserAgents()) && this.hasNotDeviceUserAgents() == other.hasNotDeviceUserAgents() && Objects.equals(this.notDeviceUserAgents(), other.notDeviceUserAgents());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMobileDeviceAccessRuleRequest").add("OrganizationId", (Object)this.organizationId()).add("ClientToken", (Object)this.clientToken()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Effect", (Object)this.effectAsString()).add("DeviceTypes", this.hasDeviceTypes() ? this.deviceTypes() : null).add("NotDeviceTypes", this.hasNotDeviceTypes() ? this.notDeviceTypes() : null).add("DeviceModels", this.hasDeviceModels() ? this.deviceModels() : null).add("NotDeviceModels", this.hasNotDeviceModels() ? this.notDeviceModels() : null).add("DeviceOperatingSystems", this.hasDeviceOperatingSystems() ? this.deviceOperatingSystems() : null).add("NotDeviceOperatingSystems", this.hasNotDeviceOperatingSystems() ? this.notDeviceOperatingSystems() : null).add("DeviceUserAgents", this.hasDeviceUserAgents() ? this.deviceUserAgents() : null).add("NotDeviceUserAgents", this.hasNotDeviceUserAgents() ? this.notDeviceUserAgents() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationId": {
                return Optional.ofNullable(clazz.cast(this.organizationId()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Effect": {
                return Optional.ofNullable(clazz.cast(this.effectAsString()));
            }
            case "DeviceTypes": {
                return Optional.ofNullable(clazz.cast(this.deviceTypes()));
            }
            case "NotDeviceTypes": {
                return Optional.ofNullable(clazz.cast(this.notDeviceTypes()));
            }
            case "DeviceModels": {
                return Optional.ofNullable(clazz.cast(this.deviceModels()));
            }
            case "NotDeviceModels": {
                return Optional.ofNullable(clazz.cast(this.notDeviceModels()));
            }
            case "DeviceOperatingSystems": {
                return Optional.ofNullable(clazz.cast(this.deviceOperatingSystems()));
            }
            case "NotDeviceOperatingSystems": {
                return Optional.ofNullable(clazz.cast(this.notDeviceOperatingSystems()));
            }
            case "DeviceUserAgents": {
                return Optional.ofNullable(clazz.cast(this.deviceUserAgents()));
            }
            case "NotDeviceUserAgents": {
                return Optional.ofNullable(clazz.cast(this.notDeviceUserAgents()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMobileDeviceAccessRuleRequest, T> g) {
        return obj -> g.apply((CreateMobileDeviceAccessRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailRequest.BuilderImpl
    implements Builder {
        private String organizationId;
        private String clientToken;
        private String name;
        private String description;
        private String effect;
        private List<String> deviceTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> notDeviceTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> deviceModels = DefaultSdkAutoConstructList.getInstance();
        private List<String> notDeviceModels = DefaultSdkAutoConstructList.getInstance();
        private List<String> deviceOperatingSystems = DefaultSdkAutoConstructList.getInstance();
        private List<String> notDeviceOperatingSystems = DefaultSdkAutoConstructList.getInstance();
        private List<String> deviceUserAgents = DefaultSdkAutoConstructList.getInstance();
        private List<String> notDeviceUserAgents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMobileDeviceAccessRuleRequest model) {
            super(model);
            this.organizationId(model.organizationId);
            this.clientToken(model.clientToken);
            this.name(model.name);
            this.description(model.description);
            this.effect(model.effect);
            this.deviceTypes(model.deviceTypes);
            this.notDeviceTypes(model.notDeviceTypes);
            this.deviceModels(model.deviceModels);
            this.notDeviceModels(model.notDeviceModels);
            this.deviceOperatingSystems(model.deviceOperatingSystems);
            this.notDeviceOperatingSystems(model.notDeviceOperatingSystems);
            this.deviceUserAgents(model.deviceUserAgents);
            this.notDeviceUserAgents(model.notDeviceUserAgents);
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        @Transient
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEffect() {
            return this.effect;
        }

        public final void setEffect(String effect) {
            this.effect = effect;
        }

        @Override
        @Transient
        public final Builder effect(String effect) {
            this.effect = effect;
            return this;
        }

        @Override
        @Transient
        public final Builder effect(MobileDeviceAccessRuleEffect effect) {
            this.effect(effect == null ? null : effect.toString());
            return this;
        }

        public final Collection<String> getDeviceTypes() {
            if (this.deviceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deviceTypes;
        }

        public final void setDeviceTypes(Collection<String> deviceTypes) {
            this.deviceTypes = DeviceTypeListCopier.copy(deviceTypes);
        }

        @Override
        @Transient
        public final Builder deviceTypes(Collection<String> deviceTypes) {
            this.deviceTypes = DeviceTypeListCopier.copy(deviceTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder deviceTypes(String ... deviceTypes) {
            this.deviceTypes(Arrays.asList(deviceTypes));
            return this;
        }

        public final Collection<String> getNotDeviceTypes() {
            if (this.notDeviceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.notDeviceTypes;
        }

        public final void setNotDeviceTypes(Collection<String> notDeviceTypes) {
            this.notDeviceTypes = DeviceTypeListCopier.copy(notDeviceTypes);
        }

        @Override
        @Transient
        public final Builder notDeviceTypes(Collection<String> notDeviceTypes) {
            this.notDeviceTypes = DeviceTypeListCopier.copy(notDeviceTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder notDeviceTypes(String ... notDeviceTypes) {
            this.notDeviceTypes(Arrays.asList(notDeviceTypes));
            return this;
        }

        public final Collection<String> getDeviceModels() {
            if (this.deviceModels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deviceModels;
        }

        public final void setDeviceModels(Collection<String> deviceModels) {
            this.deviceModels = DeviceModelListCopier.copy(deviceModels);
        }

        @Override
        @Transient
        public final Builder deviceModels(Collection<String> deviceModels) {
            this.deviceModels = DeviceModelListCopier.copy(deviceModels);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder deviceModels(String ... deviceModels) {
            this.deviceModels(Arrays.asList(deviceModels));
            return this;
        }

        public final Collection<String> getNotDeviceModels() {
            if (this.notDeviceModels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.notDeviceModels;
        }

        public final void setNotDeviceModels(Collection<String> notDeviceModels) {
            this.notDeviceModels = DeviceModelListCopier.copy(notDeviceModels);
        }

        @Override
        @Transient
        public final Builder notDeviceModels(Collection<String> notDeviceModels) {
            this.notDeviceModels = DeviceModelListCopier.copy(notDeviceModels);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder notDeviceModels(String ... notDeviceModels) {
            this.notDeviceModels(Arrays.asList(notDeviceModels));
            return this;
        }

        public final Collection<String> getDeviceOperatingSystems() {
            if (this.deviceOperatingSystems instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deviceOperatingSystems;
        }

        public final void setDeviceOperatingSystems(Collection<String> deviceOperatingSystems) {
            this.deviceOperatingSystems = DeviceOperatingSystemListCopier.copy(deviceOperatingSystems);
        }

        @Override
        @Transient
        public final Builder deviceOperatingSystems(Collection<String> deviceOperatingSystems) {
            this.deviceOperatingSystems = DeviceOperatingSystemListCopier.copy(deviceOperatingSystems);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder deviceOperatingSystems(String ... deviceOperatingSystems) {
            this.deviceOperatingSystems(Arrays.asList(deviceOperatingSystems));
            return this;
        }

        public final Collection<String> getNotDeviceOperatingSystems() {
            if (this.notDeviceOperatingSystems instanceof SdkAutoConstructList) {
                return null;
            }
            return this.notDeviceOperatingSystems;
        }

        public final void setNotDeviceOperatingSystems(Collection<String> notDeviceOperatingSystems) {
            this.notDeviceOperatingSystems = DeviceOperatingSystemListCopier.copy(notDeviceOperatingSystems);
        }

        @Override
        @Transient
        public final Builder notDeviceOperatingSystems(Collection<String> notDeviceOperatingSystems) {
            this.notDeviceOperatingSystems = DeviceOperatingSystemListCopier.copy(notDeviceOperatingSystems);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder notDeviceOperatingSystems(String ... notDeviceOperatingSystems) {
            this.notDeviceOperatingSystems(Arrays.asList(notDeviceOperatingSystems));
            return this;
        }

        public final Collection<String> getDeviceUserAgents() {
            if (this.deviceUserAgents instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deviceUserAgents;
        }

        public final void setDeviceUserAgents(Collection<String> deviceUserAgents) {
            this.deviceUserAgents = DeviceUserAgentListCopier.copy(deviceUserAgents);
        }

        @Override
        @Transient
        public final Builder deviceUserAgents(Collection<String> deviceUserAgents) {
            this.deviceUserAgents = DeviceUserAgentListCopier.copy(deviceUserAgents);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder deviceUserAgents(String ... deviceUserAgents) {
            this.deviceUserAgents(Arrays.asList(deviceUserAgents));
            return this;
        }

        public final Collection<String> getNotDeviceUserAgents() {
            if (this.notDeviceUserAgents instanceof SdkAutoConstructList) {
                return null;
            }
            return this.notDeviceUserAgents;
        }

        public final void setNotDeviceUserAgents(Collection<String> notDeviceUserAgents) {
            this.notDeviceUserAgents = DeviceUserAgentListCopier.copy(notDeviceUserAgents);
        }

        @Override
        @Transient
        public final Builder notDeviceUserAgents(Collection<String> notDeviceUserAgents) {
            this.notDeviceUserAgents = DeviceUserAgentListCopier.copy(notDeviceUserAgents);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder notDeviceUserAgents(String ... notDeviceUserAgents) {
            this.notDeviceUserAgents(Arrays.asList(notDeviceUserAgents));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMobileDeviceAccessRuleRequest build() {
            return new CreateMobileDeviceAccessRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkMailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMobileDeviceAccessRuleRequest> {
        public Builder organizationId(String var1);

        public Builder clientToken(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder effect(String var1);

        public Builder effect(MobileDeviceAccessRuleEffect var1);

        public Builder deviceTypes(Collection<String> var1);

        public Builder deviceTypes(String ... var1);

        public Builder notDeviceTypes(Collection<String> var1);

        public Builder notDeviceTypes(String ... var1);

        public Builder deviceModels(Collection<String> var1);

        public Builder deviceModels(String ... var1);

        public Builder notDeviceModels(Collection<String> var1);

        public Builder notDeviceModels(String ... var1);

        public Builder deviceOperatingSystems(Collection<String> var1);

        public Builder deviceOperatingSystems(String ... var1);

        public Builder notDeviceOperatingSystems(Collection<String> var1);

        public Builder notDeviceOperatingSystems(String ... var1);

        public Builder deviceUserAgents(Collection<String> var1);

        public Builder deviceUserAgents(String ... var1);

        public Builder notDeviceUserAgents(Collection<String> var1);

        public Builder notDeviceUserAgents(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

