/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workmail.model.MailDomainSummary;
import software.amazon.awssdk.services.workmail.model.MailDomainsCopier;
import software.amazon.awssdk.services.workmail.model.WorkMailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMailDomainsResponse
extends WorkMailResponse
implements ToCopyableBuilder<Builder, ListMailDomainsResponse> {
    private static final SdkField<List<MailDomainSummary>> MAIL_DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MailDomains").getter(ListMailDomainsResponse.getter(ListMailDomainsResponse::mailDomains)).setter(ListMailDomainsResponse.setter(Builder::mailDomains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailDomains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MailDomainSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMailDomainsResponse.getter(ListMailDomainsResponse::nextToken)).setter(ListMailDomainsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAIL_DOMAINS_FIELD, NEXT_TOKEN_FIELD));
    private final List<MailDomainSummary> mailDomains;
    private final String nextToken;

    private ListMailDomainsResponse(BuilderImpl builder) {
        super(builder);
        this.mailDomains = builder.mailDomains;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMailDomains() {
        return this.mailDomains != null && !(this.mailDomains instanceof SdkAutoConstructList);
    }

    public final List<MailDomainSummary> mailDomains() {
        return this.mailDomains;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMailDomains() ? this.mailDomains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMailDomainsResponse)) {
            return false;
        }
        ListMailDomainsResponse other = (ListMailDomainsResponse)((Object)obj);
        return this.hasMailDomains() == other.hasMailDomains() && Objects.equals(this.mailDomains(), other.mailDomains()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListMailDomainsResponse").add("MailDomains", this.hasMailDomains() ? this.mailDomains() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MailDomains": {
                return Optional.ofNullable(clazz.cast(this.mailDomains()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMailDomainsResponse, T> g) {
        return obj -> g.apply((ListMailDomainsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailResponse.BuilderImpl
    implements Builder {
        private List<MailDomainSummary> mailDomains = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMailDomainsResponse model) {
            super(model);
            this.mailDomains(model.mailDomains);
            this.nextToken(model.nextToken);
        }

        public final List<MailDomainSummary.Builder> getMailDomains() {
            List<MailDomainSummary.Builder> result = MailDomainsCopier.copyToBuilder(this.mailDomains);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMailDomains(Collection<MailDomainSummary.BuilderImpl> mailDomains) {
            this.mailDomains = MailDomainsCopier.copyFromBuilder(mailDomains);
        }

        @Override
        @Transient
        public final Builder mailDomains(Collection<MailDomainSummary> mailDomains) {
            this.mailDomains = MailDomainsCopier.copy(mailDomains);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder mailDomains(MailDomainSummary ... mailDomains) {
            this.mailDomains(Arrays.asList(mailDomains));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder mailDomains(Consumer<MailDomainSummary.Builder> ... mailDomains) {
            this.mailDomains(Stream.of(mailDomains).map(c -> (MailDomainSummary)((MailDomainSummary.Builder)MailDomainSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMailDomainsResponse build() {
            return new ListMailDomainsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkMailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMailDomainsResponse> {
        public Builder mailDomains(Collection<MailDomainSummary> var1);

        public Builder mailDomains(MailDomainSummary ... var1);

        public Builder mailDomains(Consumer<MailDomainSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

