/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workmail.WorkMailAsyncClient;
import software.amazon.awssdk.services.workmail.model.AvailabilityConfiguration;
import software.amazon.awssdk.services.workmail.model.ListAvailabilityConfigurationsRequest;
import software.amazon.awssdk.services.workmail.model.ListAvailabilityConfigurationsResponse;

public class ListAvailabilityConfigurationsPublisher
implements SdkPublisher<ListAvailabilityConfigurationsResponse> {
    private final WorkMailAsyncClient client;
    private final ListAvailabilityConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAvailabilityConfigurationsPublisher(WorkMailAsyncClient client, ListAvailabilityConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAvailabilityConfigurationsPublisher(WorkMailAsyncClient client, ListAvailabilityConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAvailabilityConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAvailabilityConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AvailabilityConfiguration> availabilityConfigurations() {
        Function<ListAvailabilityConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.availabilityConfigurations() != null) {
                return response.availabilityConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAvailabilityConfigurationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAvailabilityConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListAvailabilityConfigurationsResponse> {
        private ListAvailabilityConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListAvailabilityConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAvailabilityConfigurationsResponse> nextPage(ListAvailabilityConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListAvailabilityConfigurationsPublisher.this.client.listAvailabilityConfigurations(ListAvailabilityConfigurationsPublisher.this.firstRequest);
            }
            return ListAvailabilityConfigurationsPublisher.this.client.listAvailabilityConfigurations((ListAvailabilityConfigurationsRequest)((Object)ListAvailabilityConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

