/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workmail.WorkMailAsyncClient;
import software.amazon.awssdk.services.workmail.model.ListImpersonationRolesRequest;
import software.amazon.awssdk.services.workmail.model.ListImpersonationRolesResponse;

public class ListImpersonationRolesPublisher
implements SdkPublisher<ListImpersonationRolesResponse> {
    private final WorkMailAsyncClient client;
    private final ListImpersonationRolesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListImpersonationRolesPublisher(WorkMailAsyncClient client, ListImpersonationRolesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListImpersonationRolesPublisher(WorkMailAsyncClient client, ListImpersonationRolesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListImpersonationRolesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListImpersonationRolesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListImpersonationRolesResponseFetcher
    implements AsyncPageFetcher<ListImpersonationRolesResponse> {
        private ListImpersonationRolesResponseFetcher() {
        }

        public boolean hasNextPage(ListImpersonationRolesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListImpersonationRolesResponse> nextPage(ListImpersonationRolesResponse previousPage) {
            if (previousPage == null) {
                return ListImpersonationRolesPublisher.this.client.listImpersonationRoles(ListImpersonationRolesPublisher.this.firstRequest);
            }
            return ListImpersonationRolesPublisher.this.client.listImpersonationRoles((ListImpersonationRolesRequest)((Object)ListImpersonationRolesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

