/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workmail.model.AccessEffect;
import software.amazon.awssdk.services.workmail.model.TargetUsersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImpersonationRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImpersonationRule> {
    private static final SdkField<String> IMPERSONATION_RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImpersonationRuleId").getter(ImpersonationRule.getter(ImpersonationRule::impersonationRuleId)).setter(ImpersonationRule.setter(Builder::impersonationRuleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImpersonationRuleId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ImpersonationRule.getter(ImpersonationRule::name)).setter(ImpersonationRule.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ImpersonationRule.getter(ImpersonationRule::description)).setter(ImpersonationRule.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> EFFECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Effect").getter(ImpersonationRule.getter(ImpersonationRule::effectAsString)).setter(ImpersonationRule.setter(Builder::effect)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Effect").build()}).build();
    private static final SdkField<List<String>> TARGET_USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetUsers").getter(ImpersonationRule.getter(ImpersonationRule::targetUsers)).setter(ImpersonationRule.setter(Builder::targetUsers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetUsers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NOT_TARGET_USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NotTargetUsers").getter(ImpersonationRule.getter(ImpersonationRule::notTargetUsers)).setter(ImpersonationRule.setter(Builder::notTargetUsers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotTargetUsers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPERSONATION_RULE_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, EFFECT_FIELD, TARGET_USERS_FIELD, NOT_TARGET_USERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String impersonationRuleId;
    private final String name;
    private final String description;
    private final String effect;
    private final List<String> targetUsers;
    private final List<String> notTargetUsers;

    private ImpersonationRule(BuilderImpl builder) {
        this.impersonationRuleId = builder.impersonationRuleId;
        this.name = builder.name;
        this.description = builder.description;
        this.effect = builder.effect;
        this.targetUsers = builder.targetUsers;
        this.notTargetUsers = builder.notTargetUsers;
    }

    public final String impersonationRuleId() {
        return this.impersonationRuleId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final AccessEffect effect() {
        return AccessEffect.fromValue(this.effect);
    }

    public final String effectAsString() {
        return this.effect;
    }

    public final boolean hasTargetUsers() {
        return this.targetUsers != null && !(this.targetUsers instanceof SdkAutoConstructList);
    }

    public final List<String> targetUsers() {
        return this.targetUsers;
    }

    public final boolean hasNotTargetUsers() {
        return this.notTargetUsers != null && !(this.notTargetUsers instanceof SdkAutoConstructList);
    }

    public final List<String> notTargetUsers() {
        return this.notTargetUsers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.impersonationRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetUsers() ? this.targetUsers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotTargetUsers() ? this.notTargetUsers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImpersonationRule)) {
            return false;
        }
        ImpersonationRule other = (ImpersonationRule)obj;
        return Objects.equals(this.impersonationRuleId(), other.impersonationRuleId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.effectAsString(), other.effectAsString()) && this.hasTargetUsers() == other.hasTargetUsers() && Objects.equals(this.targetUsers(), other.targetUsers()) && this.hasNotTargetUsers() == other.hasNotTargetUsers() && Objects.equals(this.notTargetUsers(), other.notTargetUsers());
    }

    public final String toString() {
        return ToString.builder((String)"ImpersonationRule").add("ImpersonationRuleId", (Object)this.impersonationRuleId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Effect", (Object)this.effectAsString()).add("TargetUsers", this.hasTargetUsers() ? this.targetUsers() : null).add("NotTargetUsers", this.hasNotTargetUsers() ? this.notTargetUsers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImpersonationRuleId": {
                return Optional.ofNullable(clazz.cast(this.impersonationRuleId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Effect": {
                return Optional.ofNullable(clazz.cast(this.effectAsString()));
            }
            case "TargetUsers": {
                return Optional.ofNullable(clazz.cast(this.targetUsers()));
            }
            case "NotTargetUsers": {
                return Optional.ofNullable(clazz.cast(this.notTargetUsers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImpersonationRule, T> g) {
        return obj -> g.apply((ImpersonationRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String impersonationRuleId;
        private String name;
        private String description;
        private String effect;
        private List<String> targetUsers = DefaultSdkAutoConstructList.getInstance();
        private List<String> notTargetUsers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImpersonationRule model) {
            this.impersonationRuleId(model.impersonationRuleId);
            this.name(model.name);
            this.description(model.description);
            this.effect(model.effect);
            this.targetUsers(model.targetUsers);
            this.notTargetUsers(model.notTargetUsers);
        }

        public final String getImpersonationRuleId() {
            return this.impersonationRuleId;
        }

        public final void setImpersonationRuleId(String impersonationRuleId) {
            this.impersonationRuleId = impersonationRuleId;
        }

        @Override
        public final Builder impersonationRuleId(String impersonationRuleId) {
            this.impersonationRuleId = impersonationRuleId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEffect() {
            return this.effect;
        }

        public final void setEffect(String effect) {
            this.effect = effect;
        }

        @Override
        public final Builder effect(String effect) {
            this.effect = effect;
            return this;
        }

        @Override
        public final Builder effect(AccessEffect effect) {
            this.effect(effect == null ? null : effect.toString());
            return this;
        }

        public final Collection<String> getTargetUsers() {
            if (this.targetUsers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetUsers;
        }

        public final void setTargetUsers(Collection<String> targetUsers) {
            this.targetUsers = TargetUsersCopier.copy(targetUsers);
        }

        @Override
        public final Builder targetUsers(Collection<String> targetUsers) {
            this.targetUsers = TargetUsersCopier.copy(targetUsers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetUsers(String ... targetUsers) {
            this.targetUsers(Arrays.asList(targetUsers));
            return this;
        }

        public final Collection<String> getNotTargetUsers() {
            if (this.notTargetUsers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.notTargetUsers;
        }

        public final void setNotTargetUsers(Collection<String> notTargetUsers) {
            this.notTargetUsers = TargetUsersCopier.copy(notTargetUsers);
        }

        @Override
        public final Builder notTargetUsers(Collection<String> notTargetUsers) {
            this.notTargetUsers = TargetUsersCopier.copy(notTargetUsers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notTargetUsers(String ... notTargetUsers) {
            this.notTargetUsers(Arrays.asList(notTargetUsers));
            return this;
        }

        public ImpersonationRule build() {
            return new ImpersonationRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImpersonationRule> {
        public Builder impersonationRuleId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder effect(String var1);

        public Builder effect(AccessEffect var1);

        public Builder targetUsers(Collection<String> var1);

        public Builder targetUsers(String ... var1);

        public Builder notTargetUsers(Collection<String> var1);

        public Builder notTargetUsers(String ... var1);
    }
}

