/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data for a given domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MailDomainSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<MailDomainSummary.Builder, MailDomainSummary> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(MailDomainSummary::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<Boolean> DEFAULT_DOMAIN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DefaultDomain").getter(getter(MailDomainSummary::defaultDomain)).setter(setter(Builder::defaultDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultDomain").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            DEFAULT_DOMAIN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String domainName;

    private final Boolean defaultDomain;

    private MailDomainSummary(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.defaultDomain = builder.defaultDomain;
    }

    /**
     * <p>
     * The domain name.
     * </p>
     * 
     * @return The domain name.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Whether the domain is default or not.
     * </p>
     * 
     * @return Whether the domain is default or not.
     */
    public final Boolean defaultDomain() {
        return defaultDomain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(defaultDomain());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MailDomainSummary)) {
            return false;
        }
        MailDomainSummary other = (MailDomainSummary) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(defaultDomain(), other.defaultDomain());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MailDomainSummary").add("DomainName", domainName()).add("DefaultDomain", defaultDomain())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "DefaultDomain":
            return Optional.ofNullable(clazz.cast(defaultDomain()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MailDomainSummary, T> g) {
        return obj -> g.apply((MailDomainSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MailDomainSummary> {
        /**
         * <p>
         * The domain name.
         * </p>
         * 
         * @param domainName
         *        The domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Whether the domain is default or not.
         * </p>
         * 
         * @param defaultDomain
         *        Whether the domain is default or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultDomain(Boolean defaultDomain);
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private Boolean defaultDomain;

        private BuilderImpl() {
        }

        private BuilderImpl(MailDomainSummary model) {
            domainName(model.domainName);
            defaultDomain(model.defaultDomain);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Boolean getDefaultDomain() {
            return defaultDomain;
        }

        public final void setDefaultDomain(Boolean defaultDomain) {
            this.defaultDomain = defaultDomain;
        }

        @Override
        public final Builder defaultDomain(Boolean defaultDomain) {
            this.defaultDomain = defaultDomain;
            return this;
        }

        @Override
        public MailDomainSummary build() {
            return new MailDomainSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
