/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * At least one delegate must be associated to the resource to disable automatic replies from the resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BookingOptions implements SdkPojo, Serializable, ToCopyableBuilder<BookingOptions.Builder, BookingOptions> {
    private static final SdkField<Boolean> AUTO_ACCEPT_REQUESTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoAcceptRequests").getter(getter(BookingOptions::autoAcceptRequests))
            .setter(setter(Builder::autoAcceptRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoAcceptRequests").build())
            .build();

    private static final SdkField<Boolean> AUTO_DECLINE_RECURRING_REQUESTS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoDeclineRecurringRequests")
            .getter(getter(BookingOptions::autoDeclineRecurringRequests))
            .setter(setter(Builder::autoDeclineRecurringRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoDeclineRecurringRequests")
                    .build()).build();

    private static final SdkField<Boolean> AUTO_DECLINE_CONFLICTING_REQUESTS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoDeclineConflictingRequests")
            .getter(getter(BookingOptions::autoDeclineConflictingRequests))
            .setter(setter(Builder::autoDeclineConflictingRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoDeclineConflictingRequests")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ACCEPT_REQUESTS_FIELD,
            AUTO_DECLINE_RECURRING_REQUESTS_FIELD, AUTO_DECLINE_CONFLICTING_REQUESTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean autoAcceptRequests;

    private final Boolean autoDeclineRecurringRequests;

    private final Boolean autoDeclineConflictingRequests;

    private BookingOptions(BuilderImpl builder) {
        this.autoAcceptRequests = builder.autoAcceptRequests;
        this.autoDeclineRecurringRequests = builder.autoDeclineRecurringRequests;
        this.autoDeclineConflictingRequests = builder.autoDeclineConflictingRequests;
    }

    /**
     * <p>
     * The resource's ability to automatically reply to requests. If disabled, delegates must be associated to the
     * resource.
     * </p>
     * 
     * @return The resource's ability to automatically reply to requests. If disabled, delegates must be associated to
     *         the resource.
     */
    public final Boolean autoAcceptRequests() {
        return autoAcceptRequests;
    }

    /**
     * <p>
     * The resource's ability to automatically decline any recurring requests.
     * </p>
     * 
     * @return The resource's ability to automatically decline any recurring requests.
     */
    public final Boolean autoDeclineRecurringRequests() {
        return autoDeclineRecurringRequests;
    }

    /**
     * <p>
     * The resource's ability to automatically decline any conflicting requests.
     * </p>
     * 
     * @return The resource's ability to automatically decline any conflicting requests.
     */
    public final Boolean autoDeclineConflictingRequests() {
        return autoDeclineConflictingRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoAcceptRequests());
        hashCode = 31 * hashCode + Objects.hashCode(autoDeclineRecurringRequests());
        hashCode = 31 * hashCode + Objects.hashCode(autoDeclineConflictingRequests());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BookingOptions)) {
            return false;
        }
        BookingOptions other = (BookingOptions) obj;
        return Objects.equals(autoAcceptRequests(), other.autoAcceptRequests())
                && Objects.equals(autoDeclineRecurringRequests(), other.autoDeclineRecurringRequests())
                && Objects.equals(autoDeclineConflictingRequests(), other.autoDeclineConflictingRequests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BookingOptions").add("AutoAcceptRequests", autoAcceptRequests())
                .add("AutoDeclineRecurringRequests", autoDeclineRecurringRequests())
                .add("AutoDeclineConflictingRequests", autoDeclineConflictingRequests()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoAcceptRequests":
            return Optional.ofNullable(clazz.cast(autoAcceptRequests()));
        case "AutoDeclineRecurringRequests":
            return Optional.ofNullable(clazz.cast(autoDeclineRecurringRequests()));
        case "AutoDeclineConflictingRequests":
            return Optional.ofNullable(clazz.cast(autoDeclineConflictingRequests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BookingOptions, T> g) {
        return obj -> g.apply((BookingOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BookingOptions> {
        /**
         * <p>
         * The resource's ability to automatically reply to requests. If disabled, delegates must be associated to the
         * resource.
         * </p>
         * 
         * @param autoAcceptRequests
         *        The resource's ability to automatically reply to requests. If disabled, delegates must be associated
         *        to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoAcceptRequests(Boolean autoAcceptRequests);

        /**
         * <p>
         * The resource's ability to automatically decline any recurring requests.
         * </p>
         * 
         * @param autoDeclineRecurringRequests
         *        The resource's ability to automatically decline any recurring requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoDeclineRecurringRequests(Boolean autoDeclineRecurringRequests);

        /**
         * <p>
         * The resource's ability to automatically decline any conflicting requests.
         * </p>
         * 
         * @param autoDeclineConflictingRequests
         *        The resource's ability to automatically decline any conflicting requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoDeclineConflictingRequests(Boolean autoDeclineConflictingRequests);
    }

    static final class BuilderImpl implements Builder {
        private Boolean autoAcceptRequests;

        private Boolean autoDeclineRecurringRequests;

        private Boolean autoDeclineConflictingRequests;

        private BuilderImpl() {
        }

        private BuilderImpl(BookingOptions model) {
            autoAcceptRequests(model.autoAcceptRequests);
            autoDeclineRecurringRequests(model.autoDeclineRecurringRequests);
            autoDeclineConflictingRequests(model.autoDeclineConflictingRequests);
        }

        public final Boolean getAutoAcceptRequests() {
            return autoAcceptRequests;
        }

        public final void setAutoAcceptRequests(Boolean autoAcceptRequests) {
            this.autoAcceptRequests = autoAcceptRequests;
        }

        @Override
        public final Builder autoAcceptRequests(Boolean autoAcceptRequests) {
            this.autoAcceptRequests = autoAcceptRequests;
            return this;
        }

        public final Boolean getAutoDeclineRecurringRequests() {
            return autoDeclineRecurringRequests;
        }

        public final void setAutoDeclineRecurringRequests(Boolean autoDeclineRecurringRequests) {
            this.autoDeclineRecurringRequests = autoDeclineRecurringRequests;
        }

        @Override
        public final Builder autoDeclineRecurringRequests(Boolean autoDeclineRecurringRequests) {
            this.autoDeclineRecurringRequests = autoDeclineRecurringRequests;
            return this;
        }

        public final Boolean getAutoDeclineConflictingRequests() {
            return autoDeclineConflictingRequests;
        }

        public final void setAutoDeclineConflictingRequests(Boolean autoDeclineConflictingRequests) {
            this.autoDeclineConflictingRequests = autoDeclineConflictingRequests;
        }

        @Override
        public final Builder autoDeclineConflictingRequests(Boolean autoDeclineConflictingRequests) {
            this.autoDeclineConflictingRequests = autoDeclineConflictingRequests;
            return this;
        }

        @Override
        public BookingOptions build() {
            return new BookingOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
