/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workmail.model.EwsAvailabilityProvider;
import software.amazon.awssdk.services.workmail.model.LambdaAvailabilityProvider;
import software.amazon.awssdk.services.workmail.model.WorkMailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAvailabilityConfigurationRequest
extends WorkMailRequest
implements ToCopyableBuilder<Builder, CreateAvailabilityConfigurationRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateAvailabilityConfigurationRequest.getter(CreateAvailabilityConfigurationRequest::clientToken)).setter(CreateAvailabilityConfigurationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationId").getter(CreateAvailabilityConfigurationRequest.getter(CreateAvailabilityConfigurationRequest::organizationId)).setter(CreateAvailabilityConfigurationRequest.setter(Builder::organizationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(CreateAvailabilityConfigurationRequest.getter(CreateAvailabilityConfigurationRequest::domainName)).setter(CreateAvailabilityConfigurationRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<EwsAvailabilityProvider> EWS_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EwsProvider").getter(CreateAvailabilityConfigurationRequest.getter(CreateAvailabilityConfigurationRequest::ewsProvider)).setter(CreateAvailabilityConfigurationRequest.setter(Builder::ewsProvider)).constructor(EwsAvailabilityProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EwsProvider").build()}).build();
    private static final SdkField<LambdaAvailabilityProvider> LAMBDA_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LambdaProvider").getter(CreateAvailabilityConfigurationRequest.getter(CreateAvailabilityConfigurationRequest::lambdaProvider)).setter(CreateAvailabilityConfigurationRequest.setter(Builder::lambdaProvider)).constructor(LambdaAvailabilityProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaProvider").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, ORGANIZATION_ID_FIELD, DOMAIN_NAME_FIELD, EWS_PROVIDER_FIELD, LAMBDA_PROVIDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
            this.put("OrganizationId", ORGANIZATION_ID_FIELD);
            this.put("DomainName", DOMAIN_NAME_FIELD);
            this.put("EwsProvider", EWS_PROVIDER_FIELD);
            this.put("LambdaProvider", LAMBDA_PROVIDER_FIELD);
        }
    });
    private final String clientToken;
    private final String organizationId;
    private final String domainName;
    private final EwsAvailabilityProvider ewsProvider;
    private final LambdaAvailabilityProvider lambdaProvider;

    private CreateAvailabilityConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.organizationId = builder.organizationId;
        this.domainName = builder.domainName;
        this.ewsProvider = builder.ewsProvider;
        this.lambdaProvider = builder.lambdaProvider;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String organizationId() {
        return this.organizationId;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final EwsAvailabilityProvider ewsProvider() {
        return this.ewsProvider;
    }

    public final LambdaAvailabilityProvider lambdaProvider() {
        return this.lambdaProvider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ewsProvider());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaProvider());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAvailabilityConfigurationRequest)) {
            return false;
        }
        CreateAvailabilityConfigurationRequest other = (CreateAvailabilityConfigurationRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.organizationId(), other.organizationId()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.ewsProvider(), other.ewsProvider()) && Objects.equals(this.lambdaProvider(), other.lambdaProvider());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAvailabilityConfigurationRequest").add("ClientToken", (Object)this.clientToken()).add("OrganizationId", (Object)this.organizationId()).add("DomainName", (Object)this.domainName()).add("EwsProvider", (Object)this.ewsProvider()).add("LambdaProvider", (Object)this.lambdaProvider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "OrganizationId": {
                return Optional.ofNullable(clazz.cast(this.organizationId()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "EwsProvider": {
                return Optional.ofNullable(clazz.cast(this.ewsProvider()));
            }
            case "LambdaProvider": {
                return Optional.ofNullable(clazz.cast(this.lambdaProvider()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateAvailabilityConfigurationRequest, T> g) {
        return obj -> g.apply((CreateAvailabilityConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String organizationId;
        private String domainName;
        private EwsAvailabilityProvider ewsProvider;
        private LambdaAvailabilityProvider lambdaProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAvailabilityConfigurationRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.organizationId(model.organizationId);
            this.domainName(model.domainName);
            this.ewsProvider(model.ewsProvider);
            this.lambdaProvider(model.lambdaProvider);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final EwsAvailabilityProvider.Builder getEwsProvider() {
            return this.ewsProvider != null ? this.ewsProvider.toBuilder() : null;
        }

        public final void setEwsProvider(EwsAvailabilityProvider.BuilderImpl ewsProvider) {
            this.ewsProvider = ewsProvider != null ? ewsProvider.build() : null;
        }

        @Override
        public final Builder ewsProvider(EwsAvailabilityProvider ewsProvider) {
            this.ewsProvider = ewsProvider;
            return this;
        }

        public final LambdaAvailabilityProvider.Builder getLambdaProvider() {
            return this.lambdaProvider != null ? this.lambdaProvider.toBuilder() : null;
        }

        public final void setLambdaProvider(LambdaAvailabilityProvider.BuilderImpl lambdaProvider) {
            this.lambdaProvider = lambdaProvider != null ? lambdaProvider.build() : null;
        }

        @Override
        public final Builder lambdaProvider(LambdaAvailabilityProvider lambdaProvider) {
            this.lambdaProvider = lambdaProvider;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAvailabilityConfigurationRequest build() {
            return new CreateAvailabilityConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkMailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAvailabilityConfigurationRequest> {
        public Builder clientToken(String var1);

        public Builder organizationId(String var1);

        public Builder domainName(String var1);

        public Builder ewsProvider(EwsAvailabilityProvider var1);

        default public Builder ewsProvider(Consumer<EwsAvailabilityProvider.Builder> ewsProvider) {
            return this.ewsProvider((EwsAvailabilityProvider)((EwsAvailabilityProvider.Builder)EwsAvailabilityProvider.builder().applyMutation(ewsProvider)).build());
        }

        public Builder lambdaProvider(LambdaAvailabilityProvider var1);

        default public Builder lambdaProvider(Consumer<LambdaAvailabilityProvider.Builder> lambdaProvider) {
            return this.lambdaProvider((LambdaAvailabilityProvider)((LambdaAvailabilityProvider.Builder)LambdaAvailabilityProvider.builder().applyMutation(lambdaProvider)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

