/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EwsAvailabilityProvider
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EwsAvailabilityProvider> {
    private static final SdkField<String> EWS_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EwsEndpoint").getter(EwsAvailabilityProvider.getter(EwsAvailabilityProvider::ewsEndpoint)).setter(EwsAvailabilityProvider.setter(Builder::ewsEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EwsEndpoint").build()}).build();
    private static final SdkField<String> EWS_USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EwsUsername").getter(EwsAvailabilityProvider.getter(EwsAvailabilityProvider::ewsUsername)).setter(EwsAvailabilityProvider.setter(Builder::ewsUsername)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EwsUsername").build()}).build();
    private static final SdkField<String> EWS_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EwsPassword").getter(EwsAvailabilityProvider.getter(EwsAvailabilityProvider::ewsPassword)).setter(EwsAvailabilityProvider.setter(Builder::ewsPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EwsPassword").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EWS_ENDPOINT_FIELD, EWS_USERNAME_FIELD, EWS_PASSWORD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EwsEndpoint", EWS_ENDPOINT_FIELD);
            this.put("EwsUsername", EWS_USERNAME_FIELD);
            this.put("EwsPassword", EWS_PASSWORD_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String ewsEndpoint;
    private final String ewsUsername;
    private final String ewsPassword;

    private EwsAvailabilityProvider(BuilderImpl builder) {
        this.ewsEndpoint = builder.ewsEndpoint;
        this.ewsUsername = builder.ewsUsername;
        this.ewsPassword = builder.ewsPassword;
    }

    public final String ewsEndpoint() {
        return this.ewsEndpoint;
    }

    public final String ewsUsername() {
        return this.ewsUsername;
    }

    public final String ewsPassword() {
        return this.ewsPassword;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ewsEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.ewsUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.ewsPassword());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EwsAvailabilityProvider)) {
            return false;
        }
        EwsAvailabilityProvider other = (EwsAvailabilityProvider)obj;
        return Objects.equals(this.ewsEndpoint(), other.ewsEndpoint()) && Objects.equals(this.ewsUsername(), other.ewsUsername()) && Objects.equals(this.ewsPassword(), other.ewsPassword());
    }

    public final String toString() {
        return ToString.builder((String)"EwsAvailabilityProvider").add("EwsEndpoint", (Object)this.ewsEndpoint()).add("EwsUsername", (Object)this.ewsUsername()).add("EwsPassword", (Object)(this.ewsPassword() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EwsEndpoint": {
                return Optional.ofNullable(clazz.cast(this.ewsEndpoint()));
            }
            case "EwsUsername": {
                return Optional.ofNullable(clazz.cast(this.ewsUsername()));
            }
            case "EwsPassword": {
                return Optional.ofNullable(clazz.cast(this.ewsPassword()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EwsAvailabilityProvider, T> g) {
        return obj -> g.apply((EwsAvailabilityProvider)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ewsEndpoint;
        private String ewsUsername;
        private String ewsPassword;

        private BuilderImpl() {
        }

        private BuilderImpl(EwsAvailabilityProvider model) {
            this.ewsEndpoint(model.ewsEndpoint);
            this.ewsUsername(model.ewsUsername);
            this.ewsPassword(model.ewsPassword);
        }

        public final String getEwsEndpoint() {
            return this.ewsEndpoint;
        }

        public final void setEwsEndpoint(String ewsEndpoint) {
            this.ewsEndpoint = ewsEndpoint;
        }

        @Override
        public final Builder ewsEndpoint(String ewsEndpoint) {
            this.ewsEndpoint = ewsEndpoint;
            return this;
        }

        public final String getEwsUsername() {
            return this.ewsUsername;
        }

        public final void setEwsUsername(String ewsUsername) {
            this.ewsUsername = ewsUsername;
        }

        @Override
        public final Builder ewsUsername(String ewsUsername) {
            this.ewsUsername = ewsUsername;
            return this;
        }

        public final String getEwsPassword() {
            return this.ewsPassword;
        }

        public final void setEwsPassword(String ewsPassword) {
            this.ewsPassword = ewsPassword;
        }

        @Override
        public final Builder ewsPassword(String ewsPassword) {
            this.ewsPassword = ewsPassword;
            return this;
        }

        public EwsAvailabilityProvider build() {
            return new EwsAvailabilityProvider(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EwsAvailabilityProvider> {
        public Builder ewsEndpoint(String var1);

        public Builder ewsUsername(String var1);

        public Builder ewsPassword(String var1);
    }
}

