/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workmail.model.ImpersonationRoleType;
import software.amazon.awssdk.services.workmail.model.ImpersonationRule;
import software.amazon.awssdk.services.workmail.model.ImpersonationRuleListCopier;
import software.amazon.awssdk.services.workmail.model.WorkMailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetImpersonationRoleResponse
extends WorkMailResponse
implements ToCopyableBuilder<Builder, GetImpersonationRoleResponse> {
    private static final SdkField<String> IMPERSONATION_ROLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImpersonationRoleId").getter(GetImpersonationRoleResponse.getter(GetImpersonationRoleResponse::impersonationRoleId)).setter(GetImpersonationRoleResponse.setter(Builder::impersonationRoleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImpersonationRoleId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetImpersonationRoleResponse.getter(GetImpersonationRoleResponse::name)).setter(GetImpersonationRoleResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(GetImpersonationRoleResponse.getter(GetImpersonationRoleResponse::typeAsString)).setter(GetImpersonationRoleResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetImpersonationRoleResponse.getter(GetImpersonationRoleResponse::description)).setter(GetImpersonationRoleResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<ImpersonationRule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rules").getter(GetImpersonationRoleResponse.getter(GetImpersonationRoleResponse::rules)).setter(GetImpersonationRoleResponse.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImpersonationRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> DATE_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DateCreated").getter(GetImpersonationRoleResponse.getter(GetImpersonationRoleResponse::dateCreated)).setter(GetImpersonationRoleResponse.setter(Builder::dateCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateCreated").build()}).build();
    private static final SdkField<Instant> DATE_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DateModified").getter(GetImpersonationRoleResponse.getter(GetImpersonationRoleResponse::dateModified)).setter(GetImpersonationRoleResponse.setter(Builder::dateModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateModified").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPERSONATION_ROLE_ID_FIELD, NAME_FIELD, TYPE_FIELD, DESCRIPTION_FIELD, RULES_FIELD, DATE_CREATED_FIELD, DATE_MODIFIED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ImpersonationRoleId", IMPERSONATION_ROLE_ID_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Type", TYPE_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Rules", RULES_FIELD);
            this.put("DateCreated", DATE_CREATED_FIELD);
            this.put("DateModified", DATE_MODIFIED_FIELD);
        }
    });
    private final String impersonationRoleId;
    private final String name;
    private final String type;
    private final String description;
    private final List<ImpersonationRule> rules;
    private final Instant dateCreated;
    private final Instant dateModified;

    private GetImpersonationRoleResponse(BuilderImpl builder) {
        super(builder);
        this.impersonationRoleId = builder.impersonationRoleId;
        this.name = builder.name;
        this.type = builder.type;
        this.description = builder.description;
        this.rules = builder.rules;
        this.dateCreated = builder.dateCreated;
        this.dateModified = builder.dateModified;
    }

    public final String impersonationRoleId() {
        return this.impersonationRoleId;
    }

    public final String name() {
        return this.name;
    }

    public final ImpersonationRoleType type() {
        return ImpersonationRoleType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<ImpersonationRule> rules() {
        return this.rules;
    }

    public final Instant dateCreated() {
        return this.dateCreated;
    }

    public final Instant dateModified() {
        return this.dateModified;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.impersonationRoleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateModified());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetImpersonationRoleResponse)) {
            return false;
        }
        GetImpersonationRoleResponse other = (GetImpersonationRoleResponse)((Object)obj);
        return Objects.equals(this.impersonationRoleId(), other.impersonationRoleId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.description(), other.description()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules()) && Objects.equals(this.dateCreated(), other.dateCreated()) && Objects.equals(this.dateModified(), other.dateModified());
    }

    public final String toString() {
        return ToString.builder((String)"GetImpersonationRoleResponse").add("ImpersonationRoleId", (Object)this.impersonationRoleId()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("Description", (Object)this.description()).add("Rules", this.hasRules() ? this.rules() : null).add("DateCreated", (Object)this.dateCreated()).add("DateModified", (Object)this.dateModified()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImpersonationRoleId": {
                return Optional.ofNullable(clazz.cast(this.impersonationRoleId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "DateCreated": {
                return Optional.ofNullable(clazz.cast(this.dateCreated()));
            }
            case "DateModified": {
                return Optional.ofNullable(clazz.cast(this.dateModified()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetImpersonationRoleResponse, T> g) {
        return obj -> g.apply((GetImpersonationRoleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailResponse.BuilderImpl
    implements Builder {
        private String impersonationRoleId;
        private String name;
        private String type;
        private String description;
        private List<ImpersonationRule> rules = DefaultSdkAutoConstructList.getInstance();
        private Instant dateCreated;
        private Instant dateModified;

        private BuilderImpl() {
        }

        private BuilderImpl(GetImpersonationRoleResponse model) {
            super(model);
            this.impersonationRoleId(model.impersonationRoleId);
            this.name(model.name);
            this.type(model.type);
            this.description(model.description);
            this.rules(model.rules);
            this.dateCreated(model.dateCreated);
            this.dateModified(model.dateModified);
        }

        public final String getImpersonationRoleId() {
            return this.impersonationRoleId;
        }

        public final void setImpersonationRoleId(String impersonationRoleId) {
            this.impersonationRoleId = impersonationRoleId;
        }

        @Override
        public final Builder impersonationRoleId(String impersonationRoleId) {
            this.impersonationRoleId = impersonationRoleId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ImpersonationRoleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<ImpersonationRule.Builder> getRules() {
            List<ImpersonationRule.Builder> result = ImpersonationRuleListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<ImpersonationRule.BuilderImpl> rules) {
            this.rules = ImpersonationRuleListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<ImpersonationRule> rules) {
            this.rules = ImpersonationRuleListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(ImpersonationRule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<ImpersonationRule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (ImpersonationRule)((ImpersonationRule.Builder)ImpersonationRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getDateCreated() {
            return this.dateCreated;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        @Override
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final Instant getDateModified() {
            return this.dateModified;
        }

        public final void setDateModified(Instant dateModified) {
            this.dateModified = dateModified;
        }

        @Override
        public final Builder dateModified(Instant dateModified) {
            this.dateModified = dateModified;
            return this;
        }

        @Override
        public GetImpersonationRoleResponse build() {
            return new GetImpersonationRoleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkMailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetImpersonationRoleResponse> {
        public Builder impersonationRoleId(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(ImpersonationRoleType var1);

        public Builder description(String var1);

        public Builder rules(Collection<ImpersonationRule> var1);

        public Builder rules(ImpersonationRule ... var1);

        public Builder rules(Consumer<ImpersonationRule.Builder> ... var1);

        public Builder dateCreated(Instant var1);

        public Builder dateModified(Instant var1);
    }
}

