/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * List all the <code>AvailabilityConfiguration</code>'s for the given WorkMail organization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AvailabilityConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AvailabilityConfiguration.Builder, AvailabilityConfiguration> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(AvailabilityConfiguration::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProviderType").getter(getter(AvailabilityConfiguration::providerTypeAsString))
            .setter(setter(Builder::providerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderType").build()).build();

    private static final SdkField<RedactedEwsAvailabilityProvider> EWS_PROVIDER_FIELD = SdkField
            .<RedactedEwsAvailabilityProvider> builder(MarshallingType.SDK_POJO).memberName("EwsProvider")
            .getter(getter(AvailabilityConfiguration::ewsProvider)).setter(setter(Builder::ewsProvider))
            .constructor(RedactedEwsAvailabilityProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EwsProvider").build()).build();

    private static final SdkField<LambdaAvailabilityProvider> LAMBDA_PROVIDER_FIELD = SdkField
            .<LambdaAvailabilityProvider> builder(MarshallingType.SDK_POJO).memberName("LambdaProvider")
            .getter(getter(AvailabilityConfiguration::lambdaProvider)).setter(setter(Builder::lambdaProvider))
            .constructor(LambdaAvailabilityProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaProvider").build()).build();

    private static final SdkField<Instant> DATE_CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DateCreated").getter(getter(AvailabilityConfiguration::dateCreated))
            .setter(setter(Builder::dateCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateCreated").build()).build();

    private static final SdkField<Instant> DATE_MODIFIED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DateModified").getter(getter(AvailabilityConfiguration::dateModified))
            .setter(setter(Builder::dateModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateModified").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            PROVIDER_TYPE_FIELD, EWS_PROVIDER_FIELD, LAMBDA_PROVIDER_FIELD, DATE_CREATED_FIELD, DATE_MODIFIED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String domainName;

    private final String providerType;

    private final RedactedEwsAvailabilityProvider ewsProvider;

    private final LambdaAvailabilityProvider lambdaProvider;

    private final Instant dateCreated;

    private final Instant dateModified;

    private AvailabilityConfiguration(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.providerType = builder.providerType;
        this.ewsProvider = builder.ewsProvider;
        this.lambdaProvider = builder.lambdaProvider;
        this.dateCreated = builder.dateCreated;
        this.dateModified = builder.dateModified;
    }

    /**
     * <p>
     * Displays the domain to which the provider applies.
     * </p>
     * 
     * @return Displays the domain to which the provider applies.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Displays the provider type that applies to this domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link AvailabilityProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #providerTypeAsString}.
     * </p>
     * 
     * @return Displays the provider type that applies to this domain.
     * @see AvailabilityProviderType
     */
    public final AvailabilityProviderType providerType() {
        return AvailabilityProviderType.fromValue(providerType);
    }

    /**
     * <p>
     * Displays the provider type that applies to this domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link AvailabilityProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #providerTypeAsString}.
     * </p>
     * 
     * @return Displays the provider type that applies to this domain.
     * @see AvailabilityProviderType
     */
    public final String providerTypeAsString() {
        return providerType;
    }

    /**
     * <p>
     * If <code>ProviderType</code> is <code>EWS</code>, then this field contains
     * <code>RedactedEwsAvailabilityProvider</code>. Otherwise, it is not required.
     * </p>
     * 
     * @return If <code>ProviderType</code> is <code>EWS</code>, then this field contains
     *         <code>RedactedEwsAvailabilityProvider</code>. Otherwise, it is not required.
     */
    public final RedactedEwsAvailabilityProvider ewsProvider() {
        return ewsProvider;
    }

    /**
     * <p>
     * If ProviderType is <code>LAMBDA</code> then this field contains <code>LambdaAvailabilityProvider</code>.
     * Otherwise, it is not required.
     * </p>
     * 
     * @return If ProviderType is <code>LAMBDA</code> then this field contains <code>LambdaAvailabilityProvider</code>.
     *         Otherwise, it is not required.
     */
    public final LambdaAvailabilityProvider lambdaProvider() {
        return lambdaProvider;
    }

    /**
     * <p>
     * The date and time at which the availability configuration was created.
     * </p>
     * 
     * @return The date and time at which the availability configuration was created.
     */
    public final Instant dateCreated() {
        return dateCreated;
    }

    /**
     * <p>
     * The date and time at which the availability configuration was last modified.
     * </p>
     * 
     * @return The date and time at which the availability configuration was last modified.
     */
    public final Instant dateModified() {
        return dateModified;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(providerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ewsProvider());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaProvider());
        hashCode = 31 * hashCode + Objects.hashCode(dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(dateModified());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailabilityConfiguration)) {
            return false;
        }
        AvailabilityConfiguration other = (AvailabilityConfiguration) obj;
        return Objects.equals(domainName(), other.domainName())
                && Objects.equals(providerTypeAsString(), other.providerTypeAsString())
                && Objects.equals(ewsProvider(), other.ewsProvider()) && Objects.equals(lambdaProvider(), other.lambdaProvider())
                && Objects.equals(dateCreated(), other.dateCreated()) && Objects.equals(dateModified(), other.dateModified());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AvailabilityConfiguration").add("DomainName", domainName())
                .add("ProviderType", providerTypeAsString()).add("EwsProvider", ewsProvider())
                .add("LambdaProvider", lambdaProvider()).add("DateCreated", dateCreated()).add("DateModified", dateModified())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "ProviderType":
            return Optional.ofNullable(clazz.cast(providerTypeAsString()));
        case "EwsProvider":
            return Optional.ofNullable(clazz.cast(ewsProvider()));
        case "LambdaProvider":
            return Optional.ofNullable(clazz.cast(lambdaProvider()));
        case "DateCreated":
            return Optional.ofNullable(clazz.cast(dateCreated()));
        case "DateModified":
            return Optional.ofNullable(clazz.cast(dateModified()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("ProviderType", PROVIDER_TYPE_FIELD);
        map.put("EwsProvider", EWS_PROVIDER_FIELD);
        map.put("LambdaProvider", LAMBDA_PROVIDER_FIELD);
        map.put("DateCreated", DATE_CREATED_FIELD);
        map.put("DateModified", DATE_MODIFIED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AvailabilityConfiguration, T> g) {
        return obj -> g.apply((AvailabilityConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AvailabilityConfiguration> {
        /**
         * <p>
         * Displays the domain to which the provider applies.
         * </p>
         * 
         * @param domainName
         *        Displays the domain to which the provider applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Displays the provider type that applies to this domain.
         * </p>
         * 
         * @param providerType
         *        Displays the provider type that applies to this domain.
         * @see AvailabilityProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AvailabilityProviderType
         */
        Builder providerType(String providerType);

        /**
         * <p>
         * Displays the provider type that applies to this domain.
         * </p>
         * 
         * @param providerType
         *        Displays the provider type that applies to this domain.
         * @see AvailabilityProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AvailabilityProviderType
         */
        Builder providerType(AvailabilityProviderType providerType);

        /**
         * <p>
         * If <code>ProviderType</code> is <code>EWS</code>, then this field contains
         * <code>RedactedEwsAvailabilityProvider</code>. Otherwise, it is not required.
         * </p>
         * 
         * @param ewsProvider
         *        If <code>ProviderType</code> is <code>EWS</code>, then this field contains
         *        <code>RedactedEwsAvailabilityProvider</code>. Otherwise, it is not required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ewsProvider(RedactedEwsAvailabilityProvider ewsProvider);

        /**
         * <p>
         * If <code>ProviderType</code> is <code>EWS</code>, then this field contains
         * <code>RedactedEwsAvailabilityProvider</code>. Otherwise, it is not required.
         * </p>
         * This is a convenience method that creates an instance of the {@link RedactedEwsAvailabilityProvider.Builder}
         * avoiding the need to create one manually via {@link RedactedEwsAvailabilityProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedactedEwsAvailabilityProvider.Builder#build()} is called
         * immediately and its result is passed to {@link #ewsProvider(RedactedEwsAvailabilityProvider)}.
         * 
         * @param ewsProvider
         *        a consumer that will call methods on {@link RedactedEwsAvailabilityProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ewsProvider(RedactedEwsAvailabilityProvider)
         */
        default Builder ewsProvider(Consumer<RedactedEwsAvailabilityProvider.Builder> ewsProvider) {
            return ewsProvider(RedactedEwsAvailabilityProvider.builder().applyMutation(ewsProvider).build());
        }

        /**
         * <p>
         * If ProviderType is <code>LAMBDA</code> then this field contains <code>LambdaAvailabilityProvider</code>.
         * Otherwise, it is not required.
         * </p>
         * 
         * @param lambdaProvider
         *        If ProviderType is <code>LAMBDA</code> then this field contains
         *        <code>LambdaAvailabilityProvider</code>. Otherwise, it is not required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaProvider(LambdaAvailabilityProvider lambdaProvider);

        /**
         * <p>
         * If ProviderType is <code>LAMBDA</code> then this field contains <code>LambdaAvailabilityProvider</code>.
         * Otherwise, it is not required.
         * </p>
         * This is a convenience method that creates an instance of the {@link LambdaAvailabilityProvider.Builder}
         * avoiding the need to create one manually via {@link LambdaAvailabilityProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaAvailabilityProvider.Builder#build()} is called immediately
         * and its result is passed to {@link #lambdaProvider(LambdaAvailabilityProvider)}.
         * 
         * @param lambdaProvider
         *        a consumer that will call methods on {@link LambdaAvailabilityProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaProvider(LambdaAvailabilityProvider)
         */
        default Builder lambdaProvider(Consumer<LambdaAvailabilityProvider.Builder> lambdaProvider) {
            return lambdaProvider(LambdaAvailabilityProvider.builder().applyMutation(lambdaProvider).build());
        }

        /**
         * <p>
         * The date and time at which the availability configuration was created.
         * </p>
         * 
         * @param dateCreated
         *        The date and time at which the availability configuration was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateCreated(Instant dateCreated);

        /**
         * <p>
         * The date and time at which the availability configuration was last modified.
         * </p>
         * 
         * @param dateModified
         *        The date and time at which the availability configuration was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateModified(Instant dateModified);
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private String providerType;

        private RedactedEwsAvailabilityProvider ewsProvider;

        private LambdaAvailabilityProvider lambdaProvider;

        private Instant dateCreated;

        private Instant dateModified;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailabilityConfiguration model) {
            domainName(model.domainName);
            providerType(model.providerType);
            ewsProvider(model.ewsProvider);
            lambdaProvider(model.lambdaProvider);
            dateCreated(model.dateCreated);
            dateModified(model.dateModified);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getProviderType() {
            return providerType;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        @Override
        public final Builder providerType(AvailabilityProviderType providerType) {
            this.providerType(providerType == null ? null : providerType.toString());
            return this;
        }

        public final RedactedEwsAvailabilityProvider.Builder getEwsProvider() {
            return ewsProvider != null ? ewsProvider.toBuilder() : null;
        }

        public final void setEwsProvider(RedactedEwsAvailabilityProvider.BuilderImpl ewsProvider) {
            this.ewsProvider = ewsProvider != null ? ewsProvider.build() : null;
        }

        @Override
        public final Builder ewsProvider(RedactedEwsAvailabilityProvider ewsProvider) {
            this.ewsProvider = ewsProvider;
            return this;
        }

        public final LambdaAvailabilityProvider.Builder getLambdaProvider() {
            return lambdaProvider != null ? lambdaProvider.toBuilder() : null;
        }

        public final void setLambdaProvider(LambdaAvailabilityProvider.BuilderImpl lambdaProvider) {
            this.lambdaProvider = lambdaProvider != null ? lambdaProvider.build() : null;
        }

        @Override
        public final Builder lambdaProvider(LambdaAvailabilityProvider lambdaProvider) {
            this.lambdaProvider = lambdaProvider;
            return this;
        }

        public final Instant getDateCreated() {
            return dateCreated;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        @Override
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final Instant getDateModified() {
            return dateModified;
        }

        public final void setDateModified(Instant dateModified) {
            this.dateModified = dateModified;
        }

        @Override
        public final Builder dateModified(Instant dateModified) {
            this.dateModified = dateModified;
            return this;
        }

        @Override
        public AvailabilityConfiguration build() {
            return new AvailabilityConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
