/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteMailboxPermissionsRequest extends WorkMailRequest implements
        ToCopyableBuilder<DeleteMailboxPermissionsRequest.Builder, DeleteMailboxPermissionsRequest> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationId").getter(getter(DeleteMailboxPermissionsRequest::organizationId))
            .setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()).build();

    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityId").getter(getter(DeleteMailboxPermissionsRequest::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()).build();

    private static final SdkField<String> GRANTEE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GranteeId").getter(getter(DeleteMailboxPermissionsRequest::granteeId))
            .setter(setter(Builder::granteeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GranteeId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD,
            ENTITY_ID_FIELD, GRANTEE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String organizationId;

    private final String entityId;

    private final String granteeId;

    private DeleteMailboxPermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.entityId = builder.entityId;
        this.granteeId = builder.granteeId;
    }

    /**
     * <p>
     * The identifier of the organization under which the member (user or group) exists.
     * </p>
     * 
     * @return The identifier of the organization under which the member (user or group) exists.
     */
    public final String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * The identifier of the entity that owns the mailbox.
     * </p>
     * <p>
     * The identifier can be <i>UserId or Group Id</i>, <i>Username or Groupname</i>, or <i>email</i>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Entity ID: 12345678-1234-1234-1234-123456789012, r-0123456789a0123456789b0123456789, or
     * S-1-1-12-1234567890-123456789-123456789-1234
     * </p>
     * </li>
     * <li>
     * <p>
     * Email address: entity@domain.tld
     * </p>
     * </li>
     * <li>
     * <p>
     * Entity name: entity
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier of the entity that owns the mailbox.</p>
     *         <p>
     *         The identifier can be <i>UserId or Group Id</i>, <i>Username or Groupname</i>, or <i>email</i>.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Entity ID: 12345678-1234-1234-1234-123456789012, r-0123456789a0123456789b0123456789, or
     *         S-1-1-12-1234567890-123456789-123456789-1234
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Email address: entity@domain.tld
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Entity name: entity
     *         </p>
     *         </li>
     */
    public final String entityId() {
        return entityId;
    }

    /**
     * <p>
     * The identifier of the entity for which to delete granted permissions.
     * </p>
     * <p>
     * The identifier can be <i>UserId, ResourceID, or Group Id</i>, <i>Username or Groupname</i>, or <i>email</i>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Grantee ID: 12345678-1234-1234-1234-123456789012,r-0123456789a0123456789b0123456789, or
     * S-1-1-12-1234567890-123456789-123456789-1234
     * </p>
     * </li>
     * <li>
     * <p>
     * Email address: grantee@domain.tld
     * </p>
     * </li>
     * <li>
     * <p>
     * Grantee name: grantee
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier of the entity for which to delete granted permissions.</p>
     *         <p>
     *         The identifier can be <i>UserId, ResourceID, or Group Id</i>, <i>Username or Groupname</i>, or
     *         <i>email</i>.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Grantee ID: 12345678-1234-1234-1234-123456789012,r-0123456789a0123456789b0123456789, or
     *         S-1-1-12-1234567890-123456789-123456789-1234
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Email address: grantee@domain.tld
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Grantee name: grantee
     *         </p>
     *         </li>
     */
    public final String granteeId() {
        return granteeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(granteeId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMailboxPermissionsRequest)) {
            return false;
        }
        DeleteMailboxPermissionsRequest other = (DeleteMailboxPermissionsRequest) obj;
        return Objects.equals(organizationId(), other.organizationId()) && Objects.equals(entityId(), other.entityId())
                && Objects.equals(granteeId(), other.granteeId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteMailboxPermissionsRequest").add("OrganizationId", organizationId())
                .add("EntityId", entityId()).add("GranteeId", granteeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "EntityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "GranteeId":
            return Optional.ofNullable(clazz.cast(granteeId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OrganizationId", ORGANIZATION_ID_FIELD);
        map.put("EntityId", ENTITY_ID_FIELD);
        map.put("GranteeId", GRANTEE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteMailboxPermissionsRequest, T> g) {
        return obj -> g.apply((DeleteMailboxPermissionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteMailboxPermissionsRequest> {
        /**
         * <p>
         * The identifier of the organization under which the member (user or group) exists.
         * </p>
         * 
         * @param organizationId
         *        The identifier of the organization under which the member (user or group) exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * The identifier of the entity that owns the mailbox.
         * </p>
         * <p>
         * The identifier can be <i>UserId or Group Id</i>, <i>Username or Groupname</i>, or <i>email</i>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Entity ID: 12345678-1234-1234-1234-123456789012, r-0123456789a0123456789b0123456789, or
         * S-1-1-12-1234567890-123456789-123456789-1234
         * </p>
         * </li>
         * <li>
         * <p>
         * Email address: entity@domain.tld
         * </p>
         * </li>
         * <li>
         * <p>
         * Entity name: entity
         * </p>
         * </li>
         * </ul>
         * 
         * @param entityId
         *        The identifier of the entity that owns the mailbox.</p>
         *        <p>
         *        The identifier can be <i>UserId or Group Id</i>, <i>Username or Groupname</i>, or <i>email</i>.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Entity ID: 12345678-1234-1234-1234-123456789012, r-0123456789a0123456789b0123456789, or
         *        S-1-1-12-1234567890-123456789-123456789-1234
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Email address: entity@domain.tld
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Entity name: entity
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * The identifier of the entity for which to delete granted permissions.
         * </p>
         * <p>
         * The identifier can be <i>UserId, ResourceID, or Group Id</i>, <i>Username or Groupname</i>, or <i>email</i>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Grantee ID: 12345678-1234-1234-1234-123456789012,r-0123456789a0123456789b0123456789, or
         * S-1-1-12-1234567890-123456789-123456789-1234
         * </p>
         * </li>
         * <li>
         * <p>
         * Email address: grantee@domain.tld
         * </p>
         * </li>
         * <li>
         * <p>
         * Grantee name: grantee
         * </p>
         * </li>
         * </ul>
         * 
         * @param granteeId
         *        The identifier of the entity for which to delete granted permissions.</p>
         *        <p>
         *        The identifier can be <i>UserId, ResourceID, or Group Id</i>, <i>Username or Groupname</i>, or
         *        <i>email</i>.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Grantee ID: 12345678-1234-1234-1234-123456789012,r-0123456789a0123456789b0123456789, or
         *        S-1-1-12-1234567890-123456789-123456789-1234
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Email address: grantee@domain.tld
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Grantee name: grantee
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder granteeId(String granteeId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkMailRequest.BuilderImpl implements Builder {
        private String organizationId;

        private String entityId;

        private String granteeId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMailboxPermissionsRequest model) {
            super(model);
            organizationId(model.organizationId);
            entityId(model.entityId);
            granteeId(model.granteeId);
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getEntityId() {
            return entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getGranteeId() {
            return granteeId;
        }

        public final void setGranteeId(String granteeId) {
            this.granteeId = granteeId;
        }

        @Override
        public final Builder granteeId(String granteeId) {
            this.granteeId = granteeId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteMailboxPermissionsRequest build() {
            return new DeleteMailboxPermissionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
