/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUserRequest extends WorkMailRequest implements
        ToCopyableBuilder<UpdateUserRequest.Builder, UpdateUserRequest> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationId").getter(getter(UpdateUserRequest::organizationId))
            .setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(UpdateUserRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(UpdateUserRequest::roleAsString)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(UpdateUserRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirstName").getter(getter(UpdateUserRequest::firstName)).setter(setter(Builder::firstName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()).build();

    private static final SdkField<String> LAST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastName").getter(getter(UpdateUserRequest::lastName)).setter(setter(Builder::lastName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()).build();

    private static final SdkField<Boolean> HIDDEN_FROM_GLOBAL_ADDRESS_LIST_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HiddenFromGlobalAddressList")
            .getter(getter(UpdateUserRequest::hiddenFromGlobalAddressList))
            .setter(setter(Builder::hiddenFromGlobalAddressList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HiddenFromGlobalAddressList")
                    .build()).build();

    private static final SdkField<String> INITIALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Initials").getter(getter(UpdateUserRequest::initials)).setter(setter(Builder::initials))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Initials").build()).build();

    private static final SdkField<String> TELEPHONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Telephone").getter(getter(UpdateUserRequest::telephone)).setter(setter(Builder::telephone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Telephone").build()).build();

    private static final SdkField<String> STREET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Street")
            .getter(getter(UpdateUserRequest::street)).setter(setter(Builder::street))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Street").build()).build();

    private static final SdkField<String> JOB_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobTitle").getter(getter(UpdateUserRequest::jobTitle)).setter(setter(Builder::jobTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobTitle").build()).build();

    private static final SdkField<String> CITY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("City")
            .getter(getter(UpdateUserRequest::city)).setter(setter(Builder::city))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("City").build()).build();

    private static final SdkField<String> COMPANY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Company")
            .getter(getter(UpdateUserRequest::company)).setter(setter(Builder::company))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Company").build()).build();

    private static final SdkField<String> ZIP_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ZipCode").getter(getter(UpdateUserRequest::zipCode)).setter(setter(Builder::zipCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZipCode").build()).build();

    private static final SdkField<String> DEPARTMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Department").getter(getter(UpdateUserRequest::department)).setter(setter(Builder::department))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Department").build()).build();

    private static final SdkField<String> COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Country")
            .getter(getter(UpdateUserRequest::country)).setter(setter(Builder::country))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()).build();

    private static final SdkField<String> OFFICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Office")
            .getter(getter(UpdateUserRequest::office)).setter(setter(Builder::office))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Office").build()).build();

    private static final SdkField<String> IDENTITY_PROVIDER_USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityProviderUserId").getter(getter(UpdateUserRequest::identityProviderUserId))
            .setter(setter(Builder::identityProviderUserId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderUserId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD,
            USER_ID_FIELD, ROLE_FIELD, DISPLAY_NAME_FIELD, FIRST_NAME_FIELD, LAST_NAME_FIELD,
            HIDDEN_FROM_GLOBAL_ADDRESS_LIST_FIELD, INITIALS_FIELD, TELEPHONE_FIELD, STREET_FIELD, JOB_TITLE_FIELD, CITY_FIELD,
            COMPANY_FIELD, ZIP_CODE_FIELD, DEPARTMENT_FIELD, COUNTRY_FIELD, OFFICE_FIELD, IDENTITY_PROVIDER_USER_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String organizationId;

    private final String userId;

    private final String role;

    private final String displayName;

    private final String firstName;

    private final String lastName;

    private final Boolean hiddenFromGlobalAddressList;

    private final String initials;

    private final String telephone;

    private final String street;

    private final String jobTitle;

    private final String city;

    private final String company;

    private final String zipCode;

    private final String department;

    private final String country;

    private final String office;

    private final String identityProviderUserId;

    private UpdateUserRequest(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.userId = builder.userId;
        this.role = builder.role;
        this.displayName = builder.displayName;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.hiddenFromGlobalAddressList = builder.hiddenFromGlobalAddressList;
        this.initials = builder.initials;
        this.telephone = builder.telephone;
        this.street = builder.street;
        this.jobTitle = builder.jobTitle;
        this.city = builder.city;
        this.company = builder.company;
        this.zipCode = builder.zipCode;
        this.department = builder.department;
        this.country = builder.country;
        this.office = builder.office;
        this.identityProviderUserId = builder.identityProviderUserId;
    }

    /**
     * <p>
     * The identifier for the organization under which the user exists.
     * </p>
     * 
     * @return The identifier for the organization under which the user exists.
     */
    public final String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * The identifier for the user to be updated.
     * </p>
     * <p>
     * The identifier can be the <i>UserId</i>, <i>Username</i>, or <i>email</i>. The following identity formats are
     * available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * User ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234
     * </p>
     * </li>
     * <li>
     * <p>
     * Email address: user@domain.tld
     * </p>
     * </li>
     * <li>
     * <p>
     * User name: user
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier for the user to be updated.</p>
     *         <p>
     *         The identifier can be the <i>UserId</i>, <i>Username</i>, or <i>email</i>. The following identity formats
     *         are available:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         User ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Email address: user@domain.tld
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         User name: user
     *         </p>
     *         </li>
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * Updates the user role.
     * </p>
     * <p>
     * You cannot pass <i>SYSTEM_USER</i> or <i>RESOURCE</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link UserRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return Updates the user role.</p>
     *         <p>
     *         You cannot pass <i>SYSTEM_USER</i> or <i>RESOURCE</i>.
     * @see UserRole
     */
    public final UserRole role() {
        return UserRole.fromValue(role);
    }

    /**
     * <p>
     * Updates the user role.
     * </p>
     * <p>
     * You cannot pass <i>SYSTEM_USER</i> or <i>RESOURCE</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link UserRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return Updates the user role.</p>
     *         <p>
     *         You cannot pass <i>SYSTEM_USER</i> or <i>RESOURCE</i>.
     * @see UserRole
     */
    public final String roleAsString() {
        return role;
    }

    /**
     * <p>
     * Updates the display name of the user.
     * </p>
     * 
     * @return Updates the display name of the user.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * Updates the user's first name.
     * </p>
     * 
     * @return Updates the user's first name.
     */
    public final String firstName() {
        return firstName;
    }

    /**
     * <p>
     * Updates the user's last name.
     * </p>
     * 
     * @return Updates the user's last name.
     */
    public final String lastName() {
        return lastName;
    }

    /**
     * <p>
     * If enabled, the user is hidden from the global address list.
     * </p>
     * 
     * @return If enabled, the user is hidden from the global address list.
     */
    public final Boolean hiddenFromGlobalAddressList() {
        return hiddenFromGlobalAddressList;
    }

    /**
     * <p>
     * Updates the user's initials.
     * </p>
     * 
     * @return Updates the user's initials.
     */
    public final String initials() {
        return initials;
    }

    /**
     * <p>
     * Updates the user's contact details.
     * </p>
     * 
     * @return Updates the user's contact details.
     */
    public final String telephone() {
        return telephone;
    }

    /**
     * <p>
     * Updates the user's street address.
     * </p>
     * 
     * @return Updates the user's street address.
     */
    public final String street() {
        return street;
    }

    /**
     * <p>
     * Updates the user's job title.
     * </p>
     * 
     * @return Updates the user's job title.
     */
    public final String jobTitle() {
        return jobTitle;
    }

    /**
     * <p>
     * Updates the user's city.
     * </p>
     * 
     * @return Updates the user's city.
     */
    public final String city() {
        return city;
    }

    /**
     * <p>
     * Updates the user's company.
     * </p>
     * 
     * @return Updates the user's company.
     */
    public final String company() {
        return company;
    }

    /**
     * <p>
     * Updates the user's zip code.
     * </p>
     * 
     * @return Updates the user's zip code.
     */
    public final String zipCode() {
        return zipCode;
    }

    /**
     * <p>
     * Updates the user's department.
     * </p>
     * 
     * @return Updates the user's department.
     */
    public final String department() {
        return department;
    }

    /**
     * <p>
     * Updates the user's country.
     * </p>
     * 
     * @return Updates the user's country.
     */
    public final String country() {
        return country;
    }

    /**
     * <p>
     * Updates the user's office.
     * </p>
     * 
     * @return Updates the user's office.
     */
    public final String office() {
        return office;
    }

    /**
     * <p>
     * User ID from the IAM Identity Center. If this parameter is empty it will be updated automatically when the user
     * logs in for the first time to the mailbox associated with WorkMail.
     * </p>
     * 
     * @return User ID from the IAM Identity Center. If this parameter is empty it will be updated automatically when
     *         the user logs in for the first time to the mailbox associated with WorkMail.
     */
    public final String identityProviderUserId() {
        return identityProviderUserId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(firstName());
        hashCode = 31 * hashCode + Objects.hashCode(lastName());
        hashCode = 31 * hashCode + Objects.hashCode(hiddenFromGlobalAddressList());
        hashCode = 31 * hashCode + Objects.hashCode(initials());
        hashCode = 31 * hashCode + Objects.hashCode(telephone());
        hashCode = 31 * hashCode + Objects.hashCode(street());
        hashCode = 31 * hashCode + Objects.hashCode(jobTitle());
        hashCode = 31 * hashCode + Objects.hashCode(city());
        hashCode = 31 * hashCode + Objects.hashCode(company());
        hashCode = 31 * hashCode + Objects.hashCode(zipCode());
        hashCode = 31 * hashCode + Objects.hashCode(department());
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(office());
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderUserId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserRequest)) {
            return false;
        }
        UpdateUserRequest other = (UpdateUserRequest) obj;
        return Objects.equals(organizationId(), other.organizationId()) && Objects.equals(userId(), other.userId())
                && Objects.equals(roleAsString(), other.roleAsString()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(firstName(), other.firstName()) && Objects.equals(lastName(), other.lastName())
                && Objects.equals(hiddenFromGlobalAddressList(), other.hiddenFromGlobalAddressList())
                && Objects.equals(initials(), other.initials()) && Objects.equals(telephone(), other.telephone())
                && Objects.equals(street(), other.street()) && Objects.equals(jobTitle(), other.jobTitle())
                && Objects.equals(city(), other.city()) && Objects.equals(company(), other.company())
                && Objects.equals(zipCode(), other.zipCode()) && Objects.equals(department(), other.department())
                && Objects.equals(country(), other.country()) && Objects.equals(office(), other.office())
                && Objects.equals(identityProviderUserId(), other.identityProviderUserId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateUserRequest").add("OrganizationId", organizationId()).add("UserId", userId())
                .add("Role", roleAsString()).add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FirstName", firstName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LastName", lastName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("HiddenFromGlobalAddressList", hiddenFromGlobalAddressList())
                .add("Initials", initials() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Telephone", telephone() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Street", street() == null ? null : "*** Sensitive Data Redacted ***")
                .add("JobTitle", jobTitle() == null ? null : "*** Sensitive Data Redacted ***")
                .add("City", city() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Company", company() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ZipCode", zipCode() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Department", department() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Country", country() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Office", office() == null ? null : "*** Sensitive Data Redacted ***")
                .add("IdentityProviderUserId", identityProviderUserId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "Role":
            return Optional.ofNullable(clazz.cast(roleAsString()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "FirstName":
            return Optional.ofNullable(clazz.cast(firstName()));
        case "LastName":
            return Optional.ofNullable(clazz.cast(lastName()));
        case "HiddenFromGlobalAddressList":
            return Optional.ofNullable(clazz.cast(hiddenFromGlobalAddressList()));
        case "Initials":
            return Optional.ofNullable(clazz.cast(initials()));
        case "Telephone":
            return Optional.ofNullable(clazz.cast(telephone()));
        case "Street":
            return Optional.ofNullable(clazz.cast(street()));
        case "JobTitle":
            return Optional.ofNullable(clazz.cast(jobTitle()));
        case "City":
            return Optional.ofNullable(clazz.cast(city()));
        case "Company":
            return Optional.ofNullable(clazz.cast(company()));
        case "ZipCode":
            return Optional.ofNullable(clazz.cast(zipCode()));
        case "Department":
            return Optional.ofNullable(clazz.cast(department()));
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        case "Office":
            return Optional.ofNullable(clazz.cast(office()));
        case "IdentityProviderUserId":
            return Optional.ofNullable(clazz.cast(identityProviderUserId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OrganizationId", ORGANIZATION_ID_FIELD);
        map.put("UserId", USER_ID_FIELD);
        map.put("Role", ROLE_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("FirstName", FIRST_NAME_FIELD);
        map.put("LastName", LAST_NAME_FIELD);
        map.put("HiddenFromGlobalAddressList", HIDDEN_FROM_GLOBAL_ADDRESS_LIST_FIELD);
        map.put("Initials", INITIALS_FIELD);
        map.put("Telephone", TELEPHONE_FIELD);
        map.put("Street", STREET_FIELD);
        map.put("JobTitle", JOB_TITLE_FIELD);
        map.put("City", CITY_FIELD);
        map.put("Company", COMPANY_FIELD);
        map.put("ZipCode", ZIP_CODE_FIELD);
        map.put("Department", DEPARTMENT_FIELD);
        map.put("Country", COUNTRY_FIELD);
        map.put("Office", OFFICE_FIELD);
        map.put("IdentityProviderUserId", IDENTITY_PROVIDER_USER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserRequest, T> g) {
        return obj -> g.apply((UpdateUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateUserRequest> {
        /**
         * <p>
         * The identifier for the organization under which the user exists.
         * </p>
         * 
         * @param organizationId
         *        The identifier for the organization under which the user exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * The identifier for the user to be updated.
         * </p>
         * <p>
         * The identifier can be the <i>UserId</i>, <i>Username</i>, or <i>email</i>. The following identity formats are
         * available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * User ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234
         * </p>
         * </li>
         * <li>
         * <p>
         * Email address: user@domain.tld
         * </p>
         * </li>
         * <li>
         * <p>
         * User name: user
         * </p>
         * </li>
         * </ul>
         * 
         * @param userId
         *        The identifier for the user to be updated.</p>
         *        <p>
         *        The identifier can be the <i>UserId</i>, <i>Username</i>, or <i>email</i>. The following identity
         *        formats are available:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        User ID: 12345678-1234-1234-1234-123456789012 or S-1-1-12-1234567890-123456789-123456789-1234
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Email address: user@domain.tld
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        User name: user
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * Updates the user role.
         * </p>
         * <p>
         * You cannot pass <i>SYSTEM_USER</i> or <i>RESOURCE</i>.
         * </p>
         * 
         * @param role
         *        Updates the user role.</p>
         *        <p>
         *        You cannot pass <i>SYSTEM_USER</i> or <i>RESOURCE</i>.
         * @see UserRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserRole
         */
        Builder role(String role);

        /**
         * <p>
         * Updates the user role.
         * </p>
         * <p>
         * You cannot pass <i>SYSTEM_USER</i> or <i>RESOURCE</i>.
         * </p>
         * 
         * @param role
         *        Updates the user role.</p>
         *        <p>
         *        You cannot pass <i>SYSTEM_USER</i> or <i>RESOURCE</i>.
         * @see UserRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserRole
         */
        Builder role(UserRole role);

        /**
         * <p>
         * Updates the display name of the user.
         * </p>
         * 
         * @param displayName
         *        Updates the display name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * Updates the user's first name.
         * </p>
         * 
         * @param firstName
         *        Updates the user's first name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstName(String firstName);

        /**
         * <p>
         * Updates the user's last name.
         * </p>
         * 
         * @param lastName
         *        Updates the user's last name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastName(String lastName);

        /**
         * <p>
         * If enabled, the user is hidden from the global address list.
         * </p>
         * 
         * @param hiddenFromGlobalAddressList
         *        If enabled, the user is hidden from the global address list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hiddenFromGlobalAddressList(Boolean hiddenFromGlobalAddressList);

        /**
         * <p>
         * Updates the user's initials.
         * </p>
         * 
         * @param initials
         *        Updates the user's initials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initials(String initials);

        /**
         * <p>
         * Updates the user's contact details.
         * </p>
         * 
         * @param telephone
         *        Updates the user's contact details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder telephone(String telephone);

        /**
         * <p>
         * Updates the user's street address.
         * </p>
         * 
         * @param street
         *        Updates the user's street address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder street(String street);

        /**
         * <p>
         * Updates the user's job title.
         * </p>
         * 
         * @param jobTitle
         *        Updates the user's job title.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTitle(String jobTitle);

        /**
         * <p>
         * Updates the user's city.
         * </p>
         * 
         * @param city
         *        Updates the user's city.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder city(String city);

        /**
         * <p>
         * Updates the user's company.
         * </p>
         * 
         * @param company
         *        Updates the user's company.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder company(String company);

        /**
         * <p>
         * Updates the user's zip code.
         * </p>
         * 
         * @param zipCode
         *        Updates the user's zip code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zipCode(String zipCode);

        /**
         * <p>
         * Updates the user's department.
         * </p>
         * 
         * @param department
         *        Updates the user's department.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder department(String department);

        /**
         * <p>
         * Updates the user's country.
         * </p>
         * 
         * @param country
         *        Updates the user's country.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(String country);

        /**
         * <p>
         * Updates the user's office.
         * </p>
         * 
         * @param office
         *        Updates the user's office.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder office(String office);

        /**
         * <p>
         * User ID from the IAM Identity Center. If this parameter is empty it will be updated automatically when the
         * user logs in for the first time to the mailbox associated with WorkMail.
         * </p>
         * 
         * @param identityProviderUserId
         *        User ID from the IAM Identity Center. If this parameter is empty it will be updated automatically when
         *        the user logs in for the first time to the mailbox associated with WorkMail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderUserId(String identityProviderUserId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkMailRequest.BuilderImpl implements Builder {
        private String organizationId;

        private String userId;

        private String role;

        private String displayName;

        private String firstName;

        private String lastName;

        private Boolean hiddenFromGlobalAddressList;

        private String initials;

        private String telephone;

        private String street;

        private String jobTitle;

        private String city;

        private String company;

        private String zipCode;

        private String department;

        private String country;

        private String office;

        private String identityProviderUserId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserRequest model) {
            super(model);
            organizationId(model.organizationId);
            userId(model.userId);
            role(model.role);
            displayName(model.displayName);
            firstName(model.firstName);
            lastName(model.lastName);
            hiddenFromGlobalAddressList(model.hiddenFromGlobalAddressList);
            initials(model.initials);
            telephone(model.telephone);
            street(model.street);
            jobTitle(model.jobTitle);
            city(model.city);
            company(model.company);
            zipCode(model.zipCode);
            department(model.department);
            country(model.country);
            office(model.office);
            identityProviderUserId(model.identityProviderUserId);
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(UserRole role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getFirstName() {
            return firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getLastName() {
            return lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final Boolean getHiddenFromGlobalAddressList() {
            return hiddenFromGlobalAddressList;
        }

        public final void setHiddenFromGlobalAddressList(Boolean hiddenFromGlobalAddressList) {
            this.hiddenFromGlobalAddressList = hiddenFromGlobalAddressList;
        }

        @Override
        public final Builder hiddenFromGlobalAddressList(Boolean hiddenFromGlobalAddressList) {
            this.hiddenFromGlobalAddressList = hiddenFromGlobalAddressList;
            return this;
        }

        public final String getInitials() {
            return initials;
        }

        public final void setInitials(String initials) {
            this.initials = initials;
        }

        @Override
        public final Builder initials(String initials) {
            this.initials = initials;
            return this;
        }

        public final String getTelephone() {
            return telephone;
        }

        public final void setTelephone(String telephone) {
            this.telephone = telephone;
        }

        @Override
        public final Builder telephone(String telephone) {
            this.telephone = telephone;
            return this;
        }

        public final String getStreet() {
            return street;
        }

        public final void setStreet(String street) {
            this.street = street;
        }

        @Override
        public final Builder street(String street) {
            this.street = street;
            return this;
        }

        public final String getJobTitle() {
            return jobTitle;
        }

        public final void setJobTitle(String jobTitle) {
            this.jobTitle = jobTitle;
        }

        @Override
        public final Builder jobTitle(String jobTitle) {
            this.jobTitle = jobTitle;
            return this;
        }

        public final String getCity() {
            return city;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final String getCompany() {
            return company;
        }

        public final void setCompany(String company) {
            this.company = company;
        }

        @Override
        public final Builder company(String company) {
            this.company = company;
            return this;
        }

        public final String getZipCode() {
            return zipCode;
        }

        public final void setZipCode(String zipCode) {
            this.zipCode = zipCode;
        }

        @Override
        public final Builder zipCode(String zipCode) {
            this.zipCode = zipCode;
            return this;
        }

        public final String getDepartment() {
            return department;
        }

        public final void setDepartment(String department) {
            this.department = department;
        }

        @Override
        public final Builder department(String department) {
            this.department = department;
            return this;
        }

        public final String getCountry() {
            return country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final String getOffice() {
            return office;
        }

        public final void setOffice(String office) {
            this.office = office;
        }

        @Override
        public final Builder office(String office) {
            this.office = office;
            return this;
        }

        public final String getIdentityProviderUserId() {
            return identityProviderUserId;
        }

        public final void setIdentityProviderUserId(String identityProviderUserId) {
            this.identityProviderUserId = identityProviderUserId;
        }

        @Override
        public final Builder identityProviderUserId(String identityProviderUserId) {
            this.identityProviderUserId = identityProviderUserId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserRequest build() {
            return new UpdateUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
