/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workmail.model.BookingOptions;
import software.amazon.awssdk.services.workmail.model.ResourceType;
import software.amazon.awssdk.services.workmail.model.WorkMailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateResourceRequest
extends WorkMailRequest
implements ToCopyableBuilder<Builder, UpdateResourceRequest> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationId").getter(UpdateResourceRequest.getter(UpdateResourceRequest::organizationId)).setter(UpdateResourceRequest.setter(Builder::organizationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(UpdateResourceRequest.getter(UpdateResourceRequest::resourceId)).setter(UpdateResourceRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateResourceRequest.getter(UpdateResourceRequest::name)).setter(UpdateResourceRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<BookingOptions> BOOKING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BookingOptions").getter(UpdateResourceRequest.getter(UpdateResourceRequest::bookingOptions)).setter(UpdateResourceRequest.setter(Builder::bookingOptions)).constructor(BookingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BookingOptions").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateResourceRequest.getter(UpdateResourceRequest::description)).setter(UpdateResourceRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(UpdateResourceRequest.getter(UpdateResourceRequest::typeAsString)).setter(UpdateResourceRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Boolean> HIDDEN_FROM_GLOBAL_ADDRESS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HiddenFromGlobalAddressList").getter(UpdateResourceRequest.getter(UpdateResourceRequest::hiddenFromGlobalAddressList)).setter(UpdateResourceRequest.setter(Builder::hiddenFromGlobalAddressList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HiddenFromGlobalAddressList").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD, RESOURCE_ID_FIELD, NAME_FIELD, BOOKING_OPTIONS_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, HIDDEN_FROM_GLOBAL_ADDRESS_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateResourceRequest.memberNameToFieldInitializer();
    private final String organizationId;
    private final String resourceId;
    private final String name;
    private final BookingOptions bookingOptions;
    private final String description;
    private final String type;
    private final Boolean hiddenFromGlobalAddressList;

    private UpdateResourceRequest(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.resourceId = builder.resourceId;
        this.name = builder.name;
        this.bookingOptions = builder.bookingOptions;
        this.description = builder.description;
        this.type = builder.type;
        this.hiddenFromGlobalAddressList = builder.hiddenFromGlobalAddressList;
    }

    public final String organizationId() {
        return this.organizationId;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String name() {
        return this.name;
    }

    public final BookingOptions bookingOptions() {
        return this.bookingOptions;
    }

    public final String description() {
        return this.description;
    }

    public final ResourceType type() {
        return ResourceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Boolean hiddenFromGlobalAddressList() {
        return this.hiddenFromGlobalAddressList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.bookingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hiddenFromGlobalAddressList());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResourceRequest)) {
            return false;
        }
        UpdateResourceRequest other = (UpdateResourceRequest)((Object)obj);
        return Objects.equals(this.organizationId(), other.organizationId()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.bookingOptions(), other.bookingOptions()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.hiddenFromGlobalAddressList(), other.hiddenFromGlobalAddressList());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateResourceRequest").add("OrganizationId", (Object)this.organizationId()).add("ResourceId", (Object)this.resourceId()).add("Name", (Object)this.name()).add("BookingOptions", (Object)this.bookingOptions()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)this.typeAsString()).add("HiddenFromGlobalAddressList", (Object)this.hiddenFromGlobalAddressList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationId": {
                return Optional.ofNullable(clazz.cast(this.organizationId()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "BookingOptions": {
                return Optional.ofNullable(clazz.cast(this.bookingOptions()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "HiddenFromGlobalAddressList": {
                return Optional.ofNullable(clazz.cast(this.hiddenFromGlobalAddressList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OrganizationId", ORGANIZATION_ID_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("BookingOptions", BOOKING_OPTIONS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("HiddenFromGlobalAddressList", HIDDEN_FROM_GLOBAL_ADDRESS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateResourceRequest, T> g) {
        return obj -> g.apply((UpdateResourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailRequest.BuilderImpl
    implements Builder {
        private String organizationId;
        private String resourceId;
        private String name;
        private BookingOptions bookingOptions;
        private String description;
        private String type;
        private Boolean hiddenFromGlobalAddressList;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResourceRequest model) {
            super(model);
            this.organizationId(model.organizationId);
            this.resourceId(model.resourceId);
            this.name(model.name);
            this.bookingOptions(model.bookingOptions);
            this.description(model.description);
            this.type(model.type);
            this.hiddenFromGlobalAddressList(model.hiddenFromGlobalAddressList);
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final BookingOptions.Builder getBookingOptions() {
            return this.bookingOptions != null ? this.bookingOptions.toBuilder() : null;
        }

        public final void setBookingOptions(BookingOptions.BuilderImpl bookingOptions) {
            this.bookingOptions = bookingOptions != null ? bookingOptions.build() : null;
        }

        @Override
        public final Builder bookingOptions(BookingOptions bookingOptions) {
            this.bookingOptions = bookingOptions;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ResourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Boolean getHiddenFromGlobalAddressList() {
            return this.hiddenFromGlobalAddressList;
        }

        public final void setHiddenFromGlobalAddressList(Boolean hiddenFromGlobalAddressList) {
            this.hiddenFromGlobalAddressList = hiddenFromGlobalAddressList;
        }

        @Override
        public final Builder hiddenFromGlobalAddressList(Boolean hiddenFromGlobalAddressList) {
            this.hiddenFromGlobalAddressList = hiddenFromGlobalAddressList;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResourceRequest build() {
            return new UpdateResourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkMailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateResourceRequest> {
        public Builder organizationId(String var1);

        public Builder resourceId(String var1);

        public Builder name(String var1);

        public Builder bookingOptions(BookingOptions var1);

        default public Builder bookingOptions(Consumer<BookingOptions.Builder> bookingOptions) {
            return this.bookingOptions((BookingOptions)((BookingOptions.Builder)BookingOptions.builder().applyMutation(bookingOptions)).build());
        }

        public Builder description(String var1);

        public Builder type(String var1);

        public Builder type(ResourceType var1);

        public Builder hiddenFromGlobalAddressList(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

