/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGroupsRequest extends WorkMailRequest implements
        ToCopyableBuilder<ListGroupsRequest.Builder, ListGroupsRequest> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationId").getter(getter(ListGroupsRequest::organizationId))
            .setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListGroupsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListGroupsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<ListGroupsFilters> FILTERS_FIELD = SdkField
            .<ListGroupsFilters> builder(MarshallingType.SDK_POJO).memberName("Filters")
            .getter(getter(ListGroupsRequest::filters)).setter(setter(Builder::filters)).constructor(ListGroupsFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String organizationId;

    private final String nextToken;

    private final Integer maxResults;

    private final ListGroupsFilters filters;

    private ListGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * The identifier for the organization under which the groups exist.
     * </p>
     * 
     * @return The identifier for the organization under which the groups exist.
     */
    public final String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. The first call does not contain any tokens.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. The first call does not contain any tokens.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call.
     * </p>
     * 
     * @return The maximum number of results to return in a single call.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Limit the search results based on the filter criteria. Only one filter per request is supported.
     * </p>
     * 
     * @return Limit the search results based on the filter criteria. Only one filter per request is supported.
     */
    public final ListGroupsFilters filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupsRequest)) {
            return false;
        }
        ListGroupsRequest other = (ListGroupsRequest) obj;
        return Objects.equals(organizationId(), other.organizationId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListGroupsRequest").add("OrganizationId", organizationId()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("Filters", filters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OrganizationId", ORGANIZATION_ID_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("Filters", FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListGroupsRequest, T> g) {
        return obj -> g.apply((ListGroupsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListGroupsRequest> {
        /**
         * <p>
         * The identifier for the organization under which the groups exist.
         * </p>
         * 
         * @param organizationId
         *        The identifier for the organization under which the groups exist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * The token to use to retrieve the next page of results. The first call does not contain any tokens.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. The first call does not contain any tokens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return in a single call.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Limit the search results based on the filter criteria. Only one filter per request is supported.
         * </p>
         * 
         * @param filters
         *        Limit the search results based on the filter criteria. Only one filter per request is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ListGroupsFilters filters);

        /**
         * <p>
         * Limit the search results based on the filter criteria. Only one filter per request is supported.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListGroupsFilters.Builder} avoiding the
         * need to create one manually via {@link ListGroupsFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListGroupsFilters.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(ListGroupsFilters)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link ListGroupsFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(ListGroupsFilters)
         */
        default Builder filters(Consumer<ListGroupsFilters.Builder> filters) {
            return filters(ListGroupsFilters.builder().applyMutation(filters).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkMailRequest.BuilderImpl implements Builder {
        private String organizationId;

        private String nextToken;

        private Integer maxResults;

        private ListGroupsFilters filters;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupsRequest model) {
            super(model);
            organizationId(model.organizationId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            filters(model.filters);
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final ListGroupsFilters.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(ListGroupsFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(ListGroupsFilters filters) {
            this.filters = filters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListGroupsRequest build() {
            return new ListGroupsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
