/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the Personal Access Token.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PersonalAccessTokenSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<PersonalAccessTokenSummary.Builder, PersonalAccessTokenSummary> {
    private static final SdkField<String> PERSONAL_ACCESS_TOKEN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PersonalAccessTokenId").getter(getter(PersonalAccessTokenSummary::personalAccessTokenId))
            .setter(setter(Builder::personalAccessTokenId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersonalAccessTokenId").build())
            .build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(PersonalAccessTokenSummary::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(PersonalAccessTokenSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Instant> DATE_CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DateCreated").getter(getter(PersonalAccessTokenSummary::dateCreated))
            .setter(setter(Builder::dateCreated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateCreated").build()).build();

    private static final SdkField<Instant> DATE_LAST_USED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DateLastUsed").getter(getter(PersonalAccessTokenSummary::dateLastUsed))
            .setter(setter(Builder::dateLastUsed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateLastUsed").build()).build();

    private static final SdkField<Instant> EXPIRES_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpiresTime").getter(getter(PersonalAccessTokenSummary::expiresTime))
            .setter(setter(Builder::expiresTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiresTime").build()).build();

    private static final SdkField<List<String>> SCOPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Scopes")
            .getter(getter(PersonalAccessTokenSummary::scopes))
            .setter(setter(Builder::scopes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scopes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PERSONAL_ACCESS_TOKEN_ID_FIELD, USER_ID_FIELD, NAME_FIELD, DATE_CREATED_FIELD, DATE_LAST_USED_FIELD,
            EXPIRES_TIME_FIELD, SCOPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String personalAccessTokenId;

    private final String userId;

    private final String name;

    private final Instant dateCreated;

    private final Instant dateLastUsed;

    private final Instant expiresTime;

    private final List<String> scopes;

    private PersonalAccessTokenSummary(BuilderImpl builder) {
        this.personalAccessTokenId = builder.personalAccessTokenId;
        this.userId = builder.userId;
        this.name = builder.name;
        this.dateCreated = builder.dateCreated;
        this.dateLastUsed = builder.dateLastUsed;
        this.expiresTime = builder.expiresTime;
        this.scopes = builder.scopes;
    }

    /**
     * <p>
     * The ID of the Personal Access Token.
     * </p>
     * 
     * @return The ID of the Personal Access Token.
     */
    public final String personalAccessTokenId() {
        return personalAccessTokenId;
    }

    /**
     * <p>
     * The user ID of the WorkMail user associated with the Personal Access Token.
     * </p>
     * 
     * @return The user ID of the WorkMail user associated with the Personal Access Token.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * The name of the Personal Access Token.
     * </p>
     * 
     * @return The name of the Personal Access Token.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The date when the Personal Access Token was created.
     * </p>
     * 
     * @return The date when the Personal Access Token was created.
     */
    public final Instant dateCreated() {
        return dateCreated;
    }

    /**
     * <p>
     * The date when the Personal Access Token was last used.
     * </p>
     * 
     * @return The date when the Personal Access Token was last used.
     */
    public final Instant dateLastUsed() {
        return dateLastUsed;
    }

    /**
     * <p>
     * The date when the Personal Access Token will expire.
     * </p>
     * 
     * @return The date when the Personal Access Token will expire.
     */
    public final Instant expiresTime() {
        return expiresTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Scopes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasScopes() {
        return scopes != null && !(scopes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists all the Personal Access Token permissions for a mailbox.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScopes} method.
     * </p>
     * 
     * @return Lists all the Personal Access Token permissions for a mailbox.
     */
    public final List<String> scopes() {
        return scopes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(personalAccessTokenId());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(dateLastUsed());
        hashCode = 31 * hashCode + Objects.hashCode(expiresTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasScopes() ? scopes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PersonalAccessTokenSummary)) {
            return false;
        }
        PersonalAccessTokenSummary other = (PersonalAccessTokenSummary) obj;
        return Objects.equals(personalAccessTokenId(), other.personalAccessTokenId()) && Objects.equals(userId(), other.userId())
                && Objects.equals(name(), other.name()) && Objects.equals(dateCreated(), other.dateCreated())
                && Objects.equals(dateLastUsed(), other.dateLastUsed()) && Objects.equals(expiresTime(), other.expiresTime())
                && hasScopes() == other.hasScopes() && Objects.equals(scopes(), other.scopes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PersonalAccessTokenSummary").add("PersonalAccessTokenId", personalAccessTokenId())
                .add("UserId", userId()).add("Name", name()).add("DateCreated", dateCreated())
                .add("DateLastUsed", dateLastUsed()).add("ExpiresTime", expiresTime())
                .add("Scopes", hasScopes() ? scopes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PersonalAccessTokenId":
            return Optional.ofNullable(clazz.cast(personalAccessTokenId()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DateCreated":
            return Optional.ofNullable(clazz.cast(dateCreated()));
        case "DateLastUsed":
            return Optional.ofNullable(clazz.cast(dateLastUsed()));
        case "ExpiresTime":
            return Optional.ofNullable(clazz.cast(expiresTime()));
        case "Scopes":
            return Optional.ofNullable(clazz.cast(scopes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PersonalAccessTokenId", PERSONAL_ACCESS_TOKEN_ID_FIELD);
        map.put("UserId", USER_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("DateCreated", DATE_CREATED_FIELD);
        map.put("DateLastUsed", DATE_LAST_USED_FIELD);
        map.put("ExpiresTime", EXPIRES_TIME_FIELD);
        map.put("Scopes", SCOPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PersonalAccessTokenSummary, T> g) {
        return obj -> g.apply((PersonalAccessTokenSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PersonalAccessTokenSummary> {
        /**
         * <p>
         * The ID of the Personal Access Token.
         * </p>
         * 
         * @param personalAccessTokenId
         *        The ID of the Personal Access Token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder personalAccessTokenId(String personalAccessTokenId);

        /**
         * <p>
         * The user ID of the WorkMail user associated with the Personal Access Token.
         * </p>
         * 
         * @param userId
         *        The user ID of the WorkMail user associated with the Personal Access Token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The name of the Personal Access Token.
         * </p>
         * 
         * @param name
         *        The name of the Personal Access Token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The date when the Personal Access Token was created.
         * </p>
         * 
         * @param dateCreated
         *        The date when the Personal Access Token was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateCreated(Instant dateCreated);

        /**
         * <p>
         * The date when the Personal Access Token was last used.
         * </p>
         * 
         * @param dateLastUsed
         *        The date when the Personal Access Token was last used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateLastUsed(Instant dateLastUsed);

        /**
         * <p>
         * The date when the Personal Access Token will expire.
         * </p>
         * 
         * @param expiresTime
         *        The date when the Personal Access Token will expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresTime(Instant expiresTime);

        /**
         * <p>
         * Lists all the Personal Access Token permissions for a mailbox.
         * </p>
         * 
         * @param scopes
         *        Lists all the Personal Access Token permissions for a mailbox.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopes(Collection<String> scopes);

        /**
         * <p>
         * Lists all the Personal Access Token permissions for a mailbox.
         * </p>
         * 
         * @param scopes
         *        Lists all the Personal Access Token permissions for a mailbox.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scopes(String... scopes);
    }

    static final class BuilderImpl implements Builder {
        private String personalAccessTokenId;

        private String userId;

        private String name;

        private Instant dateCreated;

        private Instant dateLastUsed;

        private Instant expiresTime;

        private List<String> scopes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PersonalAccessTokenSummary model) {
            personalAccessTokenId(model.personalAccessTokenId);
            userId(model.userId);
            name(model.name);
            dateCreated(model.dateCreated);
            dateLastUsed(model.dateLastUsed);
            expiresTime(model.expiresTime);
            scopes(model.scopes);
        }

        public final String getPersonalAccessTokenId() {
            return personalAccessTokenId;
        }

        public final void setPersonalAccessTokenId(String personalAccessTokenId) {
            this.personalAccessTokenId = personalAccessTokenId;
        }

        @Override
        public final Builder personalAccessTokenId(String personalAccessTokenId) {
            this.personalAccessTokenId = personalAccessTokenId;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getDateCreated() {
            return dateCreated;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        @Override
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final Instant getDateLastUsed() {
            return dateLastUsed;
        }

        public final void setDateLastUsed(Instant dateLastUsed) {
            this.dateLastUsed = dateLastUsed;
        }

        @Override
        public final Builder dateLastUsed(Instant dateLastUsed) {
            this.dateLastUsed = dateLastUsed;
            return this;
        }

        public final Instant getExpiresTime() {
            return expiresTime;
        }

        public final void setExpiresTime(Instant expiresTime) {
            this.expiresTime = expiresTime;
        }

        @Override
        public final Builder expiresTime(Instant expiresTime) {
            this.expiresTime = expiresTime;
            return this;
        }

        public final Collection<String> getScopes() {
            if (scopes instanceof SdkAutoConstructList) {
                return null;
            }
            return scopes;
        }

        public final void setScopes(Collection<String> scopes) {
            this.scopes = PersonalAccessTokenScopeListCopier.copy(scopes);
        }

        @Override
        public final Builder scopes(Collection<String> scopes) {
            this.scopes = PersonalAccessTokenScopeListCopier.copy(scopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scopes(String... scopes) {
            scopes(Arrays.asList(scopes));
            return this;
        }

        @Override
        public PersonalAccessTokenSummary build() {
            return new PersonalAccessTokenSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
