/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAvailabilityConfigurationRequest extends WorkMailRequest implements
        ToCopyableBuilder<CreateAvailabilityConfigurationRequest.Builder, CreateAvailabilityConfigurationRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateAvailabilityConfigurationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationId").getter(getter(CreateAvailabilityConfigurationRequest::organizationId))
            .setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(CreateAvailabilityConfigurationRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<EwsAvailabilityProvider> EWS_PROVIDER_FIELD = SdkField
            .<EwsAvailabilityProvider> builder(MarshallingType.SDK_POJO).memberName("EwsProvider")
            .getter(getter(CreateAvailabilityConfigurationRequest::ewsProvider)).setter(setter(Builder::ewsProvider))
            .constructor(EwsAvailabilityProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EwsProvider").build()).build();

    private static final SdkField<LambdaAvailabilityProvider> LAMBDA_PROVIDER_FIELD = SdkField
            .<LambdaAvailabilityProvider> builder(MarshallingType.SDK_POJO).memberName("LambdaProvider")
            .getter(getter(CreateAvailabilityConfigurationRequest::lambdaProvider)).setter(setter(Builder::lambdaProvider))
            .constructor(LambdaAvailabilityProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaProvider").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            ORGANIZATION_ID_FIELD, DOMAIN_NAME_FIELD, EWS_PROVIDER_FIELD, LAMBDA_PROVIDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String organizationId;

    private final String domainName;

    private final EwsAvailabilityProvider ewsProvider;

    private final LambdaAvailabilityProvider lambdaProvider;

    private CreateAvailabilityConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.organizationId = builder.organizationId;
        this.domainName = builder.domainName;
        this.ewsProvider = builder.ewsProvider;
        this.lambdaProvider = builder.lambdaProvider;
    }

    /**
     * <p>
     * An idempotent token that ensures that an API request is executed only once.
     * </p>
     * 
     * @return An idempotent token that ensures that an API request is executed only once.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The WorkMail organization for which the <code>AvailabilityConfiguration</code> will be created.
     * </p>
     * 
     * @return The WorkMail organization for which the <code>AvailabilityConfiguration</code> will be created.
     */
    public final String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * The domain to which the provider applies.
     * </p>
     * 
     * @return The domain to which the provider applies.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Exchange Web Services (EWS) availability provider definition. The request must contain exactly one provider
     * definition, either <code>EwsProvider</code> or <code>LambdaProvider</code>.
     * </p>
     * 
     * @return Exchange Web Services (EWS) availability provider definition. The request must contain exactly one
     *         provider definition, either <code>EwsProvider</code> or <code>LambdaProvider</code>.
     */
    public final EwsAvailabilityProvider ewsProvider() {
        return ewsProvider;
    }

    /**
     * <p>
     * Lambda availability provider definition. The request must contain exactly one provider definition, either
     * <code>EwsProvider</code> or <code>LambdaProvider</code>.
     * </p>
     * 
     * @return Lambda availability provider definition. The request must contain exactly one provider definition, either
     *         <code>EwsProvider</code> or <code>LambdaProvider</code>.
     */
    public final LambdaAvailabilityProvider lambdaProvider() {
        return lambdaProvider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(ewsProvider());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaProvider());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAvailabilityConfigurationRequest)) {
            return false;
        }
        CreateAvailabilityConfigurationRequest other = (CreateAvailabilityConfigurationRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(organizationId(), other.organizationId())
                && Objects.equals(domainName(), other.domainName()) && Objects.equals(ewsProvider(), other.ewsProvider())
                && Objects.equals(lambdaProvider(), other.lambdaProvider());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAvailabilityConfigurationRequest").add("ClientToken", clientToken())
                .add("OrganizationId", organizationId()).add("DomainName", domainName()).add("EwsProvider", ewsProvider())
                .add("LambdaProvider", lambdaProvider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "EwsProvider":
            return Optional.ofNullable(clazz.cast(ewsProvider()));
        case "LambdaProvider":
            return Optional.ofNullable(clazz.cast(lambdaProvider()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("OrganizationId", ORGANIZATION_ID_FIELD);
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("EwsProvider", EWS_PROVIDER_FIELD);
        map.put("LambdaProvider", LAMBDA_PROVIDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAvailabilityConfigurationRequest, T> g) {
        return obj -> g.apply((CreateAvailabilityConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAvailabilityConfigurationRequest> {
        /**
         * <p>
         * An idempotent token that ensures that an API request is executed only once.
         * </p>
         * 
         * @param clientToken
         *        An idempotent token that ensures that an API request is executed only once.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The WorkMail organization for which the <code>AvailabilityConfiguration</code> will be created.
         * </p>
         * 
         * @param organizationId
         *        The WorkMail organization for which the <code>AvailabilityConfiguration</code> will be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * The domain to which the provider applies.
         * </p>
         * 
         * @param domainName
         *        The domain to which the provider applies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Exchange Web Services (EWS) availability provider definition. The request must contain exactly one provider
         * definition, either <code>EwsProvider</code> or <code>LambdaProvider</code>.
         * </p>
         * 
         * @param ewsProvider
         *        Exchange Web Services (EWS) availability provider definition. The request must contain exactly one
         *        provider definition, either <code>EwsProvider</code> or <code>LambdaProvider</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ewsProvider(EwsAvailabilityProvider ewsProvider);

        /**
         * <p>
         * Exchange Web Services (EWS) availability provider definition. The request must contain exactly one provider
         * definition, either <code>EwsProvider</code> or <code>LambdaProvider</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link EwsAvailabilityProvider.Builder} avoiding
         * the need to create one manually via {@link EwsAvailabilityProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EwsAvailabilityProvider.Builder#build()} is called immediately
         * and its result is passed to {@link #ewsProvider(EwsAvailabilityProvider)}.
         * 
         * @param ewsProvider
         *        a consumer that will call methods on {@link EwsAvailabilityProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ewsProvider(EwsAvailabilityProvider)
         */
        default Builder ewsProvider(Consumer<EwsAvailabilityProvider.Builder> ewsProvider) {
            return ewsProvider(EwsAvailabilityProvider.builder().applyMutation(ewsProvider).build());
        }

        /**
         * <p>
         * Lambda availability provider definition. The request must contain exactly one provider definition, either
         * <code>EwsProvider</code> or <code>LambdaProvider</code>.
         * </p>
         * 
         * @param lambdaProvider
         *        Lambda availability provider definition. The request must contain exactly one provider definition,
         *        either <code>EwsProvider</code> or <code>LambdaProvider</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaProvider(LambdaAvailabilityProvider lambdaProvider);

        /**
         * <p>
         * Lambda availability provider definition. The request must contain exactly one provider definition, either
         * <code>EwsProvider</code> or <code>LambdaProvider</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link LambdaAvailabilityProvider.Builder}
         * avoiding the need to create one manually via {@link LambdaAvailabilityProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaAvailabilityProvider.Builder#build()} is called immediately
         * and its result is passed to {@link #lambdaProvider(LambdaAvailabilityProvider)}.
         * 
         * @param lambdaProvider
         *        a consumer that will call methods on {@link LambdaAvailabilityProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaProvider(LambdaAvailabilityProvider)
         */
        default Builder lambdaProvider(Consumer<LambdaAvailabilityProvider.Builder> lambdaProvider) {
            return lambdaProvider(LambdaAvailabilityProvider.builder().applyMutation(lambdaProvider).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkMailRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String organizationId;

        private String domainName;

        private EwsAvailabilityProvider ewsProvider;

        private LambdaAvailabilityProvider lambdaProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAvailabilityConfigurationRequest model) {
            super(model);
            clientToken(model.clientToken);
            organizationId(model.organizationId);
            domainName(model.domainName);
            ewsProvider(model.ewsProvider);
            lambdaProvider(model.lambdaProvider);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final EwsAvailabilityProvider.Builder getEwsProvider() {
            return ewsProvider != null ? ewsProvider.toBuilder() : null;
        }

        public final void setEwsProvider(EwsAvailabilityProvider.BuilderImpl ewsProvider) {
            this.ewsProvider = ewsProvider != null ? ewsProvider.build() : null;
        }

        @Override
        public final Builder ewsProvider(EwsAvailabilityProvider ewsProvider) {
            this.ewsProvider = ewsProvider;
            return this;
        }

        public final LambdaAvailabilityProvider.Builder getLambdaProvider() {
            return lambdaProvider != null ? lambdaProvider.toBuilder() : null;
        }

        public final void setLambdaProvider(LambdaAvailabilityProvider.BuilderImpl lambdaProvider) {
            this.lambdaProvider = lambdaProvider != null ? lambdaProvider.build() : null;
        }

        @Override
        public final Builder lambdaProvider(LambdaAvailabilityProvider lambdaProvider) {
            this.lambdaProvider = lambdaProvider;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAvailabilityConfigurationRequest build() {
            return new CreateAvailabilityConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
