/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteImpersonationRoleRequest extends WorkMailRequest implements
        ToCopyableBuilder<DeleteImpersonationRoleRequest.Builder, DeleteImpersonationRoleRequest> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationId").getter(getter(DeleteImpersonationRoleRequest::organizationId))
            .setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()).build();

    private static final SdkField<String> IMPERSONATION_ROLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImpersonationRoleId").getter(getter(DeleteImpersonationRoleRequest::impersonationRoleId))
            .setter(setter(Builder::impersonationRoleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImpersonationRoleId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD,
            IMPERSONATION_ROLE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String organizationId;

    private final String impersonationRoleId;

    private DeleteImpersonationRoleRequest(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.impersonationRoleId = builder.impersonationRoleId;
    }

    /**
     * <p>
     * The WorkMail organization from which to delete the impersonation role.
     * </p>
     * 
     * @return The WorkMail organization from which to delete the impersonation role.
     */
    public final String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * The ID of the impersonation role to delete.
     * </p>
     * 
     * @return The ID of the impersonation role to delete.
     */
    public final String impersonationRoleId() {
        return impersonationRoleId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(impersonationRoleId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteImpersonationRoleRequest)) {
            return false;
        }
        DeleteImpersonationRoleRequest other = (DeleteImpersonationRoleRequest) obj;
        return Objects.equals(organizationId(), other.organizationId())
                && Objects.equals(impersonationRoleId(), other.impersonationRoleId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteImpersonationRoleRequest").add("OrganizationId", organizationId())
                .add("ImpersonationRoleId", impersonationRoleId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "ImpersonationRoleId":
            return Optional.ofNullable(clazz.cast(impersonationRoleId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OrganizationId", ORGANIZATION_ID_FIELD);
        map.put("ImpersonationRoleId", IMPERSONATION_ROLE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteImpersonationRoleRequest, T> g) {
        return obj -> g.apply((DeleteImpersonationRoleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteImpersonationRoleRequest> {
        /**
         * <p>
         * The WorkMail organization from which to delete the impersonation role.
         * </p>
         * 
         * @param organizationId
         *        The WorkMail organization from which to delete the impersonation role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * The ID of the impersonation role to delete.
         * </p>
         * 
         * @param impersonationRoleId
         *        The ID of the impersonation role to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impersonationRoleId(String impersonationRoleId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkMailRequest.BuilderImpl implements Builder {
        private String organizationId;

        private String impersonationRoleId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteImpersonationRoleRequest model) {
            super(model);
            organizationId(model.organizationId);
            impersonationRoleId(model.impersonationRoleId);
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getImpersonationRoleId() {
            return impersonationRoleId;
        }

        public final void setImpersonationRoleId(String impersonationRoleId) {
            this.impersonationRoleId = impersonationRoleId;
        }

        @Override
        public final Builder impersonationRoleId(String impersonationRoleId) {
            this.impersonationRoleId = impersonationRoleId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteImpersonationRoleRequest build() {
            return new DeleteImpersonationRoleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
