/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetImpersonationRoleEffectResponse extends WorkMailResponse implements
        ToCopyableBuilder<GetImpersonationRoleEffectResponse.Builder, GetImpersonationRoleEffectResponse> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(GetImpersonationRoleEffectResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> EFFECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Effect")
            .getter(getter(GetImpersonationRoleEffectResponse::effectAsString)).setter(setter(Builder::effect))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Effect").build()).build();

    private static final SdkField<List<ImpersonationMatchedRule>> MATCHED_RULES_FIELD = SdkField
            .<List<ImpersonationMatchedRule>> builder(MarshallingType.LIST)
            .memberName("MatchedRules")
            .getter(getter(GetImpersonationRoleEffectResponse::matchedRules))
            .setter(setter(Builder::matchedRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchedRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImpersonationMatchedRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImpersonationMatchedRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, EFFECT_FIELD,
            MATCHED_RULES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String type;

    private final String effect;

    private final List<ImpersonationMatchedRule> matchedRules;

    private GetImpersonationRoleEffectResponse(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.effect = builder.effect;
        this.matchedRules = builder.matchedRules;
    }

    /**
     * <p>
     * The impersonation role type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ImpersonationRoleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The impersonation role type.
     * @see ImpersonationRoleType
     */
    public final ImpersonationRoleType type() {
        return ImpersonationRoleType.fromValue(type);
    }

    /**
     * <p>
     * The impersonation role type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ImpersonationRoleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The impersonation role type.
     * @see ImpersonationRoleType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * <code/>Effect of the impersonation role on the target user based on its rules. Available effects are <code>ALLOW</code>
     * or <code>DENY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #effect} will
     * return {@link AccessEffect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #effectAsString}.
     * </p>
     * 
     * @return <code/>Effect of the impersonation role on the target user based on its rules. Available effects are <code>ALLOW</code>
     *         or <code>DENY</code>.
     * @see AccessEffect
     */
    public final AccessEffect effect() {
        return AccessEffect.fromValue(effect);
    }

    /**
     * <p>
     * <code/>Effect of the impersonation role on the target user based on its rules. Available effects are <code>ALLOW</code>
     * or <code>DENY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #effect} will
     * return {@link AccessEffect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #effectAsString}.
     * </p>
     * 
     * @return <code/>Effect of the impersonation role on the target user based on its rules. Available effects are <code>ALLOW</code>
     *         or <code>DENY</code>.
     * @see AccessEffect
     */
    public final String effectAsString() {
        return effect;
    }

    /**
     * For responses, this returns true if the service returned a value for the MatchedRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMatchedRules() {
        return matchedRules != null && !(matchedRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the rules that match the input and produce the configured effect.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMatchedRules} method.
     * </p>
     * 
     * @return A list of the rules that match the input and produce the configured effect.
     */
    public final List<ImpersonationMatchedRule> matchedRules() {
        return matchedRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(effectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasMatchedRules() ? matchedRules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetImpersonationRoleEffectResponse)) {
            return false;
        }
        GetImpersonationRoleEffectResponse other = (GetImpersonationRoleEffectResponse) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(effectAsString(), other.effectAsString())
                && hasMatchedRules() == other.hasMatchedRules() && Objects.equals(matchedRules(), other.matchedRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetImpersonationRoleEffectResponse").add("Type", typeAsString()).add("Effect", effectAsString())
                .add("MatchedRules", hasMatchedRules() ? matchedRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Effect":
            return Optional.ofNullable(clazz.cast(effectAsString()));
        case "MatchedRules":
            return Optional.ofNullable(clazz.cast(matchedRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("Effect", EFFECT_FIELD);
        map.put("MatchedRules", MATCHED_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetImpersonationRoleEffectResponse, T> g) {
        return obj -> g.apply((GetImpersonationRoleEffectResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetImpersonationRoleEffectResponse> {
        /**
         * <p>
         * The impersonation role type.
         * </p>
         * 
         * @param type
         *        The impersonation role type.
         * @see ImpersonationRoleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImpersonationRoleType
         */
        Builder type(String type);

        /**
         * <p>
         * The impersonation role type.
         * </p>
         * 
         * @param type
         *        The impersonation role type.
         * @see ImpersonationRoleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImpersonationRoleType
         */
        Builder type(ImpersonationRoleType type);

        /**
         * <p>
         * <code/>Effect of the impersonation role on the target user based on its rules. Available effects are <code>ALLOW</code>
         * or <code>DENY</code>.
         * </p>
         * 
         * @param effect
         *        <code/>Effect of the impersonation role on the target user based on its rules. Available effects are <code>ALLOW</code>
         *        or <code>DENY</code>.
         * @see AccessEffect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessEffect
         */
        Builder effect(String effect);

        /**
         * <p>
         * <code/>Effect of the impersonation role on the target user based on its rules. Available effects are <code>ALLOW</code>
         * or <code>DENY</code>.
         * </p>
         * 
         * @param effect
         *        <code/>Effect of the impersonation role on the target user based on its rules. Available effects are <code>ALLOW</code>
         *        or <code>DENY</code>.
         * @see AccessEffect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessEffect
         */
        Builder effect(AccessEffect effect);

        /**
         * <p>
         * A list of the rules that match the input and produce the configured effect.
         * </p>
         * 
         * @param matchedRules
         *        A list of the rules that match the input and produce the configured effect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchedRules(Collection<ImpersonationMatchedRule> matchedRules);

        /**
         * <p>
         * A list of the rules that match the input and produce the configured effect.
         * </p>
         * 
         * @param matchedRules
         *        A list of the rules that match the input and produce the configured effect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchedRules(ImpersonationMatchedRule... matchedRules);

        /**
         * <p>
         * A list of the rules that match the input and produce the configured effect.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workmail.model.ImpersonationMatchedRule.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.workmail.model.ImpersonationMatchedRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workmail.model.ImpersonationMatchedRule.Builder#build()} is called
         * immediately and its result is passed to {@link #matchedRules(List<ImpersonationMatchedRule>)}.
         * 
         * @param matchedRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workmail.model.ImpersonationMatchedRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #matchedRules(java.util.Collection<ImpersonationMatchedRule>)
         */
        Builder matchedRules(Consumer<ImpersonationMatchedRule.Builder>... matchedRules);
    }

    static final class BuilderImpl extends WorkMailResponse.BuilderImpl implements Builder {
        private String type;

        private String effect;

        private List<ImpersonationMatchedRule> matchedRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetImpersonationRoleEffectResponse model) {
            super(model);
            type(model.type);
            effect(model.effect);
            matchedRules(model.matchedRules);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ImpersonationRoleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getEffect() {
            return effect;
        }

        public final void setEffect(String effect) {
            this.effect = effect;
        }

        @Override
        public final Builder effect(String effect) {
            this.effect = effect;
            return this;
        }

        @Override
        public final Builder effect(AccessEffect effect) {
            this.effect(effect == null ? null : effect.toString());
            return this;
        }

        public final List<ImpersonationMatchedRule.Builder> getMatchedRules() {
            List<ImpersonationMatchedRule.Builder> result = ImpersonationMatchedRuleListCopier.copyToBuilder(this.matchedRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMatchedRules(Collection<ImpersonationMatchedRule.BuilderImpl> matchedRules) {
            this.matchedRules = ImpersonationMatchedRuleListCopier.copyFromBuilder(matchedRules);
        }

        @Override
        public final Builder matchedRules(Collection<ImpersonationMatchedRule> matchedRules) {
            this.matchedRules = ImpersonationMatchedRuleListCopier.copy(matchedRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchedRules(ImpersonationMatchedRule... matchedRules) {
            matchedRules(Arrays.asList(matchedRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchedRules(Consumer<ImpersonationMatchedRule.Builder>... matchedRules) {
            matchedRules(Stream.of(matchedRules).map(c -> ImpersonationMatchedRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetImpersonationRoleEffectResponse build() {
            return new GetImpersonationRoleEffectResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
