/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssumeImpersonationRoleResponse extends WorkMailResponse implements
        ToCopyableBuilder<AssumeImpersonationRoleResponse.Builder, AssumeImpersonationRoleResponse> {
    private static final SdkField<String> TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Token")
            .getter(getter(AssumeImpersonationRoleResponse::token)).setter(setter(Builder::token))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Token").build()).build();

    private static final SdkField<Long> EXPIRES_IN_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("ExpiresIn")
            .getter(getter(AssumeImpersonationRoleResponse::expiresIn)).setter(setter(Builder::expiresIn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiresIn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(TOKEN_FIELD, EXPIRES_IN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String token;

    private final Long expiresIn;

    private AssumeImpersonationRoleResponse(BuilderImpl builder) {
        super(builder);
        this.token = builder.token;
        this.expiresIn = builder.expiresIn;
    }

    /**
     * <p>
     * The authentication token for the impersonation role.
     * </p>
     * 
     * @return The authentication token for the impersonation role.
     */
    public final String token() {
        return token;
    }

    /**
     * <p>
     * The authentication token's validity, in seconds.
     * </p>
     * 
     * @return The authentication token's validity, in seconds.
     */
    public final Long expiresIn() {
        return expiresIn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(token());
        hashCode = 31 * hashCode + Objects.hashCode(expiresIn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssumeImpersonationRoleResponse)) {
            return false;
        }
        AssumeImpersonationRoleResponse other = (AssumeImpersonationRoleResponse) obj;
        return Objects.equals(token(), other.token()) && Objects.equals(expiresIn(), other.expiresIn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssumeImpersonationRoleResponse").add("Token", token()).add("ExpiresIn", expiresIn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Token":
            return Optional.ofNullable(clazz.cast(token()));
        case "ExpiresIn":
            return Optional.ofNullable(clazz.cast(expiresIn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Token", TOKEN_FIELD);
        map.put("ExpiresIn", EXPIRES_IN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssumeImpersonationRoleResponse, T> g) {
        return obj -> g.apply((AssumeImpersonationRoleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailResponse.Builder, SdkPojo, CopyableBuilder<Builder, AssumeImpersonationRoleResponse> {
        /**
         * <p>
         * The authentication token for the impersonation role.
         * </p>
         * 
         * @param token
         *        The authentication token for the impersonation role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder token(String token);

        /**
         * <p>
         * The authentication token's validity, in seconds.
         * </p>
         * 
         * @param expiresIn
         *        The authentication token's validity, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresIn(Long expiresIn);
    }

    static final class BuilderImpl extends WorkMailResponse.BuilderImpl implements Builder {
        private String token;

        private Long expiresIn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssumeImpersonationRoleResponse model) {
            super(model);
            token(model.token);
            expiresIn(model.expiresIn);
        }

        public final String getToken() {
            return token;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final Long getExpiresIn() {
            return expiresIn;
        }

        public final void setExpiresIn(Long expiresIn) {
            this.expiresIn = expiresIn;
        }

        @Override
        public final Builder expiresIn(Long expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        @Override
        public AssumeImpersonationRoleResponse build() {
            return new AssumeImpersonationRoleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
