/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteOrganizationRequest extends WorkMailRequest implements
        ToCopyableBuilder<DeleteOrganizationRequest.Builder, DeleteOrganizationRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(DeleteOrganizationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationId").getter(getter(DeleteOrganizationRequest::organizationId))
            .setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()).build();

    private static final SdkField<Boolean> DELETE_DIRECTORY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteDirectory").getter(getter(DeleteOrganizationRequest::deleteDirectory))
            .setter(setter(Builder::deleteDirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteDirectory").build()).build();

    private static final SdkField<Boolean> FORCE_DELETE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ForceDelete").getter(getter(DeleteOrganizationRequest::forceDelete))
            .setter(setter(Builder::forceDelete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForceDelete").build()).build();

    private static final SdkField<Boolean> DELETE_IDENTITY_CENTER_APPLICATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteIdentityCenterApplication")
            .getter(getter(DeleteOrganizationRequest::deleteIdentityCenterApplication))
            .setter(setter(Builder::deleteIdentityCenterApplication))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteIdentityCenterApplication")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            ORGANIZATION_ID_FIELD, DELETE_DIRECTORY_FIELD, FORCE_DELETE_FIELD, DELETE_IDENTITY_CENTER_APPLICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String organizationId;

    private final Boolean deleteDirectory;

    private final Boolean forceDelete;

    private final Boolean deleteIdentityCenterApplication;

    private DeleteOrganizationRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.organizationId = builder.organizationId;
        this.deleteDirectory = builder.deleteDirectory;
        this.forceDelete = builder.forceDelete;
        this.deleteIdentityCenterApplication = builder.deleteIdentityCenterApplication;
    }

    /**
     * <p>
     * The idempotency token associated with the request.
     * </p>
     * 
     * @return The idempotency token associated with the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The organization ID.
     * </p>
     * 
     * @return The organization ID.
     */
    public final String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * If true, deletes the AWS Directory Service directory associated with the organization.
     * </p>
     * 
     * @return If true, deletes the AWS Directory Service directory associated with the organization.
     */
    public final Boolean deleteDirectory() {
        return deleteDirectory;
    }

    /**
     * <p>
     * Deletes a WorkMail organization even if the organization has enabled users.
     * </p>
     * 
     * @return Deletes a WorkMail organization even if the organization has enabled users.
     */
    public final Boolean forceDelete() {
        return forceDelete;
    }

    /**
     * <p>
     * Deletes IAM Identity Center application for WorkMail. This action does not affect authentication settings for any
     * organization.
     * </p>
     * 
     * @return Deletes IAM Identity Center application for WorkMail. This action does not affect authentication settings
     *         for any organization.
     */
    public final Boolean deleteIdentityCenterApplication() {
        return deleteIdentityCenterApplication;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(deleteDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(forceDelete());
        hashCode = 31 * hashCode + Objects.hashCode(deleteIdentityCenterApplication());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteOrganizationRequest)) {
            return false;
        }
        DeleteOrganizationRequest other = (DeleteOrganizationRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(organizationId(), other.organizationId())
                && Objects.equals(deleteDirectory(), other.deleteDirectory())
                && Objects.equals(forceDelete(), other.forceDelete())
                && Objects.equals(deleteIdentityCenterApplication(), other.deleteIdentityCenterApplication());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteOrganizationRequest").add("ClientToken", clientToken())
                .add("OrganizationId", organizationId()).add("DeleteDirectory", deleteDirectory())
                .add("ForceDelete", forceDelete()).add("DeleteIdentityCenterApplication", deleteIdentityCenterApplication())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "DeleteDirectory":
            return Optional.ofNullable(clazz.cast(deleteDirectory()));
        case "ForceDelete":
            return Optional.ofNullable(clazz.cast(forceDelete()));
        case "DeleteIdentityCenterApplication":
            return Optional.ofNullable(clazz.cast(deleteIdentityCenterApplication()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("OrganizationId", ORGANIZATION_ID_FIELD);
        map.put("DeleteDirectory", DELETE_DIRECTORY_FIELD);
        map.put("ForceDelete", FORCE_DELETE_FIELD);
        map.put("DeleteIdentityCenterApplication", DELETE_IDENTITY_CENTER_APPLICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteOrganizationRequest, T> g) {
        return obj -> g.apply((DeleteOrganizationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteOrganizationRequest> {
        /**
         * <p>
         * The idempotency token associated with the request.
         * </p>
         * 
         * @param clientToken
         *        The idempotency token associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The organization ID.
         * </p>
         * 
         * @param organizationId
         *        The organization ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * If true, deletes the AWS Directory Service directory associated with the organization.
         * </p>
         * 
         * @param deleteDirectory
         *        If true, deletes the AWS Directory Service directory associated with the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteDirectory(Boolean deleteDirectory);

        /**
         * <p>
         * Deletes a WorkMail organization even if the organization has enabled users.
         * </p>
         * 
         * @param forceDelete
         *        Deletes a WorkMail organization even if the organization has enabled users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceDelete(Boolean forceDelete);

        /**
         * <p>
         * Deletes IAM Identity Center application for WorkMail. This action does not affect authentication settings for
         * any organization.
         * </p>
         * 
         * @param deleteIdentityCenterApplication
         *        Deletes IAM Identity Center application for WorkMail. This action does not affect authentication
         *        settings for any organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteIdentityCenterApplication(Boolean deleteIdentityCenterApplication);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkMailRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String organizationId;

        private Boolean deleteDirectory;

        private Boolean forceDelete;

        private Boolean deleteIdentityCenterApplication;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteOrganizationRequest model) {
            super(model);
            clientToken(model.clientToken);
            organizationId(model.organizationId);
            deleteDirectory(model.deleteDirectory);
            forceDelete(model.forceDelete);
            deleteIdentityCenterApplication(model.deleteIdentityCenterApplication);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final Boolean getDeleteDirectory() {
            return deleteDirectory;
        }

        public final void setDeleteDirectory(Boolean deleteDirectory) {
            this.deleteDirectory = deleteDirectory;
        }

        @Override
        public final Builder deleteDirectory(Boolean deleteDirectory) {
            this.deleteDirectory = deleteDirectory;
            return this;
        }

        public final Boolean getForceDelete() {
            return forceDelete;
        }

        public final void setForceDelete(Boolean forceDelete) {
            this.forceDelete = forceDelete;
        }

        @Override
        public final Builder forceDelete(Boolean forceDelete) {
            this.forceDelete = forceDelete;
            return this;
        }

        public final Boolean getDeleteIdentityCenterApplication() {
            return deleteIdentityCenterApplication;
        }

        public final void setDeleteIdentityCenterApplication(Boolean deleteIdentityCenterApplication) {
            this.deleteIdentityCenterApplication = deleteIdentityCenterApplication;
        }

        @Override
        public final Builder deleteIdentityCenterApplication(Boolean deleteIdentityCenterApplication) {
            this.deleteIdentityCenterApplication = deleteIdentityCenterApplication;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteOrganizationRequest build() {
            return new DeleteOrganizationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
