/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeIdentityProviderConfigurationResponse extends WorkMailResponse implements
        ToCopyableBuilder<DescribeIdentityProviderConfigurationResponse.Builder, DescribeIdentityProviderConfigurationResponse> {
    private static final SdkField<String> AUTHENTICATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationMode")
            .getter(getter(DescribeIdentityProviderConfigurationResponse::authenticationModeAsString))
            .setter(setter(Builder::authenticationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationMode").build())
            .build();

    private static final SdkField<IdentityCenterConfiguration> IDENTITY_CENTER_CONFIGURATION_FIELD = SdkField
            .<IdentityCenterConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("IdentityCenterConfiguration")
            .getter(getter(DescribeIdentityProviderConfigurationResponse::identityCenterConfiguration))
            .setter(setter(Builder::identityCenterConfiguration))
            .constructor(IdentityCenterConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityCenterConfiguration")
                    .build()).build();

    private static final SdkField<PersonalAccessTokenConfiguration> PERSONAL_ACCESS_TOKEN_CONFIGURATION_FIELD = SdkField
            .<PersonalAccessTokenConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("PersonalAccessTokenConfiguration")
            .getter(getter(DescribeIdentityProviderConfigurationResponse::personalAccessTokenConfiguration))
            .setter(setter(Builder::personalAccessTokenConfiguration))
            .constructor(PersonalAccessTokenConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersonalAccessTokenConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_MODE_FIELD,
            IDENTITY_CENTER_CONFIGURATION_FIELD, PERSONAL_ACCESS_TOKEN_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String authenticationMode;

    private final IdentityCenterConfiguration identityCenterConfiguration;

    private final PersonalAccessTokenConfiguration personalAccessTokenConfiguration;

    private DescribeIdentityProviderConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.authenticationMode = builder.authenticationMode;
        this.identityCenterConfiguration = builder.identityCenterConfiguration;
        this.personalAccessTokenConfiguration = builder.personalAccessTokenConfiguration;
    }

    /**
     * <p>
     * The authentication mode used in WorkMail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationMode} will return {@link IdentityProviderAuthenticationMode#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #authenticationModeAsString}.
     * </p>
     * 
     * @return The authentication mode used in WorkMail.
     * @see IdentityProviderAuthenticationMode
     */
    public final IdentityProviderAuthenticationMode authenticationMode() {
        return IdentityProviderAuthenticationMode.fromValue(authenticationMode);
    }

    /**
     * <p>
     * The authentication mode used in WorkMail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationMode} will return {@link IdentityProviderAuthenticationMode#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #authenticationModeAsString}.
     * </p>
     * 
     * @return The authentication mode used in WorkMail.
     * @see IdentityProviderAuthenticationMode
     */
    public final String authenticationModeAsString() {
        return authenticationMode;
    }

    /**
     * <p>
     * The details of the IAM Identity Center configuration.
     * </p>
     * 
     * @return The details of the IAM Identity Center configuration.
     */
    public final IdentityCenterConfiguration identityCenterConfiguration() {
        return identityCenterConfiguration;
    }

    /**
     * <p>
     * The details of the Personal Access Token configuration.
     * </p>
     * 
     * @return The details of the Personal Access Token configuration.
     */
    public final PersonalAccessTokenConfiguration personalAccessTokenConfiguration() {
        return personalAccessTokenConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authenticationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identityCenterConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(personalAccessTokenConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIdentityProviderConfigurationResponse)) {
            return false;
        }
        DescribeIdentityProviderConfigurationResponse other = (DescribeIdentityProviderConfigurationResponse) obj;
        return Objects.equals(authenticationModeAsString(), other.authenticationModeAsString())
                && Objects.equals(identityCenterConfiguration(), other.identityCenterConfiguration())
                && Objects.equals(personalAccessTokenConfiguration(), other.personalAccessTokenConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeIdentityProviderConfigurationResponse")
                .add("AuthenticationMode", authenticationModeAsString())
                .add("IdentityCenterConfiguration", identityCenterConfiguration())
                .add("PersonalAccessTokenConfiguration", personalAccessTokenConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationMode":
            return Optional.ofNullable(clazz.cast(authenticationModeAsString()));
        case "IdentityCenterConfiguration":
            return Optional.ofNullable(clazz.cast(identityCenterConfiguration()));
        case "PersonalAccessTokenConfiguration":
            return Optional.ofNullable(clazz.cast(personalAccessTokenConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AuthenticationMode", AUTHENTICATION_MODE_FIELD);
        map.put("IdentityCenterConfiguration", IDENTITY_CENTER_CONFIGURATION_FIELD);
        map.put("PersonalAccessTokenConfiguration", PERSONAL_ACCESS_TOKEN_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeIdentityProviderConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeIdentityProviderConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeIdentityProviderConfigurationResponse> {
        /**
         * <p>
         * The authentication mode used in WorkMail.
         * </p>
         * 
         * @param authenticationMode
         *        The authentication mode used in WorkMail.
         * @see IdentityProviderAuthenticationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityProviderAuthenticationMode
         */
        Builder authenticationMode(String authenticationMode);

        /**
         * <p>
         * The authentication mode used in WorkMail.
         * </p>
         * 
         * @param authenticationMode
         *        The authentication mode used in WorkMail.
         * @see IdentityProviderAuthenticationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityProviderAuthenticationMode
         */
        Builder authenticationMode(IdentityProviderAuthenticationMode authenticationMode);

        /**
         * <p>
         * The details of the IAM Identity Center configuration.
         * </p>
         * 
         * @param identityCenterConfiguration
         *        The details of the IAM Identity Center configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityCenterConfiguration(IdentityCenterConfiguration identityCenterConfiguration);

        /**
         * <p>
         * The details of the IAM Identity Center configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link IdentityCenterConfiguration.Builder}
         * avoiding the need to create one manually via {@link IdentityCenterConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdentityCenterConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #identityCenterConfiguration(IdentityCenterConfiguration)}.
         * 
         * @param identityCenterConfiguration
         *        a consumer that will call methods on {@link IdentityCenterConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityCenterConfiguration(IdentityCenterConfiguration)
         */
        default Builder identityCenterConfiguration(Consumer<IdentityCenterConfiguration.Builder> identityCenterConfiguration) {
            return identityCenterConfiguration(IdentityCenterConfiguration.builder().applyMutation(identityCenterConfiguration)
                    .build());
        }

        /**
         * <p>
         * The details of the Personal Access Token configuration.
         * </p>
         * 
         * @param personalAccessTokenConfiguration
         *        The details of the Personal Access Token configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder personalAccessTokenConfiguration(PersonalAccessTokenConfiguration personalAccessTokenConfiguration);

        /**
         * <p>
         * The details of the Personal Access Token configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link PersonalAccessTokenConfiguration.Builder}
         * avoiding the need to create one manually via {@link PersonalAccessTokenConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PersonalAccessTokenConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #personalAccessTokenConfiguration(PersonalAccessTokenConfiguration)}.
         * 
         * @param personalAccessTokenConfiguration
         *        a consumer that will call methods on {@link PersonalAccessTokenConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #personalAccessTokenConfiguration(PersonalAccessTokenConfiguration)
         */
        default Builder personalAccessTokenConfiguration(
                Consumer<PersonalAccessTokenConfiguration.Builder> personalAccessTokenConfiguration) {
            return personalAccessTokenConfiguration(PersonalAccessTokenConfiguration.builder()
                    .applyMutation(personalAccessTokenConfiguration).build());
        }
    }

    static final class BuilderImpl extends WorkMailResponse.BuilderImpl implements Builder {
        private String authenticationMode;

        private IdentityCenterConfiguration identityCenterConfiguration;

        private PersonalAccessTokenConfiguration personalAccessTokenConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIdentityProviderConfigurationResponse model) {
            super(model);
            authenticationMode(model.authenticationMode);
            identityCenterConfiguration(model.identityCenterConfiguration);
            personalAccessTokenConfiguration(model.personalAccessTokenConfiguration);
        }

        public final String getAuthenticationMode() {
            return authenticationMode;
        }

        public final void setAuthenticationMode(String authenticationMode) {
            this.authenticationMode = authenticationMode;
        }

        @Override
        public final Builder authenticationMode(String authenticationMode) {
            this.authenticationMode = authenticationMode;
            return this;
        }

        @Override
        public final Builder authenticationMode(IdentityProviderAuthenticationMode authenticationMode) {
            this.authenticationMode(authenticationMode == null ? null : authenticationMode.toString());
            return this;
        }

        public final IdentityCenterConfiguration.Builder getIdentityCenterConfiguration() {
            return identityCenterConfiguration != null ? identityCenterConfiguration.toBuilder() : null;
        }

        public final void setIdentityCenterConfiguration(IdentityCenterConfiguration.BuilderImpl identityCenterConfiguration) {
            this.identityCenterConfiguration = identityCenterConfiguration != null ? identityCenterConfiguration.build() : null;
        }

        @Override
        public final Builder identityCenterConfiguration(IdentityCenterConfiguration identityCenterConfiguration) {
            this.identityCenterConfiguration = identityCenterConfiguration;
            return this;
        }

        public final PersonalAccessTokenConfiguration.Builder getPersonalAccessTokenConfiguration() {
            return personalAccessTokenConfiguration != null ? personalAccessTokenConfiguration.toBuilder() : null;
        }

        public final void setPersonalAccessTokenConfiguration(
                PersonalAccessTokenConfiguration.BuilderImpl personalAccessTokenConfiguration) {
            this.personalAccessTokenConfiguration = personalAccessTokenConfiguration != null ? personalAccessTokenConfiguration
                    .build() : null;
        }

        @Override
        public final Builder personalAccessTokenConfiguration(PersonalAccessTokenConfiguration personalAccessTokenConfiguration) {
            this.personalAccessTokenConfiguration = personalAccessTokenConfiguration;
            return this;
        }

        @Override
        public DescribeIdentityProviderConfigurationResponse build() {
            return new DescribeIdentityProviderConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
