/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMobileDeviceAccessEffectRequest extends WorkMailRequest implements
        ToCopyableBuilder<GetMobileDeviceAccessEffectRequest.Builder, GetMobileDeviceAccessEffectRequest> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationId").getter(getter(GetMobileDeviceAccessEffectRequest::organizationId))
            .setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()).build();

    private static final SdkField<String> DEVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceType").getter(getter(GetMobileDeviceAccessEffectRequest::deviceType))
            .setter(setter(Builder::deviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceType").build()).build();

    private static final SdkField<String> DEVICE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceModel").getter(getter(GetMobileDeviceAccessEffectRequest::deviceModel))
            .setter(setter(Builder::deviceModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceModel").build()).build();

    private static final SdkField<String> DEVICE_OPERATING_SYSTEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceOperatingSystem").getter(getter(GetMobileDeviceAccessEffectRequest::deviceOperatingSystem))
            .setter(setter(Builder::deviceOperatingSystem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceOperatingSystem").build())
            .build();

    private static final SdkField<String> DEVICE_USER_AGENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceUserAgent").getter(getter(GetMobileDeviceAccessEffectRequest::deviceUserAgent))
            .setter(setter(Builder::deviceUserAgent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceUserAgent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD,
            DEVICE_TYPE_FIELD, DEVICE_MODEL_FIELD, DEVICE_OPERATING_SYSTEM_FIELD, DEVICE_USER_AGENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String organizationId;

    private final String deviceType;

    private final String deviceModel;

    private final String deviceOperatingSystem;

    private final String deviceUserAgent;

    private GetMobileDeviceAccessEffectRequest(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.deviceType = builder.deviceType;
        this.deviceModel = builder.deviceModel;
        this.deviceOperatingSystem = builder.deviceOperatingSystem;
        this.deviceUserAgent = builder.deviceUserAgent;
    }

    /**
     * <p>
     * The WorkMail organization to simulate the access effect for.
     * </p>
     * 
     * @return The WorkMail organization to simulate the access effect for.
     */
    public final String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * Device type the simulated user will report.
     * </p>
     * 
     * @return Device type the simulated user will report.
     */
    public final String deviceType() {
        return deviceType;
    }

    /**
     * <p>
     * Device model the simulated user will report.
     * </p>
     * 
     * @return Device model the simulated user will report.
     */
    public final String deviceModel() {
        return deviceModel;
    }

    /**
     * <p>
     * Device operating system the simulated user will report.
     * </p>
     * 
     * @return Device operating system the simulated user will report.
     */
    public final String deviceOperatingSystem() {
        return deviceOperatingSystem;
    }

    /**
     * <p>
     * Device user agent the simulated user will report.
     * </p>
     * 
     * @return Device user agent the simulated user will report.
     */
    public final String deviceUserAgent() {
        return deviceUserAgent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(deviceType());
        hashCode = 31 * hashCode + Objects.hashCode(deviceModel());
        hashCode = 31 * hashCode + Objects.hashCode(deviceOperatingSystem());
        hashCode = 31 * hashCode + Objects.hashCode(deviceUserAgent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMobileDeviceAccessEffectRequest)) {
            return false;
        }
        GetMobileDeviceAccessEffectRequest other = (GetMobileDeviceAccessEffectRequest) obj;
        return Objects.equals(organizationId(), other.organizationId()) && Objects.equals(deviceType(), other.deviceType())
                && Objects.equals(deviceModel(), other.deviceModel())
                && Objects.equals(deviceOperatingSystem(), other.deviceOperatingSystem())
                && Objects.equals(deviceUserAgent(), other.deviceUserAgent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMobileDeviceAccessEffectRequest").add("OrganizationId", organizationId())
                .add("DeviceType", deviceType()).add("DeviceModel", deviceModel())
                .add("DeviceOperatingSystem", deviceOperatingSystem()).add("DeviceUserAgent", deviceUserAgent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "DeviceType":
            return Optional.ofNullable(clazz.cast(deviceType()));
        case "DeviceModel":
            return Optional.ofNullable(clazz.cast(deviceModel()));
        case "DeviceOperatingSystem":
            return Optional.ofNullable(clazz.cast(deviceOperatingSystem()));
        case "DeviceUserAgent":
            return Optional.ofNullable(clazz.cast(deviceUserAgent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OrganizationId", ORGANIZATION_ID_FIELD);
        map.put("DeviceType", DEVICE_TYPE_FIELD);
        map.put("DeviceModel", DEVICE_MODEL_FIELD);
        map.put("DeviceOperatingSystem", DEVICE_OPERATING_SYSTEM_FIELD);
        map.put("DeviceUserAgent", DEVICE_USER_AGENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMobileDeviceAccessEffectRequest, T> g) {
        return obj -> g.apply((GetMobileDeviceAccessEffectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetMobileDeviceAccessEffectRequest> {
        /**
         * <p>
         * The WorkMail organization to simulate the access effect for.
         * </p>
         * 
         * @param organizationId
         *        The WorkMail organization to simulate the access effect for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * Device type the simulated user will report.
         * </p>
         * 
         * @param deviceType
         *        Device type the simulated user will report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceType(String deviceType);

        /**
         * <p>
         * Device model the simulated user will report.
         * </p>
         * 
         * @param deviceModel
         *        Device model the simulated user will report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceModel(String deviceModel);

        /**
         * <p>
         * Device operating system the simulated user will report.
         * </p>
         * 
         * @param deviceOperatingSystem
         *        Device operating system the simulated user will report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceOperatingSystem(String deviceOperatingSystem);

        /**
         * <p>
         * Device user agent the simulated user will report.
         * </p>
         * 
         * @param deviceUserAgent
         *        Device user agent the simulated user will report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceUserAgent(String deviceUserAgent);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkMailRequest.BuilderImpl implements Builder {
        private String organizationId;

        private String deviceType;

        private String deviceModel;

        private String deviceOperatingSystem;

        private String deviceUserAgent;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMobileDeviceAccessEffectRequest model) {
            super(model);
            organizationId(model.organizationId);
            deviceType(model.deviceType);
            deviceModel(model.deviceModel);
            deviceOperatingSystem(model.deviceOperatingSystem);
            deviceUserAgent(model.deviceUserAgent);
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getDeviceType() {
            return deviceType;
        }

        public final void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }

        @Override
        public final Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public final String getDeviceModel() {
            return deviceModel;
        }

        public final void setDeviceModel(String deviceModel) {
            this.deviceModel = deviceModel;
        }

        @Override
        public final Builder deviceModel(String deviceModel) {
            this.deviceModel = deviceModel;
            return this;
        }

        public final String getDeviceOperatingSystem() {
            return deviceOperatingSystem;
        }

        public final void setDeviceOperatingSystem(String deviceOperatingSystem) {
            this.deviceOperatingSystem = deviceOperatingSystem;
        }

        @Override
        public final Builder deviceOperatingSystem(String deviceOperatingSystem) {
            this.deviceOperatingSystem = deviceOperatingSystem;
            return this;
        }

        public final String getDeviceUserAgent() {
            return deviceUserAgent;
        }

        public final void setDeviceUserAgent(String deviceUserAgent) {
            this.deviceUserAgent = deviceUserAgent;
        }

        @Override
        public final Builder deviceUserAgent(String deviceUserAgent) {
            this.deviceUserAgent = deviceUserAgent;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMobileDeviceAccessEffectRequest build() {
            return new GetMobileDeviceAccessEffectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
