/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The IAM Identity Center configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentityCenterConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<IdentityCenterConfiguration.Builder, IdentityCenterConfiguration> {
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceArn").getter(getter(IdentityCenterConfiguration::instanceArn))
            .setter(setter(Builder::instanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()).build();

    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationArn").getter(getter(IdentityCenterConfiguration::applicationArn))
            .setter(setter(Builder::applicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ARN_FIELD,
            APPLICATION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String instanceArn;

    private final String applicationArn;

    private IdentityCenterConfiguration(BuilderImpl builder) {
        this.instanceArn = builder.instanceArn;
        this.applicationArn = builder.applicationArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the of IAM Identity Center instance. Must be in the same AWS account and region
     * as WorkMail organization.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the of IAM Identity Center instance. Must be in the same AWS account
     *         and region as WorkMail organization.
     */
    public final String instanceArn() {
        return instanceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of IAMIdentity Center Application for WorkMail. Must be created by the WorkMail
     * API, see CreateIdentityCenterApplication.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of IAMIdentity Center Application for WorkMail. Must be created by the
     *         WorkMail API, see CreateIdentityCenterApplication.
     */
    public final String applicationArn() {
        return applicationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(applicationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityCenterConfiguration)) {
            return false;
        }
        IdentityCenterConfiguration other = (IdentityCenterConfiguration) obj;
        return Objects.equals(instanceArn(), other.instanceArn()) && Objects.equals(applicationArn(), other.applicationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdentityCenterConfiguration").add("InstanceArn", instanceArn())
                .add("ApplicationArn", applicationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceArn":
            return Optional.ofNullable(clazz.cast(instanceArn()));
        case "ApplicationArn":
            return Optional.ofNullable(clazz.cast(applicationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceArn", INSTANCE_ARN_FIELD);
        map.put("ApplicationArn", APPLICATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdentityCenterConfiguration, T> g) {
        return obj -> g.apply((IdentityCenterConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentityCenterConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the of IAM Identity Center instance. Must be in the same AWS account and
         * region as WorkMail organization.
         * </p>
         * 
         * @param instanceArn
         *        The Amazon Resource Name (ARN) of the of IAM Identity Center instance. Must be in the same AWS account
         *        and region as WorkMail organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArn(String instanceArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of IAMIdentity Center Application for WorkMail. Must be created by the
         * WorkMail API, see CreateIdentityCenterApplication.
         * </p>
         * 
         * @param applicationArn
         *        The Amazon Resource Name (ARN) of IAMIdentity Center Application for WorkMail. Must be created by the
         *        WorkMail API, see CreateIdentityCenterApplication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArn(String applicationArn);
    }

    static final class BuilderImpl implements Builder {
        private String instanceArn;

        private String applicationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityCenterConfiguration model) {
            instanceArn(model.instanceArn);
            applicationArn(model.applicationArn);
        }

        public final String getInstanceArn() {
            return instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getApplicationArn() {
            return applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        @Override
        public IdentityCenterConfiguration build() {
            return new IdentityCenterConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
