/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an EWS based availability provider when returned from the service. It does not contain the password of the
 * endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedactedEwsAvailabilityProvider implements SdkPojo, Serializable,
        ToCopyableBuilder<RedactedEwsAvailabilityProvider.Builder, RedactedEwsAvailabilityProvider> {
    private static final SdkField<String> EWS_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EwsEndpoint").getter(getter(RedactedEwsAvailabilityProvider::ewsEndpoint))
            .setter(setter(Builder::ewsEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EwsEndpoint").build()).build();

    private static final SdkField<String> EWS_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EwsUsername").getter(getter(RedactedEwsAvailabilityProvider::ewsUsername))
            .setter(setter(Builder::ewsUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EwsUsername").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EWS_ENDPOINT_FIELD,
            EWS_USERNAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ewsEndpoint;

    private final String ewsUsername;

    private RedactedEwsAvailabilityProvider(BuilderImpl builder) {
        this.ewsEndpoint = builder.ewsEndpoint;
        this.ewsUsername = builder.ewsUsername;
    }

    /**
     * <p>
     * The endpoint of the remote EWS server.
     * </p>
     * 
     * @return The endpoint of the remote EWS server.
     */
    public final String ewsEndpoint() {
        return ewsEndpoint;
    }

    /**
     * <p>
     * The username used to authenticate the remote EWS server.
     * </p>
     * 
     * @return The username used to authenticate the remote EWS server.
     */
    public final String ewsUsername() {
        return ewsUsername;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ewsEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(ewsUsername());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedactedEwsAvailabilityProvider)) {
            return false;
        }
        RedactedEwsAvailabilityProvider other = (RedactedEwsAvailabilityProvider) obj;
        return Objects.equals(ewsEndpoint(), other.ewsEndpoint()) && Objects.equals(ewsUsername(), other.ewsUsername());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedactedEwsAvailabilityProvider").add("EwsEndpoint", ewsEndpoint())
                .add("EwsUsername", ewsUsername()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EwsEndpoint":
            return Optional.ofNullable(clazz.cast(ewsEndpoint()));
        case "EwsUsername":
            return Optional.ofNullable(clazz.cast(ewsUsername()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EwsEndpoint", EWS_ENDPOINT_FIELD);
        map.put("EwsUsername", EWS_USERNAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedactedEwsAvailabilityProvider, T> g) {
        return obj -> g.apply((RedactedEwsAvailabilityProvider) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedactedEwsAvailabilityProvider> {
        /**
         * <p>
         * The endpoint of the remote EWS server.
         * </p>
         * 
         * @param ewsEndpoint
         *        The endpoint of the remote EWS server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ewsEndpoint(String ewsEndpoint);

        /**
         * <p>
         * The username used to authenticate the remote EWS server.
         * </p>
         * 
         * @param ewsUsername
         *        The username used to authenticate the remote EWS server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ewsUsername(String ewsUsername);
    }

    static final class BuilderImpl implements Builder {
        private String ewsEndpoint;

        private String ewsUsername;

        private BuilderImpl() {
        }

        private BuilderImpl(RedactedEwsAvailabilityProvider model) {
            ewsEndpoint(model.ewsEndpoint);
            ewsUsername(model.ewsUsername);
        }

        public final String getEwsEndpoint() {
            return ewsEndpoint;
        }

        public final void setEwsEndpoint(String ewsEndpoint) {
            this.ewsEndpoint = ewsEndpoint;
        }

        @Override
        public final Builder ewsEndpoint(String ewsEndpoint) {
            this.ewsEndpoint = ewsEndpoint;
            return this;
        }

        public final String getEwsUsername() {
            return ewsUsername;
        }

        public final void setEwsUsername(String ewsUsername) {
            this.ewsUsername = ewsUsername;
        }

        @Override
        public final Builder ewsUsername(String ewsUsername) {
            this.ewsUsername = ewsUsername;
            return this;
        }

        @Override
        public RedactedEwsAvailabilityProvider build() {
            return new RedactedEwsAvailabilityProvider(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
