/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workmail.WorkMailAsyncClient;
import software.amazon.awssdk.services.workmail.internal.UserAgentUtils;
import software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsRequest;
import software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsResponse;

public class ListMailboxExportJobsPublisher
implements SdkPublisher<ListMailboxExportJobsResponse> {
    private final WorkMailAsyncClient client;
    private final ListMailboxExportJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMailboxExportJobsPublisher(WorkMailAsyncClient client, ListMailboxExportJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMailboxExportJobsPublisher(WorkMailAsyncClient client, ListMailboxExportJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMailboxExportJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMailboxExportJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListMailboxExportJobsResponseFetcher
    implements AsyncPageFetcher<ListMailboxExportJobsResponse> {
        private ListMailboxExportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListMailboxExportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMailboxExportJobsResponse> nextPage(ListMailboxExportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListMailboxExportJobsPublisher.this.client.listMailboxExportJobs(ListMailboxExportJobsPublisher.this.firstRequest);
            }
            return ListMailboxExportJobsPublisher.this.client.listMailboxExportJobs((ListMailboxExportJobsRequest)((Object)ListMailboxExportJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

