/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workmail.model.ImpersonationRoleType;
import software.amazon.awssdk.services.workmail.model.ImpersonationRule;
import software.amazon.awssdk.services.workmail.model.ImpersonationRuleListCopier;
import software.amazon.awssdk.services.workmail.model.WorkMailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateImpersonationRoleRequest
extends WorkMailRequest
implements ToCopyableBuilder<Builder, CreateImpersonationRoleRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateImpersonationRoleRequest.getter(CreateImpersonationRoleRequest::clientToken)).setter(CreateImpersonationRoleRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationId").getter(CreateImpersonationRoleRequest.getter(CreateImpersonationRoleRequest::organizationId)).setter(CreateImpersonationRoleRequest.setter(Builder::organizationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateImpersonationRoleRequest.getter(CreateImpersonationRoleRequest::name)).setter(CreateImpersonationRoleRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CreateImpersonationRoleRequest.getter(CreateImpersonationRoleRequest::typeAsString)).setter(CreateImpersonationRoleRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateImpersonationRoleRequest.getter(CreateImpersonationRoleRequest::description)).setter(CreateImpersonationRoleRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<ImpersonationRule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rules").getter(CreateImpersonationRoleRequest.getter(CreateImpersonationRoleRequest::rules)).setter(CreateImpersonationRoleRequest.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImpersonationRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, ORGANIZATION_ID_FIELD, NAME_FIELD, TYPE_FIELD, DESCRIPTION_FIELD, RULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateImpersonationRoleRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String organizationId;
    private final String name;
    private final String type;
    private final String description;
    private final List<ImpersonationRule> rules;

    private CreateImpersonationRoleRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.organizationId = builder.organizationId;
        this.name = builder.name;
        this.type = builder.type;
        this.description = builder.description;
        this.rules = builder.rules;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String organizationId() {
        return this.organizationId;
    }

    public final String name() {
        return this.name;
    }

    public final ImpersonationRoleType type() {
        return ImpersonationRoleType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<ImpersonationRule> rules() {
        return this.rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImpersonationRoleRequest)) {
            return false;
        }
        CreateImpersonationRoleRequest other = (CreateImpersonationRoleRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.organizationId(), other.organizationId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.description(), other.description()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules());
    }

    public final String toString() {
        return ToString.builder((String)"CreateImpersonationRoleRequest").add("ClientToken", (Object)this.clientToken()).add("OrganizationId", (Object)this.organizationId()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("Description", (Object)this.description()).add("Rules", this.hasRules() ? this.rules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "OrganizationId": {
                return Optional.ofNullable(clazz.cast(this.organizationId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("OrganizationId", ORGANIZATION_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Rules", RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateImpersonationRoleRequest, T> g) {
        return obj -> g.apply((CreateImpersonationRoleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String organizationId;
        private String name;
        private String type;
        private String description;
        private List<ImpersonationRule> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImpersonationRoleRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.organizationId(model.organizationId);
            this.name(model.name);
            this.type(model.type);
            this.description(model.description);
            this.rules(model.rules);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ImpersonationRoleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<ImpersonationRule.Builder> getRules() {
            List<ImpersonationRule.Builder> result = ImpersonationRuleListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<ImpersonationRule.BuilderImpl> rules) {
            this.rules = ImpersonationRuleListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<ImpersonationRule> rules) {
            this.rules = ImpersonationRuleListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(ImpersonationRule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<ImpersonationRule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (ImpersonationRule)((ImpersonationRule.Builder)ImpersonationRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateImpersonationRoleRequest build() {
            return new CreateImpersonationRoleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkMailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateImpersonationRoleRequest> {
        public Builder clientToken(String var1);

        public Builder organizationId(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(ImpersonationRoleType var1);

        public Builder description(String var1);

        public Builder rules(Collection<ImpersonationRule> var1);

        public Builder rules(ImpersonationRule ... var1);

        public Builder rules(Consumer<ImpersonationRule.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

