/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workmail.model.IdentityCenterConfiguration;
import software.amazon.awssdk.services.workmail.model.IdentityProviderAuthenticationMode;
import software.amazon.awssdk.services.workmail.model.PersonalAccessTokenConfiguration;
import software.amazon.awssdk.services.workmail.model.WorkMailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeIdentityProviderConfigurationResponse
extends WorkMailResponse
implements ToCopyableBuilder<Builder, DescribeIdentityProviderConfigurationResponse> {
    private static final SdkField<String> AUTHENTICATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationMode").getter(DescribeIdentityProviderConfigurationResponse.getter(DescribeIdentityProviderConfigurationResponse::authenticationModeAsString)).setter(DescribeIdentityProviderConfigurationResponse.setter(Builder::authenticationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationMode").build()}).build();
    private static final SdkField<IdentityCenterConfiguration> IDENTITY_CENTER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IdentityCenterConfiguration").getter(DescribeIdentityProviderConfigurationResponse.getter(DescribeIdentityProviderConfigurationResponse::identityCenterConfiguration)).setter(DescribeIdentityProviderConfigurationResponse.setter(Builder::identityCenterConfiguration)).constructor(IdentityCenterConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityCenterConfiguration").build()}).build();
    private static final SdkField<PersonalAccessTokenConfiguration> PERSONAL_ACCESS_TOKEN_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PersonalAccessTokenConfiguration").getter(DescribeIdentityProviderConfigurationResponse.getter(DescribeIdentityProviderConfigurationResponse::personalAccessTokenConfiguration)).setter(DescribeIdentityProviderConfigurationResponse.setter(Builder::personalAccessTokenConfiguration)).constructor(PersonalAccessTokenConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersonalAccessTokenConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_MODE_FIELD, IDENTITY_CENTER_CONFIGURATION_FIELD, PERSONAL_ACCESS_TOKEN_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeIdentityProviderConfigurationResponse.memberNameToFieldInitializer();
    private final String authenticationMode;
    private final IdentityCenterConfiguration identityCenterConfiguration;
    private final PersonalAccessTokenConfiguration personalAccessTokenConfiguration;

    private DescribeIdentityProviderConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.authenticationMode = builder.authenticationMode;
        this.identityCenterConfiguration = builder.identityCenterConfiguration;
        this.personalAccessTokenConfiguration = builder.personalAccessTokenConfiguration;
    }

    public final IdentityProviderAuthenticationMode authenticationMode() {
        return IdentityProviderAuthenticationMode.fromValue(this.authenticationMode);
    }

    public final String authenticationModeAsString() {
        return this.authenticationMode;
    }

    public final IdentityCenterConfiguration identityCenterConfiguration() {
        return this.identityCenterConfiguration;
    }

    public final PersonalAccessTokenConfiguration personalAccessTokenConfiguration() {
        return this.personalAccessTokenConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityCenterConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.personalAccessTokenConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIdentityProviderConfigurationResponse)) {
            return false;
        }
        DescribeIdentityProviderConfigurationResponse other = (DescribeIdentityProviderConfigurationResponse)((Object)obj);
        return Objects.equals(this.authenticationModeAsString(), other.authenticationModeAsString()) && Objects.equals(this.identityCenterConfiguration(), other.identityCenterConfiguration()) && Objects.equals(this.personalAccessTokenConfiguration(), other.personalAccessTokenConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeIdentityProviderConfigurationResponse").add("AuthenticationMode", (Object)this.authenticationModeAsString()).add("IdentityCenterConfiguration", (Object)this.identityCenterConfiguration()).add("PersonalAccessTokenConfiguration", (Object)this.personalAccessTokenConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationMode": {
                return Optional.ofNullable(clazz.cast(this.authenticationModeAsString()));
            }
            case "IdentityCenterConfiguration": {
                return Optional.ofNullable(clazz.cast(this.identityCenterConfiguration()));
            }
            case "PersonalAccessTokenConfiguration": {
                return Optional.ofNullable(clazz.cast(this.personalAccessTokenConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AuthenticationMode", AUTHENTICATION_MODE_FIELD);
        map.put("IdentityCenterConfiguration", IDENTITY_CENTER_CONFIGURATION_FIELD);
        map.put("PersonalAccessTokenConfiguration", PERSONAL_ACCESS_TOKEN_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeIdentityProviderConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeIdentityProviderConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailResponse.BuilderImpl
    implements Builder {
        private String authenticationMode;
        private IdentityCenterConfiguration identityCenterConfiguration;
        private PersonalAccessTokenConfiguration personalAccessTokenConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIdentityProviderConfigurationResponse model) {
            super(model);
            this.authenticationMode(model.authenticationMode);
            this.identityCenterConfiguration(model.identityCenterConfiguration);
            this.personalAccessTokenConfiguration(model.personalAccessTokenConfiguration);
        }

        public final String getAuthenticationMode() {
            return this.authenticationMode;
        }

        public final void setAuthenticationMode(String authenticationMode) {
            this.authenticationMode = authenticationMode;
        }

        @Override
        public final Builder authenticationMode(String authenticationMode) {
            this.authenticationMode = authenticationMode;
            return this;
        }

        @Override
        public final Builder authenticationMode(IdentityProviderAuthenticationMode authenticationMode) {
            this.authenticationMode(authenticationMode == null ? null : authenticationMode.toString());
            return this;
        }

        public final IdentityCenterConfiguration.Builder getIdentityCenterConfiguration() {
            return this.identityCenterConfiguration != null ? this.identityCenterConfiguration.toBuilder() : null;
        }

        public final void setIdentityCenterConfiguration(IdentityCenterConfiguration.BuilderImpl identityCenterConfiguration) {
            this.identityCenterConfiguration = identityCenterConfiguration != null ? identityCenterConfiguration.build() : null;
        }

        @Override
        public final Builder identityCenterConfiguration(IdentityCenterConfiguration identityCenterConfiguration) {
            this.identityCenterConfiguration = identityCenterConfiguration;
            return this;
        }

        public final PersonalAccessTokenConfiguration.Builder getPersonalAccessTokenConfiguration() {
            return this.personalAccessTokenConfiguration != null ? this.personalAccessTokenConfiguration.toBuilder() : null;
        }

        public final void setPersonalAccessTokenConfiguration(PersonalAccessTokenConfiguration.BuilderImpl personalAccessTokenConfiguration) {
            this.personalAccessTokenConfiguration = personalAccessTokenConfiguration != null ? personalAccessTokenConfiguration.build() : null;
        }

        @Override
        public final Builder personalAccessTokenConfiguration(PersonalAccessTokenConfiguration personalAccessTokenConfiguration) {
            this.personalAccessTokenConfiguration = personalAccessTokenConfiguration;
            return this;
        }

        @Override
        public DescribeIdentityProviderConfigurationResponse build() {
            return new DescribeIdentityProviderConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkMailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeIdentityProviderConfigurationResponse> {
        public Builder authenticationMode(String var1);

        public Builder authenticationMode(IdentityProviderAuthenticationMode var1);

        public Builder identityCenterConfiguration(IdentityCenterConfiguration var1);

        default public Builder identityCenterConfiguration(Consumer<IdentityCenterConfiguration.Builder> identityCenterConfiguration) {
            return this.identityCenterConfiguration((IdentityCenterConfiguration)((IdentityCenterConfiguration.Builder)IdentityCenterConfiguration.builder().applyMutation(identityCenterConfiguration)).build());
        }

        public Builder personalAccessTokenConfiguration(PersonalAccessTokenConfiguration var1);

        default public Builder personalAccessTokenConfiguration(Consumer<PersonalAccessTokenConfiguration.Builder> personalAccessTokenConfiguration) {
            return this.personalAccessTokenConfiguration((PersonalAccessTokenConfiguration)((PersonalAccessTokenConfiguration.Builder)PersonalAccessTokenConfiguration.builder().applyMutation(personalAccessTokenConfiguration)).build());
        }
    }
}

