/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.workmail.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.workmail.internal.WorkMailServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.workmail.model.AssociateDelegateToResourceRequest;
import software.amazon.awssdk.services.workmail.model.AssociateDelegateToResourceResponse;
import software.amazon.awssdk.services.workmail.model.AssociateMemberToGroupRequest;
import software.amazon.awssdk.services.workmail.model.AssociateMemberToGroupResponse;
import software.amazon.awssdk.services.workmail.model.AssumeImpersonationRoleRequest;
import software.amazon.awssdk.services.workmail.model.AssumeImpersonationRoleResponse;
import software.amazon.awssdk.services.workmail.model.CancelMailboxExportJobRequest;
import software.amazon.awssdk.services.workmail.model.CancelMailboxExportJobResponse;
import software.amazon.awssdk.services.workmail.model.CreateAliasRequest;
import software.amazon.awssdk.services.workmail.model.CreateAliasResponse;
import software.amazon.awssdk.services.workmail.model.CreateAvailabilityConfigurationRequest;
import software.amazon.awssdk.services.workmail.model.CreateAvailabilityConfigurationResponse;
import software.amazon.awssdk.services.workmail.model.CreateGroupRequest;
import software.amazon.awssdk.services.workmail.model.CreateGroupResponse;
import software.amazon.awssdk.services.workmail.model.CreateIdentityCenterApplicationRequest;
import software.amazon.awssdk.services.workmail.model.CreateIdentityCenterApplicationResponse;
import software.amazon.awssdk.services.workmail.model.CreateImpersonationRoleRequest;
import software.amazon.awssdk.services.workmail.model.CreateImpersonationRoleResponse;
import software.amazon.awssdk.services.workmail.model.CreateMobileDeviceAccessRuleRequest;
import software.amazon.awssdk.services.workmail.model.CreateMobileDeviceAccessRuleResponse;
import software.amazon.awssdk.services.workmail.model.CreateOrganizationRequest;
import software.amazon.awssdk.services.workmail.model.CreateOrganizationResponse;
import software.amazon.awssdk.services.workmail.model.CreateResourceRequest;
import software.amazon.awssdk.services.workmail.model.CreateResourceResponse;
import software.amazon.awssdk.services.workmail.model.CreateUserRequest;
import software.amazon.awssdk.services.workmail.model.CreateUserResponse;
import software.amazon.awssdk.services.workmail.model.DeleteAccessControlRuleRequest;
import software.amazon.awssdk.services.workmail.model.DeleteAccessControlRuleResponse;
import software.amazon.awssdk.services.workmail.model.DeleteAliasRequest;
import software.amazon.awssdk.services.workmail.model.DeleteAliasResponse;
import software.amazon.awssdk.services.workmail.model.DeleteAvailabilityConfigurationRequest;
import software.amazon.awssdk.services.workmail.model.DeleteAvailabilityConfigurationResponse;
import software.amazon.awssdk.services.workmail.model.DeleteEmailMonitoringConfigurationRequest;
import software.amazon.awssdk.services.workmail.model.DeleteEmailMonitoringConfigurationResponse;
import software.amazon.awssdk.services.workmail.model.DeleteGroupRequest;
import software.amazon.awssdk.services.workmail.model.DeleteGroupResponse;
import software.amazon.awssdk.services.workmail.model.DeleteIdentityCenterApplicationRequest;
import software.amazon.awssdk.services.workmail.model.DeleteIdentityCenterApplicationResponse;
import software.amazon.awssdk.services.workmail.model.DeleteIdentityProviderConfigurationRequest;
import software.amazon.awssdk.services.workmail.model.DeleteIdentityProviderConfigurationResponse;
import software.amazon.awssdk.services.workmail.model.DeleteImpersonationRoleRequest;
import software.amazon.awssdk.services.workmail.model.DeleteImpersonationRoleResponse;
import software.amazon.awssdk.services.workmail.model.DeleteMailboxPermissionsRequest;
import software.amazon.awssdk.services.workmail.model.DeleteMailboxPermissionsResponse;
import software.amazon.awssdk.services.workmail.model.DeleteMobileDeviceAccessOverrideRequest;
import software.amazon.awssdk.services.workmail.model.DeleteMobileDeviceAccessOverrideResponse;
import software.amazon.awssdk.services.workmail.model.DeleteMobileDeviceAccessRuleRequest;
import software.amazon.awssdk.services.workmail.model.DeleteMobileDeviceAccessRuleResponse;
import software.amazon.awssdk.services.workmail.model.DeleteOrganizationRequest;
import software.amazon.awssdk.services.workmail.model.DeleteOrganizationResponse;
import software.amazon.awssdk.services.workmail.model.DeletePersonalAccessTokenRequest;
import software.amazon.awssdk.services.workmail.model.DeletePersonalAccessTokenResponse;
import software.amazon.awssdk.services.workmail.model.DeleteResourceRequest;
import software.amazon.awssdk.services.workmail.model.DeleteResourceResponse;
import software.amazon.awssdk.services.workmail.model.DeleteRetentionPolicyRequest;
import software.amazon.awssdk.services.workmail.model.DeleteRetentionPolicyResponse;
import software.amazon.awssdk.services.workmail.model.DeleteUserRequest;
import software.amazon.awssdk.services.workmail.model.DeleteUserResponse;
import software.amazon.awssdk.services.workmail.model.DeregisterFromWorkMailRequest;
import software.amazon.awssdk.services.workmail.model.DeregisterFromWorkMailResponse;
import software.amazon.awssdk.services.workmail.model.DeregisterMailDomainRequest;
import software.amazon.awssdk.services.workmail.model.DeregisterMailDomainResponse;
import software.amazon.awssdk.services.workmail.model.DescribeEmailMonitoringConfigurationRequest;
import software.amazon.awssdk.services.workmail.model.DescribeEmailMonitoringConfigurationResponse;
import software.amazon.awssdk.services.workmail.model.DescribeEntityRequest;
import software.amazon.awssdk.services.workmail.model.DescribeEntityResponse;
import software.amazon.awssdk.services.workmail.model.DescribeGroupRequest;
import software.amazon.awssdk.services.workmail.model.DescribeGroupResponse;
import software.amazon.awssdk.services.workmail.model.DescribeIdentityProviderConfigurationRequest;
import software.amazon.awssdk.services.workmail.model.DescribeIdentityProviderConfigurationResponse;
import software.amazon.awssdk.services.workmail.model.DescribeInboundDmarcSettingsRequest;
import software.amazon.awssdk.services.workmail.model.DescribeInboundDmarcSettingsResponse;
import software.amazon.awssdk.services.workmail.model.DescribeMailboxExportJobRequest;
import software.amazon.awssdk.services.workmail.model.DescribeMailboxExportJobResponse;
import software.amazon.awssdk.services.workmail.model.DescribeOrganizationRequest;
import software.amazon.awssdk.services.workmail.model.DescribeOrganizationResponse;
import software.amazon.awssdk.services.workmail.model.DescribeResourceRequest;
import software.amazon.awssdk.services.workmail.model.DescribeResourceResponse;
import software.amazon.awssdk.services.workmail.model.DescribeUserRequest;
import software.amazon.awssdk.services.workmail.model.DescribeUserResponse;
import software.amazon.awssdk.services.workmail.model.DirectoryInUseException;
import software.amazon.awssdk.services.workmail.model.DirectoryServiceAuthenticationFailedException;
import software.amazon.awssdk.services.workmail.model.DirectoryUnavailableException;
import software.amazon.awssdk.services.workmail.model.DisassociateDelegateFromResourceRequest;
import software.amazon.awssdk.services.workmail.model.DisassociateDelegateFromResourceResponse;
import software.amazon.awssdk.services.workmail.model.DisassociateMemberFromGroupRequest;
import software.amazon.awssdk.services.workmail.model.DisassociateMemberFromGroupResponse;
import software.amazon.awssdk.services.workmail.model.EmailAddressInUseException;
import software.amazon.awssdk.services.workmail.model.EntityAlreadyRegisteredException;
import software.amazon.awssdk.services.workmail.model.EntityNotFoundException;
import software.amazon.awssdk.services.workmail.model.EntityStateException;
import software.amazon.awssdk.services.workmail.model.GetAccessControlEffectRequest;
import software.amazon.awssdk.services.workmail.model.GetAccessControlEffectResponse;
import software.amazon.awssdk.services.workmail.model.GetDefaultRetentionPolicyRequest;
import software.amazon.awssdk.services.workmail.model.GetDefaultRetentionPolicyResponse;
import software.amazon.awssdk.services.workmail.model.GetImpersonationRoleEffectRequest;
import software.amazon.awssdk.services.workmail.model.GetImpersonationRoleEffectResponse;
import software.amazon.awssdk.services.workmail.model.GetImpersonationRoleRequest;
import software.amazon.awssdk.services.workmail.model.GetImpersonationRoleResponse;
import software.amazon.awssdk.services.workmail.model.GetMailDomainRequest;
import software.amazon.awssdk.services.workmail.model.GetMailDomainResponse;
import software.amazon.awssdk.services.workmail.model.GetMailboxDetailsRequest;
import software.amazon.awssdk.services.workmail.model.GetMailboxDetailsResponse;
import software.amazon.awssdk.services.workmail.model.GetMobileDeviceAccessEffectRequest;
import software.amazon.awssdk.services.workmail.model.GetMobileDeviceAccessEffectResponse;
import software.amazon.awssdk.services.workmail.model.GetMobileDeviceAccessOverrideRequest;
import software.amazon.awssdk.services.workmail.model.GetMobileDeviceAccessOverrideResponse;
import software.amazon.awssdk.services.workmail.model.GetPersonalAccessTokenMetadataRequest;
import software.amazon.awssdk.services.workmail.model.GetPersonalAccessTokenMetadataResponse;
import software.amazon.awssdk.services.workmail.model.InvalidConfigurationException;
import software.amazon.awssdk.services.workmail.model.InvalidCustomSesConfigurationException;
import software.amazon.awssdk.services.workmail.model.InvalidParameterException;
import software.amazon.awssdk.services.workmail.model.InvalidPasswordException;
import software.amazon.awssdk.services.workmail.model.LimitExceededException;
import software.amazon.awssdk.services.workmail.model.ListAccessControlRulesRequest;
import software.amazon.awssdk.services.workmail.model.ListAccessControlRulesResponse;
import software.amazon.awssdk.services.workmail.model.ListAliasesRequest;
import software.amazon.awssdk.services.workmail.model.ListAliasesResponse;
import software.amazon.awssdk.services.workmail.model.ListAvailabilityConfigurationsRequest;
import software.amazon.awssdk.services.workmail.model.ListAvailabilityConfigurationsResponse;
import software.amazon.awssdk.services.workmail.model.ListGroupMembersRequest;
import software.amazon.awssdk.services.workmail.model.ListGroupMembersResponse;
import software.amazon.awssdk.services.workmail.model.ListGroupsForEntityRequest;
import software.amazon.awssdk.services.workmail.model.ListGroupsForEntityResponse;
import software.amazon.awssdk.services.workmail.model.ListGroupsRequest;
import software.amazon.awssdk.services.workmail.model.ListGroupsResponse;
import software.amazon.awssdk.services.workmail.model.ListImpersonationRolesRequest;
import software.amazon.awssdk.services.workmail.model.ListImpersonationRolesResponse;
import software.amazon.awssdk.services.workmail.model.ListMailDomainsRequest;
import software.amazon.awssdk.services.workmail.model.ListMailDomainsResponse;
import software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsRequest;
import software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsResponse;
import software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsRequest;
import software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsResponse;
import software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessOverridesRequest;
import software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessOverridesResponse;
import software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessRulesRequest;
import software.amazon.awssdk.services.workmail.model.ListMobileDeviceAccessRulesResponse;
import software.amazon.awssdk.services.workmail.model.ListOrganizationsRequest;
import software.amazon.awssdk.services.workmail.model.ListOrganizationsResponse;
import software.amazon.awssdk.services.workmail.model.ListPersonalAccessTokensRequest;
import software.amazon.awssdk.services.workmail.model.ListPersonalAccessTokensResponse;
import software.amazon.awssdk.services.workmail.model.ListResourceDelegatesRequest;
import software.amazon.awssdk.services.workmail.model.ListResourceDelegatesResponse;
import software.amazon.awssdk.services.workmail.model.ListResourcesRequest;
import software.amazon.awssdk.services.workmail.model.ListResourcesResponse;
import software.amazon.awssdk.services.workmail.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.workmail.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.workmail.model.ListUsersRequest;
import software.amazon.awssdk.services.workmail.model.ListUsersResponse;
import software.amazon.awssdk.services.workmail.model.MailDomainInUseException;
import software.amazon.awssdk.services.workmail.model.MailDomainNotFoundException;
import software.amazon.awssdk.services.workmail.model.MailDomainStateException;
import software.amazon.awssdk.services.workmail.model.NameAvailabilityException;
import software.amazon.awssdk.services.workmail.model.OrganizationNotFoundException;
import software.amazon.awssdk.services.workmail.model.OrganizationStateException;
import software.amazon.awssdk.services.workmail.model.PutAccessControlRuleRequest;
import software.amazon.awssdk.services.workmail.model.PutAccessControlRuleResponse;
import software.amazon.awssdk.services.workmail.model.PutEmailMonitoringConfigurationRequest;
import software.amazon.awssdk.services.workmail.model.PutEmailMonitoringConfigurationResponse;
import software.amazon.awssdk.services.workmail.model.PutIdentityProviderConfigurationRequest;
import software.amazon.awssdk.services.workmail.model.PutIdentityProviderConfigurationResponse;
import software.amazon.awssdk.services.workmail.model.PutInboundDmarcSettingsRequest;
import software.amazon.awssdk.services.workmail.model.PutInboundDmarcSettingsResponse;
import software.amazon.awssdk.services.workmail.model.PutMailboxPermissionsRequest;
import software.amazon.awssdk.services.workmail.model.PutMailboxPermissionsResponse;
import software.amazon.awssdk.services.workmail.model.PutMobileDeviceAccessOverrideRequest;
import software.amazon.awssdk.services.workmail.model.PutMobileDeviceAccessOverrideResponse;
import software.amazon.awssdk.services.workmail.model.PutRetentionPolicyRequest;
import software.amazon.awssdk.services.workmail.model.PutRetentionPolicyResponse;
import software.amazon.awssdk.services.workmail.model.RegisterMailDomainRequest;
import software.amazon.awssdk.services.workmail.model.RegisterMailDomainResponse;
import software.amazon.awssdk.services.workmail.model.RegisterToWorkMailRequest;
import software.amazon.awssdk.services.workmail.model.RegisterToWorkMailResponse;
import software.amazon.awssdk.services.workmail.model.ReservedNameException;
import software.amazon.awssdk.services.workmail.model.ResetPasswordRequest;
import software.amazon.awssdk.services.workmail.model.ResetPasswordResponse;
import software.amazon.awssdk.services.workmail.model.ResourceNotFoundException;
import software.amazon.awssdk.services.workmail.model.StartMailboxExportJobRequest;
import software.amazon.awssdk.services.workmail.model.StartMailboxExportJobResponse;
import software.amazon.awssdk.services.workmail.model.TagResourceRequest;
import software.amazon.awssdk.services.workmail.model.TagResourceResponse;
import software.amazon.awssdk.services.workmail.model.TestAvailabilityConfigurationRequest;
import software.amazon.awssdk.services.workmail.model.TestAvailabilityConfigurationResponse;
import software.amazon.awssdk.services.workmail.model.TooManyTagsException;
import software.amazon.awssdk.services.workmail.model.UnsupportedOperationException;
import software.amazon.awssdk.services.workmail.model.UntagResourceRequest;
import software.amazon.awssdk.services.workmail.model.UntagResourceResponse;
import software.amazon.awssdk.services.workmail.model.UpdateAvailabilityConfigurationRequest;
import software.amazon.awssdk.services.workmail.model.UpdateAvailabilityConfigurationResponse;
import software.amazon.awssdk.services.workmail.model.UpdateDefaultMailDomainRequest;
import software.amazon.awssdk.services.workmail.model.UpdateDefaultMailDomainResponse;
import software.amazon.awssdk.services.workmail.model.UpdateGroupRequest;
import software.amazon.awssdk.services.workmail.model.UpdateGroupResponse;
import software.amazon.awssdk.services.workmail.model.UpdateImpersonationRoleRequest;
import software.amazon.awssdk.services.workmail.model.UpdateImpersonationRoleResponse;
import software.amazon.awssdk.services.workmail.model.UpdateMailboxQuotaRequest;
import software.amazon.awssdk.services.workmail.model.UpdateMailboxQuotaResponse;
import software.amazon.awssdk.services.workmail.model.UpdateMobileDeviceAccessRuleRequest;
import software.amazon.awssdk.services.workmail.model.UpdateMobileDeviceAccessRuleResponse;
import software.amazon.awssdk.services.workmail.model.UpdatePrimaryEmailAddressRequest;
import software.amazon.awssdk.services.workmail.model.UpdatePrimaryEmailAddressResponse;
import software.amazon.awssdk.services.workmail.model.UpdateResourceRequest;
import software.amazon.awssdk.services.workmail.model.UpdateResourceResponse;
import software.amazon.awssdk.services.workmail.model.UpdateUserRequest;
import software.amazon.awssdk.services.workmail.model.UpdateUserResponse;
import software.amazon.awssdk.services.workmail.model.WorkMailException;
import software.amazon.awssdk.services.workmail.transform.AssociateDelegateToResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.AssociateMemberToGroupRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.AssumeImpersonationRoleRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.CancelMailboxExportJobRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.CreateAliasRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.CreateAvailabilityConfigurationRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.CreateGroupRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.CreateIdentityCenterApplicationRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.CreateImpersonationRoleRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.CreateMobileDeviceAccessRuleRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.CreateOrganizationRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.CreateResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteAccessControlRuleRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteAliasRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteAvailabilityConfigurationRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteEmailMonitoringConfigurationRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteGroupRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteIdentityCenterApplicationRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteIdentityProviderConfigurationRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteImpersonationRoleRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteMailboxPermissionsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteMobileDeviceAccessOverrideRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteMobileDeviceAccessRuleRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteOrganizationRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeletePersonalAccessTokenRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteRetentionPolicyRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeregisterFromWorkMailRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeregisterMailDomainRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DescribeEmailMonitoringConfigurationRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DescribeEntityRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DescribeGroupRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DescribeIdentityProviderConfigurationRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DescribeInboundDmarcSettingsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DescribeMailboxExportJobRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DescribeOrganizationRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DescribeResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DescribeUserRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DisassociateDelegateFromResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DisassociateMemberFromGroupRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.GetAccessControlEffectRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.GetDefaultRetentionPolicyRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.GetImpersonationRoleEffectRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.GetImpersonationRoleRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.GetMailDomainRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.GetMailboxDetailsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.GetMobileDeviceAccessEffectRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.GetMobileDeviceAccessOverrideRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.GetPersonalAccessTokenMetadataRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListAccessControlRulesRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListAliasesRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListAvailabilityConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListGroupMembersRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListGroupsForEntityRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListGroupsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListImpersonationRolesRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListMailDomainsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListMailboxExportJobsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListMailboxPermissionsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListMobileDeviceAccessOverridesRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListMobileDeviceAccessRulesRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListOrganizationsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListPersonalAccessTokensRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListResourceDelegatesRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListResourcesRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListUsersRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.PutAccessControlRuleRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.PutEmailMonitoringConfigurationRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.PutIdentityProviderConfigurationRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.PutInboundDmarcSettingsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.PutMailboxPermissionsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.PutMobileDeviceAccessOverrideRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.PutRetentionPolicyRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.RegisterMailDomainRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.RegisterToWorkMailRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ResetPasswordRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.StartMailboxExportJobRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.TestAvailabilityConfigurationRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.UpdateAvailabilityConfigurationRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.UpdateDefaultMailDomainRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.UpdateGroupRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.UpdateImpersonationRoleRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.UpdateMailboxQuotaRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.UpdateMobileDeviceAccessRuleRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.UpdatePrimaryEmailAddressRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.UpdateResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.UpdateUserRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link WorkMailAsyncClient}.
 *
 * @see WorkMailAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultWorkMailAsyncClient implements WorkMailAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkMailAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultWorkMailAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "WorkMail" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Adds a member (user or group) to the resource's set of delegates.
     * </p>
     *
     * @param associateDelegateToResourceRequest
     * @return A Java Future containing the result of the AssociateDelegateToResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.AssociateDelegateToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/AssociateDelegateToResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateDelegateToResourceResponse> associateDelegateToResource(
            AssociateDelegateToResourceRequest associateDelegateToResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateDelegateToResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateDelegateToResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateDelegateToResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateDelegateToResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateDelegateToResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AssociateDelegateToResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateDelegateToResourceRequest, AssociateDelegateToResourceResponse>()
                            .withOperationName("AssociateDelegateToResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateDelegateToResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateDelegateToResourceRequest));
            CompletableFuture<AssociateDelegateToResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds a member (user or group) to the group's set.
     * </p>
     *
     * @param associateMemberToGroupRequest
     * @return A Java Future containing the result of the AssociateMemberToGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.AssociateMemberToGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/AssociateMemberToGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateMemberToGroupResponse> associateMemberToGroup(
            AssociateMemberToGroupRequest associateMemberToGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateMemberToGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateMemberToGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateMemberToGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateMemberToGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateMemberToGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AssociateMemberToGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateMemberToGroupRequest, AssociateMemberToGroupResponse>()
                            .withOperationName("AssociateMemberToGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateMemberToGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateMemberToGroupRequest));
            CompletableFuture<AssociateMemberToGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Assumes an impersonation role for the given WorkMail organization. This method returns an authentication token
     * you can use to make impersonated calls.
     * </p>
     *
     * @param assumeImpersonationRoleRequest
     * @return A Java Future containing the result of the AssumeImpersonationRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.AssumeImpersonationRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/AssumeImpersonationRole"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssumeImpersonationRoleResponse> assumeImpersonationRole(
            AssumeImpersonationRoleRequest assumeImpersonationRoleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(assumeImpersonationRoleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, assumeImpersonationRoleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssumeImpersonationRole");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssumeImpersonationRoleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssumeImpersonationRoleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AssumeImpersonationRoleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssumeImpersonationRoleRequest, AssumeImpersonationRoleResponse>()
                            .withOperationName("AssumeImpersonationRole").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssumeImpersonationRoleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(assumeImpersonationRoleRequest));
            CompletableFuture<AssumeImpersonationRoleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels a mailbox export job.
     * </p>
     * <note>
     * <p>
     * If the mailbox export job is near completion, it might not be possible to cancel it.
     * </p>
     * </note>
     *
     * @param cancelMailboxExportJobRequest
     * @return A Java Future containing the result of the CancelMailboxExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CancelMailboxExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CancelMailboxExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelMailboxExportJobResponse> cancelMailboxExportJob(
            CancelMailboxExportJobRequest cancelMailboxExportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelMailboxExportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelMailboxExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelMailboxExportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelMailboxExportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelMailboxExportJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CancelMailboxExportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelMailboxExportJobRequest, CancelMailboxExportJobResponse>()
                            .withOperationName("CancelMailboxExportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelMailboxExportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelMailboxExportJobRequest));
            CompletableFuture<CancelMailboxExportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds an alias to the set of a given member (user or group) of WorkMail.
     * </p>
     *
     * @param createAliasRequest
     * @return A Java Future containing the result of the CreateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EmailAddressInUseException The email address that you're trying to assign is already created for a
     *         different user, group, or resource.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>MailDomainNotFoundException The domain specified is not found in your organization.</li>
     *         <li>MailDomainStateException After a domain has been added to the organization, it must be verified. The
     *         domain is not yet verified.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAliasResponse> createAlias(CreateAliasRequest createAliasRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAliasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateAliasResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAliasRequest, CreateAliasResponse>()
                            .withOperationName("CreateAlias").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAliasRequest));
            CompletableFuture<CreateAliasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an <code>AvailabilityConfiguration</code> for the given WorkMail organization and domain.
     * </p>
     *
     * @param createAvailabilityConfigurationRequest
     * @return A Java Future containing the result of the CreateAvailabilityConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>NameAvailabilityException The user, group, or resource name isn't unique in WorkMail.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateAvailabilityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateAvailabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAvailabilityConfigurationResponse> createAvailabilityConfiguration(
            CreateAvailabilityConfigurationRequest createAvailabilityConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAvailabilityConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createAvailabilityConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAvailabilityConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAvailabilityConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAvailabilityConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateAvailabilityConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAvailabilityConfigurationRequest, CreateAvailabilityConfigurationResponse>()
                            .withOperationName("CreateAvailabilityConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAvailabilityConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createAvailabilityConfigurationRequest));
            CompletableFuture<CreateAvailabilityConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a group that can be used in WorkMail by calling the <a>RegisterToWorkMail</a> operation.
     * </p>
     *
     * @param createGroupRequest
     * @return A Java Future containing the result of the CreateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>NameAvailabilityException The user, group, or resource name isn't unique in WorkMail.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>ReservedNameException This user, group, or resource name is not allowed in WorkMail.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateGroupResponse> createGroup(CreateGroupRequest createGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateGroupRequest, CreateGroupResponse>()
                            .withOperationName("CreateGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createGroupRequest));
            CompletableFuture<CreateGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates the WorkMail application in IAM Identity Center that can be used later in the WorkMail - IdC integration.
     * For more information, see PutIdentityProviderConfiguration. This action does not affect the authentication
     * settings for any WorkMail organizations.
     * </p>
     *
     * @param createIdentityCenterApplicationRequest
     * @return A Java Future containing the result of the CreateIdentityCenterApplication operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateIdentityCenterApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateIdentityCenterApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateIdentityCenterApplicationResponse> createIdentityCenterApplication(
            CreateIdentityCenterApplicationRequest createIdentityCenterApplicationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIdentityCenterApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createIdentityCenterApplicationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIdentityCenterApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateIdentityCenterApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateIdentityCenterApplicationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateIdentityCenterApplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateIdentityCenterApplicationRequest, CreateIdentityCenterApplicationResponse>()
                            .withOperationName("CreateIdentityCenterApplication").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateIdentityCenterApplicationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createIdentityCenterApplicationRequest));
            CompletableFuture<CreateIdentityCenterApplicationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an impersonation role for the given WorkMail organization.
     * </p>
     * <p>
     * <i>Idempotency</i> ensures that an API request completes no more than one time. With an idempotent request, if
     * the original request completes successfully, any subsequent retries also complete successfully without performing
     * any further actions.
     * </p>
     *
     * @param createImpersonationRoleRequest
     * @return A Java Future containing the result of the CreateImpersonationRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateImpersonationRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateImpersonationRole"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateImpersonationRoleResponse> createImpersonationRole(
            CreateImpersonationRoleRequest createImpersonationRoleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createImpersonationRoleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createImpersonationRoleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateImpersonationRole");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateImpersonationRoleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateImpersonationRoleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateImpersonationRoleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateImpersonationRoleRequest, CreateImpersonationRoleResponse>()
                            .withOperationName("CreateImpersonationRole").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateImpersonationRoleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createImpersonationRoleRequest));
            CompletableFuture<CreateImpersonationRoleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new mobile device access rule for the specified WorkMail organization.
     * </p>
     *
     * @param createMobileDeviceAccessRuleRequest
     * @return A Java Future containing the result of the CreateMobileDeviceAccessRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateMobileDeviceAccessRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateMobileDeviceAccessRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMobileDeviceAccessRuleResponse> createMobileDeviceAccessRule(
            CreateMobileDeviceAccessRuleRequest createMobileDeviceAccessRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMobileDeviceAccessRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMobileDeviceAccessRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMobileDeviceAccessRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMobileDeviceAccessRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateMobileDeviceAccessRuleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateMobileDeviceAccessRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMobileDeviceAccessRuleRequest, CreateMobileDeviceAccessRuleResponse>()
                            .withOperationName("CreateMobileDeviceAccessRule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateMobileDeviceAccessRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createMobileDeviceAccessRuleRequest));
            CompletableFuture<CreateMobileDeviceAccessRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new WorkMail organization. Optionally, you can choose to associate an existing AWS Directory Service
     * directory with your organization. If an AWS Directory Service directory ID is specified, the organization alias
     * must match the directory alias. If you choose not to associate an existing directory with your organization, then
     * we create a new WorkMail directory for you. For more information, see <a
     * href="https://docs.aws.amazon.com/workmail/latest/adminguide/add_new_organization.html">Adding an
     * organization</a> in the <i>WorkMail Administrator Guide</i>.
     * </p>
     * <p>
     * You can associate multiple email domains with an organization, then choose your default email domain from the
     * WorkMail console. You can also associate a domain that is managed in an Amazon Route 53 public hosted zone. For
     * more information, see <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/add_domain.html">Adding a
     * domain</a> and <a href="https://docs.aws.amazon.com/workmail/latest/adminguide/default_domain.html">Choosing the
     * default domain</a> in the <i>WorkMail Administrator Guide</i>.
     * </p>
     * <p>
     * Optionally, you can use a customer managed key from AWS Key Management Service (AWS KMS) to encrypt email for
     * your organization. If you don't associate an AWS KMS key, WorkMail creates a default, AWS managed key for you.
     * </p>
     *
     * @param createOrganizationRequest
     * @return A Java Future containing the result of the CreateOrganization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>DirectoryInUseException The directory is already in use by another WorkMail organization in the same
     *         account and Region.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>NameAvailabilityException The user, group, or resource name isn't unique in WorkMail.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateOrganization" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateOrganizationResponse> createOrganization(CreateOrganizationRequest createOrganizationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createOrganizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createOrganizationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOrganization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateOrganizationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateOrganizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateOrganizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateOrganizationRequest, CreateOrganizationResponse>()
                            .withOperationName("CreateOrganization").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateOrganizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createOrganizationRequest));
            CompletableFuture<CreateOrganizationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new WorkMail resource.
     * </p>
     *
     * @param createResourceRequest
     * @return A Java Future containing the result of the CreateResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>NameAvailabilityException The user, group, or resource name isn't unique in WorkMail.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>ReservedNameException This user, group, or resource name is not allowed in WorkMail.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateResourceResponse> createResource(CreateResourceRequest createResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateResourceRequest, CreateResourceResponse>()
                            .withOperationName("CreateResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createResourceRequest));
            CompletableFuture<CreateResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a user who can be used in WorkMail by calling the <a>RegisterToWorkMail</a> operation.
     * </p>
     *
     * @param createUserRequest
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>InvalidPasswordException The supplied password doesn't match the minimum security constraints, such
     *         as length or use of special characters.</li>
     *         <li>NameAvailabilityException The user, group, or resource name isn't unique in WorkMail.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>ReservedNameException This user, group, or resource name is not allowed in WorkMail.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateUserResponse> createUser(CreateUserRequest createUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateUserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateUserRequest, CreateUserResponse>().withOperationName("CreateUser")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createUserRequest));
            CompletableFuture<CreateUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an access control rule for the specified WorkMail organization.
     * </p>
     * <note>
     * <p>
     * Deleting already deleted and non-existing rules does not produce an error. In those cases, the service sends back
     * an HTTP 200 response with an empty HTTP body.
     * </p>
     * </note>
     *
     * @param deleteAccessControlRuleRequest
     * @return A Java Future containing the result of the DeleteAccessControlRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteAccessControlRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteAccessControlRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAccessControlRuleResponse> deleteAccessControlRule(
            DeleteAccessControlRuleRequest deleteAccessControlRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAccessControlRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAccessControlRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccessControlRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAccessControlRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAccessControlRuleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteAccessControlRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAccessControlRuleRequest, DeleteAccessControlRuleResponse>()
                            .withOperationName("DeleteAccessControlRule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAccessControlRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAccessControlRuleRequest));
            CompletableFuture<DeleteAccessControlRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Remove one or more specified aliases from a set of aliases for a given user.
     * </p>
     *
     * @param deleteAliasRequest
     * @return A Java Future containing the result of the DeleteAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAliasResponse> deleteAlias(DeleteAliasRequest deleteAliasRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAliasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteAliasResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAliasRequest, DeleteAliasResponse>()
                            .withOperationName("DeleteAlias").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAliasRequest));
            CompletableFuture<DeleteAliasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the <code>AvailabilityConfiguration</code> for the given WorkMail organization and domain.
     * </p>
     *
     * @param deleteAvailabilityConfigurationRequest
     * @return A Java Future containing the result of the DeleteAvailabilityConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteAvailabilityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteAvailabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAvailabilityConfigurationResponse> deleteAvailabilityConfiguration(
            DeleteAvailabilityConfigurationRequest deleteAvailabilityConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAvailabilityConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteAvailabilityConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAvailabilityConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAvailabilityConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAvailabilityConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteAvailabilityConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAvailabilityConfigurationRequest, DeleteAvailabilityConfigurationResponse>()
                            .withOperationName("DeleteAvailabilityConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAvailabilityConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAvailabilityConfigurationRequest));
            CompletableFuture<DeleteAvailabilityConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the email monitoring configuration for a specified organization.
     * </p>
     *
     * @param deleteEmailMonitoringConfigurationRequest
     * @return A Java Future containing the result of the DeleteEmailMonitoringConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteEmailMonitoringConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteEmailMonitoringConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEmailMonitoringConfigurationResponse> deleteEmailMonitoringConfiguration(
            DeleteEmailMonitoringConfigurationRequest deleteEmailMonitoringConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEmailMonitoringConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteEmailMonitoringConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEmailMonitoringConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEmailMonitoringConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteEmailMonitoringConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteEmailMonitoringConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEmailMonitoringConfigurationRequest, DeleteEmailMonitoringConfigurationResponse>()
                            .withOperationName("DeleteEmailMonitoringConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteEmailMonitoringConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteEmailMonitoringConfigurationRequest));
            CompletableFuture<DeleteEmailMonitoringConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a group from WorkMail.
     * </p>
     *
     * @param deleteGroupRequest
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteGroupResponse> deleteGroup(DeleteGroupRequest deleteGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteGroupRequest, DeleteGroupResponse>()
                            .withOperationName("DeleteGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteGroupRequest));
            CompletableFuture<DeleteGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the IAM Identity Center application from WorkMail. This action does not affect the authentication
     * settings for any WorkMail organizations.
     * </p>
     *
     * @param deleteIdentityCenterApplicationRequest
     * @return A Java Future containing the result of the DeleteIdentityCenterApplication operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteIdentityCenterApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteIdentityCenterApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteIdentityCenterApplicationResponse> deleteIdentityCenterApplication(
            DeleteIdentityCenterApplicationRequest deleteIdentityCenterApplicationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIdentityCenterApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteIdentityCenterApplicationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIdentityCenterApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteIdentityCenterApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteIdentityCenterApplicationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteIdentityCenterApplicationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteIdentityCenterApplicationRequest, DeleteIdentityCenterApplicationResponse>()
                            .withOperationName("DeleteIdentityCenterApplication").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteIdentityCenterApplicationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteIdentityCenterApplicationRequest));
            CompletableFuture<DeleteIdentityCenterApplicationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables the integration between IdC and WorkMail. Authentication will continue with the directory as it was
     * before the IdC integration. You might have to reset your directory passwords and reconfigure your desktop and
     * mobile email clients.
     * </p>
     *
     * @param deleteIdentityProviderConfigurationRequest
     * @return A Java Future containing the result of the DeleteIdentityProviderConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteIdentityProviderConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteIdentityProviderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteIdentityProviderConfigurationResponse> deleteIdentityProviderConfiguration(
            DeleteIdentityProviderConfigurationRequest deleteIdentityProviderConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIdentityProviderConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteIdentityProviderConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIdentityProviderConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteIdentityProviderConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteIdentityProviderConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteIdentityProviderConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteIdentityProviderConfigurationRequest, DeleteIdentityProviderConfigurationResponse>()
                            .withOperationName("DeleteIdentityProviderConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteIdentityProviderConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteIdentityProviderConfigurationRequest));
            CompletableFuture<DeleteIdentityProviderConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an impersonation role for the given WorkMail organization.
     * </p>
     *
     * @param deleteImpersonationRoleRequest
     * @return A Java Future containing the result of the DeleteImpersonationRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteImpersonationRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteImpersonationRole"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteImpersonationRoleResponse> deleteImpersonationRole(
            DeleteImpersonationRoleRequest deleteImpersonationRoleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteImpersonationRoleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteImpersonationRoleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteImpersonationRole");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteImpersonationRoleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteImpersonationRoleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteImpersonationRoleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteImpersonationRoleRequest, DeleteImpersonationRoleResponse>()
                            .withOperationName("DeleteImpersonationRole").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteImpersonationRoleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteImpersonationRoleRequest));
            CompletableFuture<DeleteImpersonationRoleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes permissions granted to a member (user or group).
     * </p>
     *
     * @param deleteMailboxPermissionsRequest
     * @return A Java Future containing the result of the DeleteMailboxPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteMailboxPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteMailboxPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMailboxPermissionsResponse> deleteMailboxPermissions(
            DeleteMailboxPermissionsRequest deleteMailboxPermissionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMailboxPermissionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMailboxPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMailboxPermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMailboxPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteMailboxPermissionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteMailboxPermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMailboxPermissionsRequest, DeleteMailboxPermissionsResponse>()
                            .withOperationName("DeleteMailboxPermissions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteMailboxPermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteMailboxPermissionsRequest));
            CompletableFuture<DeleteMailboxPermissionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the mobile device access override for the given WorkMail organization, user, and device.
     * </p>
     * <note>
     * <p>
     * Deleting already deleted and non-existing overrides does not produce an error. In those cases, the service sends
     * back an HTTP 200 response with an empty HTTP body.
     * </p>
     * </note>
     *
     * @param deleteMobileDeviceAccessOverrideRequest
     * @return A Java Future containing the result of the DeleteMobileDeviceAccessOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteMobileDeviceAccessOverride
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteMobileDeviceAccessOverride"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMobileDeviceAccessOverrideResponse> deleteMobileDeviceAccessOverride(
            DeleteMobileDeviceAccessOverrideRequest deleteMobileDeviceAccessOverrideRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMobileDeviceAccessOverrideRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteMobileDeviceAccessOverrideRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMobileDeviceAccessOverride");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMobileDeviceAccessOverrideResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteMobileDeviceAccessOverrideResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteMobileDeviceAccessOverrideResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMobileDeviceAccessOverrideRequest, DeleteMobileDeviceAccessOverrideResponse>()
                            .withOperationName("DeleteMobileDeviceAccessOverride").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteMobileDeviceAccessOverrideRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteMobileDeviceAccessOverrideRequest));
            CompletableFuture<DeleteMobileDeviceAccessOverrideResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a mobile device access rule for the specified WorkMail organization.
     * </p>
     * <note>
     * <p>
     * Deleting already deleted and non-existing rules does not produce an error. In those cases, the service sends back
     * an HTTP 200 response with an empty HTTP body.
     * </p>
     * </note>
     *
     * @param deleteMobileDeviceAccessRuleRequest
     * @return A Java Future containing the result of the DeleteMobileDeviceAccessRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteMobileDeviceAccessRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteMobileDeviceAccessRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMobileDeviceAccessRuleResponse> deleteMobileDeviceAccessRule(
            DeleteMobileDeviceAccessRuleRequest deleteMobileDeviceAccessRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMobileDeviceAccessRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMobileDeviceAccessRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMobileDeviceAccessRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMobileDeviceAccessRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteMobileDeviceAccessRuleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteMobileDeviceAccessRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMobileDeviceAccessRuleRequest, DeleteMobileDeviceAccessRuleResponse>()
                            .withOperationName("DeleteMobileDeviceAccessRule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteMobileDeviceAccessRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteMobileDeviceAccessRuleRequest));
            CompletableFuture<DeleteMobileDeviceAccessRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an WorkMail organization and all underlying AWS resources managed by WorkMail as part of the
     * organization. You can choose whether to delete the associated directory. For more information, see <a
     * href="https://docs.aws.amazon.com/workmail/latest/adminguide/remove_organization.html">Removing an
     * organization</a> in the <i>WorkMail Administrator Guide</i>.
     * </p>
     *
     * @param deleteOrganizationRequest
     * @return A Java Future containing the result of the DeleteOrganization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteOrganization" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteOrganizationResponse> deleteOrganization(DeleteOrganizationRequest deleteOrganizationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteOrganizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOrganizationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOrganization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteOrganizationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteOrganizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteOrganizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteOrganizationRequest, DeleteOrganizationResponse>()
                            .withOperationName("DeleteOrganization").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteOrganizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteOrganizationRequest));
            CompletableFuture<DeleteOrganizationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the Personal Access Token from the provided WorkMail Organization.
     * </p>
     *
     * @param deletePersonalAccessTokenRequest
     * @return A Java Future containing the result of the DeletePersonalAccessToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeletePersonalAccessToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeletePersonalAccessToken"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePersonalAccessTokenResponse> deletePersonalAccessToken(
            DeletePersonalAccessTokenRequest deletePersonalAccessTokenRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePersonalAccessTokenRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePersonalAccessTokenRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePersonalAccessToken");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeletePersonalAccessTokenResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeletePersonalAccessTokenResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeletePersonalAccessTokenResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePersonalAccessTokenRequest, DeletePersonalAccessTokenResponse>()
                            .withOperationName("DeletePersonalAccessToken").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeletePersonalAccessTokenRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deletePersonalAccessTokenRequest));
            CompletableFuture<DeletePersonalAccessTokenResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified resource.
     * </p>
     *
     * @param deleteResourceRequest
     * @return A Java Future containing the result of the DeleteResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteResourceResponse> deleteResource(DeleteResourceRequest deleteResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteResourceRequest, DeleteResourceResponse>()
                            .withOperationName("DeleteResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteResourceRequest));
            CompletableFuture<DeleteResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified retention policy from the specified organization.
     * </p>
     *
     * @param deleteRetentionPolicyRequest
     * @return A Java Future containing the result of the DeleteRetentionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteRetentionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteRetentionPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRetentionPolicyResponse> deleteRetentionPolicy(
            DeleteRetentionPolicyRequest deleteRetentionPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRetentionPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRetentionPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRetentionPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRetentionPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRetentionPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteRetentionPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRetentionPolicyRequest, DeleteRetentionPolicyResponse>()
                            .withOperationName("DeleteRetentionPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRetentionPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRetentionPolicyRequest));
            CompletableFuture<DeleteRetentionPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a user from WorkMail and all subsequent systems. Before you can delete a user, the user state must be
     * <code>DISABLED</code>. Use the <a>DescribeUser</a> action to confirm the user state.
     * </p>
     * <p>
     * Deleting a user is permanent and cannot be undone. WorkMail archives user mailboxes for 30 days before they are
     * permanently removed.
     * </p>
     *
     * @param deleteUserRequest
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteUserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserRequest, DeleteUserResponse>().withOperationName("DeleteUser")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteUserRequest));
            CompletableFuture<DeleteUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Mark a user, group, or resource as no longer used in WorkMail. This action disassociates the mailbox and
     * schedules it for clean-up. WorkMail keeps mailboxes for 30 days before they are permanently removed. The
     * functionality in the console is <i>Disable</i>.
     * </p>
     *
     * @param deregisterFromWorkMailRequest
     * @return A Java Future containing the result of the DeregisterFromWorkMail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeregisterFromWorkMail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeregisterFromWorkMail"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterFromWorkMailResponse> deregisterFromWorkMail(
            DeregisterFromWorkMailRequest deregisterFromWorkMailRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deregisterFromWorkMailRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterFromWorkMailRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterFromWorkMail");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeregisterFromWorkMailResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeregisterFromWorkMailResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeregisterFromWorkMailResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterFromWorkMailRequest, DeregisterFromWorkMailResponse>()
                            .withOperationName("DeregisterFromWorkMail").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeregisterFromWorkMailRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deregisterFromWorkMailRequest));
            CompletableFuture<DeregisterFromWorkMailResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a domain from WorkMail, stops email routing to WorkMail, and removes the authorization allowing WorkMail
     * use. SES keeps the domain because other applications may use it. You must first remove any email address used by
     * WorkMail entities before you remove the domain.
     * </p>
     *
     * @param deregisterMailDomainRequest
     * @return A Java Future containing the result of the DeregisterMailDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>MailDomainInUseException The domain you're trying to change is in use by another user or organization
     *         in your account. See the error message for details.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>InvalidCustomSesConfigurationException You SES configuration has customizations that WorkMail cannot
     *         save. The error message lists the invalid setting. For examples of invalid settings, refer to <a
     *         href="https://docs.aws.amazon.com/ses/latest/APIReference/API_CreateReceiptRule.html"
     *         >CreateReceiptRule</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeregisterMailDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeregisterMailDomain" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterMailDomainResponse> deregisterMailDomain(
            DeregisterMailDomainRequest deregisterMailDomainRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deregisterMailDomainRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterMailDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterMailDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeregisterMailDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeregisterMailDomainResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeregisterMailDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterMailDomainRequest, DeregisterMailDomainResponse>()
                            .withOperationName("DeregisterMailDomain").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeregisterMailDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deregisterMailDomainRequest));
            CompletableFuture<DeregisterMailDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the current email monitoring configuration for a specified organization.
     * </p>
     *
     * @param describeEmailMonitoringConfigurationRequest
     * @return A Java Future containing the result of the DescribeEmailMonitoringConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeEmailMonitoringConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeEmailMonitoringConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEmailMonitoringConfigurationResponse> describeEmailMonitoringConfiguration(
            DescribeEmailMonitoringConfigurationRequest describeEmailMonitoringConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEmailMonitoringConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeEmailMonitoringConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEmailMonitoringConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEmailMonitoringConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeEmailMonitoringConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeEmailMonitoringConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEmailMonitoringConfigurationRequest, DescribeEmailMonitoringConfigurationResponse>()
                            .withOperationName("DescribeEmailMonitoringConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeEmailMonitoringConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeEmailMonitoringConfigurationRequest));
            CompletableFuture<DescribeEmailMonitoringConfigurationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns basic details about an entity in WorkMail.
     * </p>
     *
     * @param describeEntityRequest
     * @return A Java Future containing the result of the DescribeEntity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeEntity" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeEntityResponse> describeEntity(DescribeEntityRequest describeEntityRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEntityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEntityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEntity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeEntityResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeEntityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeEntityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeEntityRequest, DescribeEntityResponse>()
                            .withOperationName("DescribeEntity").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeEntityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeEntityRequest));
            CompletableFuture<DescribeEntityResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the data available for the group.
     * </p>
     *
     * @param describeGroupRequest
     * @return A Java Future containing the result of the DescribeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeGroupResponse> describeGroup(DescribeGroupRequest describeGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeGroupRequest, DescribeGroupResponse>()
                            .withOperationName("DescribeGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeGroupRequest));
            CompletableFuture<DescribeGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns detailed information on the current IdC setup for the WorkMail organization.
     * </p>
     *
     * @param describeIdentityProviderConfigurationRequest
     * @return A Java Future containing the result of the DescribeIdentityProviderConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeIdentityProviderConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeIdentityProviderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeIdentityProviderConfigurationResponse> describeIdentityProviderConfiguration(
            DescribeIdentityProviderConfigurationRequest describeIdentityProviderConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeIdentityProviderConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeIdentityProviderConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeIdentityProviderConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeIdentityProviderConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeIdentityProviderConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeIdentityProviderConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeIdentityProviderConfigurationRequest, DescribeIdentityProviderConfigurationResponse>()
                            .withOperationName("DescribeIdentityProviderConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeIdentityProviderConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeIdentityProviderConfigurationRequest));
            CompletableFuture<DescribeIdentityProviderConfigurationResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the settings in a DMARC policy for a specified organization.
     * </p>
     *
     * @param describeInboundDmarcSettingsRequest
     * @return A Java Future containing the result of the DescribeInboundDmarcSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeInboundDmarcSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeInboundDmarcSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeInboundDmarcSettingsResponse> describeInboundDmarcSettings(
            DescribeInboundDmarcSettingsRequest describeInboundDmarcSettingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeInboundDmarcSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeInboundDmarcSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInboundDmarcSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeInboundDmarcSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeInboundDmarcSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeInboundDmarcSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeInboundDmarcSettingsRequest, DescribeInboundDmarcSettingsResponse>()
                            .withOperationName("DescribeInboundDmarcSettings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeInboundDmarcSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeInboundDmarcSettingsRequest));
            CompletableFuture<DescribeInboundDmarcSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the current status of a mailbox export job.
     * </p>
     *
     * @param describeMailboxExportJobRequest
     * @return A Java Future containing the result of the DescribeMailboxExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeMailboxExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeMailboxExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeMailboxExportJobResponse> describeMailboxExportJob(
            DescribeMailboxExportJobRequest describeMailboxExportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeMailboxExportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeMailboxExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMailboxExportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeMailboxExportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeMailboxExportJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeMailboxExportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeMailboxExportJobRequest, DescribeMailboxExportJobResponse>()
                            .withOperationName("DescribeMailboxExportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeMailboxExportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeMailboxExportJobRequest));
            CompletableFuture<DescribeMailboxExportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides more information regarding a given organization based on its identifier.
     * </p>
     *
     * @param describeOrganizationRequest
     * @return A Java Future containing the result of the DescribeOrganization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeOrganization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeOrganization" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeOrganizationResponse> describeOrganization(
            DescribeOrganizationRequest describeOrganizationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeOrganizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeOrganizationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOrganization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeOrganizationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeOrganizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeOrganizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeOrganizationRequest, DescribeOrganizationResponse>()
                            .withOperationName("DescribeOrganization").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeOrganizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeOrganizationRequest));
            CompletableFuture<DescribeOrganizationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the data available for the resource.
     * </p>
     *
     * @param describeResourceRequest
     * @return A Java Future containing the result of the DescribeResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeResourceResponse> describeResource(DescribeResourceRequest describeResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeResourceRequest, DescribeResourceResponse>()
                            .withOperationName("DescribeResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeResourceRequest));
            CompletableFuture<DescribeResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides information regarding the user.
     * </p>
     *
     * @param describeUserRequest
     * @return A Java Future containing the result of the DescribeUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeUserResponse> describeUser(DescribeUserRequest describeUserRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeUserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeUserRequest, DescribeUserResponse>()
                            .withOperationName("DescribeUser").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeUserRequest));
            CompletableFuture<DescribeUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a member from the resource's set of delegates.
     * </p>
     *
     * @param disassociateDelegateFromResourceRequest
     * @return A Java Future containing the result of the DisassociateDelegateFromResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DisassociateDelegateFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DisassociateDelegateFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateDelegateFromResourceResponse> disassociateDelegateFromResource(
            DisassociateDelegateFromResourceRequest disassociateDelegateFromResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateDelegateFromResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateDelegateFromResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateDelegateFromResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateDelegateFromResourceResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociateDelegateFromResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DisassociateDelegateFromResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateDelegateFromResourceRequest, DisassociateDelegateFromResourceResponse>()
                            .withOperationName("DisassociateDelegateFromResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisassociateDelegateFromResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateDelegateFromResourceRequest));
            CompletableFuture<DisassociateDelegateFromResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a member from a group.
     * </p>
     *
     * @param disassociateMemberFromGroupRequest
     * @return A Java Future containing the result of the DisassociateMemberFromGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DisassociateMemberFromGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DisassociateMemberFromGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateMemberFromGroupResponse> disassociateMemberFromGroup(
            DisassociateMemberFromGroupRequest disassociateMemberFromGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateMemberFromGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateMemberFromGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateMemberFromGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateMemberFromGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateMemberFromGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DisassociateMemberFromGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateMemberFromGroupRequest, DisassociateMemberFromGroupResponse>()
                            .withOperationName("DisassociateMemberFromGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisassociateMemberFromGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateMemberFromGroupRequest));
            CompletableFuture<DisassociateMemberFromGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the effects of an organization's access control rules as they apply to a specified IPv4 address, access
     * protocol action, and user ID or impersonation role ID. You must provide either the user ID or impersonation role
     * ID. Impersonation role ID can only be used with Action EWS.
     * </p>
     *
     * @param getAccessControlEffectRequest
     * @return A Java Future containing the result of the GetAccessControlEffect operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetAccessControlEffect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetAccessControlEffect"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAccessControlEffectResponse> getAccessControlEffect(
            GetAccessControlEffectRequest getAccessControlEffectRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAccessControlEffectRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAccessControlEffectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccessControlEffect");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAccessControlEffectResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAccessControlEffectResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetAccessControlEffectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAccessControlEffectRequest, GetAccessControlEffectResponse>()
                            .withOperationName("GetAccessControlEffect").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAccessControlEffectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getAccessControlEffectRequest));
            CompletableFuture<GetAccessControlEffectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the default retention policy details for the specified organization.
     * </p>
     *
     * @param getDefaultRetentionPolicyRequest
     * @return A Java Future containing the result of the GetDefaultRetentionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetDefaultRetentionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetDefaultRetentionPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDefaultRetentionPolicyResponse> getDefaultRetentionPolicy(
            GetDefaultRetentionPolicyRequest getDefaultRetentionPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDefaultRetentionPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDefaultRetentionPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDefaultRetentionPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDefaultRetentionPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDefaultRetentionPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetDefaultRetentionPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDefaultRetentionPolicyRequest, GetDefaultRetentionPolicyResponse>()
                            .withOperationName("GetDefaultRetentionPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDefaultRetentionPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDefaultRetentionPolicyRequest));
            CompletableFuture<GetDefaultRetentionPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the impersonation role details for the given WorkMail organization.
     * </p>
     *
     * @param getImpersonationRoleRequest
     * @return A Java Future containing the result of the GetImpersonationRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetImpersonationRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetImpersonationRole" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetImpersonationRoleResponse> getImpersonationRole(
            GetImpersonationRoleRequest getImpersonationRoleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getImpersonationRoleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImpersonationRoleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImpersonationRole");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetImpersonationRoleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetImpersonationRoleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetImpersonationRoleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetImpersonationRoleRequest, GetImpersonationRoleResponse>()
                            .withOperationName("GetImpersonationRole").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetImpersonationRoleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getImpersonationRoleRequest));
            CompletableFuture<GetImpersonationRoleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Tests whether the given impersonation role can impersonate a target user.
     * </p>
     *
     * @param getImpersonationRoleEffectRequest
     * @return A Java Future containing the result of the GetImpersonationRoleEffect operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetImpersonationRoleEffect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetImpersonationRoleEffect"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetImpersonationRoleEffectResponse> getImpersonationRoleEffect(
            GetImpersonationRoleEffectRequest getImpersonationRoleEffectRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getImpersonationRoleEffectRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImpersonationRoleEffectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImpersonationRoleEffect");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetImpersonationRoleEffectResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetImpersonationRoleEffectResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetImpersonationRoleEffectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetImpersonationRoleEffectRequest, GetImpersonationRoleEffectResponse>()
                            .withOperationName("GetImpersonationRoleEffect").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetImpersonationRoleEffectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getImpersonationRoleEffectRequest));
            CompletableFuture<GetImpersonationRoleEffectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets details for a mail domain, including domain records required to configure your domain with recommended
     * security.
     * </p>
     *
     * @param getMailDomainRequest
     * @return A Java Future containing the result of the GetMailDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>MailDomainNotFoundException The domain specified is not found in your organization.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetMailDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetMailDomain" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetMailDomainResponse> getMailDomain(GetMailDomainRequest getMailDomainRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMailDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMailDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMailDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMailDomainResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetMailDomainResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetMailDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMailDomainRequest, GetMailDomainResponse>()
                            .withOperationName("GetMailDomain").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMailDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMailDomainRequest));
            CompletableFuture<GetMailDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Requests a user's mailbox details for a specified organization and user.
     * </p>
     *
     * @param getMailboxDetailsRequest
     * @return A Java Future containing the result of the GetMailboxDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetMailboxDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetMailboxDetails" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMailboxDetailsResponse> getMailboxDetails(GetMailboxDetailsRequest getMailboxDetailsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMailboxDetailsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMailboxDetailsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMailboxDetails");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMailboxDetailsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMailboxDetailsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetMailboxDetailsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMailboxDetailsRequest, GetMailboxDetailsResponse>()
                            .withOperationName("GetMailboxDetails").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMailboxDetailsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMailboxDetailsRequest));
            CompletableFuture<GetMailboxDetailsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Simulates the effect of the mobile device access rules for the given attributes of a sample access event. Use
     * this method to test the effects of the current set of mobile device access rules for the WorkMail organization
     * for a particular user's attributes.
     * </p>
     *
     * @param getMobileDeviceAccessEffectRequest
     * @return A Java Future containing the result of the GetMobileDeviceAccessEffect operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetMobileDeviceAccessEffect
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetMobileDeviceAccessEffect"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMobileDeviceAccessEffectResponse> getMobileDeviceAccessEffect(
            GetMobileDeviceAccessEffectRequest getMobileDeviceAccessEffectRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMobileDeviceAccessEffectRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMobileDeviceAccessEffectRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMobileDeviceAccessEffect");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMobileDeviceAccessEffectResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMobileDeviceAccessEffectResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetMobileDeviceAccessEffectResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMobileDeviceAccessEffectRequest, GetMobileDeviceAccessEffectResponse>()
                            .withOperationName("GetMobileDeviceAccessEffect").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMobileDeviceAccessEffectRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMobileDeviceAccessEffectRequest));
            CompletableFuture<GetMobileDeviceAccessEffectResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the mobile device access override for the given WorkMail organization, user, and device.
     * </p>
     *
     * @param getMobileDeviceAccessOverrideRequest
     * @return A Java Future containing the result of the GetMobileDeviceAccessOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetMobileDeviceAccessOverride
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetMobileDeviceAccessOverride"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMobileDeviceAccessOverrideResponse> getMobileDeviceAccessOverride(
            GetMobileDeviceAccessOverrideRequest getMobileDeviceAccessOverrideRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMobileDeviceAccessOverrideRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getMobileDeviceAccessOverrideRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMobileDeviceAccessOverride");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMobileDeviceAccessOverrideResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMobileDeviceAccessOverrideResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetMobileDeviceAccessOverrideResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMobileDeviceAccessOverrideRequest, GetMobileDeviceAccessOverrideResponse>()
                            .withOperationName("GetMobileDeviceAccessOverride").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMobileDeviceAccessOverrideRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMobileDeviceAccessOverrideRequest));
            CompletableFuture<GetMobileDeviceAccessOverrideResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Requests details of a specific Personal Access Token within the WorkMail organization.
     * </p>
     *
     * @param getPersonalAccessTokenMetadataRequest
     * @return A Java Future containing the result of the GetPersonalAccessTokenMetadata operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetPersonalAccessTokenMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetPersonalAccessTokenMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetPersonalAccessTokenMetadataResponse> getPersonalAccessTokenMetadata(
            GetPersonalAccessTokenMetadataRequest getPersonalAccessTokenMetadataRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPersonalAccessTokenMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getPersonalAccessTokenMetadataRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPersonalAccessTokenMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPersonalAccessTokenMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetPersonalAccessTokenMetadataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetPersonalAccessTokenMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPersonalAccessTokenMetadataRequest, GetPersonalAccessTokenMetadataResponse>()
                            .withOperationName("GetPersonalAccessTokenMetadata").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetPersonalAccessTokenMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getPersonalAccessTokenMetadataRequest));
            CompletableFuture<GetPersonalAccessTokenMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the access control rules for the specified organization.
     * </p>
     *
     * @param listAccessControlRulesRequest
     * @return A Java Future containing the result of the ListAccessControlRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListAccessControlRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAccessControlRules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAccessControlRulesResponse> listAccessControlRules(
            ListAccessControlRulesRequest listAccessControlRulesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAccessControlRulesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAccessControlRulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccessControlRules");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAccessControlRulesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAccessControlRulesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListAccessControlRulesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAccessControlRulesRequest, ListAccessControlRulesResponse>()
                            .withOperationName("ListAccessControlRules").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAccessControlRulesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAccessControlRulesRequest));
            CompletableFuture<ListAccessControlRulesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a paginated call to list the aliases associated with a given entity.
     * </p>
     *
     * @param listAliasesRequest
     * @return A Java Future containing the result of the ListAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListAliasesResponse> listAliases(ListAliasesRequest listAliasesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAliasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAliasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAliases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAliasesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListAliasesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListAliasesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAliasesRequest, ListAliasesResponse>()
                            .withOperationName("ListAliases").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAliasesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAliasesRequest));
            CompletableFuture<ListAliasesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List all the <code>AvailabilityConfiguration</code>'s for the given WorkMail organization.
     * </p>
     *
     * @param listAvailabilityConfigurationsRequest
     * @return A Java Future containing the result of the ListAvailabilityConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListAvailabilityConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAvailabilityConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAvailabilityConfigurationsResponse> listAvailabilityConfigurations(
            ListAvailabilityConfigurationsRequest listAvailabilityConfigurationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAvailabilityConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAvailabilityConfigurationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAvailabilityConfigurations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAvailabilityConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAvailabilityConfigurationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListAvailabilityConfigurationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAvailabilityConfigurationsRequest, ListAvailabilityConfigurationsResponse>()
                            .withOperationName("ListAvailabilityConfigurations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAvailabilityConfigurationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAvailabilityConfigurationsRequest));
            CompletableFuture<ListAvailabilityConfigurationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns an overview of the members of a group. Users and groups can be members of a group.
     * </p>
     *
     * @param listGroupMembersRequest
     * @return A Java Future containing the result of the ListGroupMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListGroupMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroupMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListGroupMembersResponse> listGroupMembers(ListGroupMembersRequest listGroupMembersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGroupMembersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGroupMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGroupMembers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGroupMembersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListGroupMembersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListGroupMembersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGroupMembersRequest, ListGroupMembersResponse>()
                            .withOperationName("ListGroupMembers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListGroupMembersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listGroupMembersRequest));
            CompletableFuture<ListGroupMembersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns summaries of the organization's groups.
     * </p>
     *
     * @param listGroupsRequest
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListGroupsResponse> listGroups(ListGroupsRequest listGroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListGroupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGroupsRequest, ListGroupsResponse>().withOperationName("ListGroups")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listGroupsRequest));
            CompletableFuture<ListGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns all the groups to which an entity belongs.
     * </p>
     *
     * @param listGroupsForEntityRequest
     * @return A Java Future containing the result of the ListGroupsForEntity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListGroupsForEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroupsForEntity" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListGroupsForEntityResponse> listGroupsForEntity(
            ListGroupsForEntityRequest listGroupsForEntityRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGroupsForEntityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGroupsForEntityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGroupsForEntity");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGroupsForEntityResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListGroupsForEntityResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListGroupsForEntityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGroupsForEntityRequest, ListGroupsForEntityResponse>()
                            .withOperationName("ListGroupsForEntity").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListGroupsForEntityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listGroupsForEntityRequest));
            CompletableFuture<ListGroupsForEntityResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the impersonation roles for the given WorkMail organization.
     * </p>
     *
     * @param listImpersonationRolesRequest
     * @return A Java Future containing the result of the ListImpersonationRoles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListImpersonationRoles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListImpersonationRoles"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListImpersonationRolesResponse> listImpersonationRoles(
            ListImpersonationRolesRequest listImpersonationRolesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listImpersonationRolesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImpersonationRolesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImpersonationRoles");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListImpersonationRolesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListImpersonationRolesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListImpersonationRolesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListImpersonationRolesRequest, ListImpersonationRolesResponse>()
                            .withOperationName("ListImpersonationRoles").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListImpersonationRolesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listImpersonationRolesRequest));
            CompletableFuture<ListImpersonationRolesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the mail domains in a given WorkMail organization.
     * </p>
     *
     * @param listMailDomainsRequest
     * @return A Java Future containing the result of the ListMailDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMailDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailDomains" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListMailDomainsResponse> listMailDomains(ListMailDomainsRequest listMailDomainsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMailDomainsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMailDomainsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMailDomains");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMailDomainsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMailDomainsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListMailDomainsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMailDomainsRequest, ListMailDomainsResponse>()
                            .withOperationName("ListMailDomains").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMailDomainsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listMailDomainsRequest));
            CompletableFuture<ListMailDomainsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the mailbox export jobs started for the specified organization within the last seven days.
     * </p>
     *
     * @param listMailboxExportJobsRequest
     * @return A Java Future containing the result of the ListMailboxExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMailboxExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxExportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMailboxExportJobsResponse> listMailboxExportJobs(
            ListMailboxExportJobsRequest listMailboxExportJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMailboxExportJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMailboxExportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMailboxExportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMailboxExportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMailboxExportJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListMailboxExportJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMailboxExportJobsRequest, ListMailboxExportJobsResponse>()
                            .withOperationName("ListMailboxExportJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMailboxExportJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listMailboxExportJobsRequest));
            CompletableFuture<ListMailboxExportJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the mailbox permissions associated with a user, group, or resource mailbox.
     * </p>
     *
     * @param listMailboxPermissionsRequest
     * @return A Java Future containing the result of the ListMailboxPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMailboxPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMailboxPermissionsResponse> listMailboxPermissions(
            ListMailboxPermissionsRequest listMailboxPermissionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMailboxPermissionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMailboxPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMailboxPermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMailboxPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMailboxPermissionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListMailboxPermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMailboxPermissionsRequest, ListMailboxPermissionsResponse>()
                            .withOperationName("ListMailboxPermissions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMailboxPermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listMailboxPermissionsRequest));
            CompletableFuture<ListMailboxPermissionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the mobile device access overrides for any given combination of WorkMail organization, user, or device.
     * </p>
     *
     * @param listMobileDeviceAccessOverridesRequest
     * @return A Java Future containing the result of the ListMobileDeviceAccessOverrides operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMobileDeviceAccessOverrides
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMobileDeviceAccessOverrides"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMobileDeviceAccessOverridesResponse> listMobileDeviceAccessOverrides(
            ListMobileDeviceAccessOverridesRequest listMobileDeviceAccessOverridesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMobileDeviceAccessOverridesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listMobileDeviceAccessOverridesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMobileDeviceAccessOverrides");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMobileDeviceAccessOverridesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMobileDeviceAccessOverridesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListMobileDeviceAccessOverridesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMobileDeviceAccessOverridesRequest, ListMobileDeviceAccessOverridesResponse>()
                            .withOperationName("ListMobileDeviceAccessOverrides").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMobileDeviceAccessOverridesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listMobileDeviceAccessOverridesRequest));
            CompletableFuture<ListMobileDeviceAccessOverridesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the mobile device access rules for the specified WorkMail organization.
     * </p>
     *
     * @param listMobileDeviceAccessRulesRequest
     * @return A Java Future containing the result of the ListMobileDeviceAccessRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMobileDeviceAccessRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMobileDeviceAccessRules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMobileDeviceAccessRulesResponse> listMobileDeviceAccessRules(
            ListMobileDeviceAccessRulesRequest listMobileDeviceAccessRulesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMobileDeviceAccessRulesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMobileDeviceAccessRulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMobileDeviceAccessRules");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMobileDeviceAccessRulesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMobileDeviceAccessRulesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListMobileDeviceAccessRulesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMobileDeviceAccessRulesRequest, ListMobileDeviceAccessRulesResponse>()
                            .withOperationName("ListMobileDeviceAccessRules").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMobileDeviceAccessRulesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listMobileDeviceAccessRulesRequest));
            CompletableFuture<ListMobileDeviceAccessRulesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns summaries of the customer's organizations.
     * </p>
     *
     * @param listOrganizationsRequest
     * @return A Java Future containing the result of the ListOrganizations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListOrganizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListOrganizations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListOrganizationsResponse> listOrganizations(ListOrganizationsRequest listOrganizationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listOrganizationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOrganizationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOrganizations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListOrganizationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListOrganizationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListOrganizationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListOrganizationsRequest, ListOrganizationsResponse>()
                            .withOperationName("ListOrganizations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListOrganizationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listOrganizationsRequest));
            CompletableFuture<ListOrganizationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a summary of your Personal Access Tokens.
     * </p>
     *
     * @param listPersonalAccessTokensRequest
     * @return A Java Future containing the result of the ListPersonalAccessTokens operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListPersonalAccessTokens
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListPersonalAccessTokens"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListPersonalAccessTokensResponse> listPersonalAccessTokens(
            ListPersonalAccessTokensRequest listPersonalAccessTokensRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPersonalAccessTokensRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPersonalAccessTokensRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPersonalAccessTokens");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPersonalAccessTokensResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListPersonalAccessTokensResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListPersonalAccessTokensResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPersonalAccessTokensRequest, ListPersonalAccessTokensResponse>()
                            .withOperationName("ListPersonalAccessTokens").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListPersonalAccessTokensRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listPersonalAccessTokensRequest));
            CompletableFuture<ListPersonalAccessTokensResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the delegates associated with a resource. Users and groups can be resource delegates and answer requests on
     * behalf of the resource.
     * </p>
     *
     * @param listResourceDelegatesRequest
     * @return A Java Future containing the result of the ListResourceDelegates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListResourceDelegates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResourceDelegates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResourceDelegatesResponse> listResourceDelegates(
            ListResourceDelegatesRequest listResourceDelegatesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listResourceDelegatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResourceDelegatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResourceDelegates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResourceDelegatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListResourceDelegatesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListResourceDelegatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResourceDelegatesRequest, ListResourceDelegatesResponse>()
                            .withOperationName("ListResourceDelegates").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListResourceDelegatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listResourceDelegatesRequest));
            CompletableFuture<ListResourceDelegatesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns summaries of the organization's resources.
     * </p>
     *
     * @param listResourcesRequest
     * @return A Java Future containing the result of the ListResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResources" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListResourcesResponse> listResources(ListResourcesRequest listResourcesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listResourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResourcesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListResourcesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListResourcesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResourcesRequest, ListResourcesResponse>()
                            .withOperationName("ListResources").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListResourcesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listResourcesRequest));
            CompletableFuture<ListResourcesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the tags applied to an WorkMail organization resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns summaries of the organization's users.
     * </p>
     *
     * @param listUsersRequest
     * @return A Java Future containing the result of the ListUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListUsersResponse> listUsers(ListUsersRequest listUsersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listUsersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUsersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUsers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListUsersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListUsersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListUsersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListUsersRequest, ListUsersResponse>().withOperationName("ListUsers")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListUsersRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(listUsersRequest));
            CompletableFuture<ListUsersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds a new access control rule for the specified organization. The rule allows or denies access to the
     * organization for the specified IPv4 addresses, access protocol actions, user IDs and impersonation IDs. Adding a
     * new rule with the same name as an existing rule replaces the older rule.
     * </p>
     *
     * @param putAccessControlRuleRequest
     * @return A Java Future containing the result of the PutAccessControlRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.PutAccessControlRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutAccessControlRule" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PutAccessControlRuleResponse> putAccessControlRule(
            PutAccessControlRuleRequest putAccessControlRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putAccessControlRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putAccessControlRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutAccessControlRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutAccessControlRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutAccessControlRuleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<PutAccessControlRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutAccessControlRuleRequest, PutAccessControlRuleResponse>()
                            .withOperationName("PutAccessControlRule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutAccessControlRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putAccessControlRuleRequest));
            CompletableFuture<PutAccessControlRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates or updates the email monitoring configuration for a specified organization.
     * </p>
     *
     * @param putEmailMonitoringConfigurationRequest
     * @return A Java Future containing the result of the PutEmailMonitoringConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.PutEmailMonitoringConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutEmailMonitoringConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutEmailMonitoringConfigurationResponse> putEmailMonitoringConfiguration(
            PutEmailMonitoringConfigurationRequest putEmailMonitoringConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putEmailMonitoringConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putEmailMonitoringConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutEmailMonitoringConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutEmailMonitoringConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutEmailMonitoringConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<PutEmailMonitoringConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutEmailMonitoringConfigurationRequest, PutEmailMonitoringConfigurationResponse>()
                            .withOperationName("PutEmailMonitoringConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutEmailMonitoringConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putEmailMonitoringConfigurationRequest));
            CompletableFuture<PutEmailMonitoringConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables integration between IAM Identity Center (IdC) and WorkMail to proxy authentication requests for mailbox
     * users. You can connect your IdC directory or your external directory to WorkMail through IdC and manage access to
     * WorkMail mailboxes in a single place. For enhanced protection, you could enable Multifactor Authentication (MFA)
     * and Personal Access Tokens.
     * </p>
     *
     * @param putIdentityProviderConfigurationRequest
     * @return A Java Future containing the result of the PutIdentityProviderConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.PutIdentityProviderConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutIdentityProviderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutIdentityProviderConfigurationResponse> putIdentityProviderConfiguration(
            PutIdentityProviderConfigurationRequest putIdentityProviderConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putIdentityProviderConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putIdentityProviderConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutIdentityProviderConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutIdentityProviderConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, PutIdentityProviderConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<PutIdentityProviderConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutIdentityProviderConfigurationRequest, PutIdentityProviderConfigurationResponse>()
                            .withOperationName("PutIdentityProviderConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutIdentityProviderConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putIdentityProviderConfigurationRequest));
            CompletableFuture<PutIdentityProviderConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables or disables a DMARC policy for a given organization.
     * </p>
     *
     * @param putInboundDmarcSettingsRequest
     * @return A Java Future containing the result of the PutInboundDmarcSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.PutInboundDmarcSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutInboundDmarcSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutInboundDmarcSettingsResponse> putInboundDmarcSettings(
            PutInboundDmarcSettingsRequest putInboundDmarcSettingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putInboundDmarcSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putInboundDmarcSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutInboundDmarcSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutInboundDmarcSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutInboundDmarcSettingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<PutInboundDmarcSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutInboundDmarcSettingsRequest, PutInboundDmarcSettingsResponse>()
                            .withOperationName("PutInboundDmarcSettings").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutInboundDmarcSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putInboundDmarcSettingsRequest));
            CompletableFuture<PutInboundDmarcSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Sets permissions for a user, group, or resource. This replaces any pre-existing permissions.
     * </p>
     *
     * @param putMailboxPermissionsRequest
     * @return A Java Future containing the result of the PutMailboxPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.PutMailboxPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutMailboxPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutMailboxPermissionsResponse> putMailboxPermissions(
            PutMailboxPermissionsRequest putMailboxPermissionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putMailboxPermissionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putMailboxPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutMailboxPermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutMailboxPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutMailboxPermissionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<PutMailboxPermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutMailboxPermissionsRequest, PutMailboxPermissionsResponse>()
                            .withOperationName("PutMailboxPermissions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutMailboxPermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putMailboxPermissionsRequest));
            CompletableFuture<PutMailboxPermissionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates or updates a mobile device access override for the given WorkMail organization, user, and device.
     * </p>
     *
     * @param putMobileDeviceAccessOverrideRequest
     * @return A Java Future containing the result of the PutMobileDeviceAccessOverride operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.PutMobileDeviceAccessOverride
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutMobileDeviceAccessOverride"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<PutMobileDeviceAccessOverrideResponse> putMobileDeviceAccessOverride(
            PutMobileDeviceAccessOverrideRequest putMobileDeviceAccessOverrideRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putMobileDeviceAccessOverrideRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putMobileDeviceAccessOverrideRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutMobileDeviceAccessOverride");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutMobileDeviceAccessOverrideResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutMobileDeviceAccessOverrideResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<PutMobileDeviceAccessOverrideResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutMobileDeviceAccessOverrideRequest, PutMobileDeviceAccessOverrideResponse>()
                            .withOperationName("PutMobileDeviceAccessOverride").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutMobileDeviceAccessOverrideRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putMobileDeviceAccessOverrideRequest));
            CompletableFuture<PutMobileDeviceAccessOverrideResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Puts a retention policy to the specified organization.
     * </p>
     *
     * @param putRetentionPolicyRequest
     * @return A Java Future containing the result of the PutRetentionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.PutRetentionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutRetentionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PutRetentionPolicyResponse> putRetentionPolicy(PutRetentionPolicyRequest putRetentionPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putRetentionPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putRetentionPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutRetentionPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutRetentionPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutRetentionPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<PutRetentionPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutRetentionPolicyRequest, PutRetentionPolicyResponse>()
                            .withOperationName("PutRetentionPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutRetentionPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(putRetentionPolicyRequest));
            CompletableFuture<PutRetentionPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Registers a new domain in WorkMail and SES, and configures it for use by WorkMail. Emails received by SES for
     * this domain are routed to the specified WorkMail organization, and WorkMail has permanent permission to use the
     * specified domain for sending your users' emails.
     * </p>
     *
     * @param registerMailDomainRequest
     * @return A Java Future containing the result of the RegisterMailDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>MailDomainInUseException The domain you're trying to change is in use by another user or organization
     *         in your account. See the error message for details.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.RegisterMailDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/RegisterMailDomain" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterMailDomainResponse> registerMailDomain(RegisterMailDomainRequest registerMailDomainRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(registerMailDomainRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerMailDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterMailDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RegisterMailDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RegisterMailDomainResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<RegisterMailDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RegisterMailDomainRequest, RegisterMailDomainResponse>()
                            .withOperationName("RegisterMailDomain").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RegisterMailDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(registerMailDomainRequest));
            CompletableFuture<RegisterMailDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Registers an existing and disabled user, group, or resource for WorkMail use by associating a mailbox and
     * calendaring capabilities. It performs no change if the user, group, or resource is enabled and fails if the user,
     * group, or resource is deleted. This operation results in the accumulation of costs. For more information, see <a
     * href="https://aws.amazon.com/workmail/pricing">Pricing</a>. The equivalent console functionality for this
     * operation is <i>Enable</i>.
     * </p>
     * <p>
     * Users can either be created by calling the <a>CreateUser</a> API operation or they can be synchronized from your
     * directory. For more information, see <a>DeregisterFromWorkMail</a>.
     * </p>
     *
     * @param registerToWorkMailRequest
     * @return A Java Future containing the result of the RegisterToWorkMail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EmailAddressInUseException The email address that you're trying to assign is already created for a
     *         different user, group, or resource.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>EntityAlreadyRegisteredException The user, group, or resource that you're trying to register is
     *         already registered.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>MailDomainNotFoundException The domain specified is not found in your organization.</li>
     *         <li>MailDomainStateException After a domain has been added to the organization, it must be verified. The
     *         domain is not yet verified.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.RegisterToWorkMail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/RegisterToWorkMail" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterToWorkMailResponse> registerToWorkMail(RegisterToWorkMailRequest registerToWorkMailRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(registerToWorkMailRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerToWorkMailRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterToWorkMail");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RegisterToWorkMailResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RegisterToWorkMailResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<RegisterToWorkMailResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RegisterToWorkMailRequest, RegisterToWorkMailResponse>()
                            .withOperationName("RegisterToWorkMail").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RegisterToWorkMailRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(registerToWorkMailRequest));
            CompletableFuture<RegisterToWorkMailResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows the administrator to reset the password for a user.
     * </p>
     *
     * @param resetPasswordRequest
     * @return A Java Future containing the result of the ResetPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory is unavailable. It might be located in another Region or
     *         deleted.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>InvalidPasswordException The supplied password doesn't match the minimum security constraints, such
     *         as length or use of special characters.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ResetPassword
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ResetPassword" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ResetPasswordResponse> resetPassword(ResetPasswordRequest resetPasswordRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(resetPasswordRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resetPasswordRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResetPassword");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ResetPasswordResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ResetPasswordResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ResetPasswordResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ResetPasswordRequest, ResetPasswordResponse>()
                            .withOperationName("ResetPassword").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ResetPasswordRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(resetPasswordRequest));
            CompletableFuture<ResetPasswordResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a mailbox export job to export MIME-format email messages and calendar items from the specified mailbox to
     * the specified Amazon Simple Storage Service (Amazon S3) bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/workmail/latest/adminguide/mail-export.html">Exporting mailbox content</a> in
     * the <i>WorkMail Administrator Guide</i>.
     * </p>
     *
     * @param startMailboxExportJobRequest
     * @return A Java Future containing the result of the StartMailboxExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>LimitExceededException The request exceeds the limit of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.StartMailboxExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/StartMailboxExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartMailboxExportJobResponse> startMailboxExportJob(
            StartMailboxExportJobRequest startMailboxExportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startMailboxExportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startMailboxExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartMailboxExportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartMailboxExportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartMailboxExportJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StartMailboxExportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartMailboxExportJobRequest, StartMailboxExportJobResponse>()
                            .withOperationName("StartMailboxExportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartMailboxExportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startMailboxExportJobRequest));
            CompletableFuture<StartMailboxExportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Applies the specified tags to the specified WorkMailorganization resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>TooManyTagsException The resource can have up to 50 user-applied tags.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Performs a test on an availability provider to ensure that access is allowed. For EWS, it verifies the provided
     * credentials can be used to successfully log in. For Lambda, it verifies that the Lambda function can be invoked
     * and that the resource access policy was configured to deny anonymous access. An anonymous invocation is one done
     * without providing either a <code>SourceArn</code> or <code>SourceAccount</code> header.
     * </p>
     * <note>
     * <p>
     * The request must contain either one provider definition (<code>EwsProvider</code> or <code>LambdaProvider</code>)
     * or the <code>DomainName</code> parameter. If the <code>DomainName</code> parameter is provided, the configuration
     * stored under the <code>DomainName</code> will be tested.
     * </p>
     * </note>
     *
     * @param testAvailabilityConfigurationRequest
     * @return A Java Future containing the result of the TestAvailabilityConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.TestAvailabilityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/TestAvailabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<TestAvailabilityConfigurationResponse> testAvailabilityConfiguration(
            TestAvailabilityConfigurationRequest testAvailabilityConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(testAvailabilityConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                testAvailabilityConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TestAvailabilityConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TestAvailabilityConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, TestAvailabilityConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<TestAvailabilityConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TestAvailabilityConfigurationRequest, TestAvailabilityConfigurationResponse>()
                            .withOperationName("TestAvailabilityConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TestAvailabilityConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(testAvailabilityConfigurationRequest));
            CompletableFuture<TestAvailabilityConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Untags the specified tags from the specified WorkMail organization resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing <code>AvailabilityConfiguration</code> for the given WorkMail organization and domain.
     * </p>
     *
     * @param updateAvailabilityConfigurationRequest
     * @return A Java Future containing the result of the UpdateAvailabilityConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UpdateAvailabilityConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateAvailabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAvailabilityConfigurationResponse> updateAvailabilityConfiguration(
            UpdateAvailabilityConfigurationRequest updateAvailabilityConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAvailabilityConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateAvailabilityConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAvailabilityConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAvailabilityConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAvailabilityConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateAvailabilityConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAvailabilityConfigurationRequest, UpdateAvailabilityConfigurationResponse>()
                            .withOperationName("UpdateAvailabilityConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAvailabilityConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateAvailabilityConfigurationRequest));
            CompletableFuture<UpdateAvailabilityConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the default mail domain for an organization. The default mail domain is used by the WorkMail AWS Console
     * to suggest an email address when enabling a mail user. You can only have one default domain.
     * </p>
     *
     * @param updateDefaultMailDomainRequest
     * @return A Java Future containing the result of the UpdateDefaultMailDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>MailDomainNotFoundException The domain specified is not found in your organization.</li>
     *         <li>MailDomainStateException After a domain has been added to the organization, it must be verified. The
     *         domain is not yet verified.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state to perform certain operations on
     *         the organization or its members.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UpdateDefaultMailDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateDefaultMailDomain"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDefaultMailDomainResponse> updateDefaultMailDomain(
            UpdateDefaultMailDomainRequest updateDefaultMailDomainRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDefaultMailDomainRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDefaultMailDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkMail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDefaultMailDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDefaultMailDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDefaultMailDomainResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "DirectoryUnavailableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
                case "MailDomainStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainStateException::builder).build());
                case "InvalidCustomSesConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCustomSesConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidCustomSesConfigurationException::builder)
                            .build());
                case "NameAvailabilityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NameAvailabilityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NameAvailabilityException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "EntityAlreadyRegisteredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
                case "InvalidPasswordException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "UnsupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                case "DirectoryInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(DirectoryInUseException::builder).build());
                case "MailDomainInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainInUseException::builder).build());
                case "OrganizationNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build());
                case "EntityStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityStateException::builder).build());
                case "InvalidConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidConfigurationException::builder).build());
                case "InvalidParameterException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidParameterException::builder).build());
                case "MailDomainNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MailDomainNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build());
                case "DirectoryServiceAuthenticationFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder)
                            .build());
                case "EmailAddressInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EmailAddressInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EmailAddressInUseException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "EntityNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(EntityNotFoundException::builder).build());
                case "ReservedNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ReservedNameException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ReservedNameException::builder).build());
                case "OrganizationStateException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationStateException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationStateException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateDefaultMailDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDefaultMailDomainRequest, UpdateDefaultMailDomainResponse>()
                            .withOperationName("UpdateDefaultMailDomain").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateDefaultMailDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateDefaultMailDomainRequest));
            CompletableFuture<UpdateDefaultMailDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.