/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeGroupResponse extends WorkMailResponse implements
        ToCopyableBuilder<DescribeGroupResponse.Builder, DescribeGroupResponse> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupId").getter(getter(DescribeGroupResponse::groupId)).setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeGroupResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Email")
            .getter(getter(DescribeGroupResponse::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(DescribeGroupResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Instant> ENABLED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EnabledDate").getter(getter(DescribeGroupResponse::enabledDate)).setter(setter(Builder::enabledDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledDate").build()).build();

    private static final SdkField<Instant> DISABLED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DisabledDate").getter(getter(DescribeGroupResponse::disabledDate)).setter(setter(Builder::disabledDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisabledDate").build()).build();

    private static final SdkField<Boolean> HIDDEN_FROM_GLOBAL_ADDRESS_LIST_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HiddenFromGlobalAddressList")
            .getter(getter(DescribeGroupResponse::hiddenFromGlobalAddressList))
            .setter(setter(Builder::hiddenFromGlobalAddressList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HiddenFromGlobalAddressList")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD, NAME_FIELD,
            EMAIL_FIELD, STATE_FIELD, ENABLED_DATE_FIELD, DISABLED_DATE_FIELD, HIDDEN_FROM_GLOBAL_ADDRESS_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String groupId;

    private final String name;

    private final String email;

    private final String state;

    private final Instant enabledDate;

    private final Instant disabledDate;

    private final Boolean hiddenFromGlobalAddressList;

    private DescribeGroupResponse(BuilderImpl builder) {
        super(builder);
        this.groupId = builder.groupId;
        this.name = builder.name;
        this.email = builder.email;
        this.state = builder.state;
        this.enabledDate = builder.enabledDate;
        this.disabledDate = builder.disabledDate;
        this.hiddenFromGlobalAddressList = builder.hiddenFromGlobalAddressList;
    }

    /**
     * <p>
     * The identifier of the described group.
     * </p>
     * 
     * @return The identifier of the described group.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * <p>
     * The name of the described group.
     * </p>
     * 
     * @return The name of the described group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The email of the described group.
     * </p>
     * 
     * @return The email of the described group.
     */
    public final String email() {
        return email;
    }

    /**
     * <p>
     * The state of the user: enabled (registered to WorkMail) or disabled (deregistered or never registered to
     * WorkMail).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link EntityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the user: enabled (registered to WorkMail) or disabled (deregistered or never registered to
     *         WorkMail).
     * @see EntityState
     */
    public final EntityState state() {
        return EntityState.fromValue(state);
    }

    /**
     * <p>
     * The state of the user: enabled (registered to WorkMail) or disabled (deregistered or never registered to
     * WorkMail).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link EntityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the user: enabled (registered to WorkMail) or disabled (deregistered or never registered to
     *         WorkMail).
     * @see EntityState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The date and time when a user was registered to WorkMail, in UNIX epoch time format.
     * </p>
     * 
     * @return The date and time when a user was registered to WorkMail, in UNIX epoch time format.
     */
    public final Instant enabledDate() {
        return enabledDate;
    }

    /**
     * <p>
     * The date and time when a user was deregistered from WorkMail, in UNIX epoch time format.
     * </p>
     * 
     * @return The date and time when a user was deregistered from WorkMail, in UNIX epoch time format.
     */
    public final Instant disabledDate() {
        return disabledDate;
    }

    /**
     * <p>
     * If the value is set to <i>true</i>, the group is hidden from the address book.
     * </p>
     * 
     * @return If the value is set to <i>true</i>, the group is hidden from the address book.
     */
    public final Boolean hiddenFromGlobalAddressList() {
        return hiddenFromGlobalAddressList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enabledDate());
        hashCode = 31 * hashCode + Objects.hashCode(disabledDate());
        hashCode = 31 * hashCode + Objects.hashCode(hiddenFromGlobalAddressList());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGroupResponse)) {
            return false;
        }
        DescribeGroupResponse other = (DescribeGroupResponse) obj;
        return Objects.equals(groupId(), other.groupId()) && Objects.equals(name(), other.name())
                && Objects.equals(email(), other.email()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(enabledDate(), other.enabledDate()) && Objects.equals(disabledDate(), other.disabledDate())
                && Objects.equals(hiddenFromGlobalAddressList(), other.hiddenFromGlobalAddressList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeGroupResponse").add("GroupId", groupId()).add("Name", name()).add("Email", email())
                .add("State", stateAsString()).add("EnabledDate", enabledDate()).add("DisabledDate", disabledDate())
                .add("HiddenFromGlobalAddressList", hiddenFromGlobalAddressList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Email":
            return Optional.ofNullable(clazz.cast(email()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "EnabledDate":
            return Optional.ofNullable(clazz.cast(enabledDate()));
        case "DisabledDate":
            return Optional.ofNullable(clazz.cast(disabledDate()));
        case "HiddenFromGlobalAddressList":
            return Optional.ofNullable(clazz.cast(hiddenFromGlobalAddressList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroupId", GROUP_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Email", EMAIL_FIELD);
        map.put("State", STATE_FIELD);
        map.put("EnabledDate", ENABLED_DATE_FIELD);
        map.put("DisabledDate", DISABLED_DATE_FIELD);
        map.put("HiddenFromGlobalAddressList", HIDDEN_FROM_GLOBAL_ADDRESS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeGroupResponse, T> g) {
        return obj -> g.apply((DescribeGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkMailResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeGroupResponse> {
        /**
         * <p>
         * The identifier of the described group.
         * </p>
         * 
         * @param groupId
         *        The identifier of the described group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * The name of the described group.
         * </p>
         * 
         * @param name
         *        The name of the described group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The email of the described group.
         * </p>
         * 
         * @param email
         *        The email of the described group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * The state of the user: enabled (registered to WorkMail) or disabled (deregistered or never registered to
         * WorkMail).
         * </p>
         * 
         * @param state
         *        The state of the user: enabled (registered to WorkMail) or disabled (deregistered or never registered
         *        to WorkMail).
         * @see EntityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the user: enabled (registered to WorkMail) or disabled (deregistered or never registered to
         * WorkMail).
         * </p>
         * 
         * @param state
         *        The state of the user: enabled (registered to WorkMail) or disabled (deregistered or never registered
         *        to WorkMail).
         * @see EntityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityState
         */
        Builder state(EntityState state);

        /**
         * <p>
         * The date and time when a user was registered to WorkMail, in UNIX epoch time format.
         * </p>
         * 
         * @param enabledDate
         *        The date and time when a user was registered to WorkMail, in UNIX epoch time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledDate(Instant enabledDate);

        /**
         * <p>
         * The date and time when a user was deregistered from WorkMail, in UNIX epoch time format.
         * </p>
         * 
         * @param disabledDate
         *        The date and time when a user was deregistered from WorkMail, in UNIX epoch time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabledDate(Instant disabledDate);

        /**
         * <p>
         * If the value is set to <i>true</i>, the group is hidden from the address book.
         * </p>
         * 
         * @param hiddenFromGlobalAddressList
         *        If the value is set to <i>true</i>, the group is hidden from the address book.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hiddenFromGlobalAddressList(Boolean hiddenFromGlobalAddressList);
    }

    static final class BuilderImpl extends WorkMailResponse.BuilderImpl implements Builder {
        private String groupId;

        private String name;

        private String email;

        private String state;

        private Instant enabledDate;

        private Instant disabledDate;

        private Boolean hiddenFromGlobalAddressList;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGroupResponse model) {
            super(model);
            groupId(model.groupId);
            name(model.name);
            email(model.email);
            state(model.state);
            enabledDate(model.enabledDate);
            disabledDate(model.disabledDate);
            hiddenFromGlobalAddressList(model.hiddenFromGlobalAddressList);
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEmail() {
            return email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(EntityState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getEnabledDate() {
            return enabledDate;
        }

        public final void setEnabledDate(Instant enabledDate) {
            this.enabledDate = enabledDate;
        }

        @Override
        public final Builder enabledDate(Instant enabledDate) {
            this.enabledDate = enabledDate;
            return this;
        }

        public final Instant getDisabledDate() {
            return disabledDate;
        }

        public final void setDisabledDate(Instant disabledDate) {
            this.disabledDate = disabledDate;
        }

        @Override
        public final Builder disabledDate(Instant disabledDate) {
            this.disabledDate = disabledDate;
            return this;
        }

        public final Boolean getHiddenFromGlobalAddressList() {
            return hiddenFromGlobalAddressList;
        }

        public final void setHiddenFromGlobalAddressList(Boolean hiddenFromGlobalAddressList) {
            this.hiddenFromGlobalAddressList = hiddenFromGlobalAddressList;
        }

        @Override
        public final Builder hiddenFromGlobalAddressList(Boolean hiddenFromGlobalAddressList) {
            this.hiddenFromGlobalAddressList = hiddenFromGlobalAddressList;
            return this;
        }

        @Override
        public DescribeGroupResponse build() {
            return new DescribeGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
